/*
 * Grouch.app                           Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Handle chat invitations.
 */

#import <Oscar/OscarCapHandler.h>
#import <Grouch/GrouchStringTool.h>
#import <Foundation/NSBundle.h>
#import <Foundation/NSCharacterSet.h>

@interface OscarChatInvite : NSObject <GrouchPrompt>
{
	OscarClient *cli;
	NSString *name, *cookie;
	int exchange, instance;
}
- initWithClient:(OscarClient*)c cookie:(NSString*)ck exchange:(int)ex
  instance:(int)inst user:(id<GrouchUser>)u;
- (void)gotResult:obj;
@end

@implementation OscarChatInvite
- initWithClient:(OscarClient*)c cookie:(NSString*)ck exchange:(int)ex
  instance:(int)inst user:(id<GrouchUser>)u
{
	NSCharacterSet *s;
	NSRange r;
	int i;

	cli = [c retain];
	cookie = [ck retain];
	exchange = ex;
	instance = inst;

	// Deduce the name of the room based on cookie
	s =[NSCharacterSet characterSetWithCharactersInString:@"-:.0123456789"];
	r = [cookie rangeOfString:@"://"];
	for(i=r.length?r.location+r.length:0; i<[cookie length]; ++i)
	{
		unichar c = [cookie characterAtIndex:i];
		if(![s characterIsMember:c])
		{
			name = [[cookie substringFromIndex:i] retain];
			break;
		}
	}
	if(!name)
		name = [cookie retain];

	[[cli getUI] yesNoPrompt:self
	 title:[GrouchString getString:@"chat-title"
		withBundle:[NSBundle bundleForClass:[self class]]]
	 message:[[GrouchString getString:@"chat-msg"
		withBundle:[NSBundle bundleForClass:[self class]]]
		createUserString:2,[u alias], name]];

	return self;
}
- (void)dealloc
{
	[cli release];
	[name release];
	[cookie release];
	[super dealloc];
}
- (void)gotResult:obj
{
	if(obj)
		[cli askForChannel:name withCookie:cookie andExchange:exchange
		     andInstance:instance];	
	[self release];
}
@end

@implementation OscarCapChatInvite

- init
{
	static const unsigned char chatCap[] =
	{
		/* Chat capability: */
		0x74,0x8f,0x24,0x20,0x62,0x87,0x11,0xd1,0x82,0x22,0x44,0x45,
		0x53,0x54,0x00,0x00
	};
	[super init];
	cap = chatCap;
	len = sizeof(chatCap);
	return self;
}

- (BOOL)handleCapability:(const void *)cap
        from:(id<GrouchUser>)user onClient:(OscarClient*)cli
        type:(int)type cookie:(const void *)cookie tlv:(OscarTlvListIn*)tlv
        message:(NSString*)str
{
	OscarIncomingSnac *buf = [tlv getTLV:0x2711];
	if(!type && buf)
	{
		int exchange = [buf readInt16];
		NSString *name = [buf readPascalString];	
		int instance = [buf readInt16];
		[[OscarChatInvite new] initWithClient:cli cookie:name
		 exchange:exchange instance:instance user:user];
		return NO;
	}
	else
		return YES;
}

@end
