/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <ClientInstance.h>
#import <UserChooser.h>
#import <User.h>
#import <ErrorWindow.h>

#import <Grouch/GrouchStringTool.h>

#import <Foundation/NSBundle.h>
#import <Renaissance/Renaissance.h>

#import <Foundation/NSArray.h>

@implementation UserChooser

+ chooseWithSelector:(SEL)s target:t
{
	return [[UserChooser new] initWithSelector:s andTarget:t];
}

- initWithSelector:(SEL)s andTarget:t
{
	NSArray *instances = [ClientInstance clientInstances];
	int i;
	selector = s;
	target = t;
	[NSBundle loadGSMarkupNamed:@"UserChooser" owner:self];
	[window orderFront:nil];
	[window makeKeyWindow];
	for( i=0; i<[instances count]; ++i )
	{
		ClientInstance *cli = [instances objectAtIndex:i];
		NSArray *users = [cli getUsers];
		int j;
		for( j=0; j<[users count]; ++j )
		{
			User *u = [users objectAtIndex:j];
			[userField addItemWithObjectValue:[u name]];
		}
		if( [cli nick] )
			[instanceField addItemWithObjectValue:[cli nick]];
	}
	[userField setCompletes:YES];
	if( [instanceField numberOfItems] )
	{
		[instanceField selectItemAtIndex:0];
		[instanceField setObjectValue:
		 [instanceField objectValueOfSelectedItem]];
	}
	return self;
}

- (BOOL)windowShouldClose:sender 
{
	[window autorelease];
	[userField release];
	[instanceField release];
	[self release];
	return YES;
}

- (void)setLogin:(NSString*)str
{
	[instanceField setStringValue:str];
}

- (void)perform
{
	NSString *desiredName = [instanceField stringValue];
	ClientInstance *cli = [ClientInstance clientByName:desiredName];
	if( cli )
	{
		NSString *who = [userField stringValue];
		[target performSelector:selector withObject:[cli getUser:who]];
		[window performClose:self];
	}
	else
		[ErrorWindow errorWithString:
		 [GrouchString getString:@"no-session"]];
}

@end
