#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""
Add buttons and run commands as required.
"""

import os
import yaml
import logging
import commands

def get_functions(path):
    """Get a list of functions as objects"""
    result = []
    conf = os.path.join(path, '.gcfunctions')
    if os.path.exists(conf):
        fhl = open(conf, 'r')
        config = yaml.load(fhl)
        if type(config) != dict:
            logging.warn("GroundControl functions file is corrupt, skipped!")
            return result
        fhl.close()
        for cmd in config.values():
            result.append(CustomCommand(path, cmd))
    return result


class CustomCommand(object):
    """A custom command object"""
    def __init__(self, cwd, kwargs):
        self.cwd = cwd
        self.opt = kwargs

    @property
    def label(self):
        """Return the command's label"""
        return unicode(self.opt.get('name', _('Unamed Action')))

    def is_mode(self, mode):
        """Return true if mode is acceptable"""
        rest = self.opt.get('show-in', 'any').lower().replace(' ', '')
        if rest == 'any':
            return True
        if mode.lower() in rest.split(','):
            return True
        return False

    def run(self, widget=None):
        """Run the custom command"""
        cmd = self.opt.get('command', 'echo "No Command!"')
        cwd = self.opt.get('cwd', self.cwd)
        logging.debug("Running custom command %s" % cmd)
        # Run in a terminal
        com = 'nohup gnome-terminal --working-directory=%s -x %s' % (cwd, cmd)
        logging.debug("Full thing: %s" % com)
        logging.debug(commands.getoutput(com))

