#!/usr/bin/python
#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""Sorts out a contributor's ssh keys and launchpad authentication cookies."""

# Import standard python libs
import sys
import getpass
from GroundControl.launchpadweb import LaunchpadWeb
from GroundControl.sshkeys import compare_pubkeys

import locale
locale.setlocale(locale.LC_ALL, '')
import gettext
gettext.install("groundcontrol")

if __name__ == '__main__':
    myself = LaunchpadWeb()
    if not myself.loggedin():
        print _("You are not yet logged in to launchpad.\nEmail Address:")
        email = sys.stdin.readlines()
        myself.set_emailaddr(email)
        password = getpass.getpass(_("Launchpad Password: "))
        try:
             myself.login(password)
        except:
             print _("Failed to log into launchpad, please check your email address and password and try again.")
             sys.exit(1)

    for key in myself.sshKeys():
        if compare_pubkeys(key):
            print _("You already have existing SSH Keys uploaded, nothing to do.")
            sys.exit(0)

    if myself.hasGenKey():
        print _("You already have a generated key, but it's not live.")
        fh = open(myself.genKeyFilename()+".pub", "r")
        myself.addSshKey(fh.readline())
        fh.close()
        print _("Existing Key Re-Uploaded...")
        sys.exit(0)

    print _("\nWe're now going to generate an SSH Key which will be uploaded to launchpad.")
    password = getpass.getpass(_("Key Password: "))
    passcheck = getpass.getpass(_("Confirm Password: "))
    if password == passcheck:
        myself.genSshKey(password)
    else:
        print _("Passwords didn't match! Please try again.")
    sys.exit(0)
