/*-----------------------------------------------------------------+
 |                                                                 |
 |  Copyright (C) 2002-2003 Grubconf                               |
 |                     http://grubconf.sourceforge.net/            | 
 |                                                                 |
 | This program is free software; you can redistribute it and/or   |
 | modify it under the terms of the GNU General Public License     |
 | as published by the Free Software Foundation; either version 2  |
 | of the License, or (at your option) any later version           |
 |                                                                 |
 | This program is distributed in the hope that it will be useful, |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of  |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   |
 | GNU General Public License for more details.                    |
 |                                                                 |
 | A copy of the GNU General Public License may be found in the    |
 | installation directory named "COPYING"                          |
 |                                                                 |
 +-----------------------------------------------------------------+
 */

#include <gtk/gtk.h>
#include <include/interface.h>

#define _GNU_SOURCE

#define CAT(a,b) a##b

/* This function will find a widget called widget_name 
 */
GtkWidget *lookup_widget (GtkWidget * widget, const gchar * widget_name);

/* Finds the currently selected items index in widget. widget is of
 * type option menu 
 */
int get_selected (GtkWidget * widget);

/* Will send a warning mesage in a dialog
 */
void gtk_message (GtkMessageType m_type, char *warn_str, ...);

/* copies file from source to dest
 */
int
copy (char *source, char *dest);

/* reads a line from stream and stores it in *lineptr
 * returns 0  on failure, 1 on success
 */
size_t my_getline (char **lineptr, FILE * stream);
