/*-----------------------------------------------------------------+
 |                                                                 |
 |  Copyright (C) 2002-2003 Grubconf                               |
 |                     http://grubconf.sourceforge.net/            | 
 |                                                                 |
 | This program is free software; you can redistribute it and/or   |
 | modify it under the terms of the GNU General Public License     |
 | as published by the Free Software Foundation; either version 2  |
 | of the License, or (at your option) any later version           |
 |                                                                 |
 | This program is distributed in the hope that it will be useful, |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of  |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   |
 | GNU General Public License for more details.                    |
 |                                                                 |
 | A copy of the GNU General Public License may be found in the    |
 | installation directory named "COPYING"                          |
 |                                                                 |
 +-----------------------------------------------------------------+
 */
/*
 * Contains all functionality to create the graphical elements
 */

#include <config.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include <include/grubconf_global.h>
#include <include/callbacks.h>
#include <include/interface.h>
#include <include/support.h>

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

#if USE_SPLASHIMAGE==0

static GnomeUIInfo menu1_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("black"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("blue"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("green"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("cyan"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("red"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("magenta"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("brown"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-gray"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("dark-gray"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-blue"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-green"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-cyan"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-red"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-magenta"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("yellow"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("white"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo menu2_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("black"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("blue"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("green"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("cyan"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("red"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("magenta"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("brown"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-gray"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};


static GnomeUIInfo menu3_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("black"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("blue"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("green"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("cyan"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("red"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("magenta"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("brown"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-gray"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("dark-gray"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-blue"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-green"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-cyan"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-red"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-magenta"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("yellow"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("white"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("*inverse*"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo menu4_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("black"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("blue"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("green"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("cyan"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("red"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("magenta"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("brown"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("light-gray"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("*inverse*"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

#endif

GtkWidget*
create_winMain (void)
{
  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *label1;
  GtkWidget *hbox5;
  GtkWidget *table3;
  GtkWidget *label5;
  GtkWidget *hbox6;
  GtkObject *timeout_spin_adj;
  GtkWidget *timeout_spin;
  GtkWidget *chkGenHidden;
  GtkWidget *label6;
  GtkWidget *label26;
  GtkWidget *hbox22;
  GtkWidget *cmdMore;
  GtkWidget *alignment3;
  GtkWidget *hbox17;
  GtkWidget *image2;
  GtkWidget *label18;
  GtkWidget *label7;
  GtkWidget *hbox8;
  GtkWidget *hbox9;
  GtkWidget *scrolledwindow1;
  GtkWidget *treeview1;
  GtkWidget *vbox3;
  GtkWidget *cmdOSNew;
  GtkWidget *cmdOsEdit;
  GtkWidget *alignment1;
  GtkWidget *hbox10;
  GtkWidget *image1;
  GtkWidget *label8;
  GtkWidget *cmdOsDelete;
  GtkWidget *hseparator1;
  GtkWidget *hbox1;
  GtkWidget *cmdOSHelpMain;
  GtkWidget *cmdOSOkMain;
//  GtkWidget *cmdOSRevertMain;
	cmdOSRevertMain = NULL;

  winMain = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (winMain), _("GrubConf"));
	gtk_window_set_icon (GTK_WINDOW (winMain), gdk_pixbuf_new_from_file
	(PACKAGE_PIXMAPS_DIR "/grubconf.png", NULL));

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (winMain), vbox1);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox2), 12);

  label1 = gtk_label_new (_("<b>General</b>"));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox2), label1, FALSE, FALSE, 12);
  gtk_label_set_use_markup (GTK_LABEL (label1), TRUE);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox5, FALSE, TRUE, 0);

  table3 = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (hbox5), table3, TRUE, TRUE, 20);
  gtk_table_set_row_spacings (GTK_TABLE (table3), 12);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 4);

  label5 = gtk_label_new (_("Timeout: "));
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table3), label5, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label5, 138, 19);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox6);
  gtk_table_attach (GTK_TABLE (table3), hbox6, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  timeout_spin_adj = gtk_adjustment_new (10, 0, 99, 1, 10, 10);
  timeout_spin = gtk_spin_button_new (GTK_ADJUSTMENT (timeout_spin_adj), 1, 0);
  gtk_widget_show (timeout_spin);
  gtk_box_pack_start (GTK_BOX (hbox6), timeout_spin, FALSE, FALSE, 0);

  label6 = gtk_label_new (_("s"));
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox6), label6, FALSE, FALSE, 8);
  gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label6), 0.5, 0.48);


#if USE_SPLASHIMAGE

	GtkWidget *chkSplash;
	GtkWidget *table2;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *optGenSplashDev;
  GtkWidget *hbox2;
  GtkWidget *txtGenSplash;
  GtkWidget *cmdSplashFind;
	
  chkSplash = gtk_check_button_new_with_mnemonic (_("Splash Image"));
  gtk_widget_show (chkSplash);
  gtk_table_attach (GTK_TABLE (table3), chkSplash, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table2);
  gtk_table_attach (GTK_TABLE (table3), table2, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 20, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 8);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 4);

  label2 = gtk_label_new (_("Device:"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table2), label2, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label2, 120, 22);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

  label3 = gtk_label_new (_("Filename:"));
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table2), label3, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

  optGenSplashDev = gtk_option_menu_new ();
  gtk_widget_set_sensitive (optGenSplashDev, FALSE);
  gtk_widget_show (optGenSplashDev);
  gtk_table_attach (GTK_TABLE (table2), optGenSplashDev, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

	GtkWidget *optGenSplashDev_menu = gtk_menu_new ();
	dev_load_menu_path (optGenSplashDev_menu, TRUE);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optGenSplashDev),
				  optGenSplashDev_menu);

  hbox2 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox2);
  gtk_table_attach (GTK_TABLE (table2), hbox2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  txtGenSplash = gtk_entry_new ();
  gtk_widget_show (txtGenSplash);
  gtk_widget_set_sensitive (txtGenSplash, FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), txtGenSplash, TRUE, TRUE, 0);

  cmdSplashFind = gtk_button_new_with_mnemonic (_("Browse..."));
  gtk_widget_show (cmdSplashFind);
  gtk_widget_set_sensitive (cmdSplashFind, FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), cmdSplashFind, FALSE, FALSE, 0);

  g_signal_connect ((gpointer) chkSplash, "toggled",
                    G_CALLBACK (on_chkSplash_toggled),
                    NULL);
  g_signal_connect ((gpointer) optGenSplashDev, "changed",
                    G_CALLBACK (on_optGenSplashDev_changed),
                    NULL);
  g_signal_connect ((gpointer) txtGenSplash, "changed",
                    G_CALLBACK (on_txtGenSplash_changed),
                    NULL);
  g_signal_connect ((gpointer) cmdSplashFind, "clicked",
                    G_CALLBACK (on_cmdFileFind_clicked),
                    NULL);

  GLADE_HOOKUP_OBJECT (winMain, chkSplash, "chkSplash");
  GLADE_HOOKUP_OBJECT (winMain, txtGenSplash, "txtGenSplash");
  GLADE_HOOKUP_OBJECT (winMain, optGenSplashDev, "optGenSplashDev");
  GLADE_HOOKUP_OBJECT (winMain, cmdSplashFind, "cmdSplashFind");

  on_chkSplash_toggled (GTK_TOGGLE_BUTTON (chkSplash), NULL);

#else
	
	GtkWidget *chkColor;
	GtkWidget *table2;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *hbox2;
  GtkWidget *label4;
  GtkWidget *label9;
  GtkWidget *hbox3;
  GtkWidget *hbox4;
//  GtkWidget *label3;
  GtkWidget *menu1;
  GtkWidget *optNFor;
  GtkWidget *optNBak;
  GtkWidget *optHFor;
  GtkWidget *optHBak;

  chkColor = gtk_check_button_new_with_mnemonic (_("Color"));
  gtk_widget_show (chkColor);
  gtk_table_attach (GTK_TABLE (table3), chkColor, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
	
  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_table_attach (GTK_TABLE (table3), hbox2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label2 = gtk_label_new (_("Foreground"));
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox2), label2, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

  label3 = gtk_label_new (_("Background"));
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox2), label3, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);


  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table2);
  gtk_table_attach (GTK_TABLE (table3), table2, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 20, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 8);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 4);

  label4 = gtk_label_new (_("Normal:"));
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table2), label4, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label4, 120, 22);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

  label9 = gtk_label_new (_("Highlight:"));
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table2), label9, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

  hbox3 = gtk_hbox_new (TRUE, 12);
  gtk_widget_show (hbox3);
  gtk_table_attach (GTK_TABLE (table2), hbox3, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  optNFor = gtk_option_menu_new ();
  gtk_widget_show (optNFor);
  gtk_box_pack_start (GTK_BOX (hbox3), optNFor, TRUE, TRUE, 0);

  menu1 = gtk_menu_new ();
  gnome_app_fill_menu (GTK_MENU_SHELL (menu1), menu1_uiinfo,
                       NULL, FALSE, 0);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (optNFor), menu1);

  optNBak = gtk_option_menu_new ();
  gtk_widget_show (optNBak);
  gtk_box_pack_start (GTK_BOX (hbox3), optNBak, TRUE, TRUE, 0);

  menu1 = gtk_menu_new ();
  gnome_app_fill_menu (GTK_MENU_SHELL (menu1), menu2_uiinfo,
                       NULL, FALSE, 0);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (optNBak), menu1);

  hbox4 = gtk_hbox_new (TRUE, 12);
  gtk_widget_show (hbox4);
  gtk_table_attach (GTK_TABLE (table2), hbox4, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  optHFor = gtk_option_menu_new ();
  gtk_widget_show (optHFor);
  gtk_box_pack_start (GTK_BOX (hbox4), optHFor, TRUE, TRUE, 0);

  menu1 = gtk_menu_new ();
  gnome_app_fill_menu (GTK_MENU_SHELL (menu1), menu3_uiinfo,
                       NULL, FALSE, 0);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (optHFor), menu1);

  optHBak = gtk_option_menu_new ();
  gtk_widget_show (optHBak);
  gtk_box_pack_start (GTK_BOX (hbox4), optHBak, TRUE, TRUE, 0);

  menu1 = gtk_menu_new ();
  gnome_app_fill_menu (GTK_MENU_SHELL (menu1), menu4_uiinfo,
                       NULL, FALSE, 0);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (optHBak), menu1);

  g_signal_connect ((gpointer) chkColor, "toggled",
                    G_CALLBACK (on_chkColor_toggled),
                    NULL);
  g_signal_connect ((gpointer) optNFor, "changed",
                    G_CALLBACK (on_optGenSplashDev_changed),
                    NULL);
  g_signal_connect ((gpointer) optNBak, "changed",
                    G_CALLBACK (on_optGenSplashDev_changed),
                    NULL);
  g_signal_connect ((gpointer) optHFor, "changed",
                    G_CALLBACK (on_optHFor_changed),
                    NULL);
  g_signal_connect ((gpointer) optHBak, "changed",
                    G_CALLBACK (on_optHBak_changed),
                    NULL);

  GLADE_HOOKUP_OBJECT (winMain, chkColor, "chkColor");
  GLADE_HOOKUP_OBJECT (winMain, optNFor, "optNFor");
  GLADE_HOOKUP_OBJECT (winMain, optNBak, "optNBak");
  GLADE_HOOKUP_OBJECT (winMain, optHFor, "optHFor");
  GLADE_HOOKUP_OBJECT (winMain, optHBak, "optHBak");

  on_chkColor_toggled (GTK_TOGGLE_BUTTON (chkColor), NULL);

#endif


  chkGenHidden = gtk_check_button_new_with_mnemonic (_("Hidden Menu"));
  gtk_widget_show (chkGenHidden);
  gtk_table_attach (GTK_TABLE (table3), chkGenHidden, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label26 = gtk_label_new (_("Extra Options:"));
  gtk_widget_show (label26);
  gtk_table_attach (GTK_TABLE (table3), label26, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label26), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label26), 0, 0.5);

  hbox22 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox22);
  gtk_table_attach (GTK_TABLE (table3), hbox22, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  cmdMore = gtk_button_new ();
  gtk_widget_show (cmdMore);
  gtk_box_pack_start (GTK_BOX (hbox22), cmdMore, FALSE, FALSE, 0);
  gtk_widget_set_size_request (cmdMore, 82, 28);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (cmdMore), alignment3);

  hbox17 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox17);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox17);

  image2 = gtk_image_new_from_stock ("gtk-properties", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox17), image2, FALSE, FALSE, 0);

  label18 = gtk_label_new_with_mnemonic (_("Edit"));
  gtk_widget_show (label18);
  gtk_box_pack_start (GTK_BOX (hbox17), label18, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label18), GTK_JUSTIFY_LEFT);

  label7 = gtk_label_new (_("<b>Operating Systems</b>"));
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (vbox2), label7, FALSE, FALSE, 12);
  gtk_label_set_use_markup (GTK_LABEL (label7), TRUE);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox8, TRUE, TRUE, 0);

  hbox9 = gtk_hbox_new (FALSE, 12);
  gtk_widget_show (hbox9);
  gtk_box_pack_start (GTK_BOX (hbox8), hbox9, TRUE, TRUE, 20);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (hbox9), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_SHADOW_IN);

	
	GtkListStore *store = gtk_list_store_new (N_COLUMNS, 
	                                          G_TYPE_BOOLEAN, 
	                                          G_TYPE_STRING,
											  G_TYPE_POINTER);

	treeview1 = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
	  gtk_widget_set_size_request (treeview1, 320, 140);
  gtk_widget_show (treeview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), treeview1);

	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	
	renderer = gtk_cell_renderer_toggle_new ();
	gtk_cell_renderer_toggle_set_radio ( GTK_CELL_RENDERER_TOGGLE (renderer), TRUE);
	
	g_signal_connect ((gpointer) renderer, "toggled",
						G_CALLBACK (list_toggle),
						NULL);
	
	column = gtk_tree_view_column_new_with_attributes ("Default",
													   renderer,
													   "active", DEFAULT_COLUMN,
													   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview1), column);
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Title",
													   renderer,
													   "text", TITLE_COLUMN,
													   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview1), column);

  vbox3 = gtk_vbox_new (FALSE, 6);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox9), vbox3, FALSE, TRUE, 0);

  cmdOSNew = gtk_button_new_from_stock ("gtk-add");
  gtk_widget_show (cmdOSNew);
  gtk_box_pack_start (GTK_BOX (vbox3), cmdOSNew, FALSE, FALSE, 0);

  cmdOsEdit = gtk_button_new ();
  gtk_widget_show (cmdOsEdit);
  gtk_box_pack_start (GTK_BOX (vbox3), cmdOsEdit, FALSE, FALSE, 0);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (cmdOsEdit), alignment1);

  hbox10 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox10);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox10);

  image1 = gtk_image_new_from_stock ("gtk-properties", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox10), image1, FALSE, FALSE, 0);

  label8 = gtk_label_new_with_mnemonic (_("Edit"));
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (hbox10), label8, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_LEFT);

  cmdOsDelete = gtk_button_new_from_stock ("gtk-remove");
  gtk_widget_show (cmdOsDelete);
  gtk_box_pack_start (GTK_BOX (vbox3), cmdOsDelete, FALSE, FALSE, 0);

	hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 6);

  cmdOSHelpMain = gtk_button_new_from_stock ("gtk-help");
  gtk_widget_show (cmdOSHelpMain);
  gtk_box_pack_start (GTK_BOX (hbox1), cmdOSHelpMain, FALSE, FALSE, 12);
  gtk_widget_set_size_request (cmdOSHelpMain, 95, 30);

  cmdOSOkMain = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_show (cmdOSOkMain);
  gtk_box_pack_end (GTK_BOX (hbox1), cmdOSOkMain, FALSE, FALSE, 12);
  gtk_widget_set_size_request (cmdOSOkMain, 95, 30);

  cmdOSRevertMain = gtk_button_new_from_stock ("gtk-revert-to-saved");
  gtk_widget_show (cmdOSRevertMain);
  gtk_box_pack_end (GTK_BOX (hbox1), cmdOSRevertMain, FALSE, FALSE, 0);
  gtk_widget_set_size_request (cmdOSRevertMain, 95, 30);

  g_signal_connect ((gpointer) winMain, "destroy",
                    G_CALLBACK (on_winMain_destroy),
                    NULL);
  g_signal_connect ((gpointer) timeout_spin, "value_changed",
                    G_CALLBACK (on_timeout_spin_value_changed),
                    NULL);
  g_signal_connect ((gpointer) cmdMore, "clicked",
                    G_CALLBACK (on_cmdMore_clicked),
                    NULL);
  g_signal_connect ((gpointer) chkGenHidden, "toggled",
                    G_CALLBACK (on_chkGenHidden_clicked),
                    NULL);
  g_signal_connect ((gpointer) cmdOSNew, "clicked",
                    G_CALLBACK (on_cmdOSNew_clicked),
                    NULL);
  g_signal_connect ((gpointer) cmdOsEdit, "clicked",
                    G_CALLBACK (on_cmdOsEdit_clicked),
                    NULL);
  g_signal_connect ((gpointer) cmdOsDelete, "clicked",
                    G_CALLBACK (on_cmdOsDelete_clicked),
                    NULL);
  g_signal_connect ((gpointer) cmdOSHelpMain, "clicked",
                    G_CALLBACK (on_cmdOSHelpMain_clicked),
                    NULL);
  g_signal_connect ((gpointer) cmdOSOkMain, "clicked",
                    G_CALLBACK (on_cmdOSOkMain_clicked),
                    NULL);
  g_signal_connect ((gpointer) cmdOSRevertMain, "clicked",
                    G_CALLBACK (on_cmdOSRevertMain_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (winMain, winMain, "winMain");
  GLADE_HOOKUP_OBJECT (winMain, timeout_spin, "timeout_spin");
  GLADE_HOOKUP_OBJECT (winMain, cmdMore, "cmdMore");
  GLADE_HOOKUP_OBJECT (winMain, alignment3, "alignment3");
  GLADE_HOOKUP_OBJECT (winMain, chkGenHidden, "chkGenHidden");
  GLADE_HOOKUP_OBJECT (winMain, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (winMain, treeview1, "treeview1");
  GLADE_HOOKUP_OBJECT (winMain, cmdOSNew, "cmdOSNew");
  GLADE_HOOKUP_OBJECT (winMain, cmdOsEdit, "cmdOsEdit");
  GLADE_HOOKUP_OBJECT (winMain, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (winMain, cmdOsDelete, "cmdOsDelete");
  GLADE_HOOKUP_OBJECT (winMain, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (winMain, cmdOSHelpMain, "cmdOSHelpMain");
  GLADE_HOOKUP_OBJECT (winMain, cmdOSOkMain, "cmdOSOkMain");
  GLADE_HOOKUP_OBJECT (winMain, cmdOSRevertMain, "cmdOSRevertMain");

  return winMain;
}

GtkWidget*
create_diaMore (void)
{
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox4;
  GtkWidget *scrolledwindow2;
  GtkWidget *tvGenExtra;
  GtkWidget *dialog_action_area1;
  GtkWidget *cmdMoreClose;

  diaMore = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (diaMore), _("Extra Options"));

  dialog_vbox1 = GTK_DIALOG (diaMore)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox4, TRUE, TRUE, 0);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox4), scrolledwindow2, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow2, 360, 140);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  tvGenExtra = gtk_text_view_new ();
  gtk_widget_show (tvGenExtra);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), tvGenExtra);

  dialog_action_area1 = GTK_DIALOG (diaMore)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cmdMoreClose = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_show (cmdMoreClose);
  gtk_dialog_add_action_widget (GTK_DIALOG (diaMore), cmdMoreClose, GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (cmdMoreClose, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) diaMore, "destroy",
                    G_CALLBACK (on_diaMore_destroy),
                    NULL);
  g_signal_connect ((gpointer) cmdMoreClose, "clicked",
                    G_CALLBACK (on_cmdMoreClose_clicked),
                    NULL);
	g_signal_connect (G_OBJECT (gtk_text_view_get_buffer (GTK_TEXT_VIEW (tvGenExtra))), "changed",
				 G_CALLBACK (on_tvGenExtra_changed), NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (diaMore, diaMore, "diaMore");
  GLADE_HOOKUP_OBJECT_NO_REF (diaMore, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (diaMore, vbox4, "vbox4");
  GLADE_HOOKUP_OBJECT (diaMore, scrolledwindow2, "scrolledwindow2");
  GLADE_HOOKUP_OBJECT (diaMore, tvGenExtra, "tvGenExtra");
  GLADE_HOOKUP_OBJECT_NO_REF (diaMore, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (diaMore, cmdMoreClose, "cmdMoreClose");

  return diaMore;
}

GtkWidget *
create_diaOS (void)
{
	GtkWidget *alignment;
	GtkWidget *dialog_vbox1;
	GtkWidget *separator;
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *tbl1;
	GtkWidget *fraOSGeneral;
	GtkWidget *txtOSTitle;
	GtkWidget *optOSType;
	GtkWidget *optOSType_menu;
	GtkWidget *glade_menuitem;
	GtkWidget *label4;
	GtkWidget *label5;
	GtkWidget *fraOSLinux;
	GtkWidget *txtOSLinuxKernel;
	GtkWidget *cmdKernelFind;
	GtkWidget *cmdKernelOpts;
	GtkWidget *txtOSLinuxParams;
	GtkWidget *optLinuxBootDev;
	GtkWidget *optLinuxBootDev_menu;
	GtkWidget *optLinuxRootDev;
	GtkWidget *optLinuxRootDev_menu;
	GtkWidget *label21;
	GtkWidget *label9;
	GtkWidget *label10;
	GtkWidget *frame4;
	GtkWidget *scrolledwindow1;
	GtkWidget *tvOSLinuxExtra;
	GtkWidget *fraOSWindows;
	GtkWidget *optOSWinDev;
	GtkWidget *optOSWinDev_menu;
	GtkWidget *label18;
//	GtkWidget *frame7;
//	GtkWidget *scrolledwindow2;
//	GtkWidget *tvOSWinExtra;
	GtkWidget *fraOSOther;
	GtkWidget *scrolledwindow5;
	GtkWidget *tvOSOther;
	GtkWidget *dialog_action_area1;
	GtkWidget *cmdOSOk;
	GtkWidget *cmdOSApply;
	GtkWidget *cmdOSCancel;

	diaOS = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (diaOS), "diaOS", diaOS);
	gtk_window_set_title (GTK_WINDOW (diaOS), "Configure OS");
	GTK_WINDOW (diaOS)->type = GTK_WINDOW_TOPLEVEL;
	gtk_window_set_policy (GTK_WINDOW (diaOS), FALSE, TRUE, TRUE);
	gtk_window_set_modal (GTK_WINDOW (diaOS), TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (diaOS), 6);

  	dialog_vbox1 = GTK_DIALOG (diaOS)->vbox;
	gtk_object_set_data (GTK_OBJECT (diaOS), "dialog_vbox1",
			     dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	fraOSGeneral = gtk_frame_new ("General");
	gtk_widget_ref (fraOSGeneral);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "fraOSGeneral",
				  fraOSGeneral,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fraOSGeneral);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), fraOSGeneral, TRUE, FALSE, 0);
//	gtk_widget_set_usize (GTK_WIDGET (fraOSGeneral), 450, 65);

	vbox1 = gtk_vbox_new (TRUE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (fraOSGeneral), vbox1);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 10);

	label4 = gtk_label_new ("Title:");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "label4", label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (hbox1), label4, TRUE, TRUE, 2);
	gtk_widget_set_usize (label4, 40, 24);

	txtOSTitle = gtk_entry_new ();
	gtk_widget_ref (txtOSTitle);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "txtOSTitle",
				  txtOSTitle,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (txtOSTitle);
	gtk_box_pack_start (GTK_BOX (hbox1), txtOSTitle, TRUE, TRUE, 2);
	gtk_widget_set_usize (txtOSTitle, 158, 24);

	separator = gtk_vseparator_new ();
	gtk_box_pack_start (GTK_BOX (hbox1), separator, FALSE, TRUE, 10);
	gtk_widget_show (separator);

	label5 = gtk_label_new ("Type:");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "label5", label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (1, 0.5, 0, 0);
	gtk_widget_set_usize (alignment, 40, 24);
	gtk_container_add (GTK_CONTAINER (alignment), label5);
	gtk_box_pack_start (GTK_BOX (hbox1), alignment, TRUE, TRUE, 15);
	gtk_widget_show (label5);
	gtk_widget_show (alignment);

	optOSType = gtk_option_menu_new ();
	gtk_widget_ref (optOSType);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "optOSType", optOSType,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (optOSType);
	gtk_box_pack_start (GTK_BOX (hbox1), optOSType, TRUE, TRUE, 12);
	gtk_widget_set_usize (optOSType, 96, 26);
	optOSType_menu = gtk_menu_new ();
	glade_menuitem = gtk_menu_item_new_with_label ("Linux");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optOSType_menu), glade_menuitem);
	glade_menuitem = gtk_menu_item_new_with_label ("Windows");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optOSType_menu), glade_menuitem);
	glade_menuitem = gtk_menu_item_new_with_label ("Other");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optOSType_menu), glade_menuitem);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optOSType),
				  optOSType_menu);

	fraOSLinux = gtk_frame_new ("Linux");
	gtk_widget_ref (fraOSLinux);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "fraOSLinux",
				  fraOSLinux,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fraOSLinux);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), fraOSLinux, TRUE, TRUE,
			    0);
//	gtk_widget_set_usize (fraOSLinux, 420, 240);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (fraOSLinux), vbox1);
	gtk_widget_show (vbox1);
	
/*
	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 2);
*/

	tbl1 = gtk_table_new (4, 3, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (tbl1), 12);
	gtk_box_pack_start (GTK_BOX (vbox1), tbl1, TRUE, TRUE, 0);
	gtk_widget_show (tbl1);

	label21 = gtk_label_new ("System Root:");
	gtk_widget_ref (label21);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "label21", label21,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_set_size_request (label21, 160, 24);
	gtk_misc_set_alignment (GTK_MISC (label21), 0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), label21, 0, 1, 0, 1);
	gtk_widget_show (label21);

	optLinuxRootDev = gtk_option_menu_new ();
	gtk_widget_ref (optLinuxRootDev);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "optLinuxRootDev",
				  optLinuxRootDev,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (optLinuxRootDev);
	alignment = gtk_alignment_new (0, 0.5, 1, 0);
	gtk_container_add (GTK_CONTAINER (alignment), optLinuxRootDev);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), alignment, 1, 3, 0, 1);
	gtk_container_set_border_width (GTK_CONTAINER (alignment), 2);
	gtk_widget_show (optLinuxRootDev);
	gtk_widget_show (alignment);
	optLinuxRootDev_menu = gtk_menu_new ();
	dev_load_menu (optLinuxRootDev_menu);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optLinuxRootDev),
				  optLinuxRootDev_menu);


	label21 = gtk_label_new ("Kernel Device:");
	gtk_widget_ref (label21);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "label21", label21,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_set_size_request (label21, 160, 24);
	gtk_misc_set_alignment (GTK_MISC (label21), 0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), label21, 0, 1, 1, 2);
	gtk_widget_show (label21);

	optLinuxBootDev = gtk_option_menu_new ();
	gtk_widget_ref (optLinuxBootDev);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "optLinuxBootDev",
				  optLinuxBootDev,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (0, 0.5, 1, 0);
	gtk_container_add (GTK_CONTAINER (alignment), optLinuxBootDev);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), alignment, 1, 3, 1, 2);
	gtk_container_set_border_width (GTK_CONTAINER (alignment), 2);
	gtk_widget_show (optLinuxBootDev);
	gtk_widget_show (alignment);
	optLinuxBootDev_menu = gtk_menu_new ();
	dev_load_menu_path (optLinuxBootDev_menu, TRUE);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optLinuxBootDev),
				  optLinuxBootDev_menu);

	label9 = gtk_label_new ("Kernel Name:");
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "label9", label9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_set_size_request (label9, 160, 24);
	gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), label9, 0, 1, 2, 3);
	gtk_widget_show (label9);

	txtOSLinuxKernel = gtk_entry_new ();
	gtk_widget_ref (txtOSLinuxKernel);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "txtOSLinuxKernel",
				  txtOSLinuxKernel,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (0, 0.5, 1, 0);
	gtk_container_add (GTK_CONTAINER (alignment), txtOSLinuxKernel);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), alignment, 1, 2, 2, 3);
	gtk_container_set_border_width (GTK_CONTAINER (alignment), 2);
	gtk_widget_show (txtOSLinuxKernel);
	gtk_widget_show (alignment);

    cmdKernelFind = gtk_button_new_with_label ("...");
	gtk_widget_ref (cmdKernelFind);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "cmdKernelFind",
				  cmdKernelFind,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (0, 0.5, 1, 0);
	gtk_container_add (GTK_CONTAINER (alignment), cmdKernelFind); 
	gtk_table_attach_defaults (GTK_TABLE (tbl1), alignment, 2, 3, 2, 3);
	gtk_container_set_border_width (GTK_CONTAINER (alignment), 2);
	gtk_widget_show (cmdKernelFind);
	gtk_widget_show (alignment);


	label10 = gtk_label_new ("Kernel Parameters:");
	gtk_widget_ref (label10);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "label10", label10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_set_size_request (label10, 160, 24);
	gtk_misc_set_alignment (GTK_MISC (label10), 0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), label10, 0, 1, 3, 4);
	gtk_widget_show (label10);

	txtOSLinuxParams = gtk_entry_new ();
	gtk_editable_set_editable (GTK_EDITABLE (txtOSLinuxParams), FALSE);
	gtk_widget_ref (txtOSLinuxParams);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "txtOSLinuxParams",
				  txtOSLinuxParams,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (0, 0.5, 1, 0);
	gtk_container_add (GTK_CONTAINER (alignment), txtOSLinuxParams);
	gtk_table_attach_defaults (GTK_TABLE (tbl1), alignment, 1, 2, 3, 4);
	gtk_container_set_border_width (GTK_CONTAINER (alignment), 2);
		
	gtk_widget_show (txtOSLinuxParams);
	gtk_widget_show (alignment);

    cmdKernelOpts = gtk_button_new ();
	GtkWidget *hbox_button = gtk_hbox_new (FALSE, 0);
	GtkWidget *label_button1 = gtk_image_new_from_icon_set(gtk_icon_factory_lookup_default(
					      GTK_STOCK_PROPERTIES),
					      GTK_ICON_SIZE_BUTTON);
	GtkWidget *label_button2 = gtk_label_new(_("Edit"));
	gtk_box_pack_start (GTK_BOX (hbox_button), label_button1, FALSE, FALSE, 3);
	gtk_box_pack_start (GTK_BOX (hbox_button), label_button2, FALSE, FALSE, 3);	
	gtk_widget_show(label_button1);
	gtk_widget_show(label_button2);
	gtk_widget_show(hbox_button);
	alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (alignment), hbox_button);
	gtk_container_add (GTK_CONTAINER (cmdKernelOpts), alignment);
	gtk_widget_show (alignment);
	gtk_widget_ref (cmdKernelOpts);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "cmdKernelOpts",
				  cmdKernelOpts,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (0, 0.5, 1, 0);
	gtk_container_add (GTK_CONTAINER (alignment), cmdKernelOpts); 
	gtk_table_attach_defaults (GTK_TABLE (tbl1), alignment, 2, 3, 3, 4);
	gtk_container_set_border_width (GTK_CONTAINER (alignment), 2);
	gtk_widget_show (cmdKernelOpts);
	gtk_widget_show (alignment);


	frame4 = gtk_frame_new (_("Extra Options"));
	gtk_widget_ref (frame4);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "frame4", frame4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame4);
	gtk_box_pack_start (GTK_BOX (vbox1), frame4, FALSE, TRUE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (frame4), 12);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "scrolledwindow1",
				  scrolledwindow1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_container_add (GTK_CONTAINER (frame4), scrolledwindow1);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
					GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	tvOSLinuxExtra = gtk_text_view_new ();
	gtk_widget_ref (tvOSLinuxExtra);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "tvOSLinuxExtra",
				  tvOSLinuxExtra,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tvOSLinuxExtra);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), tvOSLinuxExtra);
	gtk_text_view_set_editable (GTK_TEXT_VIEW (tvOSLinuxExtra), TRUE);


	fraOSWindows = gtk_frame_new ("Windows");
	gtk_widget_ref (fraOSWindows);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "fraOSWindows",
				  fraOSWindows,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), fraOSWindows, TRUE, TRUE,
			    0);
	gtk_widget_set_usize (fraOSWindows, 420, 100);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (fraOSWindows), vbox1);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 20);

	label18 = gtk_label_new ("Location:");
	gtk_widget_ref (label18);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "label18", label18,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (0, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (alignment), label18);
	gtk_box_pack_start (GTK_BOX (hbox1), alignment, TRUE, TRUE, 25);
	gtk_widget_show (label18);
	gtk_widget_show (alignment);

	optOSWinDev = gtk_option_menu_new ();
	gtk_widget_ref (optOSWinDev);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "optOSWinDev",
				  optOSWinDev,
				  (GtkDestroyNotify) gtk_widget_unref);
	alignment = gtk_alignment_new (0, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (alignment), optOSWinDev);
	gtk_box_pack_start (GTK_BOX (hbox1), alignment, TRUE, TRUE, 12);
	gtk_widget_show (optOSWinDev);
	gtk_widget_show (alignment);
	optOSWinDev_menu = gtk_menu_new ();
	dev_load_menu (optOSWinDev_menu);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optOSWinDev),
				  optOSWinDev_menu);

	fraOSOther = gtk_frame_new ("Other");
	gtk_widget_ref (fraOSOther);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "fraOSOther",
				  fraOSOther,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), fraOSOther, TRUE, TRUE,
			    0);
	gtk_widget_set_usize (fraOSOther, 420, 150);

	scrolledwindow5 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow5);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "scrolledwindow5",
				  scrolledwindow5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow5);
	gtk_container_add (GTK_CONTAINER (fraOSOther), scrolledwindow5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5),
					GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	tvOSOther = gtk_text_view_new ();
	gtk_widget_ref (tvOSOther);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "tvOSOther",
				  tvOSOther,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tvOSOther);
	gtk_container_add (GTK_CONTAINER (scrolledwindow5), tvOSOther);
	gtk_text_view_set_editable (GTK_TEXT_VIEW (tvOSOther), TRUE);

	dialog_action_area1 = GTK_DIALOG (diaOS)->action_area;
	gtk_object_set_data (GTK_OBJECT (diaOS), "dialog_action_area1",
			     dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1),
					5);

	cmdOSApply = gtk_button_new_from_stock (GTK_STOCK_APPLY);
	gtk_widget_ref (cmdOSApply);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "cmdOSApply",
				  cmdOSApply,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cmdOSApply);
	gtk_box_pack_start (GTK_BOX (dialog_action_area1), cmdOSApply, FALSE,
			    FALSE, 12);
//	gtk_container_set_border_width (GTK_CONTAINER (cmdOSApply), 4);
	gtk_widget_set_usize (cmdOSApply, 85, 0);

	cmdOSCancel = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	gtk_widget_ref (cmdOSCancel);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "cmdOSCancel",
				  cmdOSCancel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cmdOSCancel);
	gtk_box_pack_start (GTK_BOX (dialog_action_area1), cmdOSCancel, FALSE,
			    FALSE, 0);
//	gtk_container_set_border_width (GTK_CONTAINER (cmdOSCancel), 4);
	gtk_widget_set_usize (cmdOSCancel, 85, 0);

	cmdOSOk = gtk_button_new_from_stock (GTK_STOCK_OK);
	gtk_widget_ref (cmdOSOk);
	gtk_object_set_data_full (GTK_OBJECT (diaOS), "cmdOSOk", cmdOSOk,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cmdOSOk);
	gtk_box_pack_start (GTK_BOX (dialog_action_area1), cmdOSOk, FALSE,
			    FALSE, 12);
//	gtk_container_set_border_width (GTK_CONTAINER (cmdOSOk), 4);
	gtk_widget_set_usize (cmdOSOk, 85, 0);

	gtk_signal_connect (GTK_OBJECT (txtOSTitle), "changed",
			    GTK_SIGNAL_FUNC (on_txtOSTitle_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (optOSType_menu), "deactivate",
			    GTK_SIGNAL_FUNC (on_optOSType_menu_clicked),
			    NULL);
	gtk_signal_connect (GTK_OBJECT (cmdKernelFind), "clicked",
			    GTK_SIGNAL_FUNC (on_cmdFileFind_clicked), NULL);
	gtk_signal_connect (GTK_OBJECT (cmdKernelOpts), "clicked",
			    GTK_SIGNAL_FUNC (on_cmdKernelOpts_clicked), NULL);
	gtk_signal_connect (GTK_OBJECT (cmdOSOk), "clicked",
			    GTK_SIGNAL_FUNC (on_cmdOSOk_clicked), NULL);
	gtk_signal_connect (GTK_OBJECT (cmdOSApply), "clicked",
			    GTK_SIGNAL_FUNC (on_cmdOSApply_clicked), NULL);
	gtk_signal_connect (GTK_OBJECT (cmdOSCancel), "clicked",
			    GTK_SIGNAL_FUNC (on_cmdOSCancel_clicked), NULL);
	gtk_signal_connect (GTK_OBJECT (diaOS), "destroy",
			    GTK_SIGNAL_FUNC (on_diaOS_destroy), NULL);

	return diaOS;
}


GtkWidget *
create_diaHelp (void)
{
	GtkWidget *dialog_vbox1;
	GtkWidget *cmdManual;
	GtkWidget *cmdAbout;
	GtkWidget *hbox1;
	GtkWidget *alignment;
	GtkWidget *label16;
	GtkWidget *label17;
	
	
	diaHelp = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (diaHelp), "diaHelp", diaOS);
	gtk_window_set_title (GTK_WINDOW (diaHelp), "Help");
	GTK_WINDOW (diaHelp)->type = GTK_WINDOW_TOPLEVEL;
	gtk_window_set_policy (GTK_WINDOW (diaHelp), FALSE, TRUE, TRUE);
	gtk_window_set_modal (GTK_WINDOW (diaHelp), TRUE);

  	dialog_vbox1 = gtk_vbox_new (TRUE, 6);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (diaHelp)->vbox), dialog_vbox1);
	gtk_widget_show (dialog_vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (dialog_vbox1), 12);
	
	cmdManual = gtk_button_new ();
	hbox1 = gtk_hbox_new (FALSE, 0);
	label16 = gtk_image_new_from_icon_set(gtk_icon_factory_lookup_default(GNOME_STOCK_PIXMAP_BOOK_GREEN), GTK_ICON_SIZE_BUTTON);
	label17 = gtk_label_new("Manual");
	gtk_widget_show(label16);
	gtk_widget_show(label17);
    gtk_box_pack_start (GTK_BOX (hbox1), label16, FALSE, FALSE, 3);
    gtk_box_pack_start (GTK_BOX (hbox1), label17, FALSE, FALSE, 3);	
	alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (alignment), hbox1);
	gtk_container_add (GTK_CONTAINER (cmdManual), alignment);
	gtk_widget_show (hbox1);
	gtk_widget_show (alignment);
	gtk_widget_ref (cmdManual);
	gtk_object_set_data_full (GTK_OBJECT (winMain), "cmdManual",
				  cmdManual,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cmdManual);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), cmdManual, TRUE, TRUE, 0);
	gtk_widget_set_usize (GTK_WIDGET (cmdManual), 110, 30);
//	gtk_container_set_border_width (GTK_CONTAINER (cmdManual), 24);


	cmdAbout = gtk_button_new_from_stock (GNOME_STOCK_PIXMAP_ABOUT);
	gtk_widget_ref (cmdAbout);
	gtk_object_set_data_full (GTK_OBJECT (winMain), "cmdAbout",
				  cmdAbout,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cmdAbout);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), cmdAbout, TRUE, TRUE, 0);
	gtk_widget_set_usize (GTK_WIDGET (cmdAbout), 110, 30);
//	gtk_container_set_border_width (GTK_CONTAINER (cmdAbout), 12);
	
	gtk_signal_connect (GTK_OBJECT (cmdManual), "clicked",
			    GTK_SIGNAL_FUNC (on_cmdManual_clicked), NULL);
	gtk_signal_connect (GTK_OBJECT (cmdAbout), "clicked",
			    GTK_SIGNAL_FUNC (on_cmdAbout_clicked), NULL);
	
	return diaHelp;

}


GtkWidget*
create_diaKernel (void)
{
  GtkWidget *dialog_vbox2;
  GtkWidget *vbox5;
  GtkWidget *chkRO;
  GtkWidget *chkScsi;
  GtkWidget *hbox13;
  GtkWidget *table6;
  GtkWidget *chkScsiHda;
  GtkWidget *chkScsiHdb;
  GtkWidget *chkScsiHdc;
  GtkWidget *chkScsiHdd;
  GtkWidget *hbox14;
  GtkWidget *chkOther;
  GtkWidget *txtOther;
  GtkWidget *dialog_action_area2;
  GtkWidget *cmdKernCancel;
  GtkWidget *cmdKernOk;

  diaKernel = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (diaKernel), _("Kernel Parameters"));
  gtk_window_set_resizable (GTK_WINDOW (diaKernel), FALSE);
  
  gtk_window_set_modal (GTK_WINDOW (diaKernel), TRUE);
  dialog_vbox2 = GTK_DIALOG (diaKernel)->vbox;
  gtk_widget_show (dialog_vbox2);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox5, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox5), 12);

  chkRO = gtk_check_button_new_with_mnemonic (_("Mount root device read-only durring boot"));
  gtk_widget_show (chkRO);
  gtk_box_pack_start (GTK_BOX (vbox5), chkRO, FALSE, FALSE, 0);

  chkScsi = gtk_check_button_new_with_mnemonic (_("SCSI Emulation Devices"));
  gtk_widget_show (chkScsi);
  gtk_box_pack_start (GTK_BOX (vbox5), chkScsi, FALSE, FALSE, 6);

  hbox13 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox13);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox13, FALSE, TRUE, 0);

  table6 = gtk_table_new (2, 2, TRUE);
  gtk_widget_show (table6);
  gtk_box_pack_start (GTK_BOX (hbox13), table6, TRUE, TRUE, 16);

  chkScsiHda = gtk_check_button_new_with_mnemonic (_("/dev/hda"));
  gtk_widget_show (chkScsiHda);
  gtk_table_attach (GTK_TABLE (table6), chkScsiHda, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chkScsiHda), 4);

  chkScsiHdb = gtk_check_button_new_with_mnemonic (_("/dev/hdb"));
  gtk_widget_show (chkScsiHdb);
  gtk_table_attach (GTK_TABLE (table6), chkScsiHdb, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chkScsiHdb), 4);

  chkScsiHdc = gtk_check_button_new_with_mnemonic (_("/dev/hdc"));
  gtk_widget_show (chkScsiHdc);
  gtk_table_attach (GTK_TABLE (table6), chkScsiHdc, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chkScsiHdc), 4);

  chkScsiHdd = gtk_check_button_new_with_mnemonic (_("/dev/hdd"));
  gtk_widget_show (chkScsiHdd);
  gtk_table_attach (GTK_TABLE (table6), chkScsiHdd, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chkScsiHdd), 4);

  hbox14 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox14);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox14, FALSE, TRUE, 6);

  chkOther = gtk_check_button_new_with_mnemonic (_("Other Options"));
  gtk_widget_show (chkOther);
  gtk_box_pack_start (GTK_BOX (hbox14), chkOther, FALSE, FALSE, 0);

  txtOther = gtk_entry_new ();
  gtk_widget_show (txtOther);
  gtk_object_set_data_full (GTK_OBJECT (diaKernel), "txtOther",
				  txtOther,
				  (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox14), txtOther, TRUE, TRUE, 6);

  dialog_action_area2 = GTK_DIALOG (diaKernel)->action_area;
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);

  cmdKernCancel = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cmdKernCancel);
  gtk_dialog_add_action_widget (GTK_DIALOG (diaKernel), cmdKernCancel, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cmdKernCancel, GTK_CAN_DEFAULT);

  cmdKernOk = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (cmdKernOk);
  gtk_dialog_add_action_widget (GTK_DIALOG (diaKernel), cmdKernOk, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (cmdKernOk, GTK_CAN_DEFAULT);

  g_signal_connect (GTK_OBJECT (diaKernel), "destroy",
                    GTK_SIGNAL_FUNC (on_diaKernel_destroy),
                    NULL);
					
  g_signal_connect (GTK_OBJECT (chkScsi), "toggled",
                    GTK_SIGNAL_FUNC (on_chkScsi_toggled),
                    NULL);
				
  g_signal_connect (GTK_OBJECT (chkOther), "toggled",
                    GTK_SIGNAL_FUNC (on_chkOther_toggled),
                    NULL);
					
  g_signal_connect (GTK_OBJECT (cmdKernCancel), "clicked",
                    GTK_SIGNAL_FUNC (on_cmdKernCancel_clicked),
                    NULL);

	g_signal_connect (GTK_OBJECT (cmdKernOk), "clicked",
                    GTK_SIGNAL_FUNC (on_cmdKernOk_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (diaKernel, diaKernel, "diaKernel");
  GLADE_HOOKUP_OBJECT_NO_REF (diaKernel, dialog_vbox2, "dialog_vbox2");
  GLADE_HOOKUP_OBJECT (diaKernel, vbox5, "vbox5");
  GLADE_HOOKUP_OBJECT (diaKernel, chkRO, "chkRO");
  GLADE_HOOKUP_OBJECT (diaKernel, chkScsi, "chkScsi");
  GLADE_HOOKUP_OBJECT (diaKernel, hbox13, "hbox13");
  GLADE_HOOKUP_OBJECT (diaKernel, table6, "table6");
  GLADE_HOOKUP_OBJECT (diaKernel, chkScsiHda, "chkScsiHda");
  GLADE_HOOKUP_OBJECT (diaKernel, chkScsiHdb, "chkScsiHdb");
  GLADE_HOOKUP_OBJECT (diaKernel, chkScsiHdc, "chkScsiHdc");
  GLADE_HOOKUP_OBJECT (diaKernel, chkScsiHdd, "chkScsiHdd");
  GLADE_HOOKUP_OBJECT (diaKernel, hbox14, "hbox14");
  GLADE_HOOKUP_OBJECT (diaKernel, chkOther, "chkOther");
  GLADE_HOOKUP_OBJECT (diaKernel, txtOther, "txtOther");
  GLADE_HOOKUP_OBJECT_NO_REF (diaKernel, dialog_action_area2, "dialog_action_area2");
  GLADE_HOOKUP_OBJECT (diaKernel, cmdKernCancel, "cmdKernCancel");
  GLADE_HOOKUP_OBJECT (diaKernel, cmdKernOk, "cmdKernOk");

  return diaKernel;
}
