#include <stdio.h>
#include <math.h>
#include <ppm.h>

int main (int argc, char **argv) {
   FILE *strip = NULL;
   FILE *window = NULL;
   int stripRows, stripCols, stripFormat;
   int windowRows, windowCols, windowFormat;
   pixval stripMaxval, windowMaxval;
   pixel **stripArray, **windowArray;
   register int marginH, marginV;
   register int deltaH, deltaV;
   int bestDeltaH, bestDeltaV, bestErr, interval;
   register int row, col, err;
   register double errSumSquare;
#define DIFF(p,q) ((p)>(q)?((p)-(q)):((q)-(p)))
   pixel stripPixel, windowPixel;
   if (argc < 3) {
      fprintf(stderr, "Usage: match stripfile.ppm windowfile.ppm [interval]\n");
      exit(1);
   }
   interval = 0;
   if (argc > 3) {
      interval = atoi(argv[3]);
   }
   if (interval < 1) {
      interval = 1;
   }
   strip = fopen(argv[1], "r");
   if (!strip) {
      perror("Can't open strip file");
      exit(1);
   }
   window = fopen(argv[2], "r");
   if (!window) {
      perror("Can't open window file");
      exit(1);
   }
   stripArray = ppm_readppm(strip, &stripCols, &stripRows, &stripMaxval);
   if (stripMaxval != 255) {
      fprintf(stderr, "Strip file is not a PPM, maxval 255\n");
      exit(1);
   }
   windowArray = ppm_readppm(window, &windowCols, &windowRows, &windowMaxval);
   if (windowMaxval != 255) {
      fprintf(stderr, "Window file is not a PPM, maxval 255\n");
      exit(1);
   }
   marginH = (windowCols - stripCols) / 2;
   marginV = (windowRows - stripRows) / 2;
   bestErr = 0x7FFFFFFF;
   for (deltaH = -marginH ; deltaH <= marginH; deltaH += interval) {
      for (deltaV = -marginV ; deltaV <= marginV; deltaV += interval) {
/*
 * TBD - review the sign of deltaV to make sure it has the same sense
 * as exists elsewhere in the tool chain
 */
	 errSumSquare = 0.0;
	 for (row = 0 ; row < stripRows; row++) {
	    for (col = 0 ; col < stripCols; col ++) {
	       stripPixel = stripArray[row][col];
	       windowPixel = windowArray[row+marginV+deltaV][col+marginH+deltaH];
	       err = ((299 * DIFF(stripPixel.r,windowPixel.r)) +
			(587 * DIFF(stripPixel.g,windowPixel.g)) +
			(114 * DIFF(stripPixel.b,windowPixel.b))) / 1000;
	       errSumSquare += err * err;
	    }
	 }
	 errSumSquare /= stripRows * stripCols / 10;
	 err = (int) sqrt(errSumSquare);
	 if (err < bestErr) {
	    bestErr = err;
	    bestDeltaH = deltaH;
	    bestDeltaV = deltaV;
	    fprintf(stderr, "Offset %d %d error %d\n", deltaH, deltaV, err);
	 }
      }
   }
   fclose(strip);
   fclose(window);
   printf("%d %d %d\n", bestDeltaH, bestDeltaV, bestErr);
}
      

