/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "gettext.h"
#include "widgets.h"
#include "commands.h"
#include "add_standard_users.h"
#include "system_defines.h"
#include "functions.h"
#include "show_info.h"



int add_standard_users()
{
    /* The sambamachines group and users NOBODY and smbguest accounts 
       must exist so add them if they are missing */
    FILE *fp;
    gchar *cmd, *info, *username;

    /* Add group NOBODY and the user NOBODY to that group */
    username = g_strdup_printf("%s", NOBODY);
    if( ! user_exists(username) )
    {
        /* Add the NOBODY system group if it doesnt exist */
        if( ! group_exists(username) )
        {
            cmd = g_strdup_printf("%s %s", "groupadd", username);
            if( ! run_command(cmd) )
            {
                printf("Error adding system group: %s\n", username);
                printf("The command was: %s\n", cmd);
                g_free(cmd);
                g_free(username);
                return 0;
            }
            g_free(cmd);
        }

        /* Add the NOBODY user to the NOBODY group and lock the account */
        cmd = g_strdup_printf("%s '%s' -l -d '/dev/null' -c 'Nobody' -s '/dev/null' -g '%s'", "useradd", username, username);
        if( ! run_command(cmd) )
        {
            printf("Error adding the system user: %s\n", username);
    	    printf("The command was: %s\n", cmd);
            g_free(cmd);
            g_free(username);
            return 0;
        }
        g_free(cmd);

	/* To be really sure we check it again with the same function */
	if( ! user_exists(username) )
	{
    	    info = g_strdup_printf(_("Failed adding the system user:\n%s\n"), username);
    	    show_info(info);
    	    g_free(info);
    	    g_free(username);
    	    return 0;
	}
    }
    g_free(username);


    /* Add the smbguest system user to the NOBODY group and lock the account */
    username = g_strdup_printf("%s", "smbguest");
    if( ! user_exists(username) )
    {
        /* Add the user to the NOBODY group */
        cmd = g_strdup_printf("%s '%s' -l -d '/dev/null' -c 'Samba guest account' -s '/dev/null' -g '%s'", "useradd", username, NOBODY);
        if( ! run_command(cmd) )
        {
            printf("Error adding the system user: %s\n", username);
    	    printf("The command was: %s\n", cmd);
            g_free(cmd);
            g_free(username);
            return 0;
        }
        g_free(cmd);

	/* To be really sure we check it again with the same function */
	if( ! user_exists(username) )
	{
    	    info = g_strdup_printf(_("Failed adding the system user:\n%s\n"), username);
    	    show_info(info);
    	    g_free(info);
    	    g_free(username);
    	    return 0;
	}

	/* The smbguest user also needs to be added to the smbpasswd file as a locked user */
	cmd = g_strdup_printf("%s -a -d '%s'\n", SMBPASSWD_BINARY, username);
	if((fp=popen(cmd, "w"))==NULL)
	{
    	    perror("popen");
    	    info = g_strdup_printf(_("Failed adding default samba user: %s\n"), username);
    	    show_info(info);
    	    g_free(info);
    	    g_free(cmd);
	    g_free(username);
    	    return 0;
	}
	pclose(fp);
	g_free(cmd);
    }
    g_free(username);


    /* The sambamachines account also needs to exist in order to automatically 
       add valid(username+password) connecting computers BIOS-id's as computer accounts */
    username = g_strdup_printf("%s", "sambamachines");
    if( ! group_exists(username) )
    {
        cmd = g_strdup_printf("%s %s", "groupadd", username);
        if( ! run_command(cmd) )
        {
            printf("Error adding system group: %s\n", username);
            printf("The command was: %s\n", cmd);
            g_free(cmd);
            g_free(username);
            return 0;
        }
        g_free(cmd);
    }
    g_free(username);    

    return 1;
}
