/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/




#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "commented.h"
#include "reread_conf.h"
#include "show_info.h"
#include "apply_server_settings.h"
#include "populate_server_settings.h"
#include "populate_conf_tab.h"

extern int activated;

/* Write the new file or just print the changes */
#define WRITE_CHANGES 1



void apply_server_settings(struct w *widgets)
{
    /* Change the selected servers configuration. */
    FILE *fp;
    long conf_size;
    gint active_index = 0, sec_index = 0;
    gchar *info;
    int global_section_found = 0;
    int sec_changed = 0;
    int dom_logons = 0;
    char *line, *conf_line, *new_conf;


    /* If the security level combo is changed, change all other relevant options. */
    sec_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[0]));

    /* Compare the current security level and domain logons option */
    if((fp=fopen(SAMBA_CONF, "r"))==NULL)
    {
	info = g_strdup_printf(_("Cant open smb.conf here: \n%s\n"), SAMBA_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    /* Check if domain logons is set */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strstr(line, "domain logons") && strstr(line, "yes") && ! commented(line) )
	{
	    dom_logons = 1;
	    break;
	}
	
	/* A share is found, break. */
	if( strstr(line, "[") && ! strstr(line, "[global]") && ! commented(line) )
	  break;
    }
    rewind(fp);
    

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strstr(line, "security =") && strstr(line, "user") 
	&& ! dom_logons && sec_index !=0 && ! commented(line) && ! sec_changed )
	  sec_changed = 1;	  
	else
	if( strstr(line, "security =") && strstr(line, "user")
	&& dom_logons && sec_index !=1 && ! commented(line) && ! sec_changed )
	  sec_changed = 1;	  
	else
	if( strstr(line, "security =") && strstr(line, "domain") 
	&& sec_index !=2 && ! commented(line) && ! sec_changed )
	  sec_changed = 1;	  
	else
	if( strstr(line, "security =") && strstr(line, "ads") 
	&& sec_index !=3 && ! commented(line) && ! sec_changed )
	  sec_changed = 1;	  

	if( sec_changed )
	  break;

	/* A share is found, break. */
	if( strstr(line, "[") && ! strstr(line, "[global]") && ! commented(line) )
	  break;
    }
    fclose(fp);
    free(line);
    

    if( sec_changed )
    {
	if( sec_index == 0 )
	  info = g_strdup_printf(_("Auto configuration for \"user\" security level done.\nPlease review any changes.\n"));
	else
	if( sec_index == 1 )
	  info = g_strdup_printf(_("Auto configuration for \"backup domain\" security level done.\nPlease review any changes.\n"));
	else
	if( sec_index == 2 )
	  info = g_strdup_printf(_("Auto configuration for \"primary domain\" security level done.\nPlease review any changes.\n"));
	else
	if( sec_index == 3 )
	  info = g_strdup_printf(_("Auto configuration for \"Active directory\" security level done.\nPlease review any changes.\n"));
	else	
	  info = g_strdup_printf(_("Error!!! Auto configuration for \"No\" security level done.\nPlease review any changes.\n"));
	
	show_info(info);
	g_free(info);
    }

    /* Entries */
    G_CONST_RETURN gchar *server_name;
    G_CONST_RETURN gchar *server_comment;
    G_CONST_RETURN gchar *domain_workgroup;
    G_CONST_RETURN gchar *allowed_nets;
    G_CONST_RETURN gchar *listen_nets;
    G_CONST_RETURN gchar *announce_server_to;
    G_CONST_RETURN gchar *retrieve_announce_from;
    G_CONST_RETURN gchar *printcap_path;
    G_CONST_RETURN gchar *guest_users;
    G_CONST_RETURN gchar *samba_logfile;
//  Will be used later    G_CONST_RETURN gchar *password_server;
    G_CONST_RETURN gchar *samba_password_file;
    G_CONST_RETURN gchar *samba_password_program;
    G_CONST_RETURN gchar *new_pass_phrase;
    G_CONST_RETURN gchar *samba_username_mapfile;
    G_CONST_RETURN gchar *samba_add_user_script;
    G_CONST_RETURN gchar *socket_options;
    G_CONST_RETURN gchar *wins_servers;
    G_CONST_RETURN gchar *logon_drive;
    G_CONST_RETURN gchar *logon_home;
    G_CONST_RETURN gchar *logon_path;
    G_CONST_RETURN gchar *logon_script;
    G_CONST_RETURN gchar *name_resolve_order;
    G_CONST_RETURN gchar *idmap_uid;
    G_CONST_RETURN gchar *idmap_gid;
    G_CONST_RETURN gchar *template_shell;

    /* Spinbuttons */
    G_CONST_RETURN gchar *max_log_file_size;
    G_CONST_RETURN gchar *username_match_level;
    G_CONST_RETURN gchar *password_match_level;
    G_CONST_RETURN gchar *election_level;


    if( ! strstr(SAMBA_CONF, "smb.conf") )
    {
	info = g_strdup_printf(_("The define for SAMBA_CONF is bad, please reinstall the application.\n"));
	show_info(info);
	g_free(info);
        return;
    }

    /* Get settings from the entries */
    server_name = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[0]));
    server_comment = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[1]));
    domain_workgroup = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[2]));
    allowed_nets = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[3]));
    listen_nets = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[4]));
    announce_server_to = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[5]));
    retrieve_announce_from = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[6]));
    printcap_path = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[7]));
    guest_users = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[8]));
    samba_logfile = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[9]));

//  Pos will be used later  password_server = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[10]));

    samba_username_mapfile = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[11]));
    samba_add_user_script = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[12]));
    samba_password_file = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[13]));
    samba_password_program = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[14]));
    new_pass_phrase = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[15]));
    socket_options = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[16]));
    logon_drive = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[17]));

    logon_home = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[18]));

    logon_path = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[19]));
    logon_script = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[20]));
    name_resolve_order = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[21]));
    wins_servers = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[22]));
    idmap_uid = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[23]));
    idmap_gid = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[24]));
    template_shell = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[25]));

    /* Get settings from the spinbuttons */
    max_log_file_size = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_spinbutton[0]));
    username_match_level = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_spinbutton[1]));
    password_match_level = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_spinbutton[2]));
    election_level = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_spinbutton[3]));


    if( strlen(server_name) == 0 ) 
    {
	info = g_strdup_printf(_("Please specify the server name.\n"));
	show_info(info);
	g_free(info);
        return;
    }
    if( strlen(domain_workgroup) == 0 ) 
    {
	info = g_strdup_printf(_("Please specify a workgroup or domain name.\n"));
	show_info(info);
	g_free(info);
        return;
    }


    /* Change the configuration for the selected server */
    if((fp=fopen(SAMBA_CONF, "r"))==NULL)
    {
	info = g_strdup_printf(_("Cant open smb.conf here: \n%s\n"), SAMBA_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    conf_line = allocate(conf_size+1);
    /* Additional bytes for changes, 350 chars per 
       entry widget * 100 widgets + 20000 for the directives */
    new_conf = allocate(conf_size+(350*100)+20000); 

    /* First scroll to the global section */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	strcat(new_conf, line);
	if( strstr(line, "[global]") && ! commented(line) )
	{
	    global_section_found = 1;
	    break;
	}
    }

    if( ! global_section_found )
    {
	info = g_strdup_printf(_("Can not find the [global] section in %s\nNo changes made.\n"), SAMBA_CONF);
	show_info(info);
	g_free(info);
	fclose(fp);
	free(line);
	free(conf_line);
	free(new_conf);
        return;
    }

    
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strlen(line) > 4000 )
	{
	    info = g_strdup_printf(_("A line with over 4000 chars is not valid in: %s\n"), SAMBA_CONF);
	    show_info(info);
	    g_free(info);
	    fclose(fp);
	    free(line);
	    free(conf_line);
	    free(new_conf);
	    return;
	}

	/* Break at any share definition "[" and collect them in the next while loop */
	if( strstr(line, "[") && strstr(line, "]") && ! commented(line) )
	{
	    strcat(new_conf, line);
	    break;
	}


	/* Change matching server directives otherwise just gather them */
	if( strstr(line, "netbios name") && ! commented(line) )
	{
    	    sprintf(conf_line, "netbios name = %s\n", server_name);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "server string") && ! commented(line) )
    	{          	
    	    sprintf(conf_line, "server string = %s\n", server_comment);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "workgroup") && ! commented(line) )
	{
    	    sprintf(conf_line, "workgroup = %s\n", domain_workgroup);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "hosts allow") && ! commented(line) )
	{
    	    sprintf(conf_line, "hosts allow = %s\n", allowed_nets);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "interfaces") && ! commented(line) )
	{
    	    sprintf(conf_line, "interfaces = %s\n", listen_nets);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "remote announce") && ! commented(line) )
	{
	    sprintf(conf_line, "remote announce = %s\n", announce_server_to);
	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "remote browse sync") && ! commented(line) )
	{
	    sprintf(conf_line, "remote browse sync = %s\n", retrieve_announce_from);
	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "printcap name") && ! commented(line) )
	{
    	    sprintf(conf_line, "printcap name = %s\n", printcap_path);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "guest account") && ! commented(line) )
	{
    	    sprintf(conf_line, "guest account = %s\n", guest_users);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "log file") && ! commented(line) )
	{
    	    sprintf(conf_line, "log file = %s\n", samba_logfile);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "username map") && ! commented(line) )
	{
    	    sprintf(conf_line, "username map = %s\n", samba_username_mapfile);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "add user script") && ! commented(line) )
	{
    	    sprintf(conf_line, "add user script = %s\n", samba_add_user_script);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "smb passwd file") && ! commented(line) )
	{
    	    sprintf(conf_line, "smb passwd file = %s\n", samba_password_file);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "passwd program") && ! commented(line) )
	{
    	    sprintf(conf_line, "passwd program = %s\n", samba_password_program);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "passwd chat") && ! commented(line) )
	{
    	    sprintf(conf_line, "passwd chat = %s\n", new_pass_phrase);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "socket options") && ! commented(line) )
	{
    	    sprintf(conf_line, "socket options = %s\n", socket_options);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "name resolve order") && ! commented(line) )
	{
    	    sprintf(conf_line, "name resolve order = %s\n", name_resolve_order);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "wins server") && ! commented(line) )
	{
    	    sprintf(conf_line, "wins server = %s\n", wins_servers);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "idmap uid") && ! commented(line) )
	{
    	    sprintf(conf_line, "idmap uid = %s\n", idmap_uid);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "idmap gid") && ! commented(line) )
	{
    	    sprintf(conf_line, "idmap gid = %s\n", idmap_gid);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "template shell") && ! commented(line) )
	{
    	    sprintf(conf_line, "template shell = %s\n", template_shell);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "logon drive") && ! commented(line) )
	{
    	    sprintf(conf_line, "logon drive = %s\n", logon_drive);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "logon home") && ! commented(line) )
	{
    	    sprintf(conf_line, "logon home = %s\n", logon_home);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "logon path") && ! commented(line) )
	{
    	    sprintf(conf_line, "logon path = %s\n", logon_path);
    	    strcat(new_conf, conf_line);
	}
	else
	if( strstr(line, "logon script") && ! commented(line) )
	{
    	    sprintf(conf_line, "logon script = %s\n", logon_script);
    	    strcat(new_conf, conf_line);
	}
	else


	/* Combos */

	
	/* Security level */
    	if( strstr(line, "security =") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[0]));
	    if( active_index == 0 )
    	      sprintf(conf_line, "security = user\n");
	    else
	    if( active_index == 1 ) /* Backup domain */ 
    	      sprintf(conf_line, "security = user\n");
	    else
	    if( active_index == 2 ) /* Primary domain */ 
    	      sprintf(conf_line, "security = domain\n");
	    else
	    if( active_index == 3 )
	      sprintf(conf_line, "security = ads\n");
	    else
	      sprintf(conf_line, "security = user\n"); /* Default to user sec */
	    
    	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "load printers") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[1]));
	    if( active_index == 0 )
    	      sprintf(conf_line, "load printers = yes\n");
	    else
    	      sprintf(conf_line, "load printers = no\n");

	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "cups options") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[2]));
	    if( active_index == 0 )
    	      sprintf(conf_line, "cups options = raw\n");
	    else
    	      sprintf(conf_line, "cups options =\n");

    	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "null passwords") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[3]));
	    if( active_index == 0 )
    	      sprintf(conf_line, "null passwords = yes\n");
	    else
    	      sprintf(conf_line, "null passwords = no\n");

    	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant */
	if( strstr(line, "encrypt passwords") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[4]));
	    if( sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "encrypt passwords = yes\n");
	    else
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "encrypt passwords = yes\n"); /* We still want this for user sec */
	    else
	    if( active_index == 0 )
    	      sprintf(conf_line, "encrypt passwords = yes\n");
	    else
    	      sprintf(conf_line, "encrypt passwords = no\n");

    	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "unix password sync") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[5]));
	    if( sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "unix password sync = yes\n");
    	    else
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "unix password sync = yes\n"); /* We still want this for user sec */
    	    else
	    if( active_index == 0 )
    	      sprintf(conf_line, "unix password sync = yes\n");
	    else
    	      sprintf(conf_line, "unix password sync = no\n");

    	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant */
    	if( strstr(line, "local master") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[6]));
	    if( sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "local master = yes\n");
	    else	    
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "local master = no\n");
	    else	    
	    if( active_index == 0 )
    	      sprintf(conf_line, "local master = yes\n");
	    else	    
    	      sprintf(conf_line, "local master = no\n");

    	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant (Auto: no for User and BDC) */
    	if( strstr(line, "domain master") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[7]));
	    if( sec_changed && (sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "domain master = yes\n");
	    else
	    if( sec_changed && (sec_index == 0 || sec_index == 1) )
    	      sprintf(conf_line, "domain master = no\n");
	    else
	    if( active_index == 0 )
    	      sprintf(conf_line, "domain master = yes\n");
	    else
    	      sprintf(conf_line, "domain master = no\n");

	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant (Auto: no for User and BDC) */
    	if( strstr(line, "preferred master") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[8]));
	    if( sec_changed && (sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "preferred master = yes\n");
	    else
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "preferred master = no\n");
	    else
	    if( active_index == 0 )
    	      sprintf(conf_line, "preferred master = yes\n");
	    else
    	      sprintf(conf_line, "preferred master = no\n");

    	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant */
    	if( strstr(line, "time server") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[9]));
	    if( sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "time server = yes\n");
	    else
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "time server = no\n");
	    else
	    if( active_index == 0 )
    	      sprintf(conf_line, "time server = yes\n");
	    else
    	      sprintf(conf_line, "time server = no\n");
	    
	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant */
    	if( strstr(line, "domain logons") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[10]));
	    if( sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "domain logons = yes\n");
	    else
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "domain logons = no\n");
	    else	    
	    if( active_index == 0 )
    	      sprintf(conf_line, "domain logons = yes\n");
	    else
	    if( active_index == 1  )
    	      sprintf(conf_line, "domain logons = no\n");
	    
	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant */
    	if( strstr(line, "wins support") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[11]));
	    if( sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "wins support = yes\n");
	    else
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "wins support = no\n");
	    else
	    if( active_index == 0 )
    	      sprintf(conf_line, "wins support = yes\n");
	    else
	    if( active_index == 1 )
    	      sprintf(conf_line, "wins support = no\n");
	    
	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant */
    	if( strstr(line, "wins proxy") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[12]));
	    if( sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "wins proxy = yes\n");
	    else
	    if( sec_changed && sec_index == 0 )
    	      sprintf(conf_line, "wins proxy = no\n");
	    else
	    if( active_index == 0 )
    	      sprintf(conf_line, "wins proxy = yes\n");
	    else
	    if( active_index == 1 )
    	      sprintf(conf_line, "wins proxy = no\n");

    	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "dns proxy") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[13]));
	    if( active_index == 0 )
    	      sprintf(conf_line, "dns proxy = yes\n");
	    else
    	      sprintf(conf_line, "dns proxy = no\n");

    	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "preserve case") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[14]));
	    if( active_index == 0 )
    	      sprintf(conf_line, "preserve case = yes\n");
	    else
    	      sprintf(conf_line, "preserve case = no\n");

    	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "winbind use default domain") && ! commented(line) )
	{
	    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[15]));
	    if( active_index == 0 || (sec_changed && (sec_index == 1 || sec_index == 2 || sec_index == 3)) )
    	      sprintf(conf_line, "winbind use default domain = yes\n");
	    else
    	      sprintf(conf_line, "winbind use default domain = no\n");

    	    strcat(new_conf, conf_line);
	}
	else


	/* Spinbuttons */


    	if( strstr(line, "max log size") && ! commented(line) )
	{
    	    sprintf(conf_line, "max log size = %s\n", max_log_file_size);
	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "username level") && ! commented(line) )
	{
    	    sprintf(conf_line, "username level = %s\n", username_match_level);
    	    strcat(new_conf, conf_line);
	}
	else
    	if( strstr(line, "password level") && ! commented(line) )
	{
    	    sprintf(conf_line, "password level = %s\n", password_match_level);
    	    strcat(new_conf, conf_line);
	}
	else /* Security level change dependant */
    	if( strstr(line, "os level") && ! commented(line) )
	{
	    /* Set it to something high for Primary domains and active directory */
	    if( sec_changed && (sec_index == 2 || sec_index == 3) )
    	      sprintf(conf_line, "os level = 80\n"); /* 35 is max but 80 doesnt hurt */
    	    else
	    if( sec_changed && (sec_index == 0 || sec_index == 1) )
    	      sprintf(conf_line, "os level = 33\n"); /* 33 is default for user level security */
	    else
    	      sprintf(conf_line, "os level = %s\n", election_level);

    	    strcat(new_conf, conf_line);
	}
	else
	  strcat(new_conf, line); /* Gather all other values */
    }



    /* Collect the rest of the file, share definitions etc */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
      strcat(new_conf, line);

    free(line);
    free(conf_line);
    fclose(fp);
    

    /* Write the new file */
    if( WRITE_CHANGES )
    {
	if((fp=fopen(SAMBA_CONF, "w+"))==NULL)
	{
	    info = g_strdup_printf(_("Cant write smb.conf here:\n%s\n"), SAMBA_CONF);
	    show_info(info);
	    g_free(info);
    	    return;
	}
	fputs(new_conf, fp);
	fclose(fp);
    }
    else
      printf("New configuration:\n%s\n", new_conf);


    free(new_conf);


//    fix_newlines_in_conf();

    /* Populate the server settings */    
    populate_server_settings(widgets);

    populate_conf_tab(widgets);


    reread_conf(widgets);
}
