/* soapC.cpp
   Generated by gSOAP 2.7.6 from interop_all.h
   Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.7.6 2005-08-20 01:31:40 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_in_xsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_long:
		return soap_in_long(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_in_xsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE_m__echoVoid:
		return soap_in_m__echoVoid(soap, NULL, NULL, "m:echoVoid");
	case SOAP_TYPE_m__echoVoidResponse:
		return soap_in_m__echoVoidResponse(soap, NULL, NULL, "m:echoVoidResponse");
	case SOAP_TYPE_ns__echoNestedArray:
		return soap_in_ns__echoNestedArray(soap, NULL, NULL, "ns:echoNestedArray");
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		return soap_in_ns__echoNestedArrayResponse(soap, NULL, NULL, "ns:echoNestedArrayResponse");
	case SOAP_TYPE_s__SOAPArrayStruct:
		return soap_in_s__SOAPArrayStruct(soap, NULL, NULL, "s:SOAPArrayStruct");
	case SOAP_TYPE_ns__echoNestedStruct:
		return soap_in_ns__echoNestedStruct(soap, NULL, NULL, "ns:echoNestedStruct");
	case SOAP_TYPE_ns__echoNestedStructResponse:
		return soap_in_ns__echoNestedStructResponse(soap, NULL, NULL, "ns:echoNestedStructResponse");
	case SOAP_TYPE_s__SOAPStructStruct:
		return soap_in_s__SOAPStructStruct(soap, NULL, NULL, "s:SOAPStructStruct");
	case SOAP_TYPE_ns__echo2DStringArray:
		return soap_in_ns__echo2DStringArray(soap, NULL, NULL, "ns:echo2DStringArray");
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		return soap_in_ns__echo2DStringArrayResponse(soap, NULL, NULL, "ns:echo2DStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring2D:
		return soap_in_ArrayOfstring2D(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		return soap_in_ns__echoSimpleTypesAsStruct(soap, NULL, NULL, "ns:echoSimpleTypesAsStruct");
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		return soap_in_ns__echoSimpleTypesAsStructResponse(soap, NULL, NULL, "ns:echoSimpleTypesAsStructResponse");
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		return soap_in_ns__echoStructAsSimpleTypes(soap, NULL, NULL, "ns:echoStructAsSimpleTypes");
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		return soap_in_ns__echoStructAsSimpleTypesResponse(soap, NULL, NULL, "ns:echoStructAsSimpleTypesResponse");
	case SOAP_TYPE_ns__echoBoolean:
		return soap_in_ns__echoBoolean(soap, NULL, NULL, "ns:echoBoolean");
	case SOAP_TYPE_ns__echoBooleanResponse:
		return soap_in_ns__echoBooleanResponse(soap, NULL, NULL, "ns:echoBooleanResponse");
	case SOAP_TYPE_ns__echoDecimal:
		return soap_in_ns__echoDecimal(soap, NULL, NULL, "ns:echoDecimal");
	case SOAP_TYPE_ns__echoDecimalResponse:
		return soap_in_ns__echoDecimalResponse(soap, NULL, NULL, "ns:echoDecimalResponse");
	case SOAP_TYPE_ns__echoHexBinary:
		return soap_in_ns__echoHexBinary(soap, NULL, NULL, "ns:echoHexBinary");
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		return soap_in_ns__echoHexBinaryResponse(soap, NULL, NULL, "ns:echoHexBinaryResponse");
	case SOAP_TYPE_xsd__hexBinary:
		return soap_in_xsd__hexBinary(soap, NULL, NULL, "xsd:hexBinary");
	case SOAP_TYPE_ns__echoDate:
		return soap_in_ns__echoDate(soap, NULL, NULL, "ns:echoDate");
	case SOAP_TYPE_ns__echoDateResponse:
		return soap_in_ns__echoDateResponse(soap, NULL, NULL, "ns:echoDateResponse");
	case SOAP_TYPE_ns__echoBase64:
		return soap_in_ns__echoBase64(soap, NULL, NULL, "ns:echoBase64");
	case SOAP_TYPE_ns__echoBase64Response:
		return soap_in_ns__echoBase64Response(soap, NULL, NULL, "ns:echoBase64Response");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_ns__echoVoid:
		return soap_in_ns__echoVoid(soap, NULL, NULL, "ns:echoVoid");
	case SOAP_TYPE_ns__echoVoidResponse:
		return soap_in_ns__echoVoidResponse(soap, NULL, NULL, "ns:echoVoidResponse");
	case SOAP_TYPE_ns__echoStructArray:
		return soap_in_ns__echoStructArray(soap, NULL, NULL, "ns:echoStructArray");
	case SOAP_TYPE_ns__echoStructArrayResponse:
		return soap_in_ns__echoStructArrayResponse(soap, NULL, NULL, "ns:echoStructArrayResponse");
	case SOAP_TYPE_ArrayOfSOAPStruct:
		return soap_in_ArrayOfSOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoStruct:
		return soap_in_ns__echoStruct(soap, NULL, NULL, "ns:echoStruct");
	case SOAP_TYPE_ns__echoStructResponse:
		return soap_in_ns__echoStructResponse(soap, NULL, NULL, "ns:echoStructResponse");
	case SOAP_TYPE_s__SOAPStruct:
		return soap_in_s__SOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoFloatArray:
		return soap_in_ns__echoFloatArray(soap, NULL, NULL, "ns:echoFloatArray");
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		return soap_in_ns__echoFloatArrayResponse(soap, NULL, NULL, "ns:echoFloatArrayResponse");
	case SOAP_TYPE_ArrayOffloat:
		return soap_in_ArrayOffloat(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_ns__echoFloat:
		return soap_in_ns__echoFloat(soap, NULL, NULL, "ns:echoFloat");
	case SOAP_TYPE_ns__echoFloatResponse:
		return soap_in_ns__echoFloatResponse(soap, NULL, NULL, "ns:echoFloatResponse");
	case SOAP_TYPE_ns__echoIntegerArray:
		return soap_in_ns__echoIntegerArray(soap, NULL, NULL, "ns:echoIntegerArray");
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		return soap_in_ns__echoIntegerArrayResponse(soap, NULL, NULL, "ns:echoIntegerArrayResponse");
	case SOAP_TYPE_ArrayOfint:
		return soap_in_ArrayOfint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_ns__echoInteger:
		return soap_in_ns__echoInteger(soap, NULL, NULL, "ns:echoInteger");
	case SOAP_TYPE_ns__echoIntegerResponse:
		return soap_in_ns__echoIntegerResponse(soap, NULL, NULL, "ns:echoIntegerResponse");
	case SOAP_TYPE_ns__echoStringArray:
		return soap_in_ns__echoStringArray(soap, NULL, NULL, "ns:echoStringArray");
	case SOAP_TYPE_ns__echoStringArrayResponse:
		return soap_in_ns__echoStringArrayResponse(soap, NULL, NULL, "ns:echoStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring:
		return soap_in_ArrayOfstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ns__echoString:
		return soap_in_ns__echoString(soap, NULL, NULL, "ns:echoString");
	case SOAP_TYPE_ns__echoStringResponse:
		return soap_in_ns__echoStringResponse(soap, NULL, NULL, "ns:echoStringResponse");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_in_PointerToSOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE_xsd__decimal:
	{	char **s;
		s = soap_in_xsd__decimal(soap, NULL, NULL, "xsd:decimal");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__dateTime:
	{	char **s;
		s = soap_in_xsd__dateTime(soap, NULL, NULL, "xsd:dateTime");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_PointerToPointerTos__SOAPStruct:
		return soap_in_PointerToPointerTos__SOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_PointerTos__SOAPStruct:
		return soap_in_PointerTos__SOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_PointerToPointerToxsd__float:
		return soap_in_PointerToPointerToxsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_PointerToxsd__float:
		return soap_in_PointerToxsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_PointerToPointerToxsd__int:
		return soap_in_PointerToPointerToxsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerToxsd__int:
		return soap_in_PointerToxsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerToxsd__string:
		return soap_in_PointerToxsd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_xsd__string:
	{	char **s;
		s = soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_Array2Ofint:
		return soap_in_Array2Ofint(soap, NULL, NULL, "xsd:int");
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_xsd__int;
			return soap_in_xsd__int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_long;
			return soap_in_long(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_xsd__float;
			return soap_in_xsd__float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SOAP-ENV:Reason"))
		{	*type = SOAP_TYPE_SOAP_ENV__Reason;
			return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "m:echoVoid"))
		{	*type = SOAP_TYPE_m__echoVoid;
			return soap_in_m__echoVoid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "m:echoVoidResponse"))
		{	*type = SOAP_TYPE_m__echoVoidResponse;
			return soap_in_m__echoVoidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedArray"))
		{	*type = SOAP_TYPE_ns__echoNestedArray;
			return soap_in_ns__echoNestedArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoNestedArrayResponse;
			return soap_in_ns__echoNestedArrayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "s:SOAPArrayStruct"))
		{	*type = SOAP_TYPE_s__SOAPArrayStruct;
			return soap_in_s__SOAPArrayStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedStruct"))
		{	*type = SOAP_TYPE_ns__echoNestedStruct;
			return soap_in_ns__echoNestedStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedStructResponse"))
		{	*type = SOAP_TYPE_ns__echoNestedStructResponse;
			return soap_in_ns__echoNestedStructResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "s:SOAPStructStruct"))
		{	*type = SOAP_TYPE_s__SOAPStructStruct;
			return soap_in_s__SOAPStructStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echo2DStringArray"))
		{	*type = SOAP_TYPE_ns__echo2DStringArray;
			return soap_in_ns__echo2DStringArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echo2DStringArrayResponse"))
		{	*type = SOAP_TYPE_ns__echo2DStringArrayResponse;
			return soap_in_ns__echo2DStringArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_ArrayOfstring2D;
			return soap_in_ArrayOfstring2D(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoSimpleTypesAsStruct"))
		{	*type = SOAP_TYPE_ns__echoSimpleTypesAsStruct;
			return soap_in_ns__echoSimpleTypesAsStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoSimpleTypesAsStructResponse"))
		{	*type = SOAP_TYPE_ns__echoSimpleTypesAsStructResponse;
			return soap_in_ns__echoSimpleTypesAsStructResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructAsSimpleTypes"))
		{	*type = SOAP_TYPE_ns__echoStructAsSimpleTypes;
			return soap_in_ns__echoStructAsSimpleTypes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructAsSimpleTypesResponse"))
		{	*type = SOAP_TYPE_ns__echoStructAsSimpleTypesResponse;
			return soap_in_ns__echoStructAsSimpleTypesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBoolean"))
		{	*type = SOAP_TYPE_ns__echoBoolean;
			return soap_in_ns__echoBoolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBooleanResponse"))
		{	*type = SOAP_TYPE_ns__echoBooleanResponse;
			return soap_in_ns__echoBooleanResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDecimal"))
		{	*type = SOAP_TYPE_ns__echoDecimal;
			return soap_in_ns__echoDecimal(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDecimalResponse"))
		{	*type = SOAP_TYPE_ns__echoDecimalResponse;
			return soap_in_ns__echoDecimalResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoHexBinary"))
		{	*type = SOAP_TYPE_ns__echoHexBinary;
			return soap_in_ns__echoHexBinary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoHexBinaryResponse"))
		{	*type = SOAP_TYPE_ns__echoHexBinaryResponse;
			return soap_in_ns__echoHexBinaryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:hexBinary"))
		{	*type = SOAP_TYPE_xsd__hexBinary;
			return soap_in_xsd__hexBinary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDate"))
		{	*type = SOAP_TYPE_ns__echoDate;
			return soap_in_ns__echoDate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDateResponse"))
		{	*type = SOAP_TYPE_ns__echoDateResponse;
			return soap_in_ns__echoDateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBase64"))
		{	*type = SOAP_TYPE_ns__echoBase64;
			return soap_in_ns__echoBase64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBase64Response"))
		{	*type = SOAP_TYPE_ns__echoBase64Response;
			return soap_in_ns__echoBase64Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoVoid"))
		{	*type = SOAP_TYPE_ns__echoVoid;
			return soap_in_ns__echoVoid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoVoidResponse"))
		{	*type = SOAP_TYPE_ns__echoVoidResponse;
			return soap_in_ns__echoVoidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructArray"))
		{	*type = SOAP_TYPE_ns__echoStructArray;
			return soap_in_ns__echoStructArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoStructArrayResponse;
			return soap_in_ns__echoStructArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "s:SOAPStruct"))
		{	*type = SOAP_TYPE_ArrayOfSOAPStruct;
			return soap_in_ArrayOfSOAPStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStruct"))
		{	*type = SOAP_TYPE_ns__echoStruct;
			return soap_in_ns__echoStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructResponse"))
		{	*type = SOAP_TYPE_ns__echoStructResponse;
			return soap_in_ns__echoStructResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "s:SOAPStruct"))
		{	*type = SOAP_TYPE_s__SOAPStruct;
			return soap_in_s__SOAPStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloatArray"))
		{	*type = SOAP_TYPE_ns__echoFloatArray;
			return soap_in_ns__echoFloatArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloatArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoFloatArrayResponse;
			return soap_in_ns__echoFloatArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:float"))
		{	*type = SOAP_TYPE_ArrayOffloat;
			return soap_in_ArrayOffloat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloat"))
		{	*type = SOAP_TYPE_ns__echoFloat;
			return soap_in_ns__echoFloat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloatResponse"))
		{	*type = SOAP_TYPE_ns__echoFloatResponse;
			return soap_in_ns__echoFloatResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoIntegerArray"))
		{	*type = SOAP_TYPE_ns__echoIntegerArray;
			return soap_in_ns__echoIntegerArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoIntegerArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoIntegerArrayResponse;
			return soap_in_ns__echoIntegerArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:int"))
		{	*type = SOAP_TYPE_ArrayOfint;
			return soap_in_ArrayOfint(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoInteger"))
		{	*type = SOAP_TYPE_ns__echoInteger;
			return soap_in_ns__echoInteger(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoIntegerResponse"))
		{	*type = SOAP_TYPE_ns__echoIntegerResponse;
			return soap_in_ns__echoIntegerResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStringArray"))
		{	*type = SOAP_TYPE_ns__echoStringArray;
			return soap_in_ns__echoStringArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStringArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoStringArrayResponse;
			return soap_in_ns__echoStringArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_ArrayOfstring;
			return soap_in_ArrayOfstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoString"))
		{	*type = SOAP_TYPE_ns__echoString;
			return soap_in_ns__echoString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStringResponse"))
		{	*type = SOAP_TYPE_ns__echoStringResponse;
			return soap_in_ns__echoStringResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:decimal"))
		{	char **s;
			*type = SOAP_TYPE_xsd__decimal;
			s = soap_in_xsd__decimal(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	char **s;
			*type = SOAP_TYPE_xsd__dateTime;
			s = soap_in_xsd__dateTime(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_xsd__string;
			s = soap_in_xsd__string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_Array2Ofint;
			return soap_in_Array2Ofint(soap, NULL, NULL, NULL);
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_out_xsd__int(soap, tag, id, (const long *)ptr, "xsd:int");
	case SOAP_TYPE_long:
		return soap_out_long(soap, tag, id, (const long *)ptr, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_out_xsd__float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_out_SOAP_ENV__Reason(soap, tag, id, (const struct SOAP_ENV__Reason *)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE_m__echoVoid:
		return soap_out_m__echoVoid(soap, tag, id, (const struct m__echoVoid *)ptr, "m:echoVoid");
	case SOAP_TYPE_m__echoVoidResponse:
		return soap_out_m__echoVoidResponse(soap, tag, id, (const struct m__echoVoidResponse *)ptr, "m:echoVoidResponse");
	case SOAP_TYPE_ns__echoNestedArray:
		return soap_out_ns__echoNestedArray(soap, tag, id, (const struct ns__echoNestedArray *)ptr, "ns:echoNestedArray");
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		return soap_out_ns__echoNestedArrayResponse(soap, tag, id, (const struct ns__echoNestedArrayResponse *)ptr, "ns:echoNestedArrayResponse");
	case SOAP_TYPE_s__SOAPArrayStruct:
		return soap_out_s__SOAPArrayStruct(soap, tag, id, (const struct s__SOAPArrayStruct *)ptr, "s:SOAPArrayStruct");
	case SOAP_TYPE_ns__echoNestedStruct:
		return soap_out_ns__echoNestedStruct(soap, tag, id, (const struct ns__echoNestedStruct *)ptr, "ns:echoNestedStruct");
	case SOAP_TYPE_ns__echoNestedStructResponse:
		return soap_out_ns__echoNestedStructResponse(soap, tag, id, (const struct ns__echoNestedStructResponse *)ptr, "ns:echoNestedStructResponse");
	case SOAP_TYPE_s__SOAPStructStruct:
		return soap_out_s__SOAPStructStruct(soap, tag, id, (const struct s__SOAPStructStruct *)ptr, "s:SOAPStructStruct");
	case SOAP_TYPE_ns__echo2DStringArray:
		return soap_out_ns__echo2DStringArray(soap, tag, id, (const struct ns__echo2DStringArray *)ptr, "ns:echo2DStringArray");
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		return soap_out_ns__echo2DStringArrayResponse(soap, tag, id, (const struct ns__echo2DStringArrayResponse *)ptr, "ns:echo2DStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring2D:
		return soap_out_ArrayOfstring2D(soap, tag, id, (const struct ArrayOfstring2D *)ptr, "xsd:string");
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		return soap_out_ns__echoSimpleTypesAsStruct(soap, tag, id, (const struct ns__echoSimpleTypesAsStruct *)ptr, "ns:echoSimpleTypesAsStruct");
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		return soap_out_ns__echoSimpleTypesAsStructResponse(soap, tag, id, (const struct ns__echoSimpleTypesAsStructResponse *)ptr, "ns:echoSimpleTypesAsStructResponse");
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		return soap_out_ns__echoStructAsSimpleTypes(soap, tag, id, (const struct ns__echoStructAsSimpleTypes *)ptr, "ns:echoStructAsSimpleTypes");
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		return soap_out_ns__echoStructAsSimpleTypesResponse(soap, tag, id, (const struct ns__echoStructAsSimpleTypesResponse *)ptr, "ns:echoStructAsSimpleTypesResponse");
	case SOAP_TYPE_ns__echoBoolean:
		return soap_out_ns__echoBoolean(soap, tag, id, (const struct ns__echoBoolean *)ptr, "ns:echoBoolean");
	case SOAP_TYPE_ns__echoBooleanResponse:
		return soap_out_ns__echoBooleanResponse(soap, tag, id, (const struct ns__echoBooleanResponse *)ptr, "ns:echoBooleanResponse");
	case SOAP_TYPE_ns__echoDecimal:
		return soap_out_ns__echoDecimal(soap, tag, id, (const struct ns__echoDecimal *)ptr, "ns:echoDecimal");
	case SOAP_TYPE_ns__echoDecimalResponse:
		return soap_out_ns__echoDecimalResponse(soap, tag, id, (const struct ns__echoDecimalResponse *)ptr, "ns:echoDecimalResponse");
	case SOAP_TYPE_ns__echoHexBinary:
		return soap_out_ns__echoHexBinary(soap, tag, id, (const struct ns__echoHexBinary *)ptr, "ns:echoHexBinary");
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		return soap_out_ns__echoHexBinaryResponse(soap, tag, id, (const struct ns__echoHexBinaryResponse *)ptr, "ns:echoHexBinaryResponse");
	case SOAP_TYPE_xsd__hexBinary:
		return soap_out_xsd__hexBinary(soap, tag, id, (const struct xsd__hexBinary *)ptr, "xsd:hexBinary");
	case SOAP_TYPE_ns__echoDate:
		return soap_out_ns__echoDate(soap, tag, id, (const struct ns__echoDate *)ptr, "ns:echoDate");
	case SOAP_TYPE_ns__echoDateResponse:
		return soap_out_ns__echoDateResponse(soap, tag, id, (const struct ns__echoDateResponse *)ptr, "ns:echoDateResponse");
	case SOAP_TYPE_ns__echoBase64:
		return soap_out_ns__echoBase64(soap, tag, id, (const struct ns__echoBase64 *)ptr, "ns:echoBase64");
	case SOAP_TYPE_ns__echoBase64Response:
		return soap_out_ns__echoBase64Response(soap, tag, id, (const struct ns__echoBase64Response *)ptr, "ns:echoBase64Response");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_out_xsd__base64Binary(soap, tag, id, (const struct xsd__base64Binary *)ptr, "xsd:base64Binary");
	case SOAP_TYPE_ns__echoVoid:
		return soap_out_ns__echoVoid(soap, tag, id, (const struct ns__echoVoid *)ptr, "ns:echoVoid");
	case SOAP_TYPE_ns__echoVoidResponse:
		return soap_out_ns__echoVoidResponse(soap, tag, id, (const struct ns__echoVoidResponse *)ptr, "ns:echoVoidResponse");
	case SOAP_TYPE_ns__echoStructArray:
		return soap_out_ns__echoStructArray(soap, tag, id, (const struct ns__echoStructArray *)ptr, "ns:echoStructArray");
	case SOAP_TYPE_ns__echoStructArrayResponse:
		return soap_out_ns__echoStructArrayResponse(soap, tag, id, (const struct ns__echoStructArrayResponse *)ptr, "ns:echoStructArrayResponse");
	case SOAP_TYPE_ArrayOfSOAPStruct:
		return soap_out_ArrayOfSOAPStruct(soap, tag, id, (const struct ArrayOfSOAPStruct *)ptr, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoStruct:
		return soap_out_ns__echoStruct(soap, tag, id, (const struct ns__echoStruct *)ptr, "ns:echoStruct");
	case SOAP_TYPE_ns__echoStructResponse:
		return soap_out_ns__echoStructResponse(soap, tag, id, (const struct ns__echoStructResponse *)ptr, "ns:echoStructResponse");
	case SOAP_TYPE_s__SOAPStruct:
		return soap_out_s__SOAPStruct(soap, tag, id, (const struct s__SOAPStruct *)ptr, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoFloatArray:
		return soap_out_ns__echoFloatArray(soap, tag, id, (const struct ns__echoFloatArray *)ptr, "ns:echoFloatArray");
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		return soap_out_ns__echoFloatArrayResponse(soap, tag, id, (const struct ns__echoFloatArrayResponse *)ptr, "ns:echoFloatArrayResponse");
	case SOAP_TYPE_ArrayOffloat:
		return soap_out_ArrayOffloat(soap, tag, id, (const struct ArrayOffloat *)ptr, "xsd:float");
	case SOAP_TYPE_ns__echoFloat:
		return soap_out_ns__echoFloat(soap, tag, id, (const struct ns__echoFloat *)ptr, "ns:echoFloat");
	case SOAP_TYPE_ns__echoFloatResponse:
		return soap_out_ns__echoFloatResponse(soap, tag, id, (const struct ns__echoFloatResponse *)ptr, "ns:echoFloatResponse");
	case SOAP_TYPE_ns__echoIntegerArray:
		return soap_out_ns__echoIntegerArray(soap, tag, id, (const struct ns__echoIntegerArray *)ptr, "ns:echoIntegerArray");
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		return soap_out_ns__echoIntegerArrayResponse(soap, tag, id, (const struct ns__echoIntegerArrayResponse *)ptr, "ns:echoIntegerArrayResponse");
	case SOAP_TYPE_ArrayOfint:
		return soap_out_ArrayOfint(soap, tag, id, (const struct ArrayOfint *)ptr, "xsd:int");
	case SOAP_TYPE_ns__echoInteger:
		return soap_out_ns__echoInteger(soap, tag, id, (const struct ns__echoInteger *)ptr, "ns:echoInteger");
	case SOAP_TYPE_ns__echoIntegerResponse:
		return soap_out_ns__echoIntegerResponse(soap, tag, id, (const struct ns__echoIntegerResponse *)ptr, "ns:echoIntegerResponse");
	case SOAP_TYPE_ns__echoStringArray:
		return soap_out_ns__echoStringArray(soap, tag, id, (const struct ns__echoStringArray *)ptr, "ns:echoStringArray");
	case SOAP_TYPE_ns__echoStringArrayResponse:
		return soap_out_ns__echoStringArrayResponse(soap, tag, id, (const struct ns__echoStringArrayResponse *)ptr, "ns:echoStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring:
		return soap_out_ArrayOfstring(soap, tag, id, (const struct ArrayOfstring *)ptr, "xsd:string");
	case SOAP_TYPE_ns__echoString:
		return soap_out_ns__echoString(soap, tag, id, (const struct ns__echoString *)ptr, "ns:echoString");
	case SOAP_TYPE_ns__echoStringResponse:
		return soap_out_ns__echoStringResponse(soap, tag, id, (const struct ns__echoStringResponse *)ptr, "ns:echoStringResponse");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, (struct SOAP_ENV__Reason *const*)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE_xsd__decimal:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:decimal");
	case SOAP_TYPE_xsd__dateTime:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:dateTime");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_PointerToPointerTos__SOAPStruct:
		return soap_out_PointerToPointerTos__SOAPStruct(soap, tag, id, (struct s__SOAPStruct **const*)ptr, "s:SOAPStruct");
	case SOAP_TYPE_PointerTos__SOAPStruct:
		return soap_out_PointerTos__SOAPStruct(soap, tag, id, (struct s__SOAPStruct *const*)ptr, "s:SOAPStruct");
	case SOAP_TYPE_PointerToPointerToxsd__float:
		return soap_out_PointerToPointerToxsd__float(soap, tag, id, (float **const*)ptr, "xsd:float");
	case SOAP_TYPE_PointerToxsd__float:
		return soap_out_PointerToxsd__float(soap, tag, id, (float *const*)ptr, "xsd:float");
	case SOAP_TYPE_PointerToPointerToxsd__int:
		return soap_out_PointerToPointerToxsd__int(soap, tag, id, (long **const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerToxsd__int:
		return soap_out_PointerToxsd__int(soap, tag, id, (long *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerToxsd__string:
		return soap_out_PointerToxsd__string(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_xsd__string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	case SOAP_TYPE_Array2Ofint:
		return soap_out_Array2Ofint(soap, tag, id, (int (*))ptr, "xsd:int");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_SOAP_ENV__Reason:
		soap_serialize_SOAP_ENV__Reason(soap, (const struct SOAP_ENV__Reason *)ptr);
		break;
	case SOAP_TYPE_m__echoVoid:
		soap_serialize_m__echoVoid(soap, (const struct m__echoVoid *)ptr);
		break;
	case SOAP_TYPE_m__echoVoidResponse:
		soap_serialize_m__echoVoidResponse(soap, (const struct m__echoVoidResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedArray:
		soap_serialize_ns__echoNestedArray(soap, (const struct ns__echoNestedArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		soap_serialize_ns__echoNestedArrayResponse(soap, (const struct ns__echoNestedArrayResponse *)ptr);
		break;
	case SOAP_TYPE_s__SOAPArrayStruct:
		soap_serialize_s__SOAPArrayStruct(soap, (const struct s__SOAPArrayStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedStruct:
		soap_serialize_ns__echoNestedStruct(soap, (const struct ns__echoNestedStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedStructResponse:
		soap_serialize_ns__echoNestedStructResponse(soap, (const struct ns__echoNestedStructResponse *)ptr);
		break;
	case SOAP_TYPE_s__SOAPStructStruct:
		soap_serialize_s__SOAPStructStruct(soap, (const struct s__SOAPStructStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echo2DStringArray:
		soap_serialize_ns__echo2DStringArray(soap, (const struct ns__echo2DStringArray *)ptr);
		break;
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		soap_serialize_ns__echo2DStringArrayResponse(soap, (const struct ns__echo2DStringArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfstring2D:
		soap_serialize_ArrayOfstring2D(soap, (const struct ArrayOfstring2D *)ptr);
		break;
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		soap_serialize_ns__echoSimpleTypesAsStruct(soap, (const struct ns__echoSimpleTypesAsStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		soap_serialize_ns__echoSimpleTypesAsStructResponse(soap, (const struct ns__echoSimpleTypesAsStructResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		soap_serialize_ns__echoStructAsSimpleTypes(soap, (const struct ns__echoStructAsSimpleTypes *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		soap_serialize_ns__echoStructAsSimpleTypesResponse(soap, (const struct ns__echoStructAsSimpleTypesResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoBoolean:
		soap_serialize_ns__echoBoolean(soap, (const struct ns__echoBoolean *)ptr);
		break;
	case SOAP_TYPE_ns__echoBooleanResponse:
		soap_serialize_ns__echoBooleanResponse(soap, (const struct ns__echoBooleanResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoDecimal:
		soap_serialize_ns__echoDecimal(soap, (const struct ns__echoDecimal *)ptr);
		break;
	case SOAP_TYPE_ns__echoDecimalResponse:
		soap_serialize_ns__echoDecimalResponse(soap, (const struct ns__echoDecimalResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoHexBinary:
		soap_serialize_ns__echoHexBinary(soap, (const struct ns__echoHexBinary *)ptr);
		break;
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		soap_serialize_ns__echoHexBinaryResponse(soap, (const struct ns__echoHexBinaryResponse *)ptr);
		break;
	case SOAP_TYPE_xsd__hexBinary:
		soap_serialize_xsd__hexBinary(soap, (const struct xsd__hexBinary *)ptr);
		break;
	case SOAP_TYPE_ns__echoDate:
		soap_serialize_ns__echoDate(soap, (const struct ns__echoDate *)ptr);
		break;
	case SOAP_TYPE_ns__echoDateResponse:
		soap_serialize_ns__echoDateResponse(soap, (const struct ns__echoDateResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoBase64:
		soap_serialize_ns__echoBase64(soap, (const struct ns__echoBase64 *)ptr);
		break;
	case SOAP_TYPE_ns__echoBase64Response:
		soap_serialize_ns__echoBase64Response(soap, (const struct ns__echoBase64Response *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		soap_serialize_xsd__base64Binary(soap, (const struct xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_ns__echoVoid:
		soap_serialize_ns__echoVoid(soap, (const struct ns__echoVoid *)ptr);
		break;
	case SOAP_TYPE_ns__echoVoidResponse:
		soap_serialize_ns__echoVoidResponse(soap, (const struct ns__echoVoidResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructArray:
		soap_serialize_ns__echoStructArray(soap, (const struct ns__echoStructArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructArrayResponse:
		soap_serialize_ns__echoStructArrayResponse(soap, (const struct ns__echoStructArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfSOAPStruct:
		soap_serialize_ArrayOfSOAPStruct(soap, (const struct ArrayOfSOAPStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoStruct:
		soap_serialize_ns__echoStruct(soap, (const struct ns__echoStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructResponse:
		soap_serialize_ns__echoStructResponse(soap, (const struct ns__echoStructResponse *)ptr);
		break;
	case SOAP_TYPE_s__SOAPStruct:
		soap_serialize_s__SOAPStruct(soap, (const struct s__SOAPStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloatArray:
		soap_serialize_ns__echoFloatArray(soap, (const struct ns__echoFloatArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		soap_serialize_ns__echoFloatArrayResponse(soap, (const struct ns__echoFloatArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOffloat:
		soap_serialize_ArrayOffloat(soap, (const struct ArrayOffloat *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloat:
		soap_serialize_ns__echoFloat(soap, (const struct ns__echoFloat *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloatResponse:
		soap_serialize_ns__echoFloatResponse(soap, (const struct ns__echoFloatResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoIntegerArray:
		soap_serialize_ns__echoIntegerArray(soap, (const struct ns__echoIntegerArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		soap_serialize_ns__echoIntegerArrayResponse(soap, (const struct ns__echoIntegerArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfint:
		soap_serialize_ArrayOfint(soap, (const struct ArrayOfint *)ptr);
		break;
	case SOAP_TYPE_ns__echoInteger:
		soap_serialize_ns__echoInteger(soap, (const struct ns__echoInteger *)ptr);
		break;
	case SOAP_TYPE_ns__echoIntegerResponse:
		soap_serialize_ns__echoIntegerResponse(soap, (const struct ns__echoIntegerResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoStringArray:
		soap_serialize_ns__echoStringArray(soap, (const struct ns__echoStringArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoStringArrayResponse:
		soap_serialize_ns__echoStringArrayResponse(soap, (const struct ns__echoStringArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfstring:
		soap_serialize_ArrayOfstring(soap, (const struct ArrayOfstring *)ptr);
		break;
	case SOAP_TYPE_ns__echoString:
		soap_serialize_ns__echoString(soap, (const struct ns__echoString *)ptr);
		break;
	case SOAP_TYPE_ns__echoStringResponse:
		soap_serialize_ns__echoStringResponse(soap, (const struct ns__echoStringResponse *)ptr);
		break;
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		soap_serialize_PointerToSOAP_ENV__Reason(soap, (struct SOAP_ENV__Reason *const*)ptr);
		break;
	case SOAP_TYPE_xsd__decimal:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__dateTime:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTos__SOAPStruct:
		soap_serialize_PointerToPointerTos__SOAPStruct(soap, (struct s__SOAPStruct **const*)ptr);
		break;
	case SOAP_TYPE_PointerTos__SOAPStruct:
		soap_serialize_PointerTos__SOAPStruct(soap, (struct s__SOAPStruct *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToxsd__float:
		soap_serialize_PointerToPointerToxsd__float(soap, (float **const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__float:
		soap_serialize_PointerToxsd__float(soap, (float *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToxsd__int:
		soap_serialize_PointerToPointerToxsd__int(soap, (long **const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__int:
		soap_serialize_PointerToxsd__int(soap, (long *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__string:
		soap_serialize_PointerToxsd__string(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_xsd__string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_Array2Ofint:
		soap_serialize_Array2Ofint(soap, (int (*))ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__int(struct soap *soap, long *a)
{	soap_default_long(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__int(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__int);
	if (soap_out_xsd__int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__int(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_xsd__int(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_xsd__int(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_long(struct soap *soap, long *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_long
	*a = SOAP_DEFAULT_long;
#else
	*a = (long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_long(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_long);
	if (soap_out_long(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_long(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_long(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_long(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_long(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__float(struct soap *soap, float *a)
{	soap_default_float(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__float);
	if (soap_out_xsd__float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_xsd__float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__float(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_xsd__float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, bool *a)
{	soap_default_bool(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, bool n)
{	return soap_bool2s(soap, n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type);
	soap_send(soap, soap_xsd__boolean2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, bool *a)
{
	return soap_s2bool(soap, s, a);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, "xsd:boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_xsd__boolean, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_str_code(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n >= 2)))
			return soap->error = SOAP_TYPE;
		*a = (bool)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->faultcode, SOAP_TYPE__QName);
	soap_serialize__QName(soap, &a->faultcode);
	soap_embedded(soap, &a->faultstring, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->faultstring);
	soap_embedded(soap, &a->faultactor, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->faultactor);
	soap_embedded(soap, &a->detail, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_embedded(soap, &a->SOAP_ENV__Code, SOAP_TYPE_PointerToSOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_embedded(soap, &a->SOAP_ENV__Reason, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_embedded(soap, &a->SOAP_ENV__Node, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_embedded(soap, &a->SOAP_ENV__Role, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_embedded(soap, &a->SOAP_ENV__Detail, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, ""))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, ""))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, ""))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, ""))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->SOAP_ENV__Text, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, ""))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->SOAP_ENV__Value, SOAP_TYPE__QName);
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_embedded(soap, &a->SOAP_ENV__Subcode, SOAP_TYPE_PointerToSOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_m__echoVoid(struct soap *soap, const struct m__echoVoid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_m__echoVoid(struct soap *soap, struct m__echoVoid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_m__echoVoid(struct soap *soap, const struct m__echoVoid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_m__echoVoid);
	if (soap_out_m__echoVoid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_m__echoVoid(struct soap *soap, const char *tag, int id, const struct m__echoVoid *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_m__echoVoid), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct m__echoVoid * SOAP_FMAC4 soap_get_m__echoVoid(struct soap *soap, struct m__echoVoid *p, const char *tag, const char *type)
{
	if ((p = soap_in_m__echoVoid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct m__echoVoid * SOAP_FMAC4 soap_in_m__echoVoid(struct soap *soap, const char *tag, struct m__echoVoid *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct m__echoVoid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_m__echoVoid, sizeof(struct m__echoVoid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_m__echoVoid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct m__echoVoid *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_m__echoVoid, 0, sizeof(struct m__echoVoid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_m__echoVoidResponse(struct soap *soap, const struct m__echoVoidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_m__echoVoidResponse(struct soap *soap, struct m__echoVoidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_m__echoVoidResponse(struct soap *soap, const struct m__echoVoidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_m__echoVoidResponse);
	if (soap_out_m__echoVoidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_m__echoVoidResponse(struct soap *soap, const char *tag, int id, const struct m__echoVoidResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_m__echoVoidResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct m__echoVoidResponse * SOAP_FMAC4 soap_get_m__echoVoidResponse(struct soap *soap, struct m__echoVoidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_m__echoVoidResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct m__echoVoidResponse * SOAP_FMAC4 soap_in_m__echoVoidResponse(struct soap *soap, const char *tag, struct m__echoVoidResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct m__echoVoidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_m__echoVoidResponse, sizeof(struct m__echoVoidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_m__echoVoidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct m__echoVoidResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_m__echoVoidResponse, 0, sizeof(struct m__echoVoidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->h__echoMeStringRequest, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->h__echoMeStringRequest);
	soap_embedded(soap, &a->h__echoMeStringRequest_, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->h__echoMeStringRequest_);
	soap_embedded(soap, &a->h__echoMeStringResponse, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->h__echoMeStringResponse);
	soap_embedded(soap, &a->h__echoMeStructRequest, SOAP_TYPE_PointerTos__SOAPStruct);
	soap_serialize_PointerTos__SOAPStruct(soap, &a->h__echoMeStructRequest);
	soap_embedded(soap, &a->h__echoMeStructRequest_, SOAP_TYPE_PointerTos__SOAPStruct);
	soap_serialize_PointerTos__SOAPStruct(soap, &a->h__echoMeStructRequest_);
	soap_embedded(soap, &a->h__echoMeStructResponse, SOAP_TYPE_PointerTos__SOAPStruct);
	soap_serialize_PointerTos__SOAPStruct(soap, &a->h__echoMeStructResponse);
	soap_embedded(soap, &a->h__someUnknownRequest, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->h__someUnknownRequest);
	soap_embedded(soap, &a->h__someUnknownRequest_, SOAP_TYPE_string);
	soap_serialize_string(soap, &a->h__someUnknownRequest_);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->h__echoMeStringRequest);
	soap_default_string(soap, &a->h__echoMeStringRequest_);
	soap_default_string(soap, &a->h__echoMeStringResponse);
	a->h__echoMeStructRequest = NULL;
	a->h__echoMeStructRequest_ = NULL;
	a->h__echoMeStructResponse = NULL;
	soap_default_string(soap, &a->h__someUnknownRequest);
	soap_default_string(soap, &a->h__someUnknownRequest_);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	soap_out_string(soap, "h:echoMeStringRequest", -1, &a->h__echoMeStringRequest, "");
	soap->mustUnderstand = 1;
	soap_out_string(soap, "h:echoMeStringRequest", -1, &a->h__echoMeStringRequest_, "");
	soap_out_string(soap, "h:echoMeStringResponse", -1, &a->h__echoMeStringResponse, "");
	soap_out_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", -1, &a->h__echoMeStructRequest, "");
	soap->mustUnderstand = 1;
	soap_out_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", -1, &a->h__echoMeStructRequest_, "");
	soap_out_PointerTos__SOAPStruct(soap, "h:echoMeStructResponse", -1, &a->h__echoMeStructResponse, "");
	soap_out_string(soap, "h:someUnknownRequest", -1, &a->h__someUnknownRequest, "");
	soap->mustUnderstand = 1;
	soap_out_string(soap, "h:someUnknownRequest", -1, &a->h__someUnknownRequest_, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	short soap_flag_h__echoMeStringRequest = 1, soap_flag_h__echoMeStringRequest_ = 1, soap_flag_h__echoMeStringResponse = 1, soap_flag_h__echoMeStructRequest = 1, soap_flag_h__echoMeStructRequest_ = 1, soap_flag_h__echoMeStructResponse = 1, soap_flag_h__someUnknownRequest = 1, soap_flag_h__someUnknownRequest_ = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_h__echoMeStringRequest && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:echoMeStringRequest", &a->h__echoMeStringRequest, ""))
				{	soap_flag_h__echoMeStringRequest--;
					continue;
				}
			if (soap_flag_h__echoMeStringRequest_ && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:echoMeStringRequest", &a->h__echoMeStringRequest_, ""))
				{	soap_flag_h__echoMeStringRequest_--;
					continue;
				}
			if (soap_flag_h__echoMeStringResponse && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:echoMeStringResponse", &a->h__echoMeStringResponse, ""))
				{	soap_flag_h__echoMeStringResponse--;
					continue;
				}
			if (soap_flag_h__echoMeStructRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", &a->h__echoMeStructRequest, "s:SOAPStruct"))
				{	soap_flag_h__echoMeStructRequest--;
					continue;
				}
			if (soap_flag_h__echoMeStructRequest_ && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", &a->h__echoMeStructRequest_, "s:SOAPStruct"))
				{	soap_flag_h__echoMeStructRequest_--;
					continue;
				}
			if (soap_flag_h__echoMeStructResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTos__SOAPStruct(soap, "h:echoMeStructResponse", &a->h__echoMeStructResponse, "s:SOAPStruct"))
				{	soap_flag_h__echoMeStructResponse--;
					continue;
				}
			if (soap_flag_h__someUnknownRequest && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:someUnknownRequest", &a->h__someUnknownRequest, ""))
				{	soap_flag_h__someUnknownRequest--;
					continue;
				}
			if (soap_flag_h__someUnknownRequest_ && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:someUnknownRequest", &a->h__someUnknownRequest_, ""))
				{	soap_flag_h__someUnknownRequest_--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif
