/****************************************************************************
#    		TAS5130C library, firmware version from			    #
#		Creative Live!Cam Notebook Pro (VF0250)			    #
# 	Copyright (C) 2004 Michel Xhaard  mxhaard@magic.fr          	    #
#  	Copyright (C) 2006 Serge Suchkov  Serge.A.S@tochka.ru	    	    #
#                                                                           #
# This program is free software; you can redistribute it and/or modify      #
# it under the terms of the GNU General Public License as published by      #
# the Free Software Foundation; either version 2 of the License, or         #
# (at your option) any later version.                                       #
#                                                                           #
# This program is distributed in the hope that it will be useful,           #
# but WITHOUT ANY WARRANTY; without even the implied warranty of            #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
# GNU General Public License for more details.                              #
#                                                                           #
# You should have received a copy of the GNU General Public License         #
# along with this program; if not, write to the Free Software               #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                           #
****************************************************************************/
static __u16 tas5130c_vf0250_start_data[][3] = {
    {0xa0, 0x0001, 0x0000},           //00,00,01,cc,
    {0xa0, 0x0002, 0x0008},           //00,08,02,cc,
    {0xa0, 0x0001, 0x0010},           //00,10,01,cc, 
    {0xa0, 0x0010, 0x0002},           //00,02,00,cc,  0<->10
    {0xa0, 0x0002, 0x0003},           //00,03,02,cc, 
    {0xa0, 0x0080, 0x0004},           //00,04,80,cc, 
    {0xa0, 0x0001, 0x0005},           //00,05,01,cc, 
    {0xa0, 0x00e0, 0x0006},           //00,06,e0,cc, 
    {0xa0, 0x0098, 0x008b},           //00,8b,98,cc, 
    {0xa0, 0x0001, 0x0001},           //00,01,01,cc, 
    {0xa0, 0x0003, 0x0012},           //00,12,03,cc, 
    {0xa0, 0x0001, 0x0012},           //00,12,01,cc, 
    {0xa0, 0x0000, 0x0098},           //00,98,00,cc, 
    {0xa0, 0x0000, 0x009a},           //00,9a,00,cc, 
    {0xa0, 0x0000, 0x011a},           //01,1a,00,cc, 
    {0xa0, 0x0000, 0x011c},           //01,1c,00,cc, 
    {0xa0, 0x00e8, 0x009c},           //00,9c,e6,cc,  6<->8
    {0xa0, 0x0088, 0x009e},           //00,9e,86,cc,  6<->8
    {0xa0, 0x0010, 0x0087},           //00,87,10,cc, 
    {0xa0, 0x0098, 0x008b},           //00,8b,98,cc, 
    {0xa0, 0x001b, 0x0092},           //00,1b,24,aa, 
    {0xa0, 0x0024, 0x0093},            
    {0xa0, 0x0000, 0x0094},           
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0000, 0x0039},           //00,00,80,dd, ???
    {0xa1, 0x0001, 0x0037},           //             ???
    {0xa0, 0x001b, 0x0092},           //00,1b,00,aa,   
    {0xa0, 0x0000, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0013, 0x0092},           //00,13,02,aa, 
    {0xa0, 0x0002, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0015, 0x0092},           //00,15,04,aa
    {0xa0, 0x0004, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0001, 0x0092},
    {0xa0, 0x0000, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},          //00,01,00,aa,   
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0001, 0x0092},            
    {0xa0, 0x0000, 0x0093},            
    {0xa0, 0x0000, 0x0094},            
    {0xa0, 0x0001, 0x0090},            
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x001a, 0x0092},          //00,1a,00,aa,  
    {0xa0, 0x0000, 0x0093},            
    {0xa0, 0x0000, 0x0094},            
    {0xa0, 0x0001, 0x0090},            
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x001c, 0x0092},          //00,1c,17,aa,  
    {0xa0, 0x0017, 0x0093},           
    {0xa0, 0x0000, 0x0094},           
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0082, 0x0086},           //00,86,82,cc,  
    {0xa0, 0x0083, 0x0087},           //00,87,83,cc,  
    {0xa0, 0x0084, 0x0088},           //00,88,84,cc,  
    {0xa0, 0x0005, 0x0092},           //00,05,10,aa,  
    {0xa0, 0x0010, 0x0093},           
    {0xa0, 0x0000, 0x0094},           
    {0xa0, 0x0001, 0x0090},           
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x000a, 0x0092},           //00,0a,00,aa, 
    {0xa0, 0x0000, 0x0093},                          
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},          
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x000b, 0x0092},           //00,0b,a0,aa, 
    {0xa0, 0x00a0, 0x0093},                          
    {0xa0, 0x0000, 0x0094},            
    {0xa1, 0x0001, 0x0091},           
    {0xa0, 0x0001, 0x0090},            
    {0xa0, 0x000c, 0x0092},           //00,0c,00,aa, 
    {0xa0, 0x0000, 0x0093},           
    {0xa0, 0x0000, 0x0094},           
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x000d, 0x0092},           //00,0d,a0,aa, 
    {0xa0, 0x00a0, 0x0093},           
    {0xa0, 0x0000, 0x0094},                          
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x000e, 0x0092},           //00,0e,00,aa, 
    {0xa0, 0x0000, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x000f, 0x0092},           //00,0f,a0,aa,
    {0xa0, 0x00a0, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0010, 0x0092},           //00,10,00,aa,
    {0xa0, 0x0000, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0011, 0x0092},           //00,11,a0,aa,
    {0xa0, 0x00a0, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0000, 0x0039},
    {0xa1, 0x0001, 0x0037},
    {0xa0, 0x0016, 0x0092},           //00,16,01,aa,
    {0xa0, 0x0001, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa0, 0x0017, 0x0092},           //00,17,e6,aa,
    {0xa0, 0x00e8, 0x0093},           //  6<->8 
    {0xa0, 0x0000, 0x0094},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0001, 0x0090},
    {0xa0, 0x0018, 0x0092},           //00,18,02,aa,
    {0xa0, 0x0002, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0001, 0x0090},
    {0xa0, 0x0019, 0x0092},           //00,19,86,aa,
    {0xa0, 0x0088, 0x0093},           //  6<->8
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0020, 0x0092},           //00,20,20,aa,
    {0xa0, 0x0020, 0x0093},           
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x00b7, 0x0101},           //01,01,b7,cc,
    {0xa0, 0x0005, 0x0012},           //00,12,05,cc, 
    {0xa0, 0x000d, 0x0100},           //01,00,0d,cc, 
    {0xa0, 0x0076, 0x0189},           //01,89,76,cc,
    {0xa0, 0x0009, 0x01ad},           //01,ad,09,cc,
    {0xa0, 0x0003, 0x01c5},           //01,c5,03,cc,
    {0xa0, 0x0013, 0x01cb},           //01,cb,13,cc,
    {0xa0, 0x0008, 0x0250},           //02,50,08,cc,
    {0xa0, 0x0008, 0x0301},           //03,01,08,cc,
    {0xa0, 0x0060, 0x01a8},           //01,a8,60,cc,
    {0xa0, 0x0061, 0x0116},           //01,16,61,cc,
    {0xa0, 0x0065, 0x0118},           //01,18,65,cc  
 /********************/
    {0, 0, 0}
};

static __u16 tas5130c_vf0250_scale_data[][3] = {
    {0xa0, 0x0001, 0x0000},          //00,00,01,cc,
    {0xa0, 0x0002, 0x0008},          //00,08,02,cc,
    {0xa0, 0x0001, 0x0010},          //00,10,01,cc,
    {0xa0, 0x0000, 0x0002},          //00,02,10,cc, 
    {0xa0, 0x0002, 0x0003},          //00,03,02,cc, 
    {0xa0, 0x0080, 0x0004},          //00,04,80,cc, 
    {0xa0, 0x0001, 0x0005},          //00,05,01,cc, 
    {0xa0, 0x00e0, 0x0006},          //00,06,e0,cc, 
    {0xa0, 0x0098, 0x008b},          //00,8b,98,cc, 
    {0xa0, 0x0001, 0x0001},          //00,01,01,cc, 
    {0xa0, 0x0003, 0x0012},          //00,12,03,cc, 
    {0xa0, 0x0001, 0x0012},          //00,12,01,cc, 
    {0xa0, 0x0000, 0x0098},          //00,98,00,cc, 
    {0xa0, 0x0000, 0x009a},          //00,9a,00,cc, 
    {0xa0, 0x0000, 0x011a},          //01,1a,00,cc, 
    {0xa0, 0x0000, 0x011c},          //01,1c,00,cc, 
    {0xa0, 0x00e8, 0x009c},          //00,9c,e8,cc, 8<->6 
    {0xa0, 0x0088, 0x009e},          //00,9e,88,cc, 8<->6 
    {0xa0, 0x0010, 0x0087},          //00,87,10,cc,      
    {0xa0, 0x0098, 0x008b},          //00,8b,98,cc,      
    {0xa0, 0x001b, 0x0092},          //00,1b,24,aa,      
    {0xa0, 0x0024, 0x0093},             
    {0xa0, 0x0000, 0x0094},                              
    {0xa0, 0x0001, 0x0090},                              
    {0xa1, 0x0001, 0x0091},                              
    {0xa0, 0x0000, 0x0039},          //00,00,80,dd, ??                   
    {0xa1, 0x0001, 0x0037},          //             ??        
    {0xa0, 0x001b, 0x0092},          //00,1b,00,aa,                    
    {0xa0, 0x0000, 0x0093},                              
    {0xa0, 0x0000, 0x0094},                              
    {0xa0, 0x0001, 0x0090},                
    {0xa1, 0x0001, 0x0091},                              
    {0xa0, 0x0013, 0x0092},          //00,13,02,aa,                    
    {0xa0, 0x0002, 0x0093},                              
    {0xa0, 0x0000, 0x0094},                
    {0xa0, 0x0001, 0x0090},                              
    {0xa1, 0x0001, 0x0091},                              
    {0xa0, 0x0015, 0x0092},          //00,15,04,aa                     
    {0xa0, 0x0004, 0x0093},                              
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0001, 0x0092},            
    {0xa0, 0x0000, 0x0093},         //00,01,00,aa,   
    {0xa0, 0x0000, 0x0094},           
    {0xa0, 0x0001, 0x0090},           
    {0xa1, 0x0001, 0x0091},           
    {0xa0, 0x0001, 0x0092},           
    {0xa0, 0x0000, 0x0093},           
    {0xa0, 0x0000, 0x0094},           
    {0xa0, 0x0001, 0x0090},           
    {0xa1, 0x0001, 0x0091},           
    {0xa0, 0x001a, 0x0092},         //00,1a,00,aa, 
    {0xa0, 0x0000, 0x0093},          
    {0xa0, 0x0000, 0x0094},           
    {0xa0, 0x0001, 0x0090},         
    {0xa1, 0x0001, 0x0091},            
    {0xa0, 0x001c, 0x0092},         //00,1c,17,aa,  
    {0xa0, 0x0017, 0x0093},           
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},           
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x0082, 0x0086},          //00,86,82,cc, 
    {0xa0, 0x0083, 0x0087},          //00,87,83,cc, 
    {0xa0, 0x0084, 0x0088},          //00,88,84,cc, 
    {0xa0, 0x0005, 0x0092},          //00,05,10,aa,
    {0xa0, 0x0010, 0x0093},          
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},          
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x000a, 0x0092},          //00,0a,00,aa, 
    {0xa0, 0x0000, 0x0093},                         
    {0xa0, 0x0000, 0x0094},         
    {0xa0, 0x0001, 0x0090},         
    {0xa1, 0x0001, 0x0091},         
    {0xa0, 0x000b, 0x0092},          //00,0b,a0,aa, 
    {0xa0, 0x00a0, 0x0093},          
    {0xa0, 0x0000, 0x0094},          
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x0001, 0x0090},            
    {0xa0, 0x000c, 0x0092},          //00,0c,00,aa,  
    {0xa0, 0x0000, 0x0093},           
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},           
    {0xa1, 0x0001, 0x0091},           
    {0xa0, 0x000d, 0x0092},          //00,0d,a0,aa, 
    {0xa0, 0x00a0, 0x0093},          
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},          
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x000e, 0x0092},          //00,0e,00,aa,
    {0xa0, 0x0000, 0x0093},          
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},          
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x000f, 0x0092},          //00,0f,a0,aa, 
    {0xa0, 0x00a0, 0x0093},          
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},           
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x0010, 0x0092},          //00,10,00,aa,                
    {0xa0, 0x0000, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},         
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0011, 0x0092},          //00,11,a0,aa,
    {0xa0, 0x00a0, 0x0093},         
    {0xa0, 0x0000, 0x0094},         
    {0xa0, 0x0001, 0x0090},          
    {0xa1, 0x0001, 0x0091},         
    {0xa0, 0x0000, 0x0039},         
    {0xa1, 0x0001, 0x0037},          
    {0xa0, 0x0016, 0x0092},          //00,16,01,aa, 
    {0xa0, 0x0001, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},          
    {0xa0, 0x0017, 0x0092},          //00,17,e6,aa
    {0xa0, 0x00e8, 0x0093},          // 8<->6         
    {0xa0, 0x0000, 0x0094},          
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x0001, 0x0090},          
    {0xa0, 0x0018, 0x0092},          //00,18,02,aa,
    {0xa0, 0x0002, 0x0093},          
    {0xa0, 0x0000, 0x0094},          
    {0xa1, 0x0001, 0x0091},          
    {0xa0, 0x0001, 0x0090},          
    {0xa0, 0x0019, 0x0092},          //00,19,88,aa,
    {0xa0, 0x0088, 0x0093},          //  8<->6          
    {0xa0, 0x0000, 0x0094},          
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x0020, 0x0092},          //00,20,20,aa,
    {0xa0, 0x0020, 0x0093},
    {0xa0, 0x0000, 0x0094},
    {0xa0, 0x0001, 0x0090},
    {0xa1, 0x0001, 0x0091},
    {0xa0, 0x00b7, 0x0101},          //01,01,b7,cc, 
    {0xa0, 0x0005, 0x0012},          //00,12,05,cc, 
    {0xa0, 0x000d, 0x0100},          //01,00,0d,cc, 
    {0xa0, 0x0076, 0x0189},          //01,89,76,cc, 
    {0xa0, 0x0009, 0x01ad},          //01,ad,09,cc, 
    {0xa0, 0x0003, 0x01c5},          //01,c5,03,cc, 
    {0xa0, 0x0013, 0x01cb},          //01,cb,13,cc, 
    {0xa0, 0x0008, 0x0250},          //02,50,08,cc, 
    {0xa0, 0x0008, 0x0301},          //03,01,08,cc, 
    {0xa0, 0x0060, 0x01a8},          //01,a8,60,cc, 
    {0xa0, 0x0061, 0x0116},          //01,16,61,cc, 
    {0xa0, 0x0065, 0x0118},          //01,18,65,cc  
 /********************/                                                           
    {0, 0, 0}                                                                       
};                                                                                
/* "50HZ" light frequency banding filter */
static __u16 tas5130c_vf0250_50HZ[][3] = {
    {0xa0, 0x0082, 0x0092},          //00,82,00,aa
    {0xa0, 0x0000, 0x0093},          //
    {0xa0, 0x0000, 0x0094},          //
    {0xa0, 0x0001, 0x0090},          //
    {0xa1, 0x0001, 0x0091},          //
/************************/          
    {0xa0, 0x0083, 0x0092},          //00,83,01,aa
    {0xa0, 0x0001, 0x0093},          //
    {0xa0, 0x0000, 0x0094},          //
    {0xa0, 0x0001, 0x0090},          //
    {0xa1, 0x0001, 0x0091},          //
/********************/                
    {0xa0, 0x0084, 0x0092},          //00,84,aa,aa
    {0xa0, 0x00aa, 0x0093},          //
    {0xa0, 0x0000, 0x0094},          //
    {0xa0, 0x0001, 0x0090},          //
    {0xa1, 0x0001, 0x0091},          //
/********************/                
    {0xa0, 0x0000, 0x0190},          //01,90,00,cc,                          
    {0xa0, 0x0006, 0x0191},	     //01,91,0d,cc,
    {0xa0, 0x00a8, 0x0192},	     //01,92,50,cc,
    {0xa0, 0x0000, 0x0195},	     //01,95,00,cc,
    {0xa0, 0x0000, 0x0196},	     //01,96,00,cc,
    {0xa0, 0x008e, 0x0197},	     //01,97,47,cc,
    {0xa0, 0x000e, 0x018c},	     //01,8c,0e,cc,
    {0xa0, 0x0015, 0x018f},	     //01,8f,15,cc,
    {0xa0, 0x0010, 0x01a9},	     //01,a9,10,cc,
    {0xa0, 0x0024, 0x01aa},	     //01,aa,24,cc,
    {0xa0, 0x0062, 0x001d},	     //00,1d,62,cc,
    {0xa0, 0x0090, 0x001e},	     //00,1e,90,cc,
    {0xa0, 0x00c8, 0x001f},	     //00,1f,c8,cc,
    {0xa0, 0x00ff, 0x0020},	     //00,20,ff,cc,
    {0xa0, 0x0058, 0x011d},	     //01,1d,58,cc,
    {0xa0, 0x0042, 0x0180},          //01,80,42,cc,
    {0xa0, 0x0078, 0x018d},	     //01,8d,78,cc
/********************/                                                           
{0, 0, 0}                                                                        
};                                                                                

/* "50HZScale" light frequency banding filter */
static __u16 tas5130c_vf0250_50HZScale[][3] = {
    {0xa0, 0x0082, 0x0092},           //00,82,00,aa
    {0xa0, 0x0000, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/************************/
    {0xa0, 0x0083, 0x0092},           //00,83,03,aa
    {0xa0, 0x0003, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0084, 0x0092},           //00,84,54,aa
    {0xa0, 0x0054, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0000, 0x0190},           //01,90,00,cc,                          
    {0xa0, 0x000d, 0x0191},	      //01,91,0d,cc,
    {0xa0, 0x0050, 0x0192},	      //01,92,50,cc,
    {0xa0, 0x0000, 0x0195},	      //01,95,00,cc,
    {0xa0, 0x0000, 0x0196},	      //01,96,00,cc,
    {0xa0, 0x008e, 0x0197},	      //01,97,8e,cc,
    {0xa0, 0x000e, 0x018c},	      //01,8c,0e,cc,
    {0xa0, 0x0015, 0x018f},	      //01,8f,15,cc,
    {0xa0, 0x0010, 0x01a9},	      //01,a9,10,cc,
    {0xa0, 0x0024, 0x01aa},	      //01,aa,24,cc,
    {0xa0, 0x0062, 0x001d},	      //00,1d,62,cc,
    {0xa0, 0x0090, 0x001e},	      //00,1e,90,cc,
    {0xa0, 0x00c8, 0x001f},	      //00,1f,c8,cc,
    {0xa0, 0x00ff, 0x0020},	      //00,20,ff,cc,
    {0xa0, 0x0058, 0x011d},	      //01,1d,58,cc,
    {0xa0, 0x0042, 0x0180},           //01,80,42,cc,
    {0xa0, 0x0078, 0x018d},	      //01,8d,78,cc
 /********************/                                                           
 {0, 0, 0}                                                                        
};                                                                                

/* "60HZ" light frequency banding filter */
static __u16 tas5130c_vf0250_60HZ[][3] = {
    {0xa0, 0x0082, 0x0092},           //00,82,00,aa
    {0xa0, 0x0000, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/************************/
    {0xa0, 0x0083, 0x0092},           //00,83,01,aa
    {0xa0, 0x0001, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0084, 0x0092},           //00,84,62,aa
    {0xa0, 0x0062, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0000, 0x0190},           //01,90,00,cc,                          
    {0xa0, 0x0005, 0x0191},	      //01,91,05,cc,
    {0xa0, 0x0088, 0x0192},	      //01,92,88,cc,
    {0xa0, 0x0000, 0x0195},	      //01,95,00,cc,
    {0xa0, 0x0000, 0x0196},	      //01,96,00,cc,
    {0xa0, 0x003b, 0x0197},	      //01,97,3b,cc,
    {0xa0, 0x000e, 0x018c},	      //01,8c,0e,cc,
    {0xa0, 0x0015, 0x018f},	      //01,8f,15,cc,
    {0xa0, 0x0010, 0x01a9},	      //01,a9,10,cc,
    {0xa0, 0x0024, 0x01aa},	      //01,aa,24,cc,
    {0xa0, 0x0062, 0x001d},	      //00,1d,62,cc,
    {0xa0, 0x0090, 0x001e},	      //00,1e,90,cc,
    {0xa0, 0x00c8, 0x001f},	      //00,1f,c8,cc,
    {0xa0, 0x00ff, 0x0020},	      //00,20,ff,cc,
    {0xa0, 0x0058, 0x011d},	      //01,1d,58,cc,
    {0xa0, 0x0042, 0x0180},           //01,80,42,cc,
    {0xa0, 0x0078, 0x018d},	      //01,8d,78,cc
/********************/                    
{0, 0, 0}                                                                           
};                                                                                   

/* "60HZScale" light frequency banding ilter */
static __u16 tas5130c_vf0250_60HZScale[][3] = {
    {0xa0, 0x0082, 0x0092},           //00,82,00,aa
    {0xa0, 0x0000, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/************************/
    {0xa0, 0x0083, 0x0092},           //00,83,02,aa
    {0xa0, 0x0002, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0084, 0x0092},           //00,84,c4,aa
    {0xa0, 0x00c4, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0000, 0x0190},           //01,90,00,cc,                          
    {0xa0, 0x000b, 0x0191},	      //01,1,0b,cc,
    {0xa0, 0x0010, 0x0192},	      //01,2,10,cc,
    {0xa0, 0x0000, 0x0195},	      //01,5,00,cc,
    {0xa0, 0x0000, 0x0196},	      //01,6,00,cc,
    {0xa0, 0x0076, 0x0197},	      //01,7,76,cc,
    {0xa0, 0x000e, 0x018c},	      //01,c,0e,cc,
    {0xa0, 0x0015, 0x018f},	      //01,f,15,cc,
    {0xa0, 0x0010, 0x01a9},	      //01,9,10,cc,
    {0xa0, 0x0024, 0x01aa},	      //01,a,24,cc,
    {0xa0, 0x0062, 0x001d},	      //00,d,62,cc,
    {0xa0, 0x0090, 0x001e},	      //00,e,90,cc,
    {0xa0, 0x00c8, 0x001f},	      //00,f,c8,cc,
    {0xa0, 0x00ff, 0x0020},	      //00,0,ff,cc,
    {0xa0, 0x0058, 0x011d},	      //01,d,58,cc,
    {0xa0, 0x0042, 0x0180},           //01,80,42,cc,
    {0xa0, 0x0078, 0x018d},	      //01,d,78,cc
/********************/                                                          
{0, 0, 0}                                                                       
};                                                                               

/* "NoFliker" light frequency banding flter */
static __u16 tas5130c_vf0250_NoFliker[][3] = {
    {0xa0, 0x00c, 0x0100},            //01,00,0c,cc,
    {0xa0, 0x0082, 0x0092},           //00,82,00,aa
    {0xa0, 0x0000, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/************************/
    {0xa0, 0x0083, 0x0092},           //00,83,00,aa
    {0xa0, 0x0000, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0084, 0x0092},           //00,84,20,aa
    {0xa0, 0x0020, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0000, 0x0190},	      // 01,0,00,cc,
    {0xa0, 0x0005, 0x0191},           //01,91,05,cc,
    {0xa0, 0x0088, 0x0192},           //01,92,88,cc,
    {0xa0, 0x0000, 0x0195},           //01,95,00,cc,
    {0xa0, 0x0000, 0x0196},           //01,96,00,cc,
    {0xa0, 0x0010, 0x0197},           //01,97,10,cc,
    {0xa0, 0x000e, 0x018c},           //01,8c,0e,cc,
    {0xa0, 0x0015, 0x018f},           //01,8f,15,cc,
    {0xa0, 0x0062, 0x001d},           //00,1d,62,cc,
    {0xa0, 0x0090, 0x001e},           //00,1e,90,cc,
    {0xa0, 0x00c8, 0x001f},           //00,1f,c8,cc,
    {0xa0, 0x00ff, 0x0020},           //00,20,ff,cc,
    {0xa0, 0x0058, 0x011d},           //01,1d,58,cc,
    {0xa0, 0x0003, 0x0180},           //01,80,03,cc
/********************/                                                           
 {0, 0, 0}                                                                        
};                                                                                

/* "NoFlikerScale" light frequency banding filter */
static __u16 tas5130c_vf0250_NoFlikerScale[][3] = {
    {0xa0, 0x000c, 0x0100},           // 01,00,0c,cc,
    {0xa0, 0x0082, 0x0092},           // 00,82,00,aa
    {0xa0, 0x0000, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/************************/
    {0xa0, 0x0083, 0x0092},           // 00,83,00,aa
    {0xa0, 0x0000, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0084, 0x0092},           // 00,84,20,aa
    {0xa0, 0x0020, 0x0093},           //
    {0xa0, 0x0000, 0x0094},           //
    {0xa0, 0x0001, 0x0090},           //
    {0xa1, 0x0001, 0x0091},           //
/********************/                 
    {0xa0, 0x0000, 0x0190},	      // 01,90,00,cc,
    {0xa0, 0x000b, 0x0191},           // 01,91,0b,cc,
    {0xa0, 0x0010, 0x0192},           // 01,92,10,cc,
    {0xa0, 0x0000, 0x0195},           // 01,95,00,cc,
    {0xa0, 0x0000, 0x0196},           // 01,96,00,cc,
    {0xa0, 0x0010, 0x0197},           // 01,97,10,cc,
    {0xa0, 0x000e, 0x018c},           // 01,8c,0e,cc,
    {0xa0, 0x0015, 0x018f},           // 01,8f,15,cc,
    {0xa0, 0x0062, 0x001d},           // 00,1d,62,cc,
    {0xa0, 0x0090, 0x001e},           // 00,1e,90,cc,
    {0xa0, 0x00c8, 0x001f},           // 00,1f,c8,cc,
    {0xa0, 0x00ff, 0x0020},           // 00,20,ff,cc,
    {0xa0, 0x0058, 0x011d},           // 01,1d,58,cc,
    {0xa0, 0x0003, 0x0180},           // 01,80,03,cc
/********************/                                                           
{0, 0, 0}                                                                        
};                                                                                
