//*****************************************************************************
//                               PrcGnucap.hpp                                *
//                              ---------------                               *
//  Description : This class provides the interface to the GNU-Cap electronic *
//                circuit simulator.                                          *
//  Started     : 01/09/2003                                                  *
//  Last Update : 07/01/2008                                                  *
//  Copyright   : (C) 2003 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCGNUCAP_HPP
#define PRCGNUCAP_HPP

// System Includes


// wxWindows Includes

#include <wx/wx.h>
#include <wx/config.h>

// Application Includes

#include "base/PrcSimrBase.hpp"
#include "utility/ConvertType.hpp"

// Local Constant Declarations

#define  GNUCAP_COL_WD  14  // Width of columns of data in the results files

//*****************************************************************************

class PrcGnuCap : public PrcSimrBase
{
  private:

    // The label for the X axis variable (sometimes missing in GNU-Cap)
    wxString  m_osInput;

    // Functions to parse simulator commands
    bool  bParseCmdGEN( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdOP ( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdDC ( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdAC ( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdTR ( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdFO ( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdPR ( wxString & rosCmd, Simulation & roSim );

    // Functions to create the simulator commands
    void  MakeCmdOP( Simulation & roSim );
    void  MakeCmdDC( Simulation & roSim );
    void  MakeCmdAC( Simulation & roSim );
    void  MakeCmdTR( Simulation & roSim );
    void  MakeCmdFO( Simulation & roSim );
    bool  bMakeCmds( Simulation & roSim );

    // Create arguments for the PRINT command
    wxString & rosMakeArgsPR( Simulation & roSim, wxString & rosPrefix );

    // Functions to check / format the circuit description lines
    bool  bFmtCpnts( wxArrayString & roasCpnts );

    // Format the results file
    bool  bFmtResults  ( void );
    bool  bFmtGeneric  ( void );
    bool  bFmtResultsFO( void );
    bool  bFmtColumnHdr( void );
    bool  bFmtDataLines( void );

  public:

    PrcGnuCap( void );
   ~PrcGnuCap( );

    // Parse the simulation commands
    virtual  bool  bParseSim( Simulation & roSim );
    // Make the simulation commands
    virtual  bool  bMakeSim( Simulation & roSim );
};

//*****************************************************************************

#endif // PRCGNUCAP_HPP
