AC_DEFUN([GST_DOCBOOK2X_CHECK],
[
  dnl enable/disable docbook2x man page building
  AC_ARG_ENABLE(docbook2x,
  AC_HELP_STRING([--enable-docbook2x],
                 [build manpages using docbook2x [default=no]]),,
                 enable_docbook2x=no)

  docbook2x_PROGRAM=false

  if test x$enable_docbook2x = xyes; then
    dnl check if we actually have everything we need

    dnl check for docbook2x tools
    AC_CHECK_PROG(HAVE_DOCBOOK2X, docbook2x-man, yes, no)
    AC_CHECK_PROG(HAVE_DOCBOOK2MAN, docbook-to-man, yes, no)

    dnl check for right executable; goes by many names, depending on distro
    docbook2x_PROGRAM=""
    if test "x$HAVE_DOCBOOK2X" != "xno"; then
      docbook2x_PROGRAM="docbook2x-man"
    elif test "x$HAVE_DOCBOOK2MAN" != "xno"; then
      docbook2x_PROGRAM="docbook-to-man"
    fi
    AC_MSG_CHECKING([whether docbook2x is valid])
    if ($docbook2x_PROGRAM --version | grep docbook2x) >/dev/null 2>&1; then
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
      enable_docbook2x=no
      docbook2x_PROGRAM=false
    fi
  fi

  AM_CONDITIONAL(ENABLE_DOCBOOK2X,    test x$enable_docbook2x = xyes)
  AC_SUBST(docbook2x_PROGRAM)
])
