/* 
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Fluendo MPEG Demuxer plugin.
 *
 * The Initial Developer of the Original Code is Fluendo, S.L.
 * Portions created by Fluendo, S.L. are Copyright (C) 2005
 * Fluendo, S.L. All Rights Reserved.
 *
 * Contributor(s): Jan Schmidt <jan@fluendo.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>

#include "flutspmtstreaminfo.h"

enum
{
  PROP_0,
  PROP_PID,
  PROP_LANGUAGES
};

GST_BOILERPLATE (FluTsPmtStreamInfo, fluts_pmt_stream_info, GObject, 
    G_TYPE_OBJECT);

static void fluts_pmt_stream_info_set_property (GObject * object, guint prop_id,
    const GValue * value, GParamSpec * spec);
static void fluts_pmt_stream_info_get_property (GObject * object, guint prop_id,
    GValue * value, GParamSpec * spec);

static void
fluts_pmt_stream_info_base_init (gpointer klass)
{
}

static void
fluts_pmt_stream_info_class_init (FluTsPmtStreamInfoClass *klass)
{
  GObjectClass *gobject_klass = (GObjectClass *) klass;

  gobject_klass->set_property = fluts_pmt_stream_info_set_property;
  gobject_klass->get_property = fluts_pmt_stream_info_get_property;

  g_object_class_install_property (gobject_klass, PROP_PID,
       g_param_spec_uint ("pid", "PID carrying this stream",
       "PID which carries this stream", 1, G_MAXUINT16, 1,
       G_PARAM_READABLE));
  g_object_class_install_property (gobject_klass, PROP_LANGUAGES,
       g_param_spec_value_array ("languages", "Languages of this stream",
       "Value array of the languages of this stream", 
         g_param_spec_string("language", "language", "language", "", 
	   G_PARAM_READABLE),
	 G_PARAM_READABLE));
}

static void
fluts_pmt_stream_info_init (FluTsPmtStreamInfo *pmt_stream_info, FluTsPmtStreamInfoClass *klass)
{
  pmt_stream_info->languages = g_value_array_new ( 0 );
}

FluTsPmtStreamInfo *fluts_pmt_stream_info_new (guint16 pid)
{
  FluTsPmtStreamInfo *info;
  info = g_object_new (FLUTS_TYPE_PMT_STREAM_INFO, NULL);

  info->pid = pid;
  return info;
}

void fluts_pmt_stream_info_add_language(FluTsPmtStreamInfo *pmt_info, 
                                        gchar *language)
{
  GValue v = { 0, };

  g_return_if_fail (FLUTS_IS_PMT_STREAM_INFO (pmt_info));

  g_value_init (&v, G_TYPE_STRING);
  g_value_take_string (&v, language);
  g_value_array_append (pmt_info->languages, &v);
}

static void 
fluts_pmt_stream_info_set_property (GObject * object, guint prop_id, 
    const GValue * value, GParamSpec * spec)
{
  g_return_if_fail (FLUTS_IS_PMT_STREAM_INFO (object));

  /* No settable properties */
  G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, spec);
}

static void 
fluts_pmt_stream_info_get_property (GObject * object, guint prop_id,
    GValue * value, GParamSpec * spec)
{
  FluTsPmtStreamInfo *si;

  g_return_if_fail (FLUTS_IS_PMT_STREAM_INFO (object));

  si = FLUTS_PMT_STREAM_INFO (object);

  switch (prop_id) {
    case PROP_PID:
      g_value_set_uint (value, si->pid);
      break;
    case PROP_LANGUAGES:
      g_value_set_boxed (value, si->languages);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, spec);
      break;
  }
}

