/* 
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Fluendo MPEG Demuxer plugin.
 *
 * The Initial Developer of the Original Code is Fluendo, S.L.
 * Portions created by Fluendo, S.L. are Copyright (C) 2005
 * Fluendo, S.L. All Rights Reserved.
 *
 * Contributor(s): Wim Taymans <wim@fluendo.com>
 */

#ifndef __GST_FLUPS_DEMUX_H__
#define __GST_FLUPS_DEMUX_H__

#include <gst/gst.h>
#include <gst/base/gstadapter.h>

#include "gstpesfilter.h"

G_BEGIN_DECLS

#define GST_TYPE_FLUPS_DEMUX		(gst_flups_demux_get_type())
#define GST_FLUPS_DEMUX(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_FLUPS_DEMUX,GstFluPSDemux))
#define GST_FLUPS_DEMUX_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_FLUPS_DEMUX,GstFluPSDemuxClass))
#define GST_FLUPS_DEMUX_GET_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS((klass),GST_TYPE_FLUPS_DEMUX,GstFluPSDemuxClass))
#define GST_IS_FLUPS_DEMUX(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_FLUPS_DEMUX))
#define GST_IS_FLUPS_DEMUX_CLASS(obj)	(G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_FLUPS_DEMUX))

typedef struct _GstFluPSStream GstFluPSStream;
typedef struct _GstFluPSDemux GstFluPSDemux;
typedef struct _GstFluPSDemuxClass GstFluPSDemuxClass;

#define GST_FLUPS_DEMUX_MAX_STREAMS	256
#define GST_FLUPS_DEMUX_MAX_PSM		256

typedef enum {
  GST_FLUPS_DEMUX_SYNC_AUTO = 0,
  GST_FLUPS_DEMUX_SYNC_SCR = 1,
  GST_FLUPS_DEMUX_SYNC_DTS = 2
} GstFluPSDemuxSync;

typedef enum {
  STATE_FLUPS_DEMUX_NEED_SYNC,
  STATE_FLUPS_DEMUX_SYNCED,
  STATE_FLUPS_DEMUX_NEED_MORE_DATA,
} GstFluPSDemuxState;

/* Information associated with a single FluPS stream. */
struct _GstFluPSStream {
  GstPad	*pad;

  gint		 id;
  gint		 type;
  gint		 size_bound;

  gboolean       discont;
};

struct _GstFluPSDemux {
  GstElement	  parent;

  GstPad	 *sinkpad;

  GstAdapter	 *adapter;
  guint32	  last_sync_code;
  GstPESFilter    filter;

  gint64	  mux_rate;
  guint64	  base_scr;
  guint64	  base_dts;
  guint64	  base_time;
  guint64	  current_scr;
  guint64	  next_scr;
  guint64	  bytes_since_scr;
  gint64	  scr_adjust;

  gint		  psm[GST_FLUPS_DEMUX_MAX_PSM];

  GstSegment	  sink_segment;
  GstSegment	  src_segment;

  /* stream output */
  GstFluPSStream *current_stream;
  gint64          next_pts;
  gint64          next_dts;
  GstFluPSStream *streams[GST_FLUPS_DEMUX_MAX_STREAMS];

  /* properties */
  GstFluPSDemuxSync sync_method;
  GstFluPSDemuxSync cur_sync_method;
};

struct _GstFluPSDemuxClass {
  GstElementClass parent_class;

  GstPadTemplate *sink_template;
  GstPadTemplate *video_template;
  GstPadTemplate *audio_template;
  GstPadTemplate *private_template;
};

GType		gst_flups_demux_get_type	(void);

gboolean	gst_flups_demux_plugin_init	(GstPlugin *plugin);

G_END_DECLS

#endif /* __GST_FLUPS_DEMUX_H__ */
