/* GStreamer
 * Copyright (C) 1999,2000,2001,2002 Erik Walthinsen <omega@cse.ogi.edu>
 *                    2000,2001,2002 Wim Taymans <wtay@chello.be>
 *                              2002 Steve Baker <steve@stevebaker.org>
 *                              2003 Julien Moutte <julien@moutte.net>
 *
 * gstmediaplay.h: Media Player widget for Gst-Player
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_MEDIA_PLAY_H__
#define __GST_MEDIA_PLAY_H__

#include <gst/play/play.h>


typedef enum
{
  GST_MEDIA_PLAY_NORMAL,
  GST_MEDIA_PLAY_NOCONTROL,
  GST_MEDIA_PLAY_FULLSCREEN,
}
GstMediaPlayMode;

#define GST_TYPE_MEDIA_PLAY           (gst_media_play_get_type())
#define GST_MEDIA_PLAY(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), GST_TYPE_MEDIA_PLAY, GstMediaPlay))
#define GST_MEDIA_PLAY_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), GST_TYPE_MEDIA_PLAY, GstMediaPlayClass))
#define GST_IS_MEDIA_PLAY(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GST_TYPE_MEDIA_PLAY))
#define GST_IS_MEDIA_PLAY_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GST_TYPE_MEDIA_PLAY))
#define GST_MEDIA_PLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MEDIA_PLAY, GstMediaPlayClass))

typedef struct _GstMediaPlay GstMediaPlay;
typedef struct _GstMediaPlayClass GstMediaPlayClass;
typedef struct _GstMediaPlayPrivate GstMediaPlayPrivate;

struct _GstMediaPlay
{
  GtkVBox parent;

  /* FIXME : should not be public.. fix main.c */
  GtkWidget *playlist;

  GstMediaPlayPrivate *_priv;
};

struct _GstMediaPlayClass
{
  GtkVBoxClass parent_class;

  /* signals */

  void (*state_changed) (GstMediaPlay * mplay,
			 GstElementState old_state,
			 GstElementState new_state);
  void (*display_mode_change) (GstMediaPlay * mplay,
			       GstMediaPlayMode display_mode);
  void (*current_location) (GstMediaPlay * mplay,
			    char *location, char *location_short);
  void (*playback_error) (GstMediaPlay * mplay,
			  char *error_message, char *object_name);
};

GType gst_media_play_get_type (void);
GstMediaPlay *gst_media_play_new (void);

void gst_media_play_toggle_play_pause (GtkWidget * widget,
				       GstMediaPlay * mplay);
void gst_media_play_stop (GtkWidget * widget, GstMediaPlay * mplay);
void gst_media_play_next (GtkWidget * widget, GstMediaPlay * mplay);
void gst_media_play_previous (GtkWidget * widget, GstMediaPlay * mplay);
void gst_media_play_toggle_mute (GtkWidget * widget, GstMediaPlay * mplay);

void gst_media_play_set_display_mode (GstMediaPlay * mplay,
				      GstMediaPlayMode display_mode,
				      gint width, gint height);

GstMediaPlayMode gst_media_play_get_display_mode (GstMediaPlay * mplay);

void gst_media_play_toggle_visualisation (GstMediaPlay * mplay);

void gst_media_play_show_about (GstMediaPlay * mplay);

void gst_media_play_set_video_scale (GstMediaPlay * mplay,
				     gfloat scale_factor);
gfloat gst_media_play_get_video_scale (GstMediaPlay * mplay);

void gst_media_play_set_video_scale_override (GstMediaPlay * mplay,
					      gboolean override);
gboolean gst_media_play_get_video_scale_override (GstMediaPlay * mplay);

GstElement *gst_media_play_get_visual (GstMediaPlay * mplay);
gboolean gst_media_play_set_visual (GstMediaPlay * mplay, const char *name);

gboolean gst_media_play_set_effect (GstMediaPlay * mplay, const char *name);

void gst_media_play_set_state (GstMediaPlay * mplay, GstElementState state);
GstElementState gst_media_play_get_state (GstMediaPlay * mplay);

void gst_media_play_set_volume (GstMediaPlay * mplay, gdouble value);
gdouble gst_media_play_get_volume (GstMediaPlay * mplay);

void gst_media_play_set_location (GstMediaPlay * mplay,
				  const gchar * location);
const gchar *gst_media_play_get_location (GstMediaPlay * mplay);


gint gst_media_play_handle_keypress (GtkWidget * widget,
				     GdkEventKey * event,
				     GstMediaPlay * mplay);
void gst_media_play_ignore_playlist_changes (GstMediaPlay * mplay,
					     gboolean ignore);

gboolean gst_media_gconf_set_boolean (const gchar *key, gboolean value);
gboolean gst_media_gconf_get_boolean (const gchar *key, gboolean *value);
void gst_media_play_show_media_info (GtkWidget * widget,
				     GstMediaPlay * mplay);
#endif /* __GST_MEDIA_PLAY_H__ */
