/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GSTPLAY_PRIVATE_H__
#define __GSTPLAY_PRIVATE_H__

#include <gst/gst.h>

typedef struct _GstPlayPrivate GstPlayPrivate;

struct _GstPlayPrivate {
	GstPlayState state;

	GstElement *pipeline;
	GstElement *video_sink;
	GstElement *audio_sink;
	GstElement *video_show;
	/*GtkWidget  *video_widget; */
	GstElement *filesrc;
	GstElement *cache;
	GstElement *typefind;
	
	guchar *location;
	gboolean muted;
	gboolean can_seek;
	
	GstElement *offset_element;
	GstElement *bit_rate_element;
	GstElement *media_time_element;
	GstElement *current_time_element;

	guint source_width;
	guint source_height;
};

#endif /* __GSTPLAY_PRIVATE_H__ */
