/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <locale.h>
#include <config.h>
#include <gnome.h>

#include "gstpreferences.h"

struct _GstPreferencesPrivate {
	GtkWidget *rbutton_full_volume;
	GtkWidget *rbutton_half_volume;
	GtkWidget *rbutton_muted;
};

static void gst_preferences_finalize (GObject *object);
static void gst_preferences_response (GtkDialog *dialog, gint response);

GNOME_CLASS_BOILERPLATE (GstPreferences, gst_preferences,
			 GtkDialog, GTK_TYPE_DIALOG)

static void
gst_preferences_class_init (GstPreferencesClass *klass)
{
	GObjectClass *object_class;
	GtkWidgetClass *widget_class;
	GtkDialogClass *dialog_class;

	object_class = (GObjectClass *) klass;
	widget_class = (GtkWidgetClass *) klass;
	dialog_class = (GtkDialogClass *) klass;

	object_class->finalize = gst_preferences_finalize;

	dialog_class->response = gst_preferences_response;
}

static void
gst_preferences_instance_init (GstPreferences *preferences)
{
	GstPreferencesPrivate  *priv;
	GtkWidget              *vbox;
	GtkWidget              *label;
	GtkWidget              *cbutton;
	GtkWidget              *hseparator;

	priv = g_new0 (GstPreferencesPrivate, 1);
	preferences->_priv = priv;

	gtk_window_set_title (GTK_WINDOW (preferences), "GStreamer Player Preferences");
	gtk_window_set_default_size (GTK_WINDOW (preferences), 400, 400);

	vbox = gtk_vbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (preferences)->vbox), vbox, TRUE, TRUE, 0);

	label = gtk_label_new ("Play mode:");
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);

	cbutton = gtk_check_button_new_with_label ("Automatically start playing");
	gtk_box_pack_start (GTK_BOX (vbox), cbutton, TRUE, TRUE, 0);

	cbutton = gtk_check_button_new_with_label ("Close window when done playing movies");
	gtk_box_pack_start (GTK_BOX (vbox), cbutton, TRUE, TRUE, 0);

	cbutton = gtk_check_button_new_with_label ("Close window when done playing music");
	gtk_box_pack_start (GTK_BOX (vbox), cbutton, TRUE, TRUE, 0);

	cbutton = gtk_check_button_new_with_label ("Loop movie by default");
	gtk_box_pack_start (GTK_BOX (vbox), cbutton, TRUE, TRUE, 0);

	cbutton = gtk_check_button_new_with_label ("Loop music by default");
	gtk_box_pack_start (GTK_BOX (vbox), cbutton, TRUE, TRUE, 0);

	hseparator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), hseparator, TRUE, TRUE, 0);

	label = gtk_label_new ("Play background movies at:");
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);	

	priv->rbutton_full_volume = gtk_radio_button_new_with_label (NULL, "Full volume");
	gtk_box_pack_start (GTK_BOX (vbox), priv->rbutton_full_volume, TRUE, TRUE, 0);		

	priv->rbutton_half_volume = gtk_radio_button_new_with_label_from_widget 
		(GTK_RADIO_BUTTON (priv->rbutton_full_volume), "Half volume");
	gtk_box_pack_start (GTK_BOX (vbox), priv->rbutton_half_volume, TRUE, TRUE, 0);		

	priv->rbutton_muted = gtk_radio_button_new_with_label_from_widget 
		(GTK_RADIO_BUTTON (priv->rbutton_full_volume), "Muted");
	gtk_box_pack_start (GTK_BOX (vbox), priv->rbutton_muted, TRUE, TRUE, 0);		

	gtk_dialog_add_button (GTK_DIALOG (preferences), GTK_STOCK_OK, GTK_RESPONSE_OK);
	gtk_dialog_set_default_response (GTK_DIALOG (preferences), GTK_RESPONSE_OK);

	gtk_window_set_resizable (GTK_WINDOW (preferences), FALSE);

	gtk_widget_show_all (GTK_WIDGET (preferences));
}

static void
gst_preferences_finalize (GObject *object)
{
	GstPreferences *preferences = GST_PREFERENCES (object);

	GNOME_CALL_PARENT (G_OBJECT_CLASS, finalize, (object));
}

static void
gst_preferences_response (GtkDialog *dialog, gint response)
{
	gtk_widget_destroy (GTK_WIDGET (dialog));
}

GtkWidget*
gst_preferences_new (void)
{
	GstPreferences *preferences;

	preferences = g_object_new (GST_TYPE_PREFERENCES, NULL);

	return GTK_WIDGET (preferences);
}
