/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GST_PREFERENCES_H__
#define __GST_PREFERENCES_H__

#include <gnome.h>

G_BEGIN_DECLS

#define GST_TYPE_PREFERENCES            (gst_preferences_get_type ())
#define GST_PREFERENCES(object)         (G_TYPE_CHECK_INSTANCE_CAST ((object), GST_TYPE_PREFERENCES, GstPreferences))
#define GST_PREFERENCES_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GST_TYPE_PREFERENCES, GstPreferencesClass))
#define GST_IS_PREFERENCES(object)      (G_TYPE_CHECK_INSTANCE_TYPE ((object), GST_TYPE_PREFERENCES))
#define GST_PREFERENCES_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GST_TYPE_PREFERENCES, GstPreferencesClass))

typedef struct _GstPreferences         GstPreferences;
typedef struct _GstPreferencesClass    GstPreferencesClass;
typedef struct _GstPreferencesPrivate  GstPreferencesPrivate;

struct _GstPreferences
{
	GtkDialog dialog;

	GstPreferencesPrivate *_priv;
};

struct _GstPreferencesClass
{
	GtkDialogClass parent_class;
};

GType       gst_preferences_get_type  (void) G_GNUC_CONST;
GtkWidget*  gst_preferences_new       (void);

G_END_DECLS

#endif /* __GST_PREFERENCES_H__ */

