/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GST_STATUS_AREA_H__
#define __GST_STATUS_AREA_H__

#include <gst/gst.h>
#include <gtk/gtk.h>

#define GST_TYPE_STATUS_AREA          (gst_status_area_get_type ())
#define GST_STATUS_AREA(obj)          (GTK_CHECK_CAST ((obj), GST_TYPE_STATUS_AREA, GstStatusArea))
#define GST_STATUS_AREA_CLASS(klass)  (GTK_CHECK_CLASS_CAST ((klass), GST_TYPE_STATUS_AREA, GstStatusAreaClass))
#define GST_IS_STATUS_AREA(obj)       (GTK_CHECK_TYPE ((obj), GST_TYPE_STATUS_AREA))
#define GST_IS_STATUS_AREA_CLASS(obj) (GTK_CHECK_CLASS_TYPE ((klass), GST_TYPE_STATUS_AREA))

typedef struct _GstStatusArea GstStatusArea;
typedef struct _GstStatusAreaClass GstStatusAreaClass;

struct _GstStatusArea {
	GtkHBox parent;

	GladeXML *xml;
	gint64 time_nanos;
	gint64 length_nanos;
	gchar *time_str;
};

struct _GstStatusAreaClass {
	GtkHBoxClass parent_class;
};


GtkType 	gst_status_area_get_type	(void);

GtkWidget*	gst_status_area_new		(GladeXML *xml);

void		gst_status_area_set_state	(GstStatusArea *area, GstElementState old_state, GstElementState new_state);
void		gst_status_area_set_location	(GstStatusArea *area, const gchar *location);
void	 	gst_status_area_set_time	(GstStatusArea *area, gint64 time_nanos);
void	 	gst_status_area_set_length	(GstStatusArea *area, gint64 length_nanos);
void            gst_status_area_set_information (GstStatusArea *area, GstElement *element, GParamSpec *param);
void            gst_status_area_reset_media_info(GstStatusArea *area);

#endif /* __GST_STATUS_AREA_H__ */
