#include <gst/gst.h>
#include <gst/play/play.h>
#include <gst/gconf/gconf.h>
#include <unistd.h>

/*#define PLAY_PIPELINE GST_PLAY_PIPE_AUDIO_HYPER_THREADED*/
/*#define PLAY_PIPELINE GST_PLAY_PIPE_AUDIO_THREADED*/
#define PLAY_PIPELINE GST_PLAY_PIPE_VIDEO

typedef struct _GstCmdPlay GstCmdPlay;

struct _GstCmdPlay {
	GSList *files;
	GAsyncQueue *queue;
	GstPlay *play;
	gint64 time_nanos;
	gint64 length_nanos;
	gboolean stopping;
};

void next_file(GstCmdPlay *cmdplay)
{
	gchar* filename;

	if (cmdplay->files == NULL){
		gst_play_set_state(cmdplay->play, GST_STATE_NULL);
		g_print("finished\n");
		cmdplay->stopping = TRUE;
		gst_main_quit();
	}

	filename = (gchar*) cmdplay->files->data;
	g_print("playing %s\n", filename);
	gst_play_set_location (cmdplay->play, filename);
	gst_play_set_state(cmdplay->play, GST_STATE_PLAYING);

	cmdplay->files = g_slist_remove_link(cmdplay->files, cmdplay->files);
}

void
file_eos (GstPlay *play, GstCmdPlay *cmdplay)
{
	g_print("got eos\n");
	next_file (cmdplay);
}

gboolean
do_cmd(GstCmdPlay *cmdplay)
{
	gpointer cmd_ptr;
	gchar cmd_int;
	
	if (!(cmd_ptr = g_async_queue_try_pop(cmdplay->queue))){
		return TRUE;
	}
	
	cmd_int = GPOINTER_TO_INT(cmd_ptr);
	switch (cmd_int){
		case 'P':
			g_print("playing\n");
			gst_play_set_state(cmdplay->play, GST_STATE_PLAYING);
			break;
		case 'p':
			g_print("pausing\n");
			gst_play_set_state(cmdplay->play, GST_STATE_PAUSED);
			break;
		case 'f':
			g_print("seeking forward 10 seconds\n");
			gst_play_seek_to_time(cmdplay->play, cmdplay->time_nanos + (10 * GST_SECOND));
			break;
		case 'b':
			g_print("seeking backward 10 seconds\n");
			gst_play_seek_to_time(cmdplay->play, cmdplay->time_nanos - (10 * GST_SECOND));
			break;
		case 'r':
			g_print("rewind to beginning of file\n");
			gst_play_seek_to_time(cmdplay->play, 0LL);
			break;
		case 'n':
			g_print("next file\n");
			next_file(cmdplay);
			break;
		case 'q':
			g_print("quitting\n");
			cmdplay->stopping = TRUE;
			gst_main_quit();
			break;
		case '\n': 
			break;

		default:
			g_print("don't understand '%c'\n", cmd_int);
	}

	return TRUE;
}

gpointer
ui_thread (GstCmdPlay *cmdplay)
{
	gint inchar;
	while (!cmdplay->stopping) {
		inchar = getchar();
		g_async_queue_push(cmdplay->queue, GINT_TO_POINTER(inchar));
		if (inchar == 'q'){
			break;
		}
	}
	return NULL;
}

void
time_tick (GstPlay *play, gint64 time_nanos, GstCmdPlay *cmdplay)
{
	gint seconds = (gint) (time_nanos / GST_SECOND);
	cmdplay->time_nanos = time_nanos;
	g_print("time: %02d:%02d\n", seconds/60, seconds%60);
}

void
stream_length (GstPlay *play, gint64 length_nanos, GstCmdPlay *cmdplay)
{
	gint seconds = (gint) (length_nanos / GST_SECOND);
	if (length_nanos > 0LL){
		g_print("stream is %02dmin %02dsec long\n", seconds/60, seconds%60);
	}
	else {
		g_print("stream length is unknown\n");
	}
	cmdplay->length_nanos = length_nanos;
}

void
pipeline_error (GstPlay *play, GstElement *el, char *error, GstCmdPlay *cmdplay)
{
    g_print ("pipeline_error: %s\n", error);
}



int main(int argc,char *argv[]) 
{
	GstElement *audio_sink, *video_sink;
	gint x;
	GstCmdPlay *cmdplay;
	
	gst_init(&argc,&argv);

	g_print("have %d files to play\n", argc - 1);

	cmdplay = g_new0(GstCmdPlay, 1);

	cmdplay->play = gst_play_new(PLAY_PIPELINE, NULL);
	g_assert (cmdplay->play != NULL);
#ifdef HAVE_GSTREAMER_CVS
	audio_sink = gst_gconf_get_default_audio_sink ();
#else
	audio_sink = gst_gconf_render_bin_from_key ("default/audiosink");
#endif
	if (!GST_IS_ELEMENT (audio_sink))
	{
		g_print("couldn't create audio sink\n");
		return -1;
	}
	gst_play_set_audio_sink (cmdplay->play, audio_sink);

#ifdef HAVE_GSTREAMER_CVS
	video_sink = gst_gconf_get_default_video_sink ();
#else
	video_sink = gst_gconf_render_bin_from_key ("default/videosink");
#endif
	if (!GST_IS_ELEMENT (video_sink))
	{
		g_print("couldn't create video sink\n");
		return -1;
	}
	gst_play_set_video_sink (cmdplay->play, video_sink);
	
	cmdplay->queue = g_async_queue_new();
	g_timeout_add (100, (GSourceFunc) do_cmd, cmdplay);
	g_thread_create((GThreadFunc)ui_thread, cmdplay, FALSE, NULL);

	cmdplay->files = NULL;
	for (x = 1 ; x < argc ; x++){
		cmdplay->files = g_slist_append(cmdplay->files, argv[x]);
	}

	g_signal_connect (G_OBJECT (cmdplay->play), "stream_end",
                          G_CALLBACK (file_eos), cmdplay);
	g_signal_connect (G_OBJECT (cmdplay->play), "time_tick",
                          G_CALLBACK (time_tick), cmdplay);
	g_signal_connect (G_OBJECT (cmdplay->play), "stream_length",
                          G_CALLBACK (stream_length), cmdplay);
        g_signal_connect (G_OBJECT (cmdplay->play), "pipeline_error",
                          G_CALLBACK (pipeline_error), cmdplay);

	next_file(cmdplay);
	gst_main();
	exit(0);
}

