/* Copyright (C) <2006> Nokia Corporation.
 *
 * Contact: Zeeshan Ali <zeenix@gstreamer.net>
 *
 * gstrtpclock.h: clock that synchronizes itself according to RTP timestamps
 * provided to it
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __GST_RTP_CLOCK_H__
#define __GST_RTP_CLOCK_H__

#include <gst/gst.h>
#include <gst/gstsystemclock.h>
#include <gst/rtp/gstrtpbuffer.h>

G_BEGIN_DECLS
#define GST_TYPE_RTP_CLOCK \
  (gst_rtp_clock_get_type())
#define GST_RTP_CLOCK(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_RTP_CLOCK,GstRTPClock))
#define GST_RTP_CLOCK_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_RTP_CLOCK,GstRTPClockClass))
#define GST_IS_RTP_CLOCK(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_RTP_CLOCK))
#define GST_IS_RTP_CLOCK_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_RTP_CLOCK))
typedef struct _GstRTPClock GstRTPClock;
typedef struct _GstRTPClockClass GstRTPClockClass;

/**
 * GstRTPClock:
 * @clock: the parent clock structure.
 *
 * Opaque #GstRTPClock structure.
 */
struct _GstRTPClock
{
  GstSystemClock clock;

  GstClockTime base_time;

  /*< private > */
  gpointer _gst_reserved[GST_PADDING];
};

struct _GstRTPClockClass
{
  GstSystemClockClass parent_class;

  /*< private > */
  gpointer _gst_reserved[GST_PADDING];
};

GType gst_rtp_clock_get_type (void);
GstClock *gst_rtp_clock_new (GstClockTime base_time);
void gst_rtp_clock_update (GstRTPClock * self, GstClockTime timestamp,
    gboolean first_packet);

G_END_DECLS
#endif /* __GST_RTP_CLOCK_H__ */
