/* utils.c for gstar */

#include <unistd.h>
#include "gstar.h"
#include "conlocs.h"

GtkWidget *RAspin;
GtkWidget *DEspin;
GtkWidget *SCspin;
GtkWidget *MAGspin;
GtkWidget *LBLspin;
GtkWidget *MOspin;
GtkWidget *DAYspin;
GtkWidget *YRspin;
GtkWidget *HRspin;
GtkWidget *MINspin;
GtkWidget *listbox;
char userdir[MAXSTR];
char rcfile[MAXSTR];
static int month, day, year, hour, minute;
static void delete_file(GtkWidget *widget, char *fle);

#define LEFTMAX 20
#define NUMFILES 5

showinfo rcinfo[] = {
  {"nebfile", "/Show/Nebulae", 1},
  {"boundfile", "/Show/Constellation boundaries", 1},
  {"patternfile", "/Show/Constellation shapes", 1},
  {"constlnamefile", "/Show/Constellation names", 1},
  {"planetfile", "/Show/Planets", 1}
};

int read_rc(char *rcfile) {
     FILE *fpin;
     GtkWidget *item;
     char left[LEFTMAX], right[MAXSTR];
     int i;
     
     fpin = fopen(rcfile, "r");
     if (fpin == NULL) {
       for (i=0;i<NUMFILES;i++) {
	 item = gtk_item_factory_get_item (factory, rcinfo[i].check_name);
	 gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
       }
       return 1;
     }
     while (fscanf( fpin, "%s = %s\n", left, right ) > 1) {
        for (i=0;i<NUMFILES;i++) {
	  item = gtk_item_factory_get_item (factory, rcinfo[i].check_name);
	  if (!strcmp(left, rcinfo[i].file_var) &&
                  !strcmp(right, "/dev/null")) {
	    rcinfo[i].status = 0;
	    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), FALSE);
	  }           
        }
     }
     fclose(fpin);
     for (i=0;i<NUMFILES;i++) {
       item = gtk_item_factory_get_item (factory, rcinfo[i].check_name);
       if (rcinfo[i].status) 
	 gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
     }
     return 0;  
}

int write_rc(char *rcfile) {
     FILE *fpout;
     GtkWidget *item;
     int i;

     fpout = fopen(rcfile, "w");
     if (fpout == NULL) return 1;

     for (i=0;i<NUMFILES;i++) {
       item = gtk_item_factory_get_item (factory, rcinfo[i].check_name);
       if (! GTK_CHECK_MENU_ITEM (item)->active)
	 fprintf(fpout, "%s = /dev/null\n", rcinfo[i].file_var);
     }
     fclose(fpout);

     return 0;
}   

int get_time (void) {
  time_t runtime;
  char timestr[5]; 
  GtkSpinButton *spin;

  time(&runtime);
  strftime(timestr, 5, "%m", localtime(&runtime));
  month = atoi(timestr);
  strftime(timestr, 5, "%d", localtime(&runtime));
  day = atoi(timestr);
  strftime(timestr, 5, "%Y", localtime(&runtime));
  year = atoi(timestr);
  strftime(timestr, 5, "%H", localtime(&runtime));
  hour = atoi(timestr);
  strftime(timestr, 5, "%M", localtime(&runtime));
  minute = atoi(timestr);
  spin = GTK_SPIN_BUTTON (MOspin);
  gtk_spin_button_set_value(spin, (gfloat)month);
  spin = GTK_SPIN_BUTTON (DAYspin);
  gtk_spin_button_set_value(spin, (gfloat)day);
  spin = GTK_SPIN_BUTTON (YRspin);
  gtk_spin_button_set_value(spin, (gfloat)year);
  spin = GTK_SPIN_BUTTON (HRspin);
  gtk_spin_button_set_value(spin, (gfloat)hour);
  spin = GTK_SPIN_BUTTON (MINspin);
  gtk_spin_button_set_value(spin, (gfloat)minute);
  return(0);
}

void planet (int show) {
  gchar cmd[MAXSTR], pfile[MAXSTR], temp[32];
  GtkSpinButton *spin;

  sprintf(cmd, "cd %s && planet ", userdir);
  spin = GTK_SPIN_BUTTON (MOspin);
  sprintf(temp, "-m %d ", gtk_spin_button_get_value_as_int (spin));
  strcat(cmd, temp);
  spin = GTK_SPIN_BUTTON (DAYspin);
  sprintf(temp, "-d %d ", gtk_spin_button_get_value_as_int (spin));
  strcat(cmd, temp);
  spin = GTK_SPIN_BUTTON (YRspin);
  sprintf(temp, "-y %d ", gtk_spin_button_get_value_as_int (spin));
  strcat(cmd, temp);
  spin = GTK_SPIN_BUTTON (HRspin);
  sprintf(temp, "-t %d.", gtk_spin_button_get_value_as_int (spin));
  strcat(cmd, temp);
  spin = GTK_SPIN_BUTTON (MINspin);
  sprintf(temp, "%d", gtk_spin_button_get_value_as_int (spin));
  strcat(cmd, temp);
  if (show == 0) {
    strcat(cmd, " >/dev/null");
  } else {
    strcat(cmd, " >planet.txt");
  }
  system(cmd);
  if (show == 1) {
    strcpy(pfile, userdir);
    strcat(pfile, "/planet.txt");
    view_file(pfile, 1, 400, 250, 0);
  }
}
  

void cons_set (void) {
  gchar temp[32];
  GtkSpinButton *spin;
  int i;

  sprintf(temp, "%s", 
	  gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(listbox)->entry)));
  for (i=0;i<87;i++) {
    if (strcmp(temp, conlocs[i].name)==0) {
      spin = GTK_SPIN_BUTTON (RAspin);
      gtk_spin_button_set_value(spin, conlocs[i].r);
      spin = GTK_SPIN_BUTTON (DEspin);
      gtk_spin_button_set_value(spin, conlocs[i].d);
      spin = GTK_SPIN_BUTTON (SCspin);
      gtk_spin_button_set_value(spin, conlocs[i].s);
      break;
    }
  }
}

char temp_filename[MAXSTR];

void make_chart (char * filename) {
  GtkSpinButton *spin;
  char buf[MAXSTR], title[MAXSTR], psout[MAXSTR], temp[MAXSTR] ;
  char * foo;
  int i, show;

  if (filename == NULL || *filename == '\0') {
    foo = tmpnam(NULL);
    sprintf(psout, "%s.ps", foo);
    strcpy(temp_filename, psout);
    show = 1;
  } else {
    strcpy(psout, filename);
    if (strcmp(psout, temp_filename))
      show = 0;
    else
      show = 2;
  }

  write_rc(rcfile);
  planet(0);
  strcpy(title, "dummy");
  sprintf(buf, "cd %s && starpost ", userdir);
  sprintf(temp, "%s", 
	  gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(listbox)->entry)));
  for (i=0;i<NUMCONS;i++) {
    if (strcmp(temp, conlocs[i].name)==0) {
      strcpy(title, temp);
      break;
    }
  }
  spin = GTK_SPIN_BUTTON (RAspin);
  sprintf(temp, "-r %.2f ", gtk_spin_button_get_value_as_float (spin));
  strcat(buf, temp);
  spin = GTK_SPIN_BUTTON (DEspin);
  sprintf(temp, "-d %.2f ", gtk_spin_button_get_value_as_float (spin));
  strcat(buf, temp);
  spin = GTK_SPIN_BUTTON (SCspin);
  sprintf(temp, "-s %d ", gtk_spin_button_get_value_as_int (spin));
  strcat(buf, temp);
  spin = GTK_SPIN_BUTTON (MAGspin);
  sprintf(temp, "-m %.1f ", gtk_spin_button_get_value_as_float (spin));
  strcat(buf, temp);
  spin = GTK_SPIN_BUTTON (LBLspin);
  sprintf(temp, "-l %.1f ", gtk_spin_button_get_value_as_float (spin));
  strcat(buf, temp);
  if (strcmp(title, "dummy")) {
    sprintf(temp, "-t \"%s\"", title);
    strcat(buf, temp);
  }
  sprintf(temp, " >%s", psout);  strcat(buf, temp);
  if (show == 1) {
    sprintf(temp, " && %s %s &", GVPATH, psout);
    strcat(buf, temp);
  }
  else if (show==2) {
    sprintf(temp, " && killall -HUP gv || %s %s &", GVPATH, psout);
    strcat(buf, temp);
  }
  system(buf);
  if (show == 1) unlink (psout);
}

void make_userdir (void) {
  char buf[MAXSTR];
  char * tmp;

  tmp = getenv("HOME");
  strcpy(userdir, tmp);
  strcat(userdir, "/.gstar");
  sprintf(buf, "mkdir -p %s", userdir);
  system(buf);

}

void set_rcfile (void) {
  char * tmp;

  tmp = getenv("HOME");
  strcpy(rcfile, tmp);
  strcat(rcfile, "/.starrc");
  read_rc(rcfile);
}


int view_file(char *filename, int del_file, int hsize, int vsize, int scroll) {
   GtkWidget *dialog, *view, *close, *table;
   GdkFont *fixed_font;
   GtkWidget *vscrollbar;
   char tempstr[MAXSTR], *fle;
   FILE *fd;

   fd = fopen(filename, "r");
   if (fd == NULL) return 1;

   dialog = gtk_dialog_new();
   gtk_widget_set_usize (dialog, hsize, vsize);
   gtk_window_set_title(GTK_WINDOW(dialog), filename);
   gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), 5);
   gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area), 5);
   gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(dialog)->vbox), 5);
   gtk_box_set_homogeneous(GTK_BOX(GTK_DIALOG(dialog)->action_area), TRUE);

   table = gtk_table_new(1, 2, FALSE);
   gtk_widget_set_usize(table, 500, 400);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), table, TRUE, TRUE, FALSE);

   view = gtk_text_new(NULL, NULL);
   gtk_text_set_editable(GTK_TEXT(view), FALSE);
   gtk_text_set_word_wrap(GTK_TEXT(view), TRUE);
   gtk_table_attach(GTK_TABLE(table), view, 0, 1, 0, 1,
      GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
   gtk_widget_show(view);

   if (scroll) {
     vscrollbar = gtk_vscrollbar_new (GTK_TEXT (view)->vadj);
     gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
                          GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_widget_show (vscrollbar);
   }

   gtk_widget_show(table);

   close = gtk_button_new_with_label("   Close   ");
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), 
		      close, FALSE, FALSE, FALSE);
   if(del_file) {
      fle = mymalloc(strlen(filename)+1);
      strcpy(fle, filename);
      gtk_signal_connect(GTK_OBJECT(close), "clicked", 
			 GTK_SIGNAL_FUNC(delete_file), (gpointer) fle);
   }
   gtk_signal_connect(GTK_OBJECT(close), "clicked", 
		      GTK_SIGNAL_FUNC(delete_modal_dialog), (gpointer) dialog);
   gtk_widget_show(close);

   fixed_font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-120-*-*-*-*-*-*");

   memset(tempstr, 0, sizeof(tempstr));
   while(fread(tempstr, 1, sizeof(tempstr)-1, fd)) {
      gtk_text_insert(GTK_TEXT(view), fixed_font, NULL, NULL, tempstr, 
		      strlen(tempstr));
      memset(tempstr, 0, sizeof(tempstr));
   }
   fclose(fd);
   gtk_widget_show(dialog);
   return 0;
}

static void delete_file(GtkWidget *widget, char *fle) {
   unlink(fle);
   free(fle);
}

void delete_modal_dialog(GtkWidget *widget, gpointer data) {
   gtk_grab_remove((GtkWidget *) data);
   gtk_widget_destroy((GtkWidget *) data);
}

void *mymalloc(size_t size) {
   void *mem;
   
   if((mem = malloc(size)) == NULL) {
      printf("\nError allocating memory. gstar will be shut down.\n");
      exit(0);
   }
   memset(mem, 0, size);
   return(mem);
}




