
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <gstreamermm/gst_wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "bin.h"
#include "buffer.h"
#include "bus.h"
#include "caps.h"
#include "childproxy.h"
#include "clock.h"
#include "element.h"
#include "elementfactory.h"
#include "enums.h"
#include "error.h"
#include "event.h"
#include "filter.h"
#include "format.h"
#include "index.h"
#include "ghostpad.h"
#include "indexfactory.h"
#include "interface.h"
#include "iterator.h"
#include "message.h"
#include "object.h"
#include "pad.h"
#include "padtemplate.h"
#include "parse.h"
#include "pipeline.h"
#include "plugin.h"
#include "pluginfeature.h"
#include "preset.h"
#include "query.h"
#include "registry.h"
#include "segment.h"
#include "structure.h"
#include "systemclock.h"
#include "taglist.h"
#include "tagsetter.h"
#include "task.h"
#include "urihandler.h"
#include "value.h"
#include "xml.h"
#include "basesrc.h"
#include "basesink.h"
#include "basetransform.h"
#include "pushsrc.h"
#include "audioclock.h"
#include "audiofilter.h"
#include "audiosink.h"
#include "audiosrc.h"
#include "baseaudiosink.h"
#include "baseaudiosrc.h"
#include "cddabasesrc.h"
#include "ringbuffer.h"
#include "videosink.h"
#include "colorbalance.h"
#include "colorbalancechannel.h"
#include "mixer.h"
#include "mixeroptions.h"
#include "mixertrack.h"
#include "navigation.h"
#include "propertyprobe.h"
#include "tuner.h"
#include "tunerchannel.h"
#include "tunernorm.h"
#include "videoorientation.h"
#include "xoverlay.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gst_buffer_get_type(void);
GType gst_event_get_type(void);
GType gst_message_get_type(void);
GType gst_query_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gst {  class Buffer_Class { public: static Gst::MiniObject* wrap_new(GstMiniObject*); };  }
namespace Gst {  class Event_Class { public: static Gst::MiniObject* wrap_new(GstMiniObject*); };  }
namespace Gst {  class Message_Class { public: static Gst::MiniObject* wrap_new(GstMiniObject*); };  }
namespace Gst {  class Query_Class { public: static Gst::MiniObject* wrap_new(GstMiniObject*); };  }

namespace Gst { 

void gst_wrap_init()
{

// Map gtypes to gstreamermm wrapper-creation functions:
  Gst::wrap_register(gst_buffer_get_type(), &Gst::Buffer_Class::wrap_new);
  Gst::wrap_register(gst_event_get_type(), &Gst::Event_Class::wrap_new);
  Gst::wrap_register(gst_message_get_type(), &Gst::Message_Class::wrap_new);
  Gst::wrap_register(gst_query_get_type(), &Gst::Query_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gst::Buffer::get_type();
  Gst::Event::get_type();
  Gst::Message::get_type();
  Gst::Query::get_type();

} // gst_wrap_init()

} //Gst


