#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# module for initialization stuff and helper functions
# 29.1.2005

use strict;

sub gtk_main_quit { exit 0; }

sub clear_all {		# reset everything to default values
	my ($indi) = @_;
	my ($form,undef,$defined_tt_entries,$uid_tt_entries) = &get_vars;
	my @empty = ("");

	$form->get_widget('treeview_classs')->get_model->clear;
	$form->get_widget('treeview_subjects')->get_model->clear;
	$form->get_widget('treeview_classrooms')->get_model->clear;
	$form->get_widget('treeview_teachers')->get_model->clear;
	$form->get_widget('treeview_tt')->get_model->clear;	
	$form->get_widget('treeview_combinations_teachers')->get_model->clear;
	$form->get_widget('treeview_combinations_subjects')->get_model->clear;
	$form->get_widget('treeview_combinations_classrooms')->get_model->clear;
	$form->get_widget('treeview_combinations_classs')->get_model->clear;
	if (!$indi) { $form->get_widget('treeview_ttview_all')->get_model->clear; }
	if (!$indi) { $form->get_widget('treeview_ttview_files')->get_model->clear; }
	
	$uid_tt_entries = ();
	$defined_tt_entries= ();    
	if (!$indi) { &clear_ttview; }
	
	$form->get_widget('entry_subject_name')->set_text("");
	$form->get_widget('entry_teacher_rests')->set_text("");
	$form->get_widget('entry_class_name')->set_text("");
	$form->get_widget('entry_classroom_name')->set_text("");
	$form->get_widget('entry_teacher_name')->set_text("");
	$form->get_widget('entry_class_rests')->set_text("");
	$form->get_widget('entry_subject_rests')->set_text("");
	$form->get_widget('entry_classroom_rests')->set_text("");
	$form->get_widget('entry_tt_day')->set_text("");
	$form->get_widget('entry_tt_period')->set_text("");
	$form->get_widget('entry_tt_perweek')->set_text("");
	
	$form->get_widget('combo_tt_classroom')->set_popdown_strings(@empty);
	$form->get_widget('combo_tt_class')->set_popdown_strings(@empty);
	$form->get_widget('combo_tt_subject')->set_popdown_strings(@empty);
	$form->get_widget('combo_tt_teacher')->set_popdown_strings(@empty);
	$form->get_widget('label-chromo')->set_text("");
	if (!$indi) { $form->get_widget('combo_tt_result')->set_popdown_strings(@empty); }

	$form->get_widget('entry_title')->set_text("");
	$form->get_widget('entry_notes')->set_text("");
	$form->get_widget('entry_author')->set_text("");
	$form->get_widget('entry_days')->set_text("5");
	$form->get_widget('entry_periods')->set_text("14");
	$form->get_widget('entry_impossible')->set_text("50");
	$form->get_widget('entry_encoding')->set_text("utf-8");

	$form->get_widget('entry_mod_opts')->set('visible',0);
	$form->get_widget('label_mod_opts')->set('visible',0);	
	$form->get_widget('button_mod_opts_use')->set('visible',0);

	my $oldtable = $form->get_widget('viewport-result')->get_child;
	if ($oldtable) { $form->get_widget('viewport-result')->remove($oldtable); }
		
#	&set_modules_path($form);
	&load_modules($form);
	
	$form->get_widget('window_main')->set_title(gettext("G-Tablix - Untitled"));
}
sub write_to_statusbar {
	my ($what) = @_;
	my $form = &get_form;
		my $cid = $form->get_widget('statusbar')->get_context_id($what);
		$form->get_widget('statusbar')->push($cid,$what);		
}

sub check {
	my ($message,$type) = @_;
	my $form = &get_form;
	my %butns = ('error' => 'ok', 'question' => 'ok-cancel', 'info' => 'ok');
	if (!$type) { $type = "question"; }
	my $main = $form->get_widget('window_main');
	my $dlg = Gtk2::MessageDialog->new($main, ['modal'], $type, $butns{$type},$message);
	my $response = $dlg->run;
	$dlg->destroy;
	return $response;
}


sub find_browser {
	my @try = ('firefox','galeon','konqueror','mozilla','opera','dillo');
	foreach my $a (@try) {
		my $b = readpipe("whereis $a");
		$b = (split/ /,$b)[1];
		if (-x $b) { return $b; }
	}
	return 0;
}

sub get_filename {
	my ($why, $title, $dir) = @_;
	my $chooser = new Gtk2::FileChooserDialog($title, undef, $why, 
							'gtk-ok' => 'ok', 'gtk-cancel' => 'cancel');
	
	if (!$dir) {
	 	my $filter = new Gtk2::FileFilter();
	 	$filter->add_pattern('*.*');
	 	$filter->set_name(gettext('All Files (*.*)'));
	 	$chooser->add_filter($filter);	

	 	my $filter2 = new Gtk2::FileFilter();
	 	$filter2->add_mime_type('text/xml');
	 	$filter2->set_name(gettext('Timetable files (*.XML)'));
	 	$chooser->add_filter($filter2);
	 
	 	my $filter3 = new Gtk2::FileFilter();
	 	$filter3->add_mime_type('application/x-gzip');
	 	$filter3->set_name(gettext('Gziped files (*.gz)'));
	 	$chooser->add_filter($filter3);	

	 	my $filter4 = new Gtk2::FileFilter();
	 	$filter4->add_mime_type('text/html');
	 	$filter4->set_name(gettext('HTML files (*.html)'));
	 	$chooser->add_filter($filter4);	
	}
	
	if ($chooser->run eq "ok") {	  
		my $filename;
		if ($dir) { 
			$filename = $chooser->get_current_folder();
		} else { 
			$filename = $chooser->get_filename(); 
		}
		$chooser->destroy;
		return $filename;
	}
	$chooser->destroy;
	return "cancel";  
}
sub strip_commas { 	# odstej podniz in/ali pobrisi podvojene, vodilne ali zadnje vejice v nizu
	my ($string,$substring) = @_;
	if ($substring) { $string =~ s/$substring//g; }
	$string =~ s/^\,//g;
	$string =~ s/\,$//g;
	$string =~ s/\,\,/\,/g;
	return $string;
}
sub get_process {
	my ($name) = @_;
	my @lines = split /\n/, readpipe("ps ax |grep $name");
	if ($#lines > 0) { return 1; } else { return 0; }
}
sub get_format {
	my ($what) = @_;
	if (!defined $what) { $what = 'svg'; }
# we expect png to work always, but want to use svg because it's faster
	my $format = 'png';
	foreach my $desc (Gtk2::Gdk::Pixbuf->get_formats) {
		if ($desc->{name} eq $what) { $format = $what; last; }
	}
	return $format;
}

sub select_row {
	my $what = $_[0];
	my $form = &get_form;
	my $modules = &get_modules;
	my $rests_active = $form->get_widget('toggletoolbutton_options')->get_active;
	if ($what eq "tt") {
		my $tw = $form->get_widget('treeview_tt');
		(my $path, my $col) = $tw->get_cursor(); 
		if (defined $path) {
	 		my $iter = $tw->get_model->get_iter($path);
	 		my @vals = $tw->get_model->get($iter,0,1,2,3,4,5,6,7,8);
	 		for (my $i = 0; $i <= $#vals; $i++) { if (!defined $vals[$i]) { $vals[$i] = ""; } }
	 		$form->get_widget('combo_entry_tt_teacher')->set_text($vals[2]);
	 		$form->get_widget('combo_entry_tt_subject')->set_text($vals[1]);
	 		$form->get_widget('combo_entry_tt_classroom')->set_text($vals[4]);
	 		$form->get_widget('entry_tt_perweek')->set_text($vals[3]);
	 		$form->get_widget('entry_tt_period')->set_text($vals[5]);
	 		$form->get_widget('entry_tt_day')->set_text($vals[6]);
	 		$form->get_widget('entry_tt_rests')->set_text($vals[7]);	
	 		$form->get_widget('combo_entry_tt_class')->set_text($vals[0]);	
	 		my $notes = $vals[8];
	 		if ($notes) { &write_to_statusbar($notes); }
	 		if ($rests_active) { &on_button_tt_rests_clicked; }
		}
	} else { 
		my $tw = $form->get_widget("treeview_$what".'s');
		my @paths = $tw->get_selection->get_selected_rows;
		my ($name) = "";
		my ($rests) = "";
		my ($notes) = "";
		my ($subject) = "";
		foreach my $path (@paths) {
	 		my $iter = $tw->get_model->get_iter($path); 		
	 		if ($what eq "teacher") {
				my $s = ($tw->get_model->get($iter,1));
				if (!defined $s) { $s = ""; }
				$subject = &clarify($s.','.$subject); 
				my $n = ($tw->get_model->get($iter,0));
				if (!defined $n) { $n = ""; }
				$name = &clarify($n.','.$name); 
				my $r = ($tw->get_model->get($iter,2));
				if (!defined $r) { $r = ""; }
				$rests = &clarify($r.','.$rests); 
				my $t = ($tw->get_model->get($iter,3));
				if (!defined $t) { $t = ""; }
				$notes = &clarify($t.','.$notes); 
				
				$form->get_widget("combo_entry_tt_subject")->set_text($s);
				$form->get_widget("combo_entry_tt_teacher")->set_text($n);
				$form->get_widget("entry_$what\_subjects")->set_text($subject);
	 		} else { 
				my $n = ($tw->get_model->get($iter,0));
				if (!defined $n) { $n = ""; }
				$name = &clarify($n.','.$name); 
				my $r = ($tw->get_model->get($iter,1));
				if (!defined $r) { $r = ""; }
				$rests = &clarify($r.','.$rests); 
				my $t = ($tw->get_model->get($iter,2));
				if (!defined $t) { $t = ""; }
				$notes = &clarify($t.','.$notes); 
				
				$form->get_widget("combo_entry_tt_$what")->set_text($n);
			}		 		
		}
	 	$form->get_widget("entry_$what\_name")->set_text($name); 
	 	$form->get_widget("entry_$what\_rests")->set_text($rests);		 
	 	if ($notes) { &write_to_statusbar($notes); }	
	 	if ($rests_active) { &load_rests($what,$modules,$form); }
	}
}
sub complete_remove {
	my ($what,$iter) = @_;
	my $form = &get_form;
	my $tt = $form->get_widget("treeview_$what".'s');
	my $name = $tt->get_model->get($iter,0);
	my $where = $what;
		$where =~ s/combinations_//;

# 1) check if user is sure
	my $sure = &check(gettext("This will completely remove the entity:")."\n".
$what."\n".gettext("from the whole project. Are you sure?"));

	if ($sure ne 'cancel') {
		&write_to_statusbar(gettext("Deleting all definitions of ".$name));
		&forall_lists('delete',$name,undef);
	}
}
sub del_row {
	my ($what,$complete) = @_;
	my $form = &get_form;
	my $tw;
		if ($what eq 'tt') { $tw = $form->get_widget("treeview_$what");
		} else { $tw = $form->get_widget("treeview_$what".'s'); }
# handle multiple selections
	my @paths = $tw->get_selection->get_selected_rows;	
	my @iters;
	foreach my $path (@paths) {
	 	push (@iters,$tw->get_model->get_iter($path));
	}
	foreach my $iter (@iters) {
# if we are in combinations lists, offer a complete removal from tt definitions and lists
		if (($what =~ /^combinations_/) or ($complete)) {
			 &complete_remove($what,$iter);
		} elsif ($tw->get_model->iter_has_child($iter)) {
	 		my $message = "$what\n".gettext("It seems that you want to delete several underlying 
subject definitions along with their parent node.\nAre you sure?");
	 		my $sure = &check($message);
	 		if ($sure eq "ok") { 
				$tw->get_model->remove($iter); 
			}
	 	} else {
			$tw->get_model->remove($iter); 
		}
	}	
	$what =~ s/combinations_//;
	if ($what ne 'tt') { &combo_change($what.'s'); }
	&title_change;
}

sub add_row {
	my $what = $_[0];
	my $form = &get_form;
	my $name = $form->get_widget("entry_$what\_name")->get_text;
	my $rest = $form->get_widget("entry_$what\_rests")->get_text;		
	my $tv_t = $form->get_widget("treeview_$what".'s')->get_model;
	if (!$name) {
		&check(gettext("You can't append an empty entity.\nGive it a name at least..."),'error');	
	} else {	
	foreach my $named (split/,/,$name) {	# always allow multiple addings...
		$named = clarify($named);	# and allow them to have spaces around...
		if ($what eq "teacher") {
	 		my $sub = $form->get_widget("entry_$what\_subjects")->get_text;	
	 		if (!defined $sub) {
				$sub = "";
				#&check(gettext("You can't define a teacher without assigning him to teach at least one subject."),'error');
			} #else {
			foreach my $subj (split/,/,$sub) { # an to teacher allow even multiple subjects
	 	 		$subj = clarify($subj);
				my $row = &add_to_tree($form,'teachers',$named,$subj);
				my $rests = $tv_t->get($row,3);
				if (defined $rests) { $rest = $rest.','.$rests; } 
	 	 		$tv_t->set($row,0,$named,1,$subj,2,$rest);
			# add new subjects...
				my $indi = &find_clist_row("subjects",$subj);
				if ($indi eq "new") { 
					$form->get_widget('entry_subject_name')->set_text($subj);
					&add_row("subject");
				} 
	 		} #}
		} else {
			my @classname = split/ /,$named;
			if ($#classname > 0) {		# allow adding same class name for all years
				my @years = split/-/,$classname[0]; # in a form: 1-4 name of the class
				if (($#years > 0) and (int($years[0]) eq $years[0]) and (int($years[1]) eq $years[1])) {	
					shift(@classname);
					my $nam = join(' ',@classname);
					for (my $year = $years[0]; $year <= $years[1] ; $year++) {
		# and allow the same for the second field also
						my @nos = split/-/,$classname[0]; # in a form: 1-4 1-11
						if (($#nos > 0) and (int($nos[0]) eq $nos[0]) and (int($nos[1]) eq $nos[1])) {	
							shift(@classname);
							$nam = join(' ',@classname);
							for (my $yr = $nos[0]; $yr <= $nos[1] ; $yr++) {
								&just_add_row($what,"$year $yr",$rest);
							}
						} else {
		# ---------------
							&just_add_row($what,"$year $nam",$rest);
						}
					}
				} else { &just_add_row($what,$named,$rest); }
			} else { &just_add_row($what,$named,$rest); }
		}
	}
	&combo_change($what.'s');
	}
}
sub just_add_row {
	my ($what,$named,$rest) = @_;
	my $form = &get_form;
	my $tv_t = $form->get_widget("treeview_$what".'s')->get_model;
	my $row = &find_clist_row($what."s",$named);
	if ($row eq "new") { $row = $tv_t->append; 
	} else { $row = $tv_t->get_iter_from_string($row);	}
	$tv_t->set($row,0,$named,1,$rest);	
}	
sub combo_change {
	my $what = $_[0]; 
	my %list = (); 
	my $form = &get_form;
	my $tw = $form->get_widget("treeview_$what")->get_model;
	$tw->foreach(sub {
		(undef, undef, my $iter) = @_;
		my $who = $tw->get($iter,0);
		if ($who) { $list{$who} = ""; }
		return 0;
	} );
# update combinations lists
	my $store = $form->get_widget("treeview_combinations_$what")->get_model;
	$store->clear;
	foreach my $who (sort(keys(%list))) { $store->set($store->append,0,$who); }
# update combos
	chop($what);	# combos names are without plural 's
	$form->get_widget("combo_tt_$what")->set_popdown_strings(sort(keys(%list)));
	&title_change;
}

sub add_to_tree {	# creates the parent node if necessary and return iter of new line
	my ($form,$tree,$key,$value) = @_;
		my $row = &find_clist_row($tree,$key,$value); 
		my $tv_tt = $form->get_widget("treeview_$tree")->get_model;
# if there is no parent, create new one and return first child iter
		if ($row eq "new") {	
			$row = $tv_tt->insert(undef,-1);
			if ((defined $value) and ($value ne "")) {
				$tv_tt->set($row,0,$key);
				$row = $tv_tt->insert($row,-1);
			} else {
						
			}
		} else { 
#			my $row1 = &find_clist_row($tree,$key,$value);
# if there is a parent, but we have to create child, return new iter
			my @len = split/\:/,$row;
			if ($#len > 0) { #($row1 eq "new") {
				$row = $tv_tt->get_iter_from_string($row);
# if we find the child also, return it's iter
			} else {
				$row = $tv_tt->insert($tv_tt->get_iter_from_string($row),-1); 
			}
		}
	return $row;
}

sub find_clist_row {	# poisce vrstico v clisti, ki ima v prvi celici vpisan dan podatek
	my ($what, $data, $subject) = @_;	# subject is used only for tt and teachers lists...
	my $form = &get_form;
	my $tw = $form->get_widget("treeview_$what")->get_model;	 	
	my $row = "new";
	$tw->foreach(sub {	
 	 	my (undef,undef,$child_iter) = @_; 	 	 		
 	 	my $t = $tw->get($child_iter,0);
		if ((defined $t) and ($t eq $data)) {
			my $r = $tw->get_string_from_iter($child_iter); 
			$row = $r;
			if ((defined $subject) and ($subject ne "")) { # if we are checking childs also...
			  my $s = $tw->get($child_iter,1);
			  if (defined $s) {	
				if ($subject eq $s) { # if we find one, report full path	
# report two-level path if we have exact match
					$row = $r;
					return 1; 
			   } else {
# save one-level path if we find it
					$row = (split/\:/,$r)[0];
				}
			  }
			} else {
# report one-level path if we don't look for two level
				$row = (split/\:/,$r)[0];
				return 1; 
			}
		}
		return 0; 
 	} );		
# report 'new' if even first level wasn't found
	return "$row";	# we always return a string value of path - x:y:z
}

sub title_change {
	my $form = &get_form;	
	my @title = split/ - /,$form->get_widget('window_main')->get_title;
	if ($#{title} != 2) { 
		$form->get_widget('window_main')->set_title($title[0]." - ".$title[1]." - ".gettext("Unsaved")); }
}

sub clarify {
	my ($what) = @_;
	if (defined $what) {
		$what =~ s/^ *//g;
		$what =~ s/ *$//g;
		$what =~ s/^,*//g;
		$what =~ s/,*$//g;
		$what =~ s/  / /g;
		$what =~ s/,,/,/g;
	}
	return $what;
}

sub draw_context_menu {
	my ($where,$now,$what) = @_;
	my $form = &get_form;	
   my $menu = new Gtk2::Menu;
# everybody
   my %items;
	if ($what =~ /ttview/) {
		%items = (gettext("Help / Wizard") => sub { &on_wizard1_activate; },
					gettext("Export to file") => sub { &on_exportresult_activate; }
					);
		if ($what eq 'ttview_files') {
			$items{gettext("Remove from list")} = sub { &ttview_file_remove; },
			$items{gettext("Import to list")} = sub { &on_importresult_activate; }
		}
	} else {
		%items = (gettext("Edit Restrictions") => sub { &load_rests("$what"); },
#					gettex("Show Statistics") => sub { $form->get_widget('toggletoolbutton_stats')->set_active(1); },
					gettext("Help / Wizard") => sub { &on_wizard1_activate; },
					gettext("Rename") => sub { &edit_cell($what,$where); }
   				);
# teachers and tt
   if ($what eq 'teacher') {
		$items{gettext("Select all")} = sub { &select_all("$what"); };
		$items{gettext("Expand / Collapse All")} = sub { &toggle_fold($what); };
		$items{gettext("Delete Row(s)")} = sub { &del_row("$what"); };
		$items{gettext("Complete remove")} = sub { &del_row("$what",1); };
	} elsif ($what eq 'tt') {
		$items{gettext("Select all")} = sub { &select_all("$what"); };
		$items{gettext("Delete Row(s)")} = sub { &del_row("$what"); };
		$items{gettext("Expand / Collapse All")} = sub { &toggle_fold($what); };
# combinations
	} elsif ($what =~ /combinations/) {
		$items{gettext("Select all")} = sub { &select_all("$what"); };
		$items{gettext("Complete remove")} = sub { &del_row("$what",1); };
# all other
	} else {
		$items{gettext("Select all")} = sub { &select_all("$what"); };
		$items{gettext("Complete remove")} = sub { &del_row("$what",1); };
		$items{gettext("Delete Row(s)")} = sub { &del_row("$what"); };
	}
	}
	while (my ($name, $callback) = each (%items)) {
		my $menu_item = Gtk2::MenuItem->new($name);
		$menu_item->signal_connect('activate', $callback);
		$menu->append($menu_item);
		$menu_item->show();
   }
   $menu->popup(undef,undef,undef,undef,$now->button,$now->time);
}

sub select_all {
	my ($what) = @_;
	my $form = &get_form;	
	$form->get_widget("treeview_$what".'s')->get_selection->select_all;	
}
sub edit_cell {
	my ($what, $where) = @_;
	my ($path,$col) = $where->get_cursor;
	$where->set_cursor_on_cell ($path,$col,undef,1);
}
sub rename_entity {
# this gets called whenever user manualy rewrites some entities name in the list
# we must search for this entity in other lists and rename appropriatly.
	my ($what,$old_text,$new_text) = @_;
	my $form = &get_form;
	if ((defined $old_text) and (defined $new_text) and ($old_text ne $new_text)) {
		my $ok = &check(gettext("Do you want to rename all definitions 
of this entity in the project?"));
		if ($ok eq 'ok') {
			&write_to_statusbar(gettext("Looking for definitions to rename..."));
			&forall_lists ('rename',$old_text,$new_text);
		} elsif ($ok eq 'cancel') {
			
		}
	}
}
sub forall_lists {
	my ($why,$old,$new) = @_;
	my $form = &get_form;
	my %rebuild;
	my @tvs = ('teachers', 'classs', 'classrooms', 'subjects',
					'tt','combinations_teachers','combinations_subjects',
					'combinations_classrooms','combinations_classs',
					);
	my $progress = $form->get_widget('progressbar_main'); 
		$progress->set('visible' => 1);

# for all treeviews
			foreach my $tv (@tvs) {
				my $tvt = $form->get_widget('treeview_'.$tv);
				my $cols = $tvt->get_model->get_n_columns;
	# and all the rows
#				my @iters;
				$tvt->get_model->foreach(sub {
					 my (undef,$child_path,$child_iter) = @_; 	 	 		
		# and all the cells
 					 	for (my $i = 0; $i < $cols; $i++) {
							my $t = $tvt->get_model->get($child_iter,$i);	
								if ((defined $t) and ($t eq $old)) {
									if ($why eq 'rename') {
										$tvt->get_model->set($child_iter,$i,$new);
										$rebuild{$tv} = 1;
									} elsif ($why eq 'delete') {
										$tvt->get_selection->select_iter($child_iter);
										$rebuild{$tv} = 1;
									}
								}
						}
					$progress->pulse;
					Gtk2->main_iteration;
					return 0;
				});
				if ($why eq 'delete') {
					foreach my $iter ($tvt->get_selection->get_selected_rows) {
						$iter = $tvt->get_model->get_iter($iter);
						$tvt->get_model->remove($iter);
					}
				}
			}
			$progress->set('visible' => 0);
			&write_to_statusbar(gettext("Succesful."));

	foreach my $t (keys(%rebuild)) {
		if (($t ne 'tt') and !($t =~ /combinations/)) {
		if ($rebuild{$t}) { &combo_change($t); }
		}
	}
	
}
return 1;
