#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# module with special knowledge about tablix modules
# contributions: Tomaz Solc
# 5.3.2005

use strict;

my %widgets;

sub on_toggletoolbutton_options_toggled {
	my ($who) = @_;
	my $form = &get_form;
	$form->get_widget('window_rests')->set('visible' => $who->get_active);
	$form->get_widget('label_names')->set_text(gettext("Select an entity to add restrictions to, by right clicking on it or by clicking the appropriate (down) button. ")); 
	$form->get_widget('window_rests')->set_keep_above($who->get_active);
}
sub on_button_ok_rests_clicked {
	&ok_rests;
}
sub on_button_close_rests_clicked {
	&get_form->get_widget('toggletoolbutton_options')->set_active(0);
}
sub on_window_rests_delete_event {
	&get_form->get_widget('toggletoolbutton_options')->set_active(0);
	return 1;
}
sub load_rests {		# vpise prave vrednosti za dialog_rests
	# rests so vedno oblike: "rest_type1:rest_val1,rest_val2,...;rest_type2:..."
	my ($what) = @_;
	my $form = &get_form;
   $widgets{'what'} = $what;
	$form->get_widget('toggletoolbutton_options')->set_active(1);   
	if ($what) { &load_rests_editor($what); 
	} else { $form->get_widget('label_names')->set_text(gettext("Select an entity to add restrictions to, by right clicking on it or by clicking the appropriate (down) button. ")); }
}

sub ok_rests {
	my $form = &get_form;
	my $tvr = $form->get_widget('treeview_rests');
	my $what = $widgets{'what'};
	my $text = "";	
	my @list = ""; my $counter = 0; 
	
	$tvr->get_model->foreach(sub {
	 		(undef, undef, my $iter) = @_;
	 		my ($rest_type,$rest_vals,$name,$active) = $tvr->get_model->get($iter,0,1,2,3);
	 # na vsak nacin aktivira ustrezne module
	 		if ($active) {
			#if (defined $rest_vals) {
	 			my $row = &find_clist_row("modules",$name);
	 	# check that the module exists
				if ($row ne "new") {
	 				my $tvm = $form->get_widget('treeview_modules')->get_model;
					my $iter = $tvm->get_iter_from_string($row);
	            $tvm->set($iter, 3, '1');	
		# set weigth to at least 1
					my $val = $tvm->get($iter,1);
 	 				if (!$val) { 
						$tvm->set($iter,1,'1'); 
					}
	 	# add text
	 				if ((defined $rest_vals) and ($rest_vals ne "")) {
						$text = "$rest_type:$rest_vals;".$text; 
					}
	 			}
	 		}
			return 0; 
	 	});
		$form->get_widget("entry\_$what\_rests")->set_text($text);
	 	if (defined $what) {
			if ($what eq "tt") { 
				&on_button_tt_use_clicked;
		 	} else { 
				if ($form->get_widget("entry_$what\_name")->get_text ne "") {
					&add_row($what); 
				}
			}
	} else { &check(gettext("Internal error: I don\'t know where to append these restrictions, or no restrictions were set."),'error'); }
}
# ------------------------------------------------------------------------------------------
sub set_smart_view {
	my ($restriction,$restriction_value,$iter) = @_;
	my $form = &get_form;
	my $tvr = $form->get_widget('treeview_rests');
	my $table = $form->get_widget('table_rests');

# this is where fields will be appended; default to the end of the table
	my $cols = $table->get('n-columns');
	my $rows = $table->get('n-rows');

# descriptions; todo: get from modules
	my %descriptions = (
		'capability-place' => gettext("Require special room:"),
		'preferred-period' => gettext("Prefer this period:"),
		'preferred-day' => gettext("Prefer this day:"),		
		'preferred-room' => gettext("Prefer this room:"),
		'teacher-maxperday' => gettext("Maximum allowed lessons per day:"),
		'morning-subject' => gettext("This subject should be scheduled before:"),
		'conflicts-with' => gettext("These classes should never be scheduled at the same time:"),		
		'group' => gettext("These classes belong to a group:"),		
		'same-time-as' => gettext("These classes must be scheduled simultaniously:"),
		'teacher-also' => gettext("Add more teachers:"),
		'ignore-sameday' => gettext("Activate to ignore checking for multiple occurances of the same subject."),
		'double-period' => gettext("Select another subject, to link into double period:"),		
		'free-period' => gettext("Select a day and a period at which this class should be free:")		
	);

# check if alredy exists
	foreach my $cell ($table->get_children) {
		if ($cell->get_name eq $restriction) {
			my $row = $table->child_get($cell,'top-attach');
			foreach my $celll ($table->get_children) {
				if ($table->child_get($celll,'top-attach') == $row) {
					$celll->destroy;
				}
			}
			$rows = $row;
			last;
		}
	}

# draw description label
	$table->resize($rows + 1,3);
	my $label = new Gtk2::Label();
		$label->set_use_markup(1);
		$label->set_markup('<b>'.$descriptions{$restriction}.'</b>'); 
		$label->set_name($restriction);
		$label->set('justify' => 'left');
		$label->set('wrap' => 1);
		$label->set('width-request' => 200);
		$table->attach($label,0,1,$rows + 0,$rows + 1,'expand','expand',2,2);
		$label->show;

# draw entry or something
	my $type_entry;
# ----------------------------------------------------
	if ($restriction eq "capability-place") {
 	# draw the elements		
		my $combobox = Gtk2::ComboBoxEntry->new_text;
			my %temp;
			my $tw_c = $form->get_widget('treeview_classrooms')->get_model;
			$tw_c->foreach(sub {
	 	  		my (undef,undef,$child_iter) = @_; 	
				my $idd = $tw_c->get($child_iter,1); 
	 	  		foreach my $id (split/; /,$idd) {
					if (((split/:/,$id)[0]) eq $restriction) {
	 					my $i = (split/:/,$id)[1];
	 					foreach my $d (split/,/,$i) {	
	 						if ($d) { $temp{$d} = ""; }
	 					}
					}
				}
				return 0;
	 	  	});
			foreach my $temp (sort(keys(%temp))) {
				$combobox->append_text($temp);
			}
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($combobox);
			$align->show;
			$table->attach_defaults($align,1,2,$rows + 0,$rows + 1);
			$combobox->show;
			$type_entry = ($combobox->get_children)[0];		
# ----------------------------------------------------
	} elsif (($restriction eq "preferred-period") or ($restriction eq "preferred-day") or ($restriction eq "preferred-room")) {
		my $what = (split/-/,$restriction)[1];
 	  	my $days = int($form->get_widget('entry_days')->get_text);
		my $pers = int($form->get_widget('entry_periods')->get_text);
		$table->resize(1,3);
 # draw the elements		
		my $combobox = Gtk2::ComboBoxEntry->new_text;
		
			if ($what eq "day") { 
			
# my $view = new Gtk2::TreeView();
# my $model = $combobox->get_model;
# my $renderer = new Gtk2::CellRendererText();
# my $col = Gtk2::TreeViewColumn->new_with_attributes('test',$renderer,'text' => 0);
# 	$col->set_cell_data_func ($renderer, sub {
# 		my ($column, $cell, $model, $iter) = @_;
# 		my $i = $model->get($iter,0);
# 		my $text = gettext("Day")." ".($i + 1);
# 		$cell->set (text => $text);
# 	});
# $view->append_column($col);
# $combobox->set_view($view);
#$combobox->priv->tree_view = $view;	

				for (my $counter = 0; $counter < $days; $counter++) {  
					$combobox->append_text($counter); } }
			if ($what eq "period") { 
				for (my $counter = 0; $counter < $pers; $counter++) { 
					$combobox->append_text($counter); } }
			if ($what eq "room") { 
	 			my $tw_c = $form->get_widget('treeview_classrooms')->get_model;
	 			$tw_c->foreach(sub {
	 	 	  		my (undef,undef,$child_iter) = @_; 	
	 	  	 	  	$combobox->append_text($tw_c->get($child_iter,0));
					return 0;
	 	  	 	});
			}
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($combobox);
			$align->show;						
			$table->attach_defaults($align,1,2,$rows + 0,$rows + 1);
			$combobox->show;
			$type_entry = ($combobox->get_children)[0];			
# ----------------------------------------------------
	} elsif (($restriction eq "teacher-maxperday") or ($restriction eq "morning-subject")) {
		my $what = (split/-/,$restriction)[1];
		my $pers = int($form->get_widget('entry_periods')->get_text);
		$table->resize(1,3);
 # draw the elements		
		my $combobox = Gtk2::ComboBoxEntry->new_text;				
			for (my $counter = 0; $counter < $pers; $counter++) { $combobox->append_text($counter); } 
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($combobox);
			$align->show;
			$table->attach_defaults($align,1,2,$rows + 0,$rows + 1);
			$combobox->show;
			$type_entry = ($combobox->get_children)[0];			
# ----------------------------------------------------
	} elsif (($restriction eq "conflicts-with") or ($restriction eq "group") or ($restriction eq "same-time-as")) {
		$table->resize(1,3);
 # draw the elements		
		my $combobox = Gtk2::ComboBoxEntry->new_text;			
	 			my $tw_c = $form->get_widget('treeview_classs')->get_model;
	 			$tw_c->foreach(sub {
	 	 	  		my (undef,undef,$child_iter) = @_; 	
	 	  	 	  	$combobox->append_text($tw_c->get($child_iter,0));
					return 0;
	 	  	 	});
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($combobox);
			$align->show;
			$table->attach_defaults($align,1,2,$rows + 0,$rows + 1);
			$combobox->show;
			$type_entry = ($combobox->get_children)[0];			
# ----------------------------------------------------
	} elsif ($restriction eq "teacher-also") {
		$table->resize(1,3);
 # draw the elements		
		my $combobox = Gtk2::ComboBoxEntry->new_text;				
		my %list;
	 			my $tw_c = $form->get_widget('treeview_teachers')->get_model;
	 			$tw_c->foreach(sub {
	 	 	  		my (undef,undef,$child_iter) = @_; 	
	 	  	 	  	$list{$tw_c->get($child_iter,0)} = "";
					return 0;
	 	  	 	});
			foreach my $t (keys(%list)) { $combobox->append_text($t); }
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($combobox);
			$align->show;
			$table->attach_defaults($align,1,2,$rows + 0,$rows + 1);
			$combobox->show;
			$type_entry = ($combobox->get_children)[0];	
# ----------------------------------------------------
	} elsif ($restriction eq "ignore-sameday") {
		$table->resize(1,3);
 # draw the elements		
		my $checkbox = Gtk2::CheckButton->new;				
			$table->attach_defaults($checkbox,1,2,$rows + 0,$rows + 1);
			$checkbox->show;
		
			my $button = Gtk2::Button->new_from_stock('gtk-add');
			$button->signal_connect(clicked=> sub { 
					my $val = $checkbox->get_active;
	 	  			my $row = &find_clist_row("rests",$restriction);
	 	  			if ($row ne "new") {
						$tvr->get_model->set($iter,1,$val,3,'1');			
	 	  			}
					#&on_okbutton_rests_clicked;
				});
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($button);
			$align->show;
			$table->attach_defaults($align,2,3,$rows + 0,$rows + 1);
			$button->show;

# ----------------------------------------------------
	} elsif ($restriction eq "double-period") {
		$table->resize(1,3);		
		my @what = (split/\n/,$form->get_widget('label_names')->get_text);	
		my $class_name = (split/: /,$what[0])[1];
			$class_name =~ s/, //g;
 # draw the elements		
		my $combobox = Gtk2::ComboBoxEntry->new_text;	
		my $tw = $form->get_widget('treeview_tt')->get_model;
		my $class_iter = &find_clist_row('tt',$class_name);
		if ($class_iter ne 'new') { 			
			$class_iter = $tw->get_iter_from_string($class_iter);
			$combobox->append_text($tw->get($class_iter,1)); 
			if ($tw->iter_has_child($class_iter)) {
				for (my $iter = $tw->iter_children($class_iter); $iter; $iter = $tw->iter_next($iter)) {
					$combobox->append_text($tw->get($iter,1));
				}
			} 
		}
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($combobox);
			$align->show;
		$table->attach_defaults($align,1,2,$rows + 0,$rows + 1);
		$combobox->show;
		$type_entry = ($combobox->get_children)[0];			
# ----------------------------------------------------
	} elsif (($restriction eq "free-period")) {
		my $what = (split/-/,$restriction)[1];
 	  	my $days = int($form->get_widget('entry_days')->get_text);
		my $pers = int($form->get_widget('entry_periods')->get_text);
		$table->resize(2,3);
		#$table->attach_defaults($label,0,1,0,2);
 # draw the elements		
		my $combobox_day = Gtk2::ComboBoxEntry->new_text;	
		my $combobox_per = Gtk2::ComboBoxEntry->new_text;	
			for (my $counter = 0; $counter < $days; $counter++) { $combobox_day->append_text($counter); } 
			for (my $counter = 0; $counter < $pers; $counter++) { $combobox_per->append_text($counter); } 
				
		my $align2 = new Gtk2::Alignment(0.5,0.5,0,0);
			$align2->add($combobox_day);
			$align2->show;
			$table->attach_defaults($align2,1,2,$rows + 0,$rows + 1);
		my $align1 = new Gtk2::Alignment(0.5,0.5,0,0);
			$align1->add($combobox_per);
			$align1->show;
			$table->attach_defaults($align1,1,2,$rows + 1,$rows + 2);
			$combobox_day->show;
			$combobox_per->show;
			my $type_entry_day = ($combobox_day->get_children)[0];
			my $type_entry_per = ($combobox_per->get_children)[0];	

			my $button = Gtk2::Button->new_from_stock('gtk-add');
			$button->signal_connect(clicked=> sub { 
					my $val_day = $type_entry_day->get_text;
					my $val_per = $type_entry_per->get_text;
	 	 			my $val;
					if (($val_day eq "") or ($val_per eq "")) {
						$val = "";
					} else {
						$val = "$val_day $val_per";
					}
					my $active = 1;
	 	 			if ($val eq "") { 
	 	 				$active = 0; 
	 	 				$restriction_value = "";
	 	 			} elsif (defined $restriction_value) { 
	 	 				$restriction_value = &strip_commas("$val,".$restriction_value); 
	 	 			} else { 
	 	 				$restriction_value = $val; 
	 	 			}
					$tvr->get_model->set($iter,1,$restriction_value,3,$active);		
					$form->get_widget('button_ok_rests')->clicked;
				});
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($button);
			$align->show;
			$table->attach_defaults($align,2,3,$rows + 0,$rows + 1);
			$button->show;
			$table->child_set($label,'bottom-attach' => $rows + 2);

# -----------------------------------------------------
# if i dont know it...
	} else { 
 		$label->set_text(gettext("I'm sorry, I don't know \nthis restriction well enough").
		": $restriction.");
	}
	
	if ($type_entry) {
		if (defined $restriction_value) { $type_entry->set_text($restriction_value); }
		my $button = Gtk2::Button->new_from_stock('gtk-add');
#		my $image = $button->get_image;
#		$button->set_label('');
#		$button->set_image($image);
		$button->signal_connect(clicked => sub { 
			my $val = $type_entry->get_text;
			my $active = 1;
			if ($val eq "") { 
				$active = 0; 
				$restriction_value = "";
			} elsif (defined $restriction_value) { 
				$restriction_value = &strip_commas("$val,".$restriction_value); 
			} else { 
				$restriction_value = $val; 
			}
			$tvr->get_model->set($iter,1,$restriction_value,3,$active);
			$form->get_widget('button_ok_rests')->clicked;
		});
		my $align = new Gtk2::Alignment(0.5,0.5,0,0);
			$align->add($button);
			$align->show;
		$table->attach_defaults($align,2,3,$rows + 0,$rows + 1);
		$button->show;
	}	
}
sub on_treeview_rests_cursor_changed {
# 	my ($tvr) = @_;
# 	my $form = &get_form;
# 
# 	(my $path, my $col) = $tvr->get_cursor(); 
# 	my $iter = $tvr->get_model->get_iter($path);
# 	my ($restriction, $restriction_value) = $tvr->get_model->get($iter,0,1);
# 
# 	if (!$restriction_value) { $restriction_value = ""; }
# 	
# 	&set_smart_view($restriction, $restriction_value,$iter);
}
########################################################################3
sub load_rests_editor {
	my ($what) = @_;
	my $form = &get_form;
	my $twm = $form->get_widget('treeview_rests');
	my $dialog = $form->get_widget('window_rests');
	my $label = $form->get_widget('label_names');
	my %rests_s;
	my $name;
	my $What = ucfirst($what);
	my $rests;
# get names
	if ($what eq 'tt') {
		$What = 'Tuple';
	 	my $teacher = $form->get_widget('combo_entry_tt_teacher')->get_text();
	 	my $subject = $form->get_widget('combo_entry_tt_subject')->get_text();
	 	my $class = $form->get_widget('combo_entry_tt_class')->get_text();
		$label->set_text(gettext("Settings for class:")." $class, \n".
								gettext("subject:")." $subject, \n".
								gettext("teacher:")." $teacher");
	} elsif ($form->get_widget("entry_$what\_name")) { 
		$name = $form->get_widget("entry_$what\_name")->get_text;
		$dialog->set_title(gettext($What).gettext("\'s restrictions editor"));
		$label->set_text(gettext("Settings for")." ".gettext($what).": $name");
	} elsif ($what =~ /^combinations_/) {
		my $tw = $form->get_widget("treeview_$what".'s');

		(my $path, my $col) = $tw->get_cursor(); 
		if (defined $path) {
	 		my $iter = $tw->get_model->get_iter($path);
	 		$name = $tw->get_model->get($iter,0);	
		}
		
		$what =~ s/combinations_//;
		$What = ucfirst($what);
		$dialog->set_title(gettext($What).gettext("\'s restrictions editor"));
		$label->set_text(gettext("Settings for").' '.gettext($what).": $name");
		
		my $row = &find_clist_row($what.'s',$name);
		if ($row ne 'new') {
			my $tv = $form->get_widget("treeview_$what".'s');
			$tv->set_cursor($tv->get_model->get_path($tv->get_model->get_iter_from_string($row)));
		}
	}
	if ($What eq "Teacher") { 
		$What = "Subject"; 
		my $text = $label->get_text;
		my $subject = $form->get_widget("entry_teacher_subjects")->get_text;
		$label->set_text($text.",\n ".gettext("subject").": $subject");
	} elsif ($What eq "Classroom") { $What = "Room"; }
# alredy set restrictions	
	if ($form->get_widget("entry_$what\_rests")) { 
		$rests = $form->get_widget("entry_$what\_rests")->get_text; 
		foreach my $rest (split/\;/,$rests) { 			
			my @spec = split/:/,$rest;
			if ($spec[1]) { 
				foreach my $spec (split/\,/,$spec[1]) {
						if ($rests_s{$spec[0]}) { $rests_s{$spec[0]} = "$spec,$rests_s{$spec[0]}";
						} else {	$rests_s{$spec[0]} = $spec; }
						$rests_s{$spec[0]} =~ s/\,$//g;
				}
			}
		}
	}

# clear the table
	my $table = $form->get_widget('table_rests');
	my @children = $table->get_children;
	foreach my $child (@children) { $child->destroy; }

# get appropriate restrictions from modules list	
	if ($twm) {
	$twm->get_model->clear;
	my $tvm = $form->get_widget('treeview_modules')->get_model;
	$tvm->foreach(sub {	
 	 	my (undef,undef,$child_iter) = @_; 	 	 		
 	 	my ($module,$active) = $tvm->get($child_iter,0,3);	
		my $description = &get_description($module); #readpipe("tablix_modinfo $module");
			foreach my $desc (split/\n/,$description) {	
				if ($desc) { 
					my @spec = split/:/,$desc; 
					$spec[0] =~ s/ *$//g;
					$spec[1] =~ s/ *$//g;
					$spec[1] =~ s/^ *//g;
					if (($spec[0] eq "$What restrictions") && ($spec[1])) {		
						foreach my $s (split/ /,$spec[1]) { 
							my $value = $rests_s{$s};
							my $row = $twm->get_model->append(undef); 
							$twm->get_model->set($row,0,$s,1,$value,2,$module,3,$active);
							&set_smart_view($s,$value,$row);
						}	
					}
				}
			}
			return 0;
		});
	}
# reconnect ok button
	if ($widgets{'ok_id'}) { 
		$form->get_widget('button_ok_rests')->signal_handler_disconnect($widgets{'ok_id'}); }
	my $ok_id = $form->get_widget('button_ok_rests')->signal_connect(clicked => 
																			sub { &ok_rests($form,$twm,$what); });
	$widgets{'ok_id'} = $ok_id;
}

sub draw_rests_editor {
# draw the treeview
	my $form = &get_form;
 	my $drevo = new Gtk2::TreeStore('Glib::String',
												'Glib::String',
												 'Glib::String',
												  'Glib::Boolean',
												   'Glib::String');
	my $tvr = $form->get_widget('treeview_rests');
		$tvr->set_model($drevo);
	#my $tvr = Gtk2::TreeView->new_with_model($drevo);
		$tvr->set('headers-clickable',1);
 		$tvr->set('rules-hint',1);
		$tvr->signal_connect('cursor_changed' => \&on_treeview_rests_cursor_changed);
	my @columns = (gettext("Name"),
						gettext("Value"),
						gettext("Module"),
						gettext("Active"),
						gettext("Notes"));
 	for (my $c = 0; $c <= $#columns; $c++) {
 		my $col;
		if ($c == 1) { 
			my $renderer = new Gtk2::CellRendererText();
			$col = Gtk2::TreeViewColumn->new_with_attributes($columns[$c],$renderer,'text' => $c);
 			$renderer->set('editable' => TRUE); 
  			$renderer->signal_connect (edited => sub {
	           my ($cell, $text_path, $new_text) = @_;
				  my $iter = $drevo->get_iter_from_string($text_path);
	           $drevo->set($iter, '1', $new_text);
				  my $s = $drevo->get($iter,0);
				  &set_smart_view($s,$new_text,$iter);
 			 });
 		} elsif ($c == 3) { 
 			my $renderer = new Gtk2::CellRendererToggle();
			$renderer->set('activatable' => '1');
   			$renderer->signal_connect('toggled' => sub {
  					my ($render,$row) = @_;	
					my $iter = $drevo->get_iter_from_string($row);
					my $val = $drevo->get($iter, 3);
					$drevo->set($iter, 3, !$val);
  				});
			$col = Gtk2::TreeViewColumn->new_with_attributes($columns[$c],$renderer,'active' => $c);
		} elsif ($c == 4) { 
			my $renderer = new Gtk2::CellRendererText();
			$col = Gtk2::TreeViewColumn->new_with_attributes($columns[$c],$renderer,'text' => $c);
 			$renderer->set('editable' => TRUE); 
  			$renderer->signal_connect (edited => sub {
	           my ($cell, $text_path, $new_text) = @_;
				  my $iter = $drevo->get_iter_from_string($text_path);
	           $drevo->set($iter, '4', $new_text);
 			 });
		} else { 
			my $renderer = new Gtk2::CellRendererText();
			$col = Gtk2::TreeViewColumn->new_with_attributes($columns[$c],$renderer,'text' => $c);
		}
		$col->set_sort_column_id($c);
 		$tvr->append_column($col);
		$col->set_resizable(1);
 	}
	my $white = Gtk2::Gdk::Color->new(65535,65535,65535);
	$form->get_widget('eventbox_label_rests_note')->modify_bg('normal',$white);
	$form->get_widget('eventbox_label_rests_name')->modify_bg('normal',$white);	
#	$form->get_widget('eventbox_buttons_rests')->modify_bg('normal',$white);
}
return 1;
