#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# module for initialization of treeviews
# ran only at the startup...
# 19.3.2005

use strict;

sub init_stuff {
	 my $form = &get_form;
	 &prep_tvs;					# create simplelists
	 &prep_pics;
	 &check_deps;				# check if all internally used programs are present
	 #&set_module_path;			# check tablix's module path
	 &load_modules;				# check tablix's modules and fillup %modules
	 &check_opts(shift(@ARGV));	 # check command line options
	 &init_legend;
	 my $white = Gtk2::Gdk::Color->new(65535,65535,65535);
	 $form->get_widget('eventbox_tt_table_explain')->modify_bg('normal',$white);
	 $form->get_widget('radiobutton_tt_graphic')->set_active(1);
# load possible timetable export functions
	my @exports	= (gettext("Result XML file"),
						gettext("Individual"),
						gettext("All Individuals"),
						gettext("Combined"),
						gettext("Styled Combined"),
						gettext("CVS Combined")
						);
	$form->get_widget("combo_tt_exports")->set_popdown_strings(@exports);
# setup the days and periods combos	
	&on_entry_periods_changed;
	&on_entry_days_changed;
	$form->get_widget('checkbutton_additive')->set_active(1);
	 &write_to_statusbar(gettext("Welcome to G-Tablix."));
}
sub prep_tvs { 			# make SimpleLists from treeviews
	&draw_rests_editor;
	&prep_tt;
	&prep_lists;
	&prep_ttviews;
	&prep_teachers;
	&prep_combinations;
	&prep_modules;
#	&prep_combos;
}
# -----------------------------------------------------------------
sub prep_combos {
# display day names instead of numbers
#	my %days = (1 => 'Monday', 2 => 'Tuesday', 3 => 'Wednesday', 4 => 'Thursday', 5 => 'Friday',
#		6 => 'Saturday', 7 => 'Sunday');
	my $form = &get_form;
	my $entry = $form->get_widget('combo_tt_days');
# 	my $model = $entry->get_model;
	my $model = new Gtk2::ListStore('Glib::String');
		$entry->list = $model;
   	my $renderer = new Gtk2::CellRendererText();
 	my $col = Gtk2::TreeViewColumn->new_with_attributes('',$renderer,'text' => 0);
 	$col->set_cell_data_func ($renderer, sub {
          my ($column, $cell, $model, $iter) = @_;
          my $i = $model->get($iter,0);
          my $text = gettext("Day").($i + 1);
          $cell->set (text => $text);
 	});
 	$model->append_column($col);
}
# -----------------------------------------------------------------
sub prep_pics {
	my $form = &get_form;
# setup shared pixmaps...
	$form->get_widget('image_hedge_about')->set_from_file(&get_picdir."/jezek-16.png");
	$form->get_widget('image_welcome_decor')->set_from_file(&get_picdir."/jezek-64_L.png");
	$form->get_widget('image_welcome_decor')->set_alignment(1,1);
	$form->get_widget('image_wizard_decor')->set_from_file(&get_picdir."/jezek-64_L.png");
	$form->get_widget('image_wizard_decor')->set_alignment(1,1);
	$form->get_widget('window_main')->set_default_icon_from_file(&get_picdir."/jezek-64_L.png");
}
# -----------------------------------------------------------------
sub prep_tt {
# prepare the tuples tree like list...
	my $form = &get_form;
 	my $drevo2 = new Gtk2::TreeStore ('Glib::String','Glib::String',
													'Glib::String','Glib::String',
													'Glib::String','Glib::String',
													'Glib::String','Glib::String',
													'Glib::String');
 	$form->get_widget('treeview_tt')->set_model($drevo2);
	$form->get_widget('treeview_tt')->set('headers-clickable',1);
 	$form->get_widget('treeview_tt')->set('rules-hint',1);
 	$form->get_widget('treeview_tt')->get_selection->set_mode('multiple');
	my @columns = (gettext("Class"), 
					gettext("Subject"), 
					gettext("Teacher"), 
					gettext("Perweek"), 
					gettext("Room"), 
					gettext("Period"), 
					gettext("Day"), 
					gettext("Restrictions"), 
					gettext("Notes"));
	for (my $c = 0; $c <= $#columns; $c++) {
 		my $renderer = new Gtk2::CellRendererText();
		my $count = $c;
			$renderer->set('editable' => TRUE);
			$renderer->set('mode' => 'editable'); 
  			$renderer->signal_connect ('edited' => sub {
	           my ($cell,$text_path,$new_text) = @_;
				  my $tree = $form->get_widget('treeview_tt')->get_model;
				  my $iter = $tree->get_iter_from_string($text_path);
				  if (defined $iter) { 
					  my $old_text = $tree->get($iter,$count);
						$tree->set($iter,$count,$new_text); 
# if the user has renamed us, update other tvs
						if ($count == 0) { &rename_entity('classs',$old_text,$new_text); }
						elsif ($count == 1) { &rename_entity('subjects',$old_text,$new_text); }
						elsif ($count == 2) { &rename_entity('teachers',$old_text,$new_text); }
						elsif ($count == 4) { &rename_entity('classrooms',$old_text,$new_text); }
				  }
 			 	});	 
		my $col = Gtk2::TreeViewColumn->new_with_attributes($columns[$c],$renderer,'text' => $c);
		$col->set_resizable(1);
		$col->set_sort_column_id($c);
 		$form->get_widget('treeview_tt')->append_column($col);
 	}

}
# -----------------------------------------------------------------
sub prep_teachers {
# prepare the teachers tree like list...
	my $form = &get_form;
 	my $tvt = $form->get_widget('treeview_teachers');
	my $drevo = new Gtk2::TreeStore ('Glib::String','Glib::String','Glib::String','Glib::String');
 	$tvt->set_model($drevo);
	$tvt->set('headers-clickable',1);
 	$tvt->set('rules-hint',1);
#	$tvt->set('fixed-height-mode',1);
	$tvt->get_selection->set_mode('multiple');
#	$tvt->get_selection->signal_connect(changed => sub { &select_row('teacher');});
	my @columns = (gettext("Teacher"),
						gettext("Subject"),
						gettext("Restrictions"),
						gettext("Notes"));
 	for (my $c = 0; $c <= $#columns; $c++) {
 		my $renderer = new Gtk2::CellRendererText();
		my $col = Gtk2::TreeViewColumn->new_with_attributes($columns[$c],$renderer,'text' => $c);
			$col->set_sort_column_id($c);
 			$tvt->append_column($col);
			$col->set_resizable(1);
		my $count = $c;
			$renderer->set('editable' => TRUE);
			$renderer->set('mode' => 'editable'); 
  			$renderer->signal_connect ('edited' => sub {
	           my ($cell,$text_path,$new_text) = @_;
				  my $tree = $tvt->get_model;
				  my $iter = $tree->get_iter_from_string($text_path);
				  if (defined $iter) { 
					  my $old_text = $tree->get($iter,$count);
						$tree->set($iter,$count,$new_text); 
# if the user has renamed us, update other tvs
						if ($count == 0) { &rename_entity('teachers',$old_text,$new_text); }
						elsif ($count == 1) { &rename_entity('subjects',$old_text,$new_text); }
				  }
 			 	});	 
 	}

}
# -----------------------------------------------------------------
sub prep_ttviews {
	my $form = &get_form;
	my %clists;
	$clists{"ttview_all"} = Gtk2::SimpleList->new_from_treeview(
									$form->get_widget('treeview_ttview_all'),
									gettext("Entity")=>"text");
	$clists{"ttview_files"} = Gtk2::SimpleList->new_from_treeview(
									$form->get_widget('treeview_ttview_files'),
									gettext("File")=>"text");
	foreach my $tv (keys(%clists)) {	# set the columns sort ids...
		my @columns = $form->get_widget("treeview_$tv")->get_columns;
		for (my $i = 0 ; $i <= $#columns ; $i++) { 
			$columns[$i]->set_sort_column_id ($i); 
			$columns[$i]->set_resizable(1);
		}
	}	
}
# -----------------------------------------------------------------
sub prep_modules {	
	my $form = &get_form;
		my $modules = Gtk2::SimpleList->new_from_treeview(
									$form->get_widget('treeview_modules'),
									gettext("Name")=>"text",
									gettext("Weight")=>"int",
									gettext("Mandatory")=>"bool",
									gettext("Active")=>"bool",
									gettext("Options")=>"text",
									gettext("Notes")=>"text");  
		$modules->set_column_editable("1","1");
		my @columns = $form->get_widget("treeview_modules")->get_columns;
		$form->get_widget("treeview_modules")->get_selection->set_mode('multiple');
		for (my $i = 0 ; $i <= $#columns ; $i++) { 
			$columns[$i]->set_sort_column_id ($i); 
			$columns[$i]->set_resizable(1);
		}
}
# -----------------------------------------------------------------
sub prep_lists {
	my $form = &get_form;
#	my @clists = ('subjects', 'classrooms', 'classs');
	my %clists;
	$clists{"subjects"} = $form->get_widget('treeview_subjects'); 
	$clists{"classrooms"} = $form->get_widget('treeview_classrooms'); 
	$clists{"classs"} = $form->get_widget('treeview_classs'); 

# and other simple lists....
	foreach my $tv (keys(%clists)) {	# set the columns sort ids...
	  	my $drevo = new Gtk2::ListStore ('Glib::String','Glib::String','Glib::String');
	  	$clists{$tv}->set_model($drevo);
	 	$clists{$tv}->set('headers-clickable',1);
	   $clists{$tv}->set('rules-hint',1);
	 #	$clists{$tv}->set('fixed-height-mode',1);
	 	$clists{$tv}->get_selection->set_mode('multiple');
	
		my @columns = (gettext("Name"),
							gettext("Restrictions"),
							gettext("Notes"));
		for (my $i = 0 ; $i <= $#columns ; $i++) { 
			my $renderer = new Gtk2::CellRendererText();
			my $col = Gtk2::TreeViewColumn->new_with_attributes($columns[$i],$renderer,'text' => $i);
				$col->set_sort_column_id ($i); 
				$col->set_resizable(1);
			$clists{$tv}->append_column($col);
			my $count = $i;
			$renderer->set('editable' => TRUE);
			$renderer->set('mode' => 'editable'); 
			$renderer->signal_connect('edited' => sub {
	 	 		my ($renderer,$text_path,$new_text) = @_;
	 	 		my $tree = $form->get_widget('treeview_'.$tv)->get_model;
	 	 		my $iter = $tree->get_iter_from_string($text_path);
	 	 		if (defined $iter) { 
		 	 		my $old_text = $tree->get($iter,$count);
	 	 			$tree->set($iter,$count,$new_text); 
	 	 # if the user has renamed us, update other tvs
	 	 			if ($count == 0) { rename_entity($tv,$old_text,$new_text); }
	 	 		}
			});
		}
	}	
}
# -----------------------------------------------------------------
sub prep_combinations {
# prepare the combinations lists...
	my $form = &get_form;
	my @combination = ('teachers','subjects','classs','classrooms');
	for (my $c = 0; $c <= $#combination; $c++) {
	  	my $drevo = new Gtk2::ListStore ('Glib::String','Glib::String');
	  	my $tree = 	$form->get_widget('treeview_combinations_'.$combination[$c]);
		$tree->set_model($drevo);
	 	$tree->set('headers-clickable',1);
	  	$tree->set('rules-hint',1); 
		$drevo->set_sort_func(0,\&sort_by_color);
	  	$drevo->set_sort_func(1,\&sort_by_number);

	# column with names
	  	my $renderer1 = new Gtk2::CellRendererText();
			$renderer1->set('editable' => TRUE);
			$renderer1->set('mode' => 'editable'); 
  			$renderer1->signal_connect ('edited' => sub {
	           my ($cell,$text_path,$new_text) = @_;
				  #my $tree = $form->get_widget('treeview_combinations_'.$combination[$c])->get_model;
				  my $iter = $tree->get_model->get_iter_from_string($text_path);
				  if (defined $iter) { 
					  my $old_text = $tree->get_model->get($iter,0);
						$tree->get_model->set($iter,0,$new_text); 
# if the user has renamed us, update other tvs
						&rename_entity(undef,$old_text,$new_text); 
				  }
 			 	});	 
		my $title = ucfirst($combination[$c]);
		my $col1 = Gtk2::TreeViewColumn->new_with_attributes(gettext($title),$renderer1,'text' => 0);
			$col1->set_cell_data_func ($renderer1, sub {
	         my ($column, $cell, $model, $iter) = @_;
	         my ($text, $color) = do_something_cool ($model, $iter);
	         $cell->set (text => $text, background => $color);
    		});
	  	$col1->set_sort_column_id(0);
	   $col1->set_resizable(1);
		$tree->append_column($col1);

	# column with frequencies
	  	my $renderer2 = new Gtk2::CellRendererText();
		my $col2 = Gtk2::TreeViewColumn->new_with_attributes('#',$renderer2,'text' => 1);
			$col2->set_cell_data_func ($renderer2, sub {
	         my ($column, $cell, $model, $iter) = @_;
	         my ($text, $color) = do_something_cool_perweek ($model, $iter);
	         $cell->set (text => $text, background => $color);
    		});
		$col2->set_sort_column_id(1);
	   $col2->set_resizable(1);
		$tree->append_column($col2);
	}

}
# -----------------------------------------------------------------

sub check_opts {
	my ($open_file) = @_;
	my ($form,undef,$defined_tt_entries,$uid_tt_entries) = &get_vars;
	if ((defined $open_file) and !($open_file =~ /^-/)) { 
		&parse_xml($open_file,$form,$defined_tt_entries,$uid_tt_entries); 
	}
}

sub check_deps {
	my ($quiet) = @_;
	my @checks = ('tablix','tablix_modinfo','tablix_plot',
						'convert','gnuplot','iconv','gzip','killall',
						'gunzip','file','xpvm','html2ps','lp');
	my $errors = "";
	my $module = 1;
# check for external executables
	foreach my $a (@checks) {
		my $b = readpipe("whereis $a");
		$b = (split/ /,$b)[1];
		if (!defined $b or !-x $b) { 
			$errors = $errors."Couldn't start $a;\n"; 
			&disable ($a);
			if ($a eq 'tablix_modinfo') { $module = 0; }
		}
	}
# set modules path
	$errors = $errors.&set_modules_path; 
# report errors	
	if ($errors ne "" and !$quiet) {
		$errors = $errors."-----\n".gettext("Some external programs couldn't be started. Check that they are installed and in the path, or some functions will not work.");
		&check($errors,'error');
	}
}
sub disable {
	my ($what) = @_;
	my $form = &get_form;
	if ($what eq 'tablix') {
		$form->get_widget('frame_tablix')->set('sensitive' => 0);
		$form->get_widget('run1')->set('sensitive' => 0);
		&disable_modules;
	} elsif ($what eq 'tablix_plot') {
		$form->get_widget('frame_plot')->set('sensitive' => 0);
	} elsif ($what eq 'tablix_modinfo') {
		&disable_modules;
	} elsif ($what eq 'gnuplot') {
		$form->get_widget('frame_plot')->set('sensitive' => 0);
	} elsif ($what eq 'clusterconf') {
		$form->get_widget('clusterconf1')->set('sensitive' => 0);
	} elsif ($what eq 'xpvm') {
		$form->get_widget('xpvm1')->set('sensitive' => 0);
	} elsif (($what eq 'html2ps') or ($what eq 'lp')) {
		$form->get_widget('button_tt_print')->set('sensitive' => 0);
	}
}
sub disable_modules {
	my $form = &get_form;
	$form->get_widget('frame_modules')->set('sensitive' => 0);
	$form->get_widget('button_teacher_rests')->set('sensitive' => 0);
	$form->get_widget('button_subjects_rests')->set('sensitive' => 0);
	$form->get_widget('button_rooms_rests')->set('sensitive' => 0);
	$form->get_widget('button_classes_rests')->set('sensitive' => 0);
	$form->get_widget('button_tt_rests')->set('sensitive' => 0);
	$form->get_widget('toggletoolbutton_options')->set('sensitive' => 0);
	$form->get_widget('restrictions1')->set('sensitive' => 0);	
}
sub set_modules_path {	# Extract module path from "tablix -v" output and set "entry_modpath"
# If "tablix -v" does not contain this information, use a default value.
	my $form = &get_form;
	my $temp = readpipe("LC_ALL=C ; tablix -v");
	
	if (($temp=~/Searching for modules in (.*)/) && ($temp!~/default dir/)) {
		$temp = $1;
	} elsif (-d "/usr/lib/tablix") {
		$temp = "/usr/lib/tablix";
	} elsif (-d "/usr/local/lib/tablix") {
		$temp = "/usr/local/lib/tablix";
	} else {
		&disable_modules;
		return gettext("Couldn't find directory with tablix modules");
	}
	$form->get_widget('entry_modpath')->set_text($temp);
#	return $temp;
# stupid: dont return an error...
	return "";
}


return 1;
