#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# module with wizard...
# 9.2.2005

#package gtablix::gui;

use strict;

my %wizard_help;
my @frames = ('select', 'settings', 'classes', 
					'classrooms', 'teachers', 'editor', 
					'modules', 'tablix','plot', 'result');
my %buttons;

sub init_wizard {
	my $form = &get_form;
	my $notebook = $form->get_widget('notebook1');
	my $label = $form->get_widget('scrolledwindow_wizard_help');
	my $white = Gtk2::Gdk::Color->new(65535,65535,65535);
	my $eventbox = $form->get_widget('viewport_wizard_help');
	&build_help;
	$notebook->set_show_tabs(0);
	$label->set('visible' => 1);
	$eventbox->modify_bg('normal',$white);
	$form->get_widget('hbox_wizard_navigate')->set('visible' => 1);
	$form->get_widget('hbox_lists')->set('visible' => 0);
	&build_buttons;
	&write_to_statusbar(gettext('Read the guide, navigate with "Next" and "Back" buttons or return to beginning with the "Home" button.'));
}
sub close_wizard {
	my $form = &get_form;
	my $notebook = $form->get_widget('notebook1');
	my $label = $form->get_widget('scrolledwindow_wizard_help');
	
	$notebook->set_show_tabs(1);
	$label->set('visible' => 0);
	$form->get_widget('hbox_wizard_navigate')->set('visible' => 0);
	$form->get_widget('radiobutton_classes')->set_active(1);
	my $name;
# $name is the frame, that is currently visible in the wizard. it must always be only one.
	foreach my $b (@frames) {
		my $frame = $form->get_widget("frame_$b");
		if ($frame->get('visible')) {
			$name = $b;
		} else {
		# since we are leaving the wizard, make all of them visible again
			$frame->set('visible' => 1);
		}
	}
	$form->get_widget('hbox_lists')->set('visible' => 1);

	if ($name eq 'select') { $notebook->set_current_page(0);
	} elsif ($name eq 'settings') { $notebook->set_current_page(1);
	} elsif ($name eq 'classes') { 
		$notebook->set_current_page(2);
#		&switch_lists($form->get_widget('radiobutton_classes'),'classes');
	} elsif ($name eq 'classrooms') { 
		$notebook->set_current_page(2);
		&switch_lists($form->get_widget('radiobutton_classrooms'),'classrooms');
		$form->get_widget('radiobutton_classrooms')->set_active(1);
	} elsif ($name eq 'teachers') { $notebook->set_current_page(2);
	} elsif ($name eq 'editor') { $notebook->set_current_page(3);
	} elsif ($name eq 'tt_lists') { $notebook->set_current_page(3);
	} elsif ($name eq 'modules') { $notebook->set_current_page(1);
	} elsif ($name eq 'tablix') { $notebook->set_current_page(4);
	} elsif ($name eq 'plot') { $notebook->set_current_page(4);
	} elsif ($name eq 'result') { $notebook->set_current_page(5);
	} 
# ugly
	if ($name ne 'classrooms') {
		&switch_lists($form->get_widget('radiobutton_classes'),'classes');	
	}	
	&write_to_statusbar(gettext('Hope this was usefull...'));
}
sub build_buttons {
	my $form = &get_form;
	my $buttons = $form->get_widget('vbuttonbox_wizard_steps');
	my $combo = $form->get_widget('combobox_wizard_navigate');
	my @ts;
	foreach my $f (@frames) {
		push(@ts,ucfirst(gettext($f)));
	}
	$combo->set_popdown_strings(@ts);	
}
sub wizard_step {
	my ($name) = @_;
	my $form = &get_form;
	my $notebook = $form->get_widget('notebook1');
	my $label = $form->get_widget('label_wizard_help');
	my $text;
	foreach my $b (@frames) {
		my $frame = $form->get_widget("frame_$b");
		if (lc(gettext($b)) eq lc($name)) {
			$frame->set('visible' => 1);
			$text = $wizard_help{lc(gettext($b))};
		} else { 
			$frame->set('visible' => 0);
		}
	}	
	
	if (lc($name) eq lc(gettext('select'))) {
		$notebook->set_current_page(0);
		$form->get_widget('button_wizard_back')->set('sensitive' => 0);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('settings'))) {
		$notebook->set_current_page(1);
		$form->get_widget('button_wizard_back')->set('sensitive' => 0);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('classes'))) {
		$notebook->set_current_page(2);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('classrooms'))) {
		$notebook->set_current_page(2);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('teachers'))) {
		$notebook->set_current_page(2);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('editor'))) {
		$notebook->set_current_page(3);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('modules'))) {
		$notebook->set_current_page(1);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('tablix'))) {
		$notebook->set_current_page(4);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('plot'))) {
		$notebook->set_current_page(4);
#		$form->get_widget('frame_tablix')->set('visible' => 1);
		$form->get_widget('button_wizard_next')->set('sensitive' => 1);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
	} elsif (lc($name) eq lc(gettext('result'))) {
		$notebook->set_current_page(5);
		$form->get_widget('button_wizard_back')->set('sensitive' => 1);
		$form->get_widget('button_wizard_next')->set('sensitive' => 0);
	} else { return 0; }

	if (!defined $text) { 
		$text = gettext("I'm sorry, no help here... Check your installation."); 
	}
	$form->get_widget('label_wizard_help')->set_markup($text);
}
sub on_combobox_wizard_text_changed {
	my ($me) = @_;
	my $text = $me->get_text;
	&wizard_step($text);
}
sub on_button_wizard_next_clicked {
	my $form = &get_form;
	my $c_no; my $count = 0;
	foreach my $c (@frames) {
		my $how = $form->get_widget("frame_$c")->get('visible');
		if ($how) {
			$c_no = $count + 1;
			my $new = $frames[$c_no];
			$form->get_widget('combobox_wizard_text')->set_text(gettext($new));	
			last;
		} else {
			$count++;
		}
	}
}
sub on_button_wizard_back_clicked {
	my $form = &get_form;
	my $c_no; my $count = 0;
	foreach my $c (@frames) {
		my $how = $form->get_widget("frame_$c")->get('visible');
		if ($how) {
			$c_no = $count - 1;
			my $new = $frames[$c_no];
			$form->get_widget('combobox_wizard_text')->set_text(gettext($new));	
			last;
		} else {
			$count++;
		}
	}
}
sub on_button_wizard_end_clicked {
	my $form = &get_form;
	$form->get_widget('togglebutton_wizard')->set_active(0);	
	my $notebook = $form->get_widget('notebook1');
	$notebook->set_current_page(0);
}
sub on_togglebutton_wizard_toggled {
	my ($me) = @_;
	my $how = $me->get_active;
	my $form = &get_form;
	my $notebook = $form->get_widget('notebook1');
	my $page = $notebook->get_current_page;
	my $what;
	
	if ($page == 0) {	$what = 'settings';
	} elsif ($page == 1) {	$what = 'settings';
	} elsif ($page == 2) {	$what = 'teachers';
	} elsif ($page == 3) {	$what = 'editor';
	} elsif ($page == 4) {	$what = 'tablix';
	} elsif ($page == 5) {	$what = 'result';
	} 
	
	if (!$how) { 
		&close_wizard;
		&check_deps(1); # do it quietly
	} else {
		&init_wizard;
		$form->get_widget('combobox_wizard_text')->set_text(gettext($what));
	}
}

sub on_button_welcome_simple_clicked { 
	my $form = &get_form;
	$form->get_widget('togglebutton_wizard')->set_active(1);
	#&write_to_statusbar('Don\' panic.');
}

sub on_button_welcome_simpler_clicked {

}

sub on_button_welcome_skip_clicked {
	my $form = &get_form;
	$form->get_widget('togglebutton_wizard')->set_active(0);
	$form->get_widget('notebook1')->set_current_page(3);
	&write_to_statusbar(gettext('Type in timetable definitions or go to the "Lists" tab and fill data lists.'));
}
sub on_button_welcome_save_clicked { &on_save1_activate; }
sub on_button_welcome_open_clicked { &on_open1_activate; }

sub build_help {
	my (undef,$file) = &get_help;
	my $form = &get_form;
	my $helpfile = "";
	if (-r $file) {
		$helpfile = readpipe("more $file");
	} elsif (-r $file.'.gz') {
		$helpfile = readpipe("gunzip -c $file.gz");
	} else {
		&check(gettext("I'm sorry, I couldn't find or open the help file. 
Check your install and permissions:")." $file",'error');
		return 0;
	}
	my @segments = split/--- /,$helpfile;
	foreach my $segment (@segments) {
		my @lines = split/\n/,$segment;
		my $name = shift(@lines);
		if (defined $name) {
			$wizard_help{lc($name)} = join("\n",@lines);
		}
	}	
}

return 1;
