#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# module for importing and exporting everything to Tablix XML
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# contributions: Tomaz Solc
# 19.12.2004

use XML::LibXML;

use strict;

my %fet_days;
my %fet_periods;

# --------- I / O --------------------------------
sub xml_result {
	my ($filename,$uid_entries,$defined_entries) = @_;
	my $form = &get_form;
# we get this filename directly from tablix, so we won't check anything!
	my $progress = $form->get_widget('progressbar_main');
	my $parser = XML::LibXML->new();
	my $file_opened = $parser->parse_file($filename); # build the XML
	$progress->set('visible' => 1);
 	my $root = $file_opened->getDocumentElement;
 	my @segs = $root->getChildNodes; 
	my $grade; my $days; my $periods;
	if ($root->nodeName eq "school") {	# tablix 0.1 file		 
 	 	foreach my $seg (@segs) {
			if ($seg->nodeName eq "parameters") { 
				($days,$periods) = &params_result($seg,$form); 
				$progress->pulse; Gtk2->main_iteration;
			} elsif ($seg->nodeName eq "timetable") { 
				&timetable_result($seg,$form,$defined_entries,$uid_entries); 
				$progress->pulse;  Gtk2->main_iteration; 
	 		} elsif ($seg->nodeName eq "chromo") { 
				$grade = &chromo_result($seg,$form,$defined_entries,$uid_entries); 
				$progress->pulse; Gtk2->main_iteration; 
	 		}
		}				
	}
	$progress->set('visible' => 0);
	return ($uid_entries,$defined_entries,$grade,$days,$periods);
}
sub params_result {		# podatki o modulih
	my ($params,$form) = @_; 
	my $comment;
	foreach my $param ($params->getChildNodes) {
		if ($param->nodeName eq "time") { 
			my $days = getNamedItem($param,"days");	
			my $periods = getNamedItem($param,"periods");	
			return ($days,$periods);
		}
	}
	return (0,0);
}
sub timetable_result {		# podatki o urnikih
 	my ($ttable,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my $class; 
	foreach my $timetable ($ttable->getChildNodes) {
 		if ($timetable->nodeName eq "class") {
			my $year = getNamedItem($timetable,"year");
 			my $name = getNamedItem($timetable,"name");
 			$class = "$year $name";
 		} elsif ($timetable->nodeName eq "subject") {
			my $title = getNamedItem($timetable,"title");
  			my $teacher = getNamedItem($timetable,"teacher");
			my $perweek = getNamedItem($timetable,"perweek");
			my $room = getNamedItem($timetable,"room");
			my $period = getNamedItem($timetable,"period");
			my $day = getNamedItem($timetable,"day");			
			my $id = getNamedItem($timetable,"uid");
# ce smo slucajno nalozil result.xml
			if ($id) { 	# za vse ki nimajo fiksne lokacije v urniku, si zapomnimo idje
				for (my $i = $id; $i < ($id + $perweek); $i++) {
					${$uid_tt_entries}{$i} = "$class||$title||$teacher";
				}
			} elsif ($room and $period and $day) {		# tiste dolocene pa vpisemo v bazo dolocenih
				${$defined_tt_entries}{"$room||$period||$day"} = "$class||$title||$teacher";
			}
		}
	}
	$form->get_widget('progressbar_main')->pulse;
	Gtk2->main_iteration;
}
sub chromo_result {	# napolnimo globalno bazo urnikov uciteljev in razredov
	my ($chromo,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my %list;
	my $grade = getNamedItem($chromo,"grade");
	foreach my $entry ($chromo->getChildNodes) {
		if ($entry->nodeName eq "gen") {
			my $id = getNamedItem($entry,"uid");
			my $rm = getNamedItem($entry,"room");
			my $pd = getNamedItem($entry,"period");
			my $dy = getNamedItem($entry,"day");			

			my $who = ${$uid_tt_entries}{$id}; 
			if ($who) { 
				${$defined_tt_entries}{"$rm||$pd||$dy"} = "$who||$id";  # ||$id
			}
		}
	}
	return $grade;
#	@{$form->get_widget("treeview_ttview_all")->{data}} = (sort(keys(%list)));
}

# ---------------------------------------------------------------------------

sub parse_xml {
	my ($filename,$form,$defined_tt_entries,$uid_tt_entries) = @_;

#TODO: lovi parserjeva sporocila...									
# nalozimo datoteko in vse potrebne veje
	
	my $progress = $form->get_widget('progressbar_main');

  if (!-r $filename) {
  		print gettext("Error:")." $filename ".gettext("not readable.")."\n";
		&check(gettext("Couldn't open file)")."\n$filename\n".
				 gettext("Check full path and permissions"),'error'); 
  } else {
	   if (!-w $filename) { &check(gettext("File")." \n$filename\n".
				 gettext("is not writable. Changes will not be saved."),'error'); }
	 	my $parser = XML::LibXML->new();
	 	my $file_opened;
	 	my $file_type = &get_file_type($filename);
	 	if ($file_type eq 'gzip') {
	 		my $content = readpipe("gunzip -c $filename");
	 		$file_opened = $parser->parse_string($content);
	 	} elsif ($file_type eq 'XML') {
	 		$file_opened = $parser->parse_file($filename); # build the XML
	 	} else {
	 		print gettext("Error: didn't recognize file type:")." $filename\n";
		}
	 	if (!$file_opened) {
	 		print gettext("Error: when pasing")." $filename\n";
	 		&check(gettext("Couldn't parse file")."\n$filename\n".
					 gettext("This Could be a syntax error"),'error');
	 	} else {
			$progress->set('visible' => 1);
	 # zapomnimo si encoding	
	 	  	my $encoding = $file_opened->encoding; 
	 	 	if (defined $encoding) { $form->get_widget('entry_encoding')->set_text($encoding); }
	 	  
	 	 	my $root = $file_opened->getDocumentElement;
	 	 	my @segs = $root->getChildNodes;
	 
		 	if ($root->nodeName eq "school") {	# tablix 0.1 file		 
	 	 	 	foreach my $seg (@segs) {
	 	 	 		if ($seg->nodeName eq "info") { &infos($seg,$form); $progress->pulse; Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "parameters") { &params($seg,$form); $progress->pulse; Gtk2->main_iteration;
	 	 	 		} elsif ($seg->nodeName eq "subjects") { &subjects($seg,$form); $progress->pulse; Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "building") {	&building($seg,$form); $progress->pulse; Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "timetable") { &timetable($seg,$form,$defined_tt_entries,$uid_tt_entries); $progress->pulse;  Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "chromo") { &chromo($seg,$form,$defined_tt_entries,$uid_tt_entries); $progress->pulse; Gtk2->main_iteration; 
	 	 	 		}
				}	
				&load_result($filename);     			
			} elsif ($root->nodeName =~ /^FET/) {	# fet file
	 	 	 	foreach my $seg (@segs) {
	 	 	 		if ($seg->nodeName eq "Hours_List") { &fet_hours($seg,$form); $progress->pulse; Gtk2->main_iteration;
	 	 	 		} elsif ($seg->nodeName eq "Days_List") { &fet_days($seg,$form); $progress->pulse; Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "Students_List") { &fet_students($seg,$form); $progress->pulse; Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "Teachers_List") { &fet_teachers($seg,$form); $progress->pulse;  Gtk2->main_iteration;
	 	 	 		} elsif ($seg->nodeName eq "Subjects_List") { &fet_subjects($seg,$form); $progress->pulse;  Gtk2->main_iteration; 
					} elsif ($seg->nodeName eq "Activities_List") { &fet_activities($seg,$form); $progress->pulse;  Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "Equipments_List") {	&fet_equipment($seg,$form); $progress->pulse; Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "Rooms_List") { &fet_rooms($seg,$form);  Gtk2->main_iteration; $progress->pulse; 
	 	 	 		} elsif ($seg->nodeName eq "Time_Constraints_List") { &fet_time_constraints($seg,$form); $progress->pulse;  Gtk2->main_iteration; 
	 	 	 		} elsif ($seg->nodeName eq "Space_Constraints_List") { &fet_time_constraints($seg,$form); $progress->pulse;  Gtk2->main_iteration; 
	 	 	 		}
				}								
			} else {	# error
				&check(gettext("Couldn't parse file")."\n$filename\n".
						 gettext("This is a syntax error in the root element."),'error');
				return 0;
			}			
	 	 	$form->get_widget('window_main')->set_title("Gtablix - $filename");
			&on_treeview_tt_unselect_all;
			$progress->set('visible' => 0);
			&write_to_statusbar(gettext("Loaded file")." $filename.");
	 	}
	}
}
sub get_file_type {
	my ($what) = @_;
	my $type = readpipe("file $what"); chop($type);
	$type = (split/\:/,$type)[1];
	$type = (split/ /,$type)[1];
	return $type;
}

sub infos {			# osnovne informacije
	my ($infos,$form) = @_; 
	my $title =""; my $address = ""; my $author = "";
	foreach my $info ($infos->getChildNodes) {		
		if ($info->getFirstChild) {
			if ($info->nodeName eq "title") { $title = $info->firstChild->data }
			elsif ($info->nodeName eq "address") { $address = $info->firstChild->data }
			elsif ($info->nodeName eq "author") { $author = $info->firstChild->data }
		}
	}
	$form->get_widget('entry_title')->set_text($title);
 	$form->get_widget('entry_notes')->set_text($address);
	$form->get_widget('entry_author')->set_text($author);
	$form->get_widget('progressbar_main')->pulse;
}
sub params {		# podatki o modulih
	my ($params,$form) = @_; 
	my $comment;
	my $tv = $form->get_widget('treeview_modules')->get_model;
	foreach my $param ($params->getChildNodes) {
# module notes
		if ($param->nodeType eq 'COMMENT_NODE') {
			$comment = $comment.$param->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g; 
		}		
		if ($param->nodeName eq "time") { 
			my $days = getNamedItem($param,"days");	
			my $periods = getNamedItem($param,"periods");	
			$form->get_widget('entry_days')->set_text($days);
			$form->get_widget('entry_periods')->set_text($periods);
		}
		elsif (($param->nodeName eq "module")) { 
			my $mand = getNamedItem($param,"mandatory"); 
				if ($mand eq "yes") { $mand = 1; } elsif ($mand eq "no") { $mand = 0; }
			my $weight = getNamedItem($param,"weight");
			my $name = getNamedItem($param,"name");		
			my $row = &find_clist_row("modules",$name); 
			if ($row ne "new") {
				$row = $tv->get_iter_from_string($row);
				$tv->set($row,1,$weight,2,$mand,3,'1',5,$comment);			
				$comment = "";				
		# load module options
				my %rests;
				foreach my $rest ($param->childNodes) {
					if ($rest->nodeName eq "option") {
						my $rest_type = getNamedItem($rest,"type");
						if ($rest_type) {
							my $rest_val = $rest->firstChild->data;
							if ($rests{$rest_type}) { $rests{$rest_type} = "$rest_val,".$rests{$rest_type};
							} else { $rests{$rest_type} = $rest_val; }
						}
					}
				}
				while ((my $key, my $value) = each %rests) {
					my $old = $tv->get($row,4);
					if (!$old) { $old = ""; }
					$tv->set($row,4,"$key:$value;");
				}		
			}
		} elsif ($param->nodeName eq "internal") {
			my $weight = getNamedItem($param,"weight");	
			my $name = getNamedItem($param,"name");
			
			if ($name eq "impossible") {
				$form->get_widget('entry_impossible')->set_text($weight);
			}
		} 
	}
}
sub subjects {		# podatki o predmetih in uciteljih
	my ($subjects,$form) = @_; 
	my $s_comment = ""; my $t_comment = "";
	my %s_count; my %sr_count;
	my $tv = $form->get_widget('treeview_subjects')->get_model;
	my $tv_t = $form->get_widget('treeview_teachers')->get_model;
	foreach my $subject ($subjects->getChildNodes) {
# notes
		if ($subject->nodeType eq 'COMMENT_NODE') {
			my $comment = $subject->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g; 			
			if ($comment =~ /^Teacher:/) { $t_comment = $comment;
			} else {	$s_comment = $comment;	}
		}

		if ($subject->nodeName eq "subject") {		
			my $subj = getNamedItem($subject,"title");
			my $teacher = getNamedItem($subject,"teacher");
			if (!defined $subj) { $subj = ""; }
			if (!defined $teacher) { $teacher = ""; }
			if ($s_count{$subj}) { $s_count{$subj}++; } else { $s_count{$subj} = 1; }

	# load restrictions			
			my @rest = $subject->getChildNodes;
			my %rests;
			foreach my $rest (@rest) {
 			 	if ($rest->nodeName eq "restriction") {
	 				my $rest_type = getNamedItem($rest,"type");
 					if ($rest_type) {
						my $rest_val = $rest->firstChild->data;
						if ($sr_count{$rest_type}) { $sr_count{$rest_type}++; 
						} else { $sr_count{$rest_type} = 1; }
			# form a hash: rest_type=>rest_val1,rest_Val2,...
						if ($rests{$rest_type}) { 
							$rests{$rest_type} = "$rest_val,".$rests{$rest_type};
						} else { 
							$rests{$rest_type} = $rest_val; 
						}
					}
				}
			}			
			my $s_rests = "";
			while ((my $key, my $value) = each %rests) {
	 			$s_rests = "$key:$value;".$s_rests; 
	 			$s_rests =~ s/\,$//g;
	 			$s_rests =~ s/\,\,/\,/g;
			}	
					
	# write		
		# load teachers other subjects
			my $row = &add_to_tree($form,"teachers",$teacher,$subj);
			$tv_t->set($row,0,$teacher,1,$subj,2,$s_rests,3,$t_comment);
				
			$row = &find_clist_row("subjects",$subj);
			if (($row eq "new")) {
				if ((defined $subj) and ($subj ne "")) {
					$tv->set($tv->append,0,$subj,2,$s_comment);
				}
 			} else {
				$row = $tv->get_iter_from_string($row);
 				my $s_notes = $tv->get($row,2); 
				$s_notes = "$s_notes,$s_comment";
 				$s_notes =~ s/^\,//g;
 				$s_notes =~ s/\,$//g; 				
 				$tv->set($row,2,$s_notes);
 			}

			$t_comment = "" ;
			$s_comment = "";
		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
	}
	&combo_change("subjects");
	&combo_change("teachers");
}
sub building {		# podatki o prostorih
	my ($building,$form) = @_; 
	my $comment;
	my $tv = $form->get_widget('treeview_classrooms')->get_model;
	foreach my $room ($building->getChildNodes) {
# notes
		if ($room->nodeType eq 'COMMENT_NODE') {
			$comment = $comment.$room->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g; 
		} 		
# classroom
		if ($room->nodeName eq "classroom") {		
			my $id = getNamedItem($room,"id");
	# load restrictions
			my @rest = $room->getChildNodes; my %rests;
			foreach my $rest (@rest) {
				if ($rest->nodeName eq "capability") {
				my $rest_type = getNamedItem($rest,"type");
					if ($rest_type) {
						my $rest_val = $rest->firstChild->data;
						if ($rests{$rest_type}) { $rests{$rest_type} = "$rest_val,".$rests{$rest_type};
						} else { $rests{$rest_type} = $rest_val; }
					}
				}
			}
			my $rests = "";
			while ((my $key, my $value) = each %rests) {
	 				$rests = "$key:$value,$rests"; 
	 				$rests =~ s/\,$//g;
	 				$rests =~ s/\,\,/\,/g;
			}	
	# write
			if ($id) { $tv->set($tv->append,0,$id,1,$rests,2,$comment); }
			$comment = "";	
# classrooms
 		} elsif ($room->nodeName eq "classrooms") {
			my $start = getNamedItem($room,"start");
			my $end = getNamedItem($room,"end");
			for (my $i = $start; $i <= $end; $i++) { 
				$tv->set($tv->append,0,$i,2,$comment);
			}
		}						
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
	}
	&combo_change("classrooms");
}
sub timetable {		# podatki o urnikih
 	my ($ttable,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my $class; my $comment;
	my $tv_c = $form->get_widget('treeview_classs')->get_model;
	my $tv_t = $form->get_widget('treeview_tt')->get_model;
	foreach my $timetable ($ttable->getChildNodes) {
		if ($timetable->nodeType eq 'COMMENT_NODE') {
			$comment = $comment.$timetable->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g; 			
		}
 		if ($timetable->nodeName eq "class") {
			my $year = getNamedItem($timetable,"year");
 			my $name = getNamedItem($timetable,"name");
 			$class = "$year $name";
			$tv_c->set($tv_c->append,0,$class,2,$comment);
			$comment = "";
 		} elsif ($timetable->nodeName eq "subject") {
			my $title = getNamedItem($timetable,"title");
  			my $teacher = getNamedItem($timetable,"teacher");
			my $perweek = getNamedItem($timetable,"perweek");
			my $room = getNamedItem($timetable,"room");
			my $period = getNamedItem($timetable,"period");
			my $day = getNamedItem($timetable,"day");			
			my $id = getNamedItem($timetable,"uid");

# ce smo slucajno nalozil result.xml
 			if ($id) { 	# za vse ki nimajo fiksne lokacije v urniku, si zapomnimo idje
 				for (my $i = $id; $i < ($id + $perweek); $i++) {
 					${$uid_tt_entries}{$i} = "$class||$title||$teacher";
 				}
 			} elsif ($room and $period and $day) {		# tiste dolocene pa vpisemo v bazo dolocenih
 				${$defined_tt_entries}{"$room||$period||$day"} = "$class||$title||$teacher";
 			}
# ------------------------------	
# load tuple restrictions
			my $tt_rest = "";
				foreach my $tt_rests ($timetable->getChildNodes) {		
					if ($tt_rests->nodeName eq "restriction") {
						my $rest_type = getNamedItem($tt_rests,"type");	
						if ($rest_type) {
							my $data = $tt_rests->firstChild->data;
	 						$tt_rest = "$rest_type:$data;".$tt_rest;
	 	  	 				$tt_rest =~ s/\,$//g;
	 	 	 				$tt_rest =~ s/\,\,/\,/g;
	 		# convert from (type1:data1;type1:data2) to (type1:data1,data2;type2:...)
	 						$tt_rest = &beutify_rests($tt_rest);	
						}
					}
				}
# write in
			my $row = &add_to_tree($form,"tt",$class,$title);
			$tv_t->set($row,0,$class,1,$title,2,$teacher,3,$perweek,4,$room,5,$period,6,$day,7,$tt_rest,8,$comment);
			$comment = "";		

# load class restrictions
		} elsif ($timetable->nodeName eq "restriction") {
			my $rest = getNamedItem($timetable,"type");	
			if ($rest) {
				my $data = $timetable->firstChild->data;
				my $row = &find_clist_row("classs",$class);				
	 	 	  	if ($row ne "new") {
					$row = $tv_c->get_iter_from_string($row);
		# alter the existing field
	  				my $rests = $tv_c->get($row,1);	
						if (!$rests) { $rests = ""; }
					$rests = "$rest:$data;".$rests;
	  	 			$rests = &strip_commas($rests);
		# convert from (type1:data1;type1:data2) to (type1:data1,data2;type2:...)
					$rests = &beutify_rests($rests);	
	 	 	  		$tv_c->set($row,1,$rests);
	 	 	  	}
			}
		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
# ------------------------
 	}
	&combo_change("classs");
#	return ($defined_tt_entries,$uid_tt_entries);
}
sub chromo {	# napolnimo globalno bazo urnikov uciteljev in razredov
	my ($chromo,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my $grade = getNamedItem($chromo,"grade");
	$form->get_widget('label-chromo')->set_text($grade);
	my %list;
	foreach my $entry ($chromo->getChildNodes) {
		if ($entry->nodeName eq "gen") {
			my $id = getNamedItem($entry,"uid");
			my $rm = getNamedItem($entry,"room");
			my $pd = getNamedItem($entry,"period");
			my $dy = getNamedItem($entry,"day");			

			my $who = ${$uid_tt_entries}{$id}; 
			if ($who) { 
				${$defined_tt_entries}{"$rm||$pd||$dy"} = "$who||$id";  # ||$id
	 			my $teach = (split/\|\|/,$who)[2];
	 			my $class = (split/\|\|/,$who)[0];
	 			$list{gettext("Room").": $rm"}  ="";
	 			$list{gettext("Teacher").": $teach"} = "";
	 			$list{gettext("Class").": $class"} = "";
			}
		}
	}
#	$form->get_widget("combo_tt_result")->set_popdown_strings(sort(keys(%list)));
#	@{$form->get_widget("treeview_ttview_all")->{data}} = (sort(keys(%list)));
#	my $tt = $form->get_widget("treeview_ttview_all")->get_model;
#	foreach my $entry (sort(keys(%list))) {
#		$tt->set($tt->append,0,$entry);
#	}
}
	
sub beutify_rests {		# convert from (type1:data1;type1:data2) to (type1:data1,data2;type2:...)
	my ($data) = @_;
	
	my %rests;	
	my @parts = split/;/,$data;
	foreach my $part (@parts) {
		my @rest = split/:/,$part;		
		my $rest_type = $rest[0];
		my $rest_val = $rest[1];
		if ($rests{$rest_type}) { $rests{$rest_type} = "$rest_val,".$rests{$rest_type};
		} else { $rests{$rest_type} = $rest_val; }		
	}
	my $rests = "";
	while ((my $key, my $value) = each %rests) {
		$rests = "$key:$value;$rests"; 
		$rests =~ s/\;$//g;
		$rests =~ s/\,\,/\,/g;
	}	
	
	return $rests;
}
sub getNamedItem {
	my ($where,$what) = @_;
	
	foreach my $value ($where->attributes) {
		if ($value->name eq $what) {
			my $val = $value->value;
			return "$val";
		}
	}
	
	return "";
}

#################################################################################################

sub generateXML { 	# generira XML (kdo bi si mislil... :)
	my ($filename,$form,$defined_tt_entries,$uid_tt_entries,$how) = @_;	# how: loose / strict
	my $progress = $form->get_widget('progressbar_main');
	my $output; my $time = localtime; my $errors;
	my $encoding = $form->get_widget('entry_encoding')->get_text;
# heading
	$output = "<?xml version=\"1.0\" encoding=\"$encoding\"?>\n".
		"<!-- User XML data file for Tablix, created with Gtablix  -->\n".
		"<!-- Time: $time -->\n<school>\n";
# titles
	$output = $output."<info>\n".
		"\t<title>".$form->get_widget('entry_title')->get_text."</title>\n".
		"\t<address>".$form->get_widget('entry_notes')->get_text."</address>\n".
		"\t<author>".$form->get_widget('entry_author')->get_text."</author>\n".
		"</info>\n";
	$progress->set('visible' => 1);

	$output = $output.&XML_params("",$form,$how);
	$output = $output.&XML_subjects("",$form,$how);
	$output = $output.&XML_rooms("",$form,$how);
	
	#&build_uids;
	
	$output = $output.&XML_tt("",$form,$defined_tt_entries,$uid_tt_entries,$how);
	$output = $output.&XML_chromo("",$form,$defined_tt_entries,$uid_tt_entries,$how);
	
# footer
	$output = $output."</school>";

# escape the < and >
	$output =~ s/(=".*)<(.*")/$1-$2/g;
	$output =~ s/(=".*)>(.*")/$1-$2/g;
	$output =~ s/(=".*)&(.*")/$1|$2/g;
	
# return to saving
	$progress->set('visible' => 0);
	return $output;
}

sub XML_params {	# modules
	my ($output,$form,$how) = @_;
	$output = $output."<parameters>\n";
	my $days = int($form->get_widget('entry_days')->get_text);
	my $periods = int($form->get_widget('entry_periods')->get_text);	
	if (($days < 8) && $periods) { $output = $output."\t<time days=\"$days\" periods=\"$periods\"/>\n"; }
	my $tv = $form->get_widget('treeview_modules')->get_model;
	$tv->foreach(sub {
 		my (undef,undef,$child_iter) = @_; 	 	 
		my ($id,$weight,$mand,$active,$opts,$comments) = $tv->get($child_iter,0,1,2,3,4,5);
			if ($mand == 1) { $mand = "yes";	} else {	$mand = "no"; }

		if ($active == 1) {	
			if ($comments) { $output = $output."\t"."<!-- $comments -->\n"; }
			$output = $output."\t".'<module name="'.$id.'" weight="'.$weight.'" mandatory="'.$mand.'"';

			if (defined $opts) {
				$output = $output.">\n";
				foreach my $rest (split/\;/,$opts) { 			
					my @specc = split/:/,$rest;
					
					if (defined $specc[1]) { 
						foreach my $spec (split/,/,$specc[1]) {
							my $type = $specc[0];
							$output = $output."\t\t<option type=\"$type\">$spec</option>\n";
					#  <option type="morning-ends">7</option>
						}
					}
				}
				$output = $output."\t</module>\n";
			} else { $output = $output."/>\n"; }
		 }
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;		 
		 return 0;
#        <module name="sametime.so" weight="60" mandatory="yes"/>
	});
# se internal
	if (my $internal = $form->get_widget('entry_impossible')->get_text) {
		$output = $output."\t<internal name=\"impossible\" weight=\"$internal\"/>\n";
	}	
	$output = $output."</parameters>\n";
	return $output;
}

sub XML_subjects {	# subjects + teachers
	my ($output,$form,$how) = @_;
	$output = $output."<subjects>\n";
	my $tw = $form->get_widget('treeview_teachers')->get_model;
	my $tw_s = $form->get_widget('treeview_subjects')->get_model;
# za vsakega ucitlja
# in vse njegove predmete	
# poiscemo morebitne notese in restrictione predmeta
	my %subjects;
	my %teachers;
	$tw->foreach(sub {
		(undef, undef, my $iter) = @_;			
			my $teacher = $tw->get($iter,0);
			my $subject = $tw->get($iter,1);
			my $rests_t = $tw->get($iter,2);
			my $notes_t = $tw->get($iter,3);
			
			#if (!defined $subject) { return 0; }	# go next if empty
			my $s_row = 'new';
			if (!defined $subject) { $subject = ""; } 
			else { 
				$subjects{$subject} = 1; 
				$s_row = &find_clist_row("subjects",$subject);
			}
			my ($s_rests,$s_comments);
			if ($s_row ne "new") {
				($s_rests,$s_comments) = $tw_s->get($tw_s->get_iter_from_string($s_row),1,2);
				if (!defined $s_rests) { $s_rests = ""; }
			}

# in vse skupaj vpisemo v enem koraku.
 			if ((defined $notes_t) and ($notes_t ne "")) { 
				$output = $output."\t"."<!-- Teacher: $notes_t -->\n"; } 
 			if ((defined $s_comments) and ($s_comments ne "")) { 
				$output = $output."\t"."<!-- Subject: $s_comments -->\n"; } 
	# write tuple
			$output = $output."\t".'<subject title="'.$subject.'"'." teacher=\"$teacher\">";
	# write teachers restrictions
			if (defined $rests_t) {
			foreach my $type (split/;/,$rests_t) {
				my @rests = split/:/,$type;
				my $rest_type = $rests[0];
				foreach my $rest_val (split/\,/,$rests[1]) {	
					$output = $output."\n\t\t<restriction type=\"$rest_type\">$rest_val</restriction>\n";
				}
			} }
	# write subjects restrictions
			if (defined $s_rests) {
			foreach my $type (split/;/,$s_rests) {
				my @rests = split/:/,$type;
				my $rest_type = $rests[0];
				foreach my $rest_val (split/\,/,$rests[1]) {	
					$output = $output."\n\t\t<restriction type=\"$rest_type\">$rest_val</restriction>\n";
				}
			} }
	# end
			$output = $output."\t</subject>\n";	
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
			return 0;	
		});
	$tw_s->foreach(sub {
		(undef, undef, my $iter) = @_;
			my $subject = $tw_s->get($iter,0);
			my $rests_t = $tw_s->get($iter,1);
			my $notes_t = $tw_s->get($iter,2);
			my $teacher = "";
# for subjects that weren't used with teachers...		
			if (!$subjects{$subject}) {
	 			if ((defined $notes_t) and ($notes_t ne "")) { 
					$output = $output."\t"."<!-- Subject: $notes_t -->\n"; } 
	# write tuple
					$output = $output."\t".'<subject title="'.$subject.'"'." teacher=\"$teacher\">";
	# write restrictions
					if (defined $rests_t) {
						foreach my $type (split/;/,$rests_t) {
							my @rests = split/:/,$type;
							my $rest_type = $rests[0];
							foreach my $rest_val (split/\,/,$rests[1]) {	
								$output = $output."\n\t\t<restriction type=\"$rest_type\">$rest_val</restriction>\n";
							}
						} 
					}
	# end
			$output = $output."\t</subject>\n";	
			}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
			return 0;
	});
#	}
#                 <subject title="SVZ-Z" teacher="Prof. SVZ 1">
#                 <restriction type="capability-place">Telovadba</restriction>
#                 </subject>

	$output = $output."</subjects>\n";
	return $output;
}

sub XML_rooms {		# building
	my ($output,$form,$how) = @_;

#TODO: zaporedno stevilcene najdi in dodaj kot classrooms
	$output = $output."<building>\n";
	my $tv = $form->get_widget('treeview_classrooms')->get_model;
	$tv->foreach(sub {
 		my (undef,undef,$child_iter) = @_; 	 	 
# room notes
		my ($id,$rests,$comments) = $tv->get($child_iter,0,1,2);
		if (!defined $id) { return 0; }
		if ((defined $comments) and ($comments ne "")) { 
			$output = $output."\t"."<!-- $comments -->\n"; }
		$output = $output."\t".'<classroom id="'.$id.'">';
		if (!defined $rests) { $rests = ""; }
		foreach my $type (split/;/,$rests) {
			if ($type) { 
				my @rests = split/:/,$type;
				my $rest_type = $rests[0];
				foreach my $rest_val (split/\,/,$rests[1]) {	
					$output = $output."\n\t\t<capability type=\"$rest_type\">$rest_val</capability>";
				}
			}
		}
		$output = $output."\n\t</classroom>\n";
#                 <classroom id="1">
#                         <capability type="capability-place">Nemscina</capability>
#                         <capability type="capability-place">Normal</capability>
#                 </classroom>
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
		return 0;
	});
	$output = $output."</building>\n";
	return $output;
}
sub XML_tt {		# timetables
	my ($output,$form,$defined_tt_entries,$uid_tt_entries,$how) = @_;
	my $tw_c = $form->get_widget('treeview_classs')->get_model;
	my $tw = $form->get_widget('treeview_tt')->get_model;
	my %classs;
	$tw_c->foreach(sub {
		my (undef,undef,$child_iter) = @_; 	 	 
		my ($class,$c_rests,$c_comments) = $tw_c->get($child_iter,0,1,2);
			if (!defined $class) { return 0; }
			if (!defined $c_rests) { $c_rests = ""; }
		my $row = &find_clist_row("tt",$class);
			#if ($row eq 'new') { return 0; }

# NOTE: might be annoying...		
		my @class = split/ /,$class;		
#		if ($#class > 0) {
	 		my $year = shift(@class);
			my $classname = join(' ',@class);
			
			$classs{$class} = 1;
			
			$output = $output."<timetable>\n";
	 	 	if ((defined $c_comments) and ($c_comments ne "")) { 
				$output = $output."\t"."<!-- $c_comments -->\n"; }
	 		$output = $output."\t<class year=\"$year\" name=\"$classname\"/>\n";	# class name	
	 		
	 		if ($row ne 'new') {
	 			my $iter = $tw->get_iter_from_string($row);
	 	 		#$output = $output.&tt_output($class,$iter,$form,$uid_tt_entries);
	 	 		if (defined $tw->iter_has_child($iter)) {
	 	 			for (my $child = $tw->iter_children($iter); $child; $child = $tw->iter_next($child)) {
	 	 				$output = $output.&tt_output($class,$child,$form,$uid_tt_entries);
	 	 			}
	 	 		}	
			}		
	 	# class restrictions from clist_classes	
	 		foreach my $sub (split/;/,$c_rests) {  
	 			my @rests = split/:/,$sub;
	 			my $rest_type = $rests[0];
	 			if (defined $rests[1]) {
	 				foreach my $rest_val (split/\,/,$rests[1]) {	
	 					$output = $output."\t\t<restriction type=\"$rest_type\">$rest_val</restriction>\n";
	 				} 
	 			}
	 		}
	 		$output = $output."</timetable>\n";
#		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
		
		return 0;
	});
	return $output;
#         <timetable>
#                 <class year="3" name="A"/>
#                 <subject title="SOC" teacher="Prof. SOC 1" perweek="2"/>
#                 <subject title="SVZ" teacher="Prof. SVZ 1" perweek="3"/>
#                 <restriction type="conflicts-with">3 MA-FIZ</restriction>
#                 <restriction type="conflicts-with">3 MA-BIO</restriction>
#         </timetable>
}
sub tt_output {
	my ($class,$iter,$form,$uid_tt_entries,$how) = @_;
	my $tw = $form->get_widget('treeview_tt')->get_model;
	my @values = $tw->get($iter);
	my $output = "";
	
	my $id = $values[0];
	my $title = $values[1];
	my $teacher = $values[2];
	my $perweek = $values[3];
	my $room = $values[4];
	my $period = $values[5];
	my $day = $values[6];
	my $restss = $values[7];
	my $comments = $values[8];

#	if ($id and $teacher and $title and ($room or ($period and $day and $room))) {
 		if ((defined $comments) and ($comments ne "")) { 
			$output = $output."\t"."<!-- $comments -->\n"; }	# tuple notes
		$output = $output."\t\t<subject "."title=\"$title\" "."teacher=\"$teacher\" ";
	# either perweek or (period and day) can and must be specified
		if ($perweek ne "") { $output = $output."perweek=\"$perweek\" ";
	 	} elsif (($room ne "") and ($period ne "") and ($day ne "")) { 
			$output = $output."room=\"$room\" period=\"$period\" day=\"$day\"";
	 	} else { # TODO: error message
			return "";
		}
	# if we're dealing with results file...
		my $uid;
		foreach my $id (sort(keys(%{$uid_tt_entries}))) {
			my $who = ${$uid_tt_entries}{$id};
			if ($who eq "$class||$title||$teacher") {
				$uid = $id; 
				last;
			}
		}
		if (defined $uid) {	$output = $output." uid=\"$uid\""; }				
	# if tuple restrictions are specified		
		if ($restss ne "") {
		  foreach my $rests (split/;/,$restss) {
				my @rests = split/:/,$rests;
				my $rest_type = $rests[0];
				foreach my $rest_val (split/\,/,$rests[1]) {	
					$output = $output.">\n\t\t\t<restriction type=\"$rest_type\">$rest_val</restriction>";
				}
		  }
		  $output = $output."\n\t\t</subject>\n";
		} else { $output = $output."/>\n"; }
#	}
	return $output;
}
sub XML_chromo {	# chromo output
	my ($output,$form,$defined_tt_entries,$uid_tt_entries,$how) = @_;

	my $grade = $form->get_widget('label-chromo')->get_text;

	if ($grade) { 
		$output = $output."\n\t<chromo grade=\"$grade\">\n";

	  	while ((my $when, my $who) = each (%{$defined_tt_entries})) {	
	 		my $uid = (split/\|\|/,$who)[3];
	 		if ($uid) {
 				my $room = (split/\|\|/,$when)[0];
  				my $period = (split/\|\|/,$when)[1];
  				my $day = (split/\|\|/,$when)[2];
  			
	  			$output = $output."\t\t<gen period=\"$period\" day=\"$day\" room=\"$room\" uid=\"$uid\"/>\n";
	  		}
	 	}
		
		$output = $output."\t</chromo>\n";
	}	
	return $output;
#	${$uid_tt_entries}{$i} = "$class||$title||$teacher";	uid=>what, multiple whats!
#	${$defined_tt_entries}{"$room||$period||$day"} = "$class||$title||$teacher";	when=>what            

# 	<chromo grade="323">
# 		<gen period="1" day="0" room="Music Room" uid="1"/>
# 		<gen period="0" day="1" room="Music Room" uid="2"/>
# 		<gen period="1" day="3" room="JW" uid="3"/>
# 		<gen period="1" day="1" room="VW" uid="4"/>
}

####################################################################################################
####################################################################################################
# fet file format

sub fet_hours {
	my ($what,$form) = @_; 
	my @fet_hours;
	foreach my $info ($what->getChildNodes) {		
		if ($info->getFirstChild) {
			if ($info->nodeName eq "Number") { 
				my $no = $info->firstChild->data;
				$form->get_widget('entry_periods')->set_text($no);
			} elsif ($info->nodeName eq "Name") { 
				my $no = $info->firstChild->data;
				push (@fet_hours,$no);
			}
		}
	}
	my $count = 0;
	foreach my $hour (sort(@fet_hours)) {
		$fet_periods{$hour} = $count;
		$count++;
	}
}
sub fet_days {
	my ($what,$form) = @_; 
	my @fet_days;
	foreach my $info ($what->getChildNodes) {		
		if ($info->getFirstChild) {
			if ($info->nodeName eq "Number") { 
				my $no = $info->firstChild->data;
				$form->get_widget('entry_days')->set_text($no);
			} elsif ($info->nodeName eq "Name") { 
				my $no = $info->firstChild->data;
				push (@fet_days,$no);
			}
		}
	}
	my $count = 0;
	foreach my $hour (sort(@fet_days)) {
		$fet_days{$hour} = $count;
		$count++;
	}
}
sub fet_students {
	my ($what,$form) = @_; 
	my $tv_c = $form->get_widget('treeview_classs')->get_model;
	foreach my $year ($what->getChildNodes) {
		if ($year->getFirstChild) {
			my $named = "";
			foreach my $some ($year->getChildNodes) {
	 			if ($some->getFirstChild) {
	 				if ($some->nodeName eq "Name") { 			# year name
	 					$named = $some->firstChild->data;	
	 				} elsif ($some->nodeName eq "Group") { 	# class names
	 					my $class = "";
						foreach my $grp ($some->getChildNodes) {	# read groups info
							if ($grp->nodeName eq "Name") {
								my $no = $grp->firstChild->data;
								$class = $named." $no";
	 	 	 	 	 	 		my $row = &find_clist_row("classs",$class);
	 	 	 	 	 	 		if ($row eq "new") { # add group only if new
									$tv_c->set($tv_c->append,0,$class);
	 	 	 	 	 	 		} 
							} elsif ($grp->nodeName eq "Subgroup") { 
	 	 	 					foreach my $sgrp ($grp->getChildNodes) {	# read subgroups
	 	 							if ($sgrp->nodeName eq "Name") {
	 	 								my $no = $sgrp->firstChild->data;									
	 	 								$no = $named." $no";
										my $type = "conflicts-with:$class;";
	 	 	 	 	 	 	 	 		my $row = &find_clist_row("classs",$no);
	 	 	 	 	 	 	 	 		if ($row eq "new") {
	 	 	 	 	 	 	 	 			$tv_c->set($tv_c->append,0,$no,1,$type);
	 	 	 	 	 	 	 	 		} else {
											$row = $tv_c->get_iter_from_string($row);
	 										$tv_c->set($row,1,$type);
										}
	 	 							}
	 	 						}						
	 	 	 				} 
						}						
	 				} 
	 			}
	 		}
		}
	}
	&combo_change("classs");
}
sub fet_teachers {
	my ($what,$form) = @_; 
	my $tv_t = $form->get_widget('treeview_teachers')->get_model;
	foreach my $teacher ($what->getChildNodes) {		
		foreach my $name ($teacher->getChildNodes) {
			if ($name->getFirstChild) {
				if ($name->nodeName eq "Name") { 
					my $no = $name->firstChild->data;
					my $row = &find_clist_row("teachers",$no);
	 	 			if (($row eq "new") and (defined $no)) { # add teacher only if new
	 	 				$row = $tv_t->insert(undef,-1); 
	 	 				$tv_t->set($row,0,$no);
	 	 			} 				
				}
			}
		}
	}
	&combo_change("teachers");
}
sub fet_subjects {
	my ($what,$form) = @_; 
	my $tv_t = $form->get_widget('treeview_subjects')->get_model;
	foreach my $teacher ($what->getChildNodes) {		
		foreach my $name ($teacher->getChildNodes) {
			if ($name->getFirstChild) {
				if ($name->nodeName eq "Name") { 
					my $no = $name->firstChild->data;
	 	 			my $row = &find_clist_row("subjects",$no);
	 	 			if (($row eq "new") and (defined $no)) { # add subject only if new
	 	 				$tv_t->set($tv_t->append,0,$no);
	 	 			} 				
				}
			}
		}
	}
	&combo_change("subjects");
}
sub fet_activities {
	my ($what,$form) = @_; 
	my $tv_tt = $form->get_widget('treeview_tt')->get_model;
	my $tv_t = $form->get_widget('treeview_teachers')->get_model;
	foreach my $act ($what->getChildNodes) {		# each activity
		if ($act->getFirstChild) {
		my $teacher = "";
		my $subject = "";
		my $duration = "";
		my $total_duration = "";
		my $class = "";
		my $rests = "";
		my $id = "";
		my $aid = "";
		foreach my $some ($act->getChildNodes) {		# its preferences
			if ($some->nodeName eq "Teacher") {
				if ($teacher ne "") {
					$rests = $rests."teacher-also:$teacher;";
				} else {
					$teacher = $some->firstChild->data;
				}
			} elsif ($some->nodeName eq "Subject") {
				$subject = $some->firstChild->data;
	 			my $row = &add_to_tree($form,"teachers",$teacher,$subject);
	 	 		$tv_t->set($row,0,$teacher,1,$subject);
			} elsif ($some->nodeName eq "Duration") {
				$duration = $some->firstChild->data;
				if ($duration == 2) {
					$rests = $rests."double-period:$subject;";
				}
			} elsif ($some->nodeName eq "Total_Duration") {
				$total_duration = $some->firstChild->data;
			} elsif ($some->nodeName eq "Id") {
				$id = $some->firstChild->data;
			} elsif ($some->nodeName eq "Activity_Group_Id") {
				$aid = $some->firstChild->data;
			} elsif ($some->nodeName eq "Students") {
				$class = $some->firstChild->data;
				my $tv_c = $form->get_widget('treeview_classs')->get_model;
				$tv_c->foreach(sub {
					my (undef,undef,$child_iter) = @_; 	 	 		
 	 				my ($c) = $tv_c->get($child_iter,0);
					if ((split/ /,$c)[1] eq $class) {
						$class = $c;
						return 1;
					}
					return 0;
				});
			} elsif ($some->nodeName eq "Weekly") {
				
			} 			
		}
		my $row = &add_to_tree($form,'tt',$class,$subject);
		$tv_tt->set($row,0,$class,1,$subject,2,$teacher,3,$total_duration,7,$rests);
	} }
	&combo_change("teachers");
}	
sub fet_equipment {			# these will become capability places
	my ($what,$form) = @_; 
} 
sub fet_rooms {
	my ($what,$form) = @_; 
	my $tv_t = $form->get_widget('treeview_classrooms')->get_model;
	foreach my $teacher ($what->getChildNodes) {		
		if ($teacher->getFirstChild) {
		my $named = ""; my $type = "";
		foreach my $name ($teacher->getChildNodes) {
			if ($name->getFirstChild) {
				if ($name->nodeName eq "Name") { 
					$named = $name->firstChild->data;
				} elsif ($name->nodeName eq "Type") { 
					my $no = $name->firstChild->data;
					$type = $type."capability-place:$no;";
				} elsif ($name->nodeName eq "Equipment") { 
					my $no = $name->firstChild->data;
	 	 			$type = $type."capability-place:$no;";
				}
			}
		}
		my $row = &find_clist_row("classrooms",$named);
		if ($row eq "new") { # add room only if new
			$tv_t->set($tv_t->append,0,$named,1,$type);
		} else {
			$row = $tv_t->get_iter_from_string($row);
			$tv_t->set($row,1,$type);
		}
	} }
	&combo_change("classrooms");
}
sub fet_time_constraints {
	my ($what,$form) = @_; 
 	my $tv_m = $form->get_widget('treeview_modules')->get_model;
	foreach my $type ($what->getChildNodes) {	
		if ($type->getFirstChild) {
# no appropriate tablix module
			if ($type->nodeName eq "ConstraintTeacherNotAvailable") {
				my $weight; my $mand; my $teacher; my $day; my $h1; my $h2;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Teacher_Name") { $teacher = $param->firstChild->data;
						} elsif ($param->nodeName eq "Day") { $day = $param->firstChild->data;
						} elsif ($param->nodeName eq "Start_Hour") { $h1 = $param->firstChild->data;
						} elsif ($param->nodeName eq "End_Hour") { $h2 = $param->firstChild->data;
						}
					}
				}
				my $row = &find_clist_row ('teachers',$teacher);
	# setup restriction for teacher
				if ($row ne 'new') {
					my $tv_c = $form->get_widget('treeview_classs')->get_model;
					$row = $tv_c->get_iter_from_string($row);

				}
	# start the module

# preferred period, preferred day			
			} elsif ($type->nodeName eq "ConstraintActivityPreferredTimes") {
				my $weight; my $mand; my $id; my $day; my $hour; my $ptimes;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Activity_Id") { $id = $param->firstChild->data;
						} elsif ($param->nodeName eq "Number_of_Preferred_Times") { $ptimes = $param->firstChild->data;
						} elsif ($param->nodeName eq "Preferred_Time") { 
							foreach my $times ($param->getChildNodes) {
								if ($times->getFirstChild) {
									if ($times->nodeName eq 'Preferred_Day') { $day = $times->firstChild->data;
									} elsif ($times->nodeName eq 'Preferred_Hour') { $hour = $times->firstChild->data;
									} 
								}
							}
							
						} 
					}
				}
	# start the module
				if ($mand eq 'yes') { $mand = 1; } else { $mand = 0; }
	 	 	 	my $row = &find_clist_row ('modules','preferred.so');
				if ($row ne 'new') {
					$row = $tv_m->get_iter_from_string($row);
					$tv_m->set($row,1,$weight,2,$mand,3,1);
	 	 	 	}				
# no appropriate tablix module 					
			} elsif ($type->nodeName eq "ConstraintActivityEndsDay") {
				my $weight; my $mand; my $id;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Activity_Id") { $id = $param->firstChild->data;
						}
					}
				}			
# class_freeperiod
			} elsif ($type->nodeName eq "ConstraintStudentsSetNotAvailable") {
				my $weight; my $mand; my $class; my $day; my $h1; my $h2;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Students") { $class = $param->firstChild->data;
						} elsif ($param->nodeName eq "Day") { $day = $param->firstChild->data;
						} elsif ($param->nodeName eq "Start_Hour") { $h1 = $param->firstChild->data;
						} elsif ($param->nodeName eq "End_Hour") { $h2 = $param->firstChild->data;
						}
					}
				}
				my $row = &find_clist_row ('classs',$class);
	# setup restriction for class
				if ($row ne 'new') {
					my $tv_c = $form->get_widget('treeview_classs')->get_model;
					$row = $tv_c->get_iter_from_string($row);
					for (my $c = $fet_periods{$h1}; $c <= $fet_periods{$h2}; $c++) {
						my $rests = $tv_c->get($row,1);
						$tv_c->set($row,1,"free-period:$c;$rests");
					}
	# start the module
	 				if ($mand eq 'yes') { $mand = 1; } else { $mand = 0; }
	 	 	 	 	$row = &find_clist_row ('modules','class_freeperiod.so');
	 				if ($row ne 'new') {
	 					$row = $tv_m->get_iter_from_string($row);
	 					$tv_m->set($row,1,$weight,2,$mand,3,1);
	 	 	 	 	}
				}
# no appropriate tablix module 				
			} elsif ($type->nodeName eq "ConstraintBasicCompulsoryTime") {
				my $weight; my $mand;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						}
					}
				}				
# student-holes
			} elsif ($type->nodeName eq "ConstraintStudentsNoGaps") {
				my $weight; my $mand;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						}
					}
				}	
	# start the module
				if ($mand eq 'yes') { $mand = 1; } else { $mand = 0; }
	 	 	 	my $row = &find_clist_row ('modules','student_holes.so');
				if ($row ne 'new') {
					$row = $tv_m->get_iter_from_string($row);
					$tv_m->set($row,1,$weight,2,$mand,3,1);
	 	 	 	}
			} 
		}
	}
}
sub fet_space_constraints {
	my ($what,$form) = @_; 
	foreach my $type ($what->getChildNodes) {	
		if ($type->getFirstChild) {
# no appropriate tablix module 		
			if ($type->nodeName eq "ConstraintBasicCompulsorySpace") {
			
# no appropriate tablix module 		
			} elsif ($type->nodeName eq "ConstraintRoomTypeNotAllowedSubjects") {
			
			} 
		}
	}
}

return 1;
