/*
 * Copyright (C) 1995,1996, 1998 Eric M. Ludlam
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * $Log: xphone.h,v $
 * Revision 1.2  1998/10/11 14:03:23  zappo
 * Added click commands into the main structure.
 *
 * Revision 1.1  1998/10/11 13:38:01  zappo
 * Initial revision
 *
 * Revision 1.6  1996/01/06  02:33:52  zappo
 * Updated some copywrite stuff and added name field to context
 *
 * Revision 1.5  1995/12/10  03:59:33  zappo
 * Updated some copyright information
 *
 * Revision 1.4  1995/07/21  02:22:56  zappo
 * Changed version number
 *
 * Revision 1.3  1995/07/08  16:26:40  zappo
 * Added GCs to context.  These specify the colors used by the phone icon
 *
 * Revision 1.2  1995/05/09  23:47:26  zappo
 * Fixed some prototypes
 *
 * Revision 1.1  1995/04/18  22:25:22  zappo
 * Initial revision
 *
 */

#ifndef XPHONE_

#define XPHONE_ "XPHONE version 0.3 (c) 1995,1996 Eric M. Ludlam for Free Software Foundation"

/*
 * lets define the context used thoughout this program.
 */
struct PhoneContext {
  char               *myname;		/* username we are listening for */
  struct HostObject  *me;		/* The current host.            */
  int                 ringerflag;       /* flag saying the ringer is on */
  struct InputDevice *udp_ring;	        /* udp port to use for ring svc */
  struct InputDevice *x_dev;	        /* descriptor used by X         */
  pid_t               pid;		/* pid, (autoconf makes pid_t)  */
  int                 ringing;	        /* is the phone ringing?        */
  int                 silent;	        /* are we running silently?     */
  char               *ringcommand;      /* command used to ring phone   */
  char               *clickinactivecommand; /* command inactive click   */
  char               *clickactivecommand;   /* command inactive click   */
  /* The following are things we need to know about Xwindows            */
  Display            *display;
  Window              window;
  Pixmap              idle;
  GC                  idle_gc;
  Pixmap              active;
  GC                  active_gc;
};

#ifdef PROTOTYPES
/* xphone.c */
extern void XPH_read(struct PhoneContext *Ctxt, struct InputDevice *dev);
extern void xphone_shutdown();
extern void XPH_xread(struct PhoneContext *Ctxt, struct InputDevice *dev);
extern void XPH_noring(struct PhoneContext *Ctxt, struct InputDevice *dev);
extern void XPH_draw_picture(struct PhoneContext *Ctxt, struct InputDevice *dev);

#else
/* xphone.c */
extern void XPH_read();
extern void xphone_shutdown();
extern void XPH_xread();
extern void XPH_noring();
extern void XPH_draw_picture();

#endif /* PROTOTYPES */

#endif /* PHONE_ */


