/* simple-feed-view.vala
 *
 * Copyright (C) 2008 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#include "simple-feed-view.h"
#include <gtk/gtk.h>
#include <rss-glib/rss-glib.h>
#include <stdlib.h>
#include <string.h>
#include <webkit/webkit.h>
#include <gtask/gtask.h>
#include <gio/gio.h>
#include <stdio.h>




static glong string_get_length (const char* self);
struct _SimpleFeedViewMainPrivate {
	GtkWindow* window;
	GtkEntry* entry;
	RssDocument* document;
	char* url_base;
	char* generated;
	char* content;
	gulong content_length;
	WebKitWebView* webview;
};

#define SIMPLE_FEED_VIEW_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SIMPLE_FEED_VIEW_TYPE_MAIN, SimpleFeedViewMainPrivate))
enum  {
	SIMPLE_FEED_VIEW_MAIN_DUMMY_PROPERTY
};
static GValue* simple_feed_view_main_retrieve_url (SimpleFeedViewMain* self, GTask* task);
static GValue* simple_feed_view_main_build_content (SimpleFeedViewMain* self, GTask* task);
static GValue* simple_feed_view_main_convert (SimpleFeedViewMain* self, GTask* task);
static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self);
static GValue* _simple_feed_view_main_retrieve_url_gtask_func (GTask* task, gpointer self);
static GValue* _simple_feed_view_main_build_content_gtask_func (GTask* task, gpointer self);
static GValue* _g_value_dup (GValue* self);
static GValue* __lambda1 (GTask* _, SimpleFeedViewMain* self);
static GValue* ___lambda1_gtask_callback (GTask* task, GValue* result, gpointer self);
static GValue* _simple_feed_view_main_convert_gtask_func (GTask* task, gpointer self);
static GValue* __lambda2 (GTask* _, SimpleFeedViewMain* self);
static GValue* ___lambda2_gtask_callback (GTask* task, GValue* result, gpointer self);
static GValue* __lambda3 (GTask* _, SimpleFeedViewMain* self);
static GValue* ___lambda3_gtask_callback (GTask* task, GValue* result, gpointer self);
static void __lambda0 (GtkButton* _, SimpleFeedViewMain* self);
static void ___lambda0_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * simple_feed_view_main_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer simple_feed_view_main_parent_class = NULL;
static void simple_feed_view_main_finalize (GObject* obj);
static gint simple_feed_view_main (char** args, int args_length1);

static const GOptionEntry SIMPLE_FEED_VIEW_options[] = {{NULL}};


static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


static GValue* simple_feed_view_main_retrieve_url (SimpleFeedViewMain* self, GTask* task) {
	GError * inner_error;
	0;
	0;
	inner_error = NULL;
	g_debug ("simple-feed-view.vala:115: retrieving url '%s'", self->priv->url_base);
	{
		char* etag;
		GFile* _tmp1;
		GFile* file;
		const char* _tmp9;
		char* _tmp8;
		gboolean _tmp7;
		const char* _tmp6;
		const char* _tmp5;
		char* _tmp4;
		gboolean _tmp3;
		const char* _tmp2;
		if (self->priv->url_base == NULL) {
			return NULL;
		}
		etag = NULL;
		_tmp1 = NULL;
		file = (_tmp1 = g_vfs_get_file_for_uri (g_vfs_get_default (), self->priv->url_base), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp2 = NULL;
		_tmp7 = (_tmp3 = g_file_load_contents (file, NULL, &_tmp2, &self->priv->content_length, &_tmp6, &inner_error), self->priv->content = (_tmp4 = (_tmp5 = _tmp2, (_tmp5 == NULL ? NULL : g_strdup (_tmp5))), (self->priv->content = (g_free (self->priv->content), NULL)), _tmp4), _tmp3);
		etag = (_tmp8 = (_tmp9 = _tmp6, (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (etag = (g_free (etag), NULL)), _tmp8);
		_tmp7;
		if (inner_error != NULL) {
			goto __catch0_g_error;
		}
		etag = (g_free (etag), NULL);
		(file == NULL ? NULL : (file = (g_object_unref (file), NULL)));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_warning ("simple-feed-view.vala:126: Error retrieving data");
			g_warning ("simple-feed-view.vala:127: %s", error->message);
			(error == NULL ? NULL : (error = (g_error_free (error), NULL)));
		}
	}
	__finally0:
	;
	return NULL;
}


static GValue* simple_feed_view_main_build_content (SimpleFeedViewMain* self, GTask* task) {
	GError * inner_error;
	RssParser* parser;
	GValue* _tmp2 = {0};
	0;
	0;
	inner_error = NULL;
	g_debug ("simple-feed-view.vala:133: Building content for '%s'", self->priv->url_base);
	parser = rss_parser_new ();
	{
		if (self->priv->content != NULL && string_get_length (self->priv->content) > 0) {
			RssDocument* _tmp0;
			rss_parser_load_from_data (parser, self->priv->content, self->priv->content_length, &inner_error);
			if (inner_error != NULL) {
				goto __catch1_g_error;
			}
			_tmp0 = NULL;
			self->priv->document = (_tmp0 = rss_parser_get_document (parser), (self->priv->document == NULL ? NULL : (self->priv->document = (g_object_unref (self->priv->document), NULL))), _tmp0);
			g_debug ("simple-feed-view.vala:140: document parsed");
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * __err;
		__err = inner_error;
		inner_error = NULL;
		{
			RssDocument* _tmp1;
			g_debug ("simple-feed-view.vala:144: Could not parse data");
			_tmp1 = NULL;
			self->priv->document = (_tmp1 = NULL, (self->priv->document == NULL ? NULL : (self->priv->document = (g_object_unref (self->priv->document), NULL))), _tmp1);
		}
	}
	__finally1:
	;
	return (_tmp2 = NULL, (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), _tmp2);
}


static GValue* simple_feed_view_main_convert (SimpleFeedViewMain* self, GTask* task) {
	GString* sb;
	RssDocument* _tmp6;
	char* _tmp8;
	const char* _tmp7;
	GValue* _tmp9 = {0};
	0;
	0;
	sb = g_string_new ("");
	if (self->priv->document == NULL) {
		GValue* _tmp0 = {0};
		return (_tmp0 = NULL, (sb == NULL ? NULL : (sb = (g_string_free (sb, TRUE), NULL))), _tmp0);
	}
	{
		GList* item_collection;
		GList* item_it;
		item_collection = rss_document_get_items (self->priv->document);
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			RssItem* item;
			item = ((RssItem*) (item_it->data));
			{
				char* _tmp5;
				char* _tmp4;
				char* _tmp3;
				char* _tmp2;
				char* _tmp1;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				g_string_prepend (sb, (_tmp5 = g_strdup_printf ("<h1>%s</h1><h3>%s %s</h3><p>%s</p>", (g_object_get (G_OBJECT (item), "title", &_tmp1, NULL), _tmp1), (g_object_get (G_OBJECT (item), "author", &_tmp2, NULL), _tmp2), (g_object_get (G_OBJECT (item), "pub-date", &_tmp3, NULL), _tmp3), (g_object_get (G_OBJECT (item), "description", &_tmp4, NULL), _tmp4))));
				_tmp5 = (g_free (_tmp5), NULL);
				_tmp4 = (g_free (_tmp4), NULL);
				_tmp3 = (g_free (_tmp3), NULL);
				_tmp2 = (g_free (_tmp2), NULL);
				_tmp1 = (g_free (_tmp1), NULL);
			}
		}
		(item_collection == NULL ? NULL : (item_collection = (g_list_free (item_collection), NULL)));
	}
	_tmp6 = NULL;
	self->priv->document = (_tmp6 = NULL, (self->priv->document == NULL ? NULL : (self->priv->document = (g_object_unref (self->priv->document), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->priv->generated = (_tmp8 = (_tmp7 = sb->str, (_tmp7 == NULL ? NULL : g_strdup (_tmp7))), (self->priv->generated = (g_free (self->priv->generated), NULL)), _tmp8);
	return (_tmp9 = NULL, (sb == NULL ? NULL : (sb = (g_string_free (sb, TRUE), NULL))), _tmp9);
}


SimpleFeedViewMain* simple_feed_view_main_construct (GType object_type) {
	SimpleFeedViewMain * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


SimpleFeedViewMain* simple_feed_view_main_new (void) {
	return simple_feed_view_main_construct (SIMPLE_FEED_VIEW_TYPE_MAIN);
}


static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
	gtk_main_quit ();
}


static GValue* _simple_feed_view_main_retrieve_url_gtask_func (GTask* task, gpointer self) {
	return simple_feed_view_main_retrieve_url (self, task);
}


static GValue* _simple_feed_view_main_build_content_gtask_func (GTask* task, gpointer self) {
	return simple_feed_view_main_build_content (self, task);
}


static GValue* _g_value_dup (GValue* self) {
	return g_memdup (self, sizeof (GValue));
}


static GValue* __lambda1 (GTask* _, SimpleFeedViewMain* self) {
	GValue _tmp0 = {0};
	GValue val;
	GTask* _tmp1;
	GValue* _tmp4 = {0};
	GValue _tmp3 = {0};
	GValue _tmp2 = {0};
	GValue* _tmp5 = {0};
	0;
	val = (g_value_init (&_tmp0, G_TYPE_OBJECT), _tmp0);
	_tmp1 = NULL;
	g_value_set_object (&val, ((GObject*) ((_tmp1 = g_task_new (_simple_feed_view_main_build_content_gtask_func, self, NULL)))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	return (_tmp5 = (_tmp4 = (_tmp3 = (_tmp2 = val), &_tmp3), (_tmp4 == NULL ? NULL : _g_value_dup (_tmp4))), g_value_unset (&_tmp2), _tmp5);
}


static GValue* ___lambda1_gtask_callback (GTask* task, GValue* result, gpointer self) {
	return __lambda1 (task, self);
}


static GValue* _simple_feed_view_main_convert_gtask_func (GTask* task, gpointer self) {
	return simple_feed_view_main_convert (self, task);
}


static GValue* __lambda2 (GTask* _, SimpleFeedViewMain* self) {
	GValue _tmp0 = {0};
	GValue val;
	GTask* _tmp1;
	GValue* _tmp4 = {0};
	GValue _tmp3 = {0};
	GValue _tmp2 = {0};
	GValue* _tmp5 = {0};
	0;
	val = (g_value_init (&_tmp0, G_TYPE_OBJECT), _tmp0);
	_tmp1 = NULL;
	g_value_set_object (&val, ((GObject*) ((_tmp1 = g_task_new (_simple_feed_view_main_convert_gtask_func, self, NULL)))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	return (_tmp5 = (_tmp4 = (_tmp3 = (_tmp2 = val), &_tmp3), (_tmp4 == NULL ? NULL : _g_value_dup (_tmp4))), g_value_unset (&_tmp2), _tmp5);
}


static GValue* ___lambda2_gtask_callback (GTask* task, GValue* result, gpointer self) {
	return __lambda2 (task, self);
}


static GValue* __lambda3 (GTask* _, SimpleFeedViewMain* self) {
	0;
	g_debug ("simple-feed-view.vala:96: loading webview");
	if (self->priv->webview == NULL || self->priv->url_base == NULL) {
		return NULL;
	}
	if (self->priv->generated != NULL) {
		webkit_web_view_load_html_string (self->priv->webview, self->priv->generated, self->priv->url_base);
	}
	return NULL;
}


static GValue* ___lambda3_gtask_callback (GTask* task, GValue* result, gpointer self) {
	return __lambda3 (task, self);
}


static void __lambda0 (GtkButton* _, SimpleFeedViewMain* self) {
	char* _tmp1;
	const char* _tmp0;
	GTask* task;
	GTaskScheduler* _tmp2;
	g_return_if_fail (_ != NULL);
	/* store the url to prevent race */
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->url_base = (_tmp1 = (_tmp0 = gtk_entry_get_text (self->priv->entry), (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (self->priv->url_base = (g_free (self->priv->url_base), NULL)), _tmp1);
	/* asynchronously get the url */
	task = g_task_new (_simple_feed_view_main_retrieve_url_gtask_func, self, NULL);
	g_task_add_callback (task, ___lambda1_gtask_callback, self, NULL);
	g_task_add_callback (task, ___lambda2_gtask_callback, self, NULL);
	g_task_add_callback (task, ___lambda3_gtask_callback, self, NULL);
	_tmp2 = NULL;
	g_task_scheduler_schedule ((_tmp2 = g_task_scheduler_get_default ()), task);
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	(task == NULL ? NULL : (task = (g_object_unref (task), NULL)));
}


static void ___lambda0_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda0 (_sender, self);
}


static GObject * simple_feed_view_main_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	SimpleFeedViewMainClass * klass;
	GObjectClass * parent_class;
	SimpleFeedViewMain * self;
	klass = SIMPLE_FEED_VIEW_MAIN_CLASS (g_type_class_peek (SIMPLE_FEED_VIEW_TYPE_MAIN));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SIMPLE_FEED_VIEW_MAIN (obj);
	{
		GtkWindow* _tmp0;
		GtkVBox* vbox;
		GtkHBox* hbox;
		GtkButton* go;
		GtkEntry* _tmp1;
		GtkScrolledWindow* sw;
		WebKitWebView* _tmp2;
		_tmp0 = NULL;
		self->priv->window = (_tmp0 = g_object_ref_sink (((GtkWindow*) (gtk_window_new (GTK_WINDOW_TOPLEVEL)))), (self->priv->window == NULL ? NULL : (self->priv->window = (g_object_unref (self->priv->window), NULL))), _tmp0);
		gtk_window_set_default_size (self->priv->window, 600, 400);
		g_signal_connect (((GtkObject*) (self->priv->window)), "destroy", ((GCallback) (_gtk_main_quit_gtk_object_destroy)), NULL);
		gtk_widget_show (((GtkWidget*) (self->priv->window)));
		vbox = g_object_ref_sink (((GtkVBox*) (gtk_vbox_new (FALSE, 0))));
		gtk_container_add (((GtkContainer*) (self->priv->window)), ((GtkWidget*) (vbox)));
		gtk_widget_show (((GtkWidget*) (vbox)));
		hbox = g_object_ref_sink (((GtkHBox*) (gtk_hbox_new (FALSE, 0))));
		gtk_box_pack_start (((GtkBox*) (vbox)), ((GtkWidget*) (hbox)), FALSE, TRUE, ((guint) (2)));
		gtk_widget_show (((GtkWidget*) (hbox)));
		go = g_object_ref_sink (((GtkButton*) (gtk_button_new_from_stock (GTK_STOCK_GO_FORWARD))));
		_tmp1 = NULL;
		self->priv->entry = (_tmp1 = g_object_ref_sink (((GtkEntry*) (gtk_entry_new ()))), (self->priv->entry == NULL ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL))), _tmp1);
		gtk_entry_set_text (self->priv->entry, "http://planet.gnome.org/atom.xml");
		gtk_box_pack_start (((GtkBox*) (hbox)), ((GtkWidget*) (self->priv->entry)), TRUE, TRUE, ((guint) (6)));
		gtk_widget_show (((GtkWidget*) (self->priv->entry)));
		sw = g_object_ref_sink (((GtkScrolledWindow*) (gtk_scrolled_window_new (NULL, NULL))));
		gtk_scrolled_window_set_policy (sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_box_pack_start (((GtkBox*) (vbox)), ((GtkWidget*) (sw)), TRUE, TRUE, ((guint) (0)));
		gtk_widget_show (((GtkWidget*) (sw)));
		_tmp2 = NULL;
		self->priv->webview = (_tmp2 = g_object_ref_sink (((WebKitWebView*) (webkit_web_view_new ()))), (self->priv->webview == NULL ? NULL : (self->priv->webview = (g_object_unref (self->priv->webview), NULL))), _tmp2);
		gtk_container_add (((GtkContainer*) (sw)), ((GtkWidget*) (self->priv->webview)));
		gtk_widget_show (((GtkWidget*) (self->priv->webview)));
		g_signal_connect_object (go, "clicked", ((GCallback) (___lambda0_gtk_button_clicked)), self, 0);
		gtk_box_pack_start (((GtkBox*) (hbox)), ((GtkWidget*) (go)), FALSE, TRUE, ((guint) (6)));
		gtk_widget_show (((GtkWidget*) (go)));
		(vbox == NULL ? NULL : (vbox = (g_object_unref (vbox), NULL)));
		(hbox == NULL ? NULL : (hbox = (g_object_unref (hbox), NULL)));
		(go == NULL ? NULL : (go = (g_object_unref (go), NULL)));
		(sw == NULL ? NULL : (sw = (g_object_unref (sw), NULL)));
	}
	return obj;
}


static void simple_feed_view_main_class_init (SimpleFeedViewMainClass * klass) {
	simple_feed_view_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SimpleFeedViewMainPrivate));
	G_OBJECT_CLASS (klass)->constructor = simple_feed_view_main_constructor;
	G_OBJECT_CLASS (klass)->finalize = simple_feed_view_main_finalize;
}


static void simple_feed_view_main_instance_init (SimpleFeedViewMain * self) {
	self->priv = SIMPLE_FEED_VIEW_MAIN_GET_PRIVATE (self);
}


static void simple_feed_view_main_finalize (GObject* obj) {
	SimpleFeedViewMain * self;
	self = SIMPLE_FEED_VIEW_MAIN (obj);
	(self->priv->window == NULL ? NULL : (self->priv->window = (g_object_unref (self->priv->window), NULL)));
	(self->priv->entry == NULL ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL)));
	(self->priv->document == NULL ? NULL : (self->priv->document = (g_object_unref (self->priv->document), NULL)));
	self->priv->url_base = (g_free (self->priv->url_base), NULL);
	self->priv->generated = (g_free (self->priv->generated), NULL);
	self->priv->content = (g_free (self->priv->content), NULL);
	(self->priv->webview == NULL ? NULL : (self->priv->webview = (g_object_unref (self->priv->webview), NULL)));
	G_OBJECT_CLASS (simple_feed_view_main_parent_class)->finalize (obj);
}


GType simple_feed_view_main_get_type (void) {
	static GType simple_feed_view_main_type_id = 0;
	if (simple_feed_view_main_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (SimpleFeedViewMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_feed_view_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleFeedViewMain), 0, (GInstanceInitFunc) simple_feed_view_main_instance_init, NULL };
		simple_feed_view_main_type_id = g_type_register_static (G_TYPE_OBJECT, "SimpleFeedViewMain", &g_define_type_info, 0);
	}
	return simple_feed_view_main_type_id;
}


static gint simple_feed_view_main (char** args, int args_length1) {
	GError * inner_error;
	SimpleFeedViewMain* m;
	gint _tmp1;
	inner_error = NULL;
	if (!g_thread_supported ()) {
		g_error ("simple-feed-view.vala:176: Threads are not supported on your platform!");
	}
	{
		GOptionContext* context;
		context = g_option_context_new ("- a simple rss viewer");
		g_option_context_set_help_enabled (context, TRUE);
		g_option_context_add_main_entries (context, SIMPLE_FEED_VIEW_options, NULL);
		g_option_context_add_group (context, gtk_get_option_group (TRUE));
		g_option_context_parse (context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		(context == NULL ? NULL : (context = (g_option_context_free (context), NULL)));
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			gint _tmp0;
			fprintf (stdout, "%s\n", error->message);
			fprintf (stdout, "Run '%s --help' for command list.\n", args[0]);
			return (_tmp0 = 1, (error == NULL ? NULL : (error = (g_error_free (error), NULL))), _tmp0);
		}
	}
	__finally2:
	;
	g_set_application_name ("SimpleFeedView");
	gtk_init (&args_length1, &args);
	m = simple_feed_view_main_new ();
	gtk_main ();
	return (_tmp1 = 0, (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp1);
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return simple_feed_view_main (argv, argc);
}




