#@iconSizes = ( 22,                  32,           22,        16,         16,                  48           );
# KDE Uses 32x32 for dialogs, and 16x16 for buttons
@iconSizes = ( 22,                  32,        16,           16,         16,                  32           );
@gtk       = ( "gtk-large-toolbar", "gtk-dnd", "gtk-button", "gtk-menu", "gtk-small-toolbar", "gtk-dialog" );
$numSizes=$#iconSizes+1;

if ($ARGV[0])
{
    $base=$ARGV[0];
}

if($ARGV[1] == "3")
{
    $base=join("", $base, "/default.kde/");
}
else
{
    $base=join("", $base, "/oxygen/");
}

open(icons, "icons$ARGV[1]") || die "Could not open \"icons\"\n";

sub checkSize
{
    $fname=join("", $_[0], $_[1], "x", $_[1], "/", $_[2]);
    if (open(tst, $fname))
    {
        close(tst);
        $fname;
    }
    else
    {
        "";
    }
}

sub printSize
{
    if($_[0])
    {
        print "\t\t{ \"$_[1]x$_[1]/$_[2]\", *, *, \"$_[3]\" },\n";
        $_[4]--;
    }
}

print "\nstyle \"KDE$ARGV[1]-icons\"\n{\n";

while($entry=<icons>)
{
    @iconMap=split(/ /, $entry);

    for($i=0; $i<$#iconMap; $i++)
    {
        $iconMap[$i+1]=~s/\n//;
    }

    if($iconMap[1] == /WHAT/)
    {
        $got=0;
        $use=0;
        for($i=0; $i<$#iconMap && $use == 0; $i++)
        {
            for($index=0; $index<$numSizes; $index++)
            {
                $files[$index]=checkSize($base, $iconSizes[$index], $iconMap[$i+1]);
                if($files[$index])
                {
                    $got++;
                }
            }

            if($got)
            {
                $use=$i+1;
            }
        }

        if($got)
        {
            print "\tstock[\"$iconMap[0]\"]={\n";
            if($got > 1)
            {
                for($index=0; $index<$numSizes; $index++)
                {
                    $got=printSize($files[$index], $iconSizes[$index], $iconMap[$use], $gtk[$index], $got);
                }
            }
            $found=0;
            for($index=0; $index<$numSizes && !$found; $index++)
            {
                if($files[$index])
                {
                    print "\t\t{ \"$iconSizes[$index]x$iconSizes[$index]/$iconMap[$use]\" }\n";
                    $found=1;
                }
            }
            print "\t}\n";
        }
        else
        {
            print "#\tstock[\"$iconMap[0]\"]=<No matching KDE icon>\n";
        }
    }
}
print "}\nclass \"*\" style \"KDE$ARGV[1]-icons\"\n";

close(icons);
