/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <config.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "gtkballs.h"
#include "interface.h"
#include "scoreboard.h"
#include "preferences.h"
#include "path.h"
#include "themerc.h"
#include "gfx.h"

GdkPixmap *Pixmap=NULL;

GtkbTheme *gtkbTheme=NULL;

/* Balls that shows what colors will appear on next turn */
GtkWidget **SmallBalls;

/* Number and color of the jumping ball */
gint Jumping_ball=0;
gint Jumping_ball_color=0;

gint AnimationInProgress=FALSE;

/*some file/dir names*/
gchar *installpath=DATADIR "/gtkballs/themes/";
gchar *themeprefix="/.gtkballs/themes/";

/* not used. just experimenting... =/ */
void gtk_usleep(gint x) {
        GTimeVal begin_time, now_time;

        g_get_current_time(&begin_time);
        do {
        	g_get_current_time(&now_time);
		gtk_main_iteration_do(FALSE);
        } while(now_time.tv_usec+(now_time.tv_sec-begin_time.tv_sec)*1000000-begin_time.tv_usec < x);
}

/* get time and print it to stderr... not used. */
void timestamp(void) {
        struct timeval tv;
	struct timezone tz;

	gettimeofday(&tv, &tz);
        fprintf(stderr, "%d.%06d\n", (int)tv.tv_sec, (int)tv.tv_usec);
}

void my_usleep(gint x) {
        struct timeval st_delay;

        if(!x) return;
        st_delay.tv_usec=x;
        st_delay.tv_sec=0;
        select(32, NULL, NULL, NULL, &st_delay);
}

gchar *find_theme_path(gchar *themename) {
  	gchar *homedir;
  	gchar *themepath;
  	struct stat buf;

  	if((homedir=getenv("HOME")) && (themepath=g_strconcat(homedir,themeprefix,themename,G_DIR_SEPARATOR_S,NULL))) {
  		if(!stat(themepath,&buf) && S_ISDIR(buf.st_mode)) {
			return themepath;
        	}
        	g_free(themepath);
	}
  	if((themepath=g_strconcat(installpath,themename,G_DIR_SEPARATOR_S,NULL))) {
        	if(!stat(themepath,&buf) && S_ISDIR(buf.st_mode)) {
			return themepath;
        	}
        	g_free(themepath);
  	}
  	return NULL;
}

gint gtkb_load_pixmap(GtkbPixmap *pixmap, gchar *path, gchar *pixmapname) {
        gchar *fname;

        if(!(fname=g_strconcat(path, pixmapname, NULL))) {
                return 0;
        }
  	if(pixmap->pixmap) g_object_unref(pixmap->pixmap);
  	if(pixmap->mask) g_object_unref(pixmap->mask);
        pixmap->pixmap=gdk_pixmap_create_from_xpm(MainWindow->window, &pixmap->mask, &MainStyle->bg[GTK_STATE_NORMAL], fname);
  	if(!pixmap->pixmap) {
        	perror(fname);
        	g_free(fname);
        	return 0;
  	}
        g_free(fname);
  	gdk_drawable_get_size(GDK_DRAWABLE(pixmap->pixmap), &pixmap->xsize, &pixmap->ysize);
  	return 1;
}

void gtkb_pixmap_free(GtkbPixmap pixmap) {
	if(pixmap.pixmap) {
                g_object_unref(pixmap.pixmap);
        }
	if(pixmap.mask) {
                g_object_unref(pixmap.mask);
        }
}

void gtkb_theme_free(GtkbTheme *theme) {
        gint i,j;

        if(!theme) {
                return;
        }
	gtkb_pixmap_free(theme->emptycell);
        for(i=0;i<8;i++) {
		gtkb_pixmap_free(theme->paws[i]);
        }
        if(theme->balls) {
        	for(i=0;i<theme->numballs;i++) {
        		gtkb_pixmap_free(theme->balls[i].ball);
	        	gtkb_pixmap_free(theme->balls[i].small);
        	        if(theme->balls[i].jump) {
                		for(j=0;j<theme->balls[i].jumpphases;j++) {
                			gtkb_pixmap_free(theme->balls[i].jump[j]);
	                	}
        	        	g_free(theme->balls[i].jump);
                		if(theme->balls[i].jumpdelays) {
					g_free(theme->balls[i].jumpdelays);
	                        }
        	        }
                	if(theme->balls[i].destroy) {
                		for(j=0;j<theme->balls[i].destroyphases;j++) {
                			gtkb_pixmap_free(theme->balls[i].destroy[j]);
	                	}
        	        	g_free(theme->balls[i].destroy);
                		if(theme->balls[i].destroydelays) {
                			g_free(theme->balls[i].destroydelays);
	                        }
        	        }
	        }
        }
        g_free(theme->balls);
        g_free(theme);
}

gint gtkb_theme_free_handler(GtkWidget *widget, gpointer data) {
        gtkb_theme_free(gtkbTheme);
        gtkbTheme=NULL;
        return 0;
}

#define CHECKRET(ret,cond) \
        if(ret==cond) { \
                gtkb_theme_free(theme); \
        	trc_close(trc); \
		return NULL; \
        }

GtkbTheme *gtkb_load_theme(gchar *themepath) {
        gchar **trc,*val,*opt;
        gchar *paws[]={"down_up", "left_right", "up_down", "right_left", "down_right", "down_left", "up_right", "up_left", NULL};
        gint  i,j,ret;
        GtkbTheme *theme;

        /* all glib memory allocation functions will terminate programm on failure, so
	   we dont check it's return status... */
        opt=g_strconcat(themepath, "themerc", NULL);
        trc=trc_open(opt); /* open theme description file */
        g_free(opt);
        if(!trc) {
		return NULL;
        }
        theme=g_new0(GtkbTheme, 1);

        /* find and load "empty cell" pixmap. */
        val=trc_get_str(trc, "cell");
	CHECKRET(val, NULL);
        ret=gtkb_load_pixmap(&theme->emptycell, themepath, val);
        g_free(val);
	CHECKRET(ret, 0);

        /* find and load "footprints" pixmaps. */
        for(i=0;paws[i];i++) {
                opt=g_strconcat("paw.", paws[i], NULL);
                val=trc_get_str(trc, opt);
                g_free(opt);
		CHECKRET(val, NULL);
        	ret=gtkb_load_pixmap(&theme->paws[i], themepath, val);
                g_free(val);
		CHECKRET(ret, 0);
        }

        /* query number of available balls in theme */
        theme->numballs=trc_get_uint(trc, "ball.numbers");
	CHECKRET(theme->numballs, -1);
        if(theme->numballs<Rules.colors) CHECKRET(0, 0); /* yes, i know. its ugly =) */
        theme->balls=g_new0(GtkbBall, theme->numballs);

        /* find and load all balls data. */
        for(i=0;i<theme->numballs;i++) {
                opt=g_strdup_printf("ball.%d.still", i+1);
                val=trc_get_str(trc, opt);
                g_free(opt);
                CHECKRET(val, NULL);
                ret=gtkb_load_pixmap(&theme->balls[i].ball, themepath, val);
                g_free(val);
                CHECKRET(ret, 0);

                opt=g_strdup_printf("ball.%d.small", i+1);
                val=trc_get_str(trc, opt);
                g_free(opt);
                CHECKRET(val, NULL);
                ret=gtkb_load_pixmap(&theme->balls[i].small, themepath, val);
                g_free(val);
                CHECKRET(ret, 0);

                opt=g_strdup_printf("ball.%d.jump.numbers", i+1);
                theme->balls[i].jumpphases=trc_get_uint(trc, opt);
                g_free(opt);
		CHECKRET(theme->balls[i].jumpphases, -1);
        	if(theme->balls[i].jumpphases<2) CHECKRET(0, 0); /* yes, i know. its ugly =) */
                theme->balls[i].jump=g_new0(GtkbPixmap, theme->balls[i].jumpphases);
                theme->balls[i].jumpdelays=g_new0(gint, theme->balls[i].jumpphases);

                for(j=0;j<theme->balls[i].jumpphases;j++) {
                	opt=g_strdup_printf("ball.%d.jump.%d", i+1, j+1);
                	val=trc_get_str(trc, opt);
                	g_free(opt);
                	CHECKRET(val, NULL);
                	ret=gtkb_load_pixmap(&theme->balls[i].jump[j], themepath, val);
                	g_free(val);
                	CHECKRET(ret, 0);

                	opt=g_strdup_printf("ball.%d.jump.%d.usec", i+1, j+1);
                        theme->balls[i].jumpdelays[j]=trc_get_uint(trc, opt);
                	g_free(opt);
                	CHECKRET(theme->balls[i].jumpdelays[j], -1);
                }

                opt=g_strdup_printf("ball.%d.destroy.numbers", i+1);
                theme->balls[i].destroyphases=trc_get_uint(trc, opt);
                g_free(opt);
		CHECKRET(theme->balls[i].destroyphases, -1);
        	if(theme->balls[i].destroyphases<2) CHECKRET(0, 0); /* yes, i know. its ugly =) */
                theme->balls[i].destroy=g_new0(GtkbPixmap, theme->balls[i].destroyphases);
                theme->balls[i].destroydelays=g_new0(gint, theme->balls[i].destroyphases);

                for(j=0;j<theme->balls[i].destroyphases;j++) {
                	opt=g_strdup_printf("ball.%d.destroy.%d", i+1, j+1);
                	val=trc_get_str(trc, opt);
                	g_free(opt);
                	CHECKRET(val, NULL);
                	ret=gtkb_load_pixmap(&theme->balls[i].destroy[j], themepath, val);
                	g_free(val);
                	CHECKRET(ret, 0);

                	opt=g_strdup_printf("ball.%d.destroy.%d.usec", i+1, j+1);
                        theme->balls[i].destroydelays[j]=trc_get_uint(trc, opt);
                	g_free(opt);
                	CHECKRET(theme->balls[i].destroydelays[j], -1);
                }
        }
        trc_close(trc);

        return theme;
}

void remake_board(gint numoldchilds, gboolean nextwalid) {
  	gint  cxs, cys, i;

        if(numoldchilds && numoldchilds != Rules.next) {
        	for(i=0; i<numoldchilds; i++) {
                	gtk_widget_destroy(SmallBalls[i]);
        	}
        	SmallBalls=g_malloc(Rules.next*sizeof(GtkWidget *));
        	for(i=0;i<Rules.next;i++) {
                        if(nextwalid) {
                		SmallBalls[i]=gtk_image_new_from_pixmap(gtkbTheme->balls[NextColors[i]-1].small.pixmap, gtkbTheme->balls[NextColors[i]-1].small.mask);
                        } else {
                		SmallBalls[i]=gtk_image_new_from_pixmap(gtkbTheme->balls[0].small.pixmap, gtkbTheme->balls[0].small.mask);
                        }
  			gtk_box_pack_start(GTK_BOX(Small_balls_box), SmallBalls[i], FALSE, FALSE, 0);
        	}
                show_hide_next_balls(Show_next_colors);
        }

        cxs=gtkbTheme->emptycell.xsize;
        cys=gtkbTheme->emptycell.ysize;
  	gtk_widget_set_size_request(DrawingArea, Rules.xsize*cxs, Rules.ysize*cys);
  	if(Pixmap) {
		g_object_unref(Pixmap);
  		Pixmap=gdk_pixmap_new(DrawingArea->window, Rules.xsize*cxs, Rules.ysize*cys, -1);
  	}
}

gint load_theme(gchar *themename) {
  	gchar *themepath;
        GtkbTheme *theme;

  	if(!(themepath=find_theme_path(themename))) return 0;

        if(!(theme=gtkb_load_theme(themepath))) return 0;
        gtkb_theme_free(gtkbTheme);
        gtkbTheme=theme;

  	g_free(themepath);

        remake_board(0, 1);

  	return 1;
}

void draw_next_balls(void) {
        gint i;

	for(i=0;i<Rules.next;i++) {
		gtk_image_set_from_pixmap(GTK_IMAGE(SmallBalls[i]), gtkbTheme->balls[NextColors[i]-1].small.pixmap, gtkbTheme->balls[NextColors[i]-1].small.mask);
        }
}

void draw_ball_no_update(GtkWidget *widget, gint ballcolor, GdkPixmap *pixmap, gint x, gint y, gint jumpnum, gint destroynum) {
        GdkGC *gc = widget->style->fg_gc[GTK_WIDGET_STATE(widget)];
        gint  cxs = gtkbTheme->emptycell.xsize;
        gint  cys = gtkbTheme->emptycell.ysize;
        GtkbPixmap *ball;
        gint  xr, yr;


  	gdk_draw_drawable(pixmap, gc, gtkbTheme->emptycell.pixmap, 0, 0, x*cxs, y*cys, cxs, cys);
	if(ballcolor) {
                if(!jumpnum && !destroynum) {
                        ball=&gtkbTheme->balls[ballcolor-1].ball;
                } else if(jumpnum) {
		 	ball=&gtkbTheme->balls[ballcolor-1].jump[jumpnum-1];
		} else {
			ball=&gtkbTheme->balls[ballcolor-1].destroy[destroynum-1];
                }
        	xr=x*cxs+(cxs-ball->xsize)/2;
        	yr=y*cys+(cys-ball->ysize)/2;
        	gdk_gc_set_clip_mask(gc, ball->mask);
        	gdk_gc_set_clip_origin(gc, xr, yr);
        	gdk_draw_drawable(pixmap, gc, ball->pixmap, 0, 0, xr, yr, ball->xsize, ball->ysize);
        	gdk_gc_set_clip_origin(gc, 0, 0);
        	gdk_gc_set_clip_mask(gc, 0);
  	}
}

void draw_ball(GtkWidget *widget, gint ballcolor, GdkPixmap *pixmap, gint x, gint y, gint jumpnum, gint destroynum) {
        gint cxs = gtkbTheme->emptycell.xsize;
        gint cys = gtkbTheme->emptycell.ysize;

  	draw_ball_no_update(widget, ballcolor, pixmap, x, y, jumpnum, destroynum);
  	update_rectangle(widget, x*cxs, y*cys, cxs, cys);
}

void draw_paw(GtkWidget *widget, gint pawnumber, GdkPixmap *pixmap, gint x, gint y) {
        GtkbPixmap *paw=&gtkbTheme->paws[pawnumber];
        GdkGC *gc = widget->style->fg_gc[GTK_WIDGET_STATE(widget)];
        gint  cxs = gtkbTheme->emptycell.xsize;
        gint  cys = gtkbTheme->emptycell.ysize;
        gint  xr  = x*cxs+(cxs-paw->xsize)/2;
        gint  yr  = y*cys+(cys-paw->ysize)/2;

  	gdk_draw_drawable(pixmap, gc, gtkbTheme->emptycell.pixmap, 0, 0, x*cxs, y*cys, cxs, cys);
  	gdk_gc_set_clip_mask(gc, paw->mask);
  	gdk_gc_set_clip_origin(gc, xr, yr);
  	gdk_draw_drawable(pixmap, gc, paw->pixmap, 0, 0, xr, yr, paw->xsize, paw->ysize);
  	gdk_gc_set_clip_origin(gc, 0, 0);
  	gdk_gc_set_clip_mask(gc, 0);
  	update_rectangle(widget, x*cxs, y*cys, cxs, cys);
}

void draw_board(GtkWidget *widget, GdkPixmap *pixmap) {
  	gint i, j, *bp=Board;

    	for(j=0;j<Rules.ysize;j++) {
  		for(i=0;i<Rules.xsize;i++) {
      			if(!AnimationInProgress || ((j*Rules.xsize+i)!=Jumping_ball)) {
              			draw_ball_no_update(widget, *bp, pixmap, i, j, 0, 0);
                        }
                        bp++;
                }
        }
}

/* Refill the screen from the backing pixmap */
gint expose_event(GtkWidget *widget, GdkEventExpose *event) {
  	gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE(widget)], Pixmap,
		   	event->area.x, event->area.y, event->area.x, event->area.y,
			event->area.width, event->area.height);
  	return FALSE;
}

void find_pawnum_and_direction(gint PawX, gint PawY, gint x, gint y, gint *pawnum, gint *direction) {
	if(PawY<y) {
        	*pawnum=2;
                if(*direction==1) *pawnum=6;
        	if(*direction==3) *pawnum=7;
        	*direction=2; /* up */
	} else if(PawY>y) {
        	*pawnum=0;
                if(*direction==1) *pawnum=4;
                if(*direction==3) *pawnum=5;
	        *direction=0; /* down */
	} else if(PawX<x) {
        	*pawnum=1;
                if(*direction==0) *pawnum=4;
                if(*direction==2) *pawnum=6;
	        *direction=1; /* left */
	} else if(PawX>x) {
        	*pawnum=3;
                if(*direction==0) *pawnum=5;
                if(*direction==2) *pawnum=7;
	        *direction=3; /* right */
        }
}

gint find_direction(gint PawX, gint PawY, gint x, gint y) {
	if(PawY<y) return 2; /* up */
	if(PawY>y) return 0; /* down */
        if(PawX<x) return 1; /* left */
        if(PawX>x) return 3; /* right */
        return -1; /* should never happens */
}

gint move_ball(GtkWidget *widget, gint source_ball, gint target_ball) {
  	gint nodes[Rules.xsize*Rules.ysize];
  	gint path[Rules.xsize*Rules.ysize];
	gint PawX=-1,PawY=-1;
  	gint i,j,k,phase;
  	gint x,y,color,tbx,tby;
  	gint direction,pawnum;
        gint *bp=Board;

  	find_x_y_of_the_node(&tbx, &tby, target_ball, Rules.xsize, Rules.ysize);
  	if(Board[target_ball]) return 2;

    	for(j=0;j<Rules.ysize;j++) {
  		for(i=0;i<Rules.xsize;i++) {
      			if(*bp++!=0) {
				nodes[j*Rules.xsize+i]=-1;
      			} else {
				nodes[j*Rules.xsize+i]=0;
                        }
        	}
        }

  	nodes[source_ball]=nodes[target_ball]=0;
  	if(!find_path(nodes, source_ball, target_ball, path, Rules.xsize, Rules.ysize)) {
		return 0;
        }

  	find_x_y_of_the_node(&x, &y, source_ball, Rules.xsize, Rules.ysize);
  	color=Board[source_ball];
  	Board[source_ball]=0;
  	phase=0;

      	draw_ball(widget, 0, Pixmap, x, y, 0, 0);
  	if(Show_path) {
      		for(k=path[0]-1;k;k--) {
	  		find_x_y_of_the_node(&i, &j, path[k], Rules.xsize, Rules.ysize);
	  		if(k==path[0]-1) {
	      			/* x and y are the coordinates of starting position */
	      			PawX = x;
	      			PawY = y;
	  		} else {
	      			find_x_y_of_the_node(&PawX, &PawY, path[k+1], Rules.xsize, Rules.ysize);
	  		}
          		if(k!=path[0]-1) {
                                find_pawnum_and_direction(PawX, PawY, i, j, &pawnum, &direction);
          		} else {
                		pawnum=direction=find_direction(PawX, PawY, i, j);
          		}
	  		if(Show_footprints) {
	    			draw_paw (widget, pawnum, Pixmap, PawX, PawY);
                        }
            		draw_ball(widget, Jumping_ball_color, Pixmap, i, j, 0, 0);
                        /* gdk docs says that "This is rarely needed by applications". fucked humour =/ */
                        gdk_flush();
			/* should i make it configurable? and maybe i should use timers instead? */
	      		/* gtk_usleep(100000); */
	      		my_usleep(100000);
            		draw_ball(widget, 0, Pixmap, i, j, 0, 0);
      		}
      		if(k==path[0]-1) {
	  		/* x and y are the coordinates of starting position */
	  		PawX=x;
	  		PawY=y;
      		} else {
	  		find_x_y_of_the_node(&PawX, &PawY, path[k+1], Rules.xsize, Rules.ysize);
      		}
      		if (Show_footprints) {
                	find_pawnum_and_direction(PawX, PawY, tbx, tby, &pawnum, &direction);
			draw_paw(widget, pawnum, Pixmap, PawX, PawY);
                }
  	}
  	Board[target_ball]=color;
        draw_ball(widget, color, Pixmap, tbx, tby, 0, 0);
  	return 1;
}

