/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GFX__H
#define __GFX__H

typedef struct _GtkbTheme GtkbTheme;
typedef struct _GtkbPixmap GtkbPixmap;
typedef struct _GtkbBall GtkbBall;

/* sometime i must switch to gdkpixbuf, i think... */
struct _GtkbPixmap {
        GdkPixmap *pixmap;
        GdkBitmap *mask;
        gint      xsize, ysize;
};

struct _GtkbBall {
        GtkbPixmap ball;           /* still picture of ball */
        GtkbPixmap small;          /* small picture of ball */
        gint       jumpphases;
        GtkbPixmap *jump;
        gint       *jumpdelays;
        gint       destroyphases;
        GtkbPixmap *destroy;
        gint       *destroydelays;
};

struct _GtkbTheme {
        GtkbPixmap emptycell;      /* pixmap for empty cell */
        GtkbPixmap paws[8];        /* 8 pixmaps for footprints */
        gint       numballs;       /* number of balls */
        GtkbBall   *balls;  	   /* array of balls */
};


extern GdkPixmap *Pixmap;
extern GtkbTheme *gtkbTheme;

/* Balls that shows what colors will appear on next turn */
GtkWidget **SmallBalls;

/* Number and color of the jumping ball */
extern gint Jumping_ball;
extern gint Jumping_ball_color;

extern gint AnimationInProgress;

extern gchar *installpath;
extern gchar *themeprefix;

extern void     my_usleep		(gint x);

extern gint     gtkb_theme_free_handler	(GtkWidget *widget, gpointer data);

extern int 	load_theme		(gchar *themename);
extern void 	draw_next_balls		(void);
extern void 	draw_ball 		(GtkWidget *widget, gint ballcolor, GdkPixmap *pixmap,
				 	 gint x, gint y, gint jumpnum, gint destroynum);
extern void 	draw_paw 		(GtkWidget *widget, gint pawnumber, GdkPixmap *pixmap,
 				 	 gint x, gint y);
extern void 	draw_board 		(GtkWidget *widget, GdkPixmap *pixmap);
/* Refill the screen from the backing pixmap */
extern gint 	expose_event 		(GtkWidget *widget, GdkEventExpose *event);
extern gint 	move_ball 		(GtkWidget *widget, gint source_ball, gint target_ball);
extern void 	remake_board		(gint numoldchilds, gboolean nextwalid);

#endif
