/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GTKBALLS__H
#define __GTKBALLS__H

#include <config.h>

#ifdef HAVE_NLS
#  include <locale.h>
#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#endif                          /* HAVE_LIBINTL_H */
#    define _(String) gettext (String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else                           /* HAVE_NLS not defined */
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif                          /* HAVE_NLS */

typedef struct _GtkbGameRules GtkbGameRules;

struct _GtkbGameRules {
	gint xsize;    /* width of the boards in "cells" */
	gint ysize;    /* height of the boards in "cells" */
	gint colors;   /* number of different collors */
	gint next;     /* number of colors appearing on the next turn */
	gint destroy; /* number of same colors in line to destroy */
};

extern gint *Board;
extern gint *BoardUndo;
extern gint *NextColors;
extern gint *NextColorsUndo;

extern struct score_board Scoreboard[10];
extern struct score_board_full *FullScoreboard;
extern gint FullScoreboardNumber;

extern int Score_fds[2];

extern gint Score;
extern gint ScoreUndo;
extern gint Hi_score;
extern gint Hi_scoreUndo;

extern gint Show_next_colors;
extern gint Show_path;
extern gint Show_footprints;
extern gint Show_destroy;

extern guint TimerTag;
extern volatile gint phase;

extern GtkWidget *MainWindow;
extern GtkStyle  *MainStyle;
extern GtkWidget *DrawingArea;
extern GtkItemFactory *Menu_items_factory;

extern GtkWidget *Small_balls_box;

extern GtkbGameRules Rules;
extern GtkbGameRules ClassicRules;

extern time_t Timer_start_time;
extern gint Timer_limit;
extern GtkWidget *Timer_label;

gint button_press_event(GtkWidget *widget, GdkEventButton *event);
void menu_set_sensitive(GtkItemFactory *ifactory, const gchar *path, gboolean sensitive);
void new_game(void);

#endif /* __GTKBALLS__H */
