/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#include <glib.h>


#include "gtkballs.h"
#include "scoreboard.h"

#define BUFFER_SIZE 1024

gint write_score(struct score_board *b, struct score_board_full *bf, gint nbf) {
  	gint i;
  	gchar *buf, *tname, *tdate;
        gsize br, bw;
        size_t sz;

  	for(i=0; i<10; i++) {
    		if(strlen(b[i].name)) {
                        tname=g_locale_from_utf8(b[i].name, -1, &br, &bw, NULL);
                        if(!tname) {
                                tname=g_strdup(_("Unknown"));
                        }
                        tdate=g_locale_from_utf8(b[i].date, -1, &br, &bw, NULL);
                        if(!tdate) {
                                tdate=g_strdup(_("Unknown"));
                        }
      			buf=g_strdup_printf("%s\t%i\t%s\t%d\t%d\t%d\t%d\t%d\n", tname, b[i].score, tdate, Rules.xsize, Rules.ysize, Rules.colors, Rules.next, Rules.destroy);
                        sz=strlen(buf);
    			write(Score_fds[1], &sz, sizeof(sz));
    			write(Score_fds[1], buf, strlen(buf));
                        g_free(tname);
                        g_free(tdate);
                	g_free(buf);
    		}
  	}
  	for(i=0; i<nbf; i++) {
    		if(strlen(bf[i].name)) {
      			buf=g_strdup_printf("%s\t%i\t%s\t%d\t%d\t%d\t%d\t%d\n", bf[i].name, bf[i].score, bf[i].date, bf[i].rules.xsize, bf[i].rules.ysize, bf[i].rules.colors, bf[i].rules.next, bf[i].rules.destroy);
                        sz=strlen(buf);
    			write(Score_fds[1], &sz, sizeof(sz));
    			write(Score_fds[1], buf, strlen(buf));
                	g_free(buf);
   		}
        }
        sz=0;
    	write(Score_fds[1], &sz, sizeof(sz));

  	return TRUE;
}

int score_sort(const void *a, const void *b) {
        if(((const struct score_board *)a)->score == ((const struct score_board *)b)->score) return 0;
        if(((const struct score_board *)a)->score < ((const struct score_board *)b)->score) return 1;
	return -1;
}

gint read_score(struct score_board *b, struct score_board_full **bf, gint *nbf) {
  	FILE *fp;
  	gchar buffer[BUFFER_SIZE];
  	gchar **str_val, *tstr;
        gint  i, valid, sc, fsc;
        GtkbGameRules rules;
        gsize br, bw;
	struct flock lockinfo;

        for(i=0; i<10; i++) {
                b[i].name[0] = '\0';
                b[i].score = 0;
                b[i].date[0] = '\0';
        }

        if(*bf) {
                g_free(*bf);
                *bf=NULL;
        }

  	if(!(fp=fopen(LOCALSTATEDIR SCORE_FILE, "r"))) {
		return FALSE;
        }

    	do {
  		lockinfo.l_whence=SEEK_SET;
  		lockinfo.l_start=0;
	  	lockinfo.l_len=0;
    		lockinfo.l_type=F_WRLCK;
		fcntl(fileno(fp), F_GETLK, &lockinfo);
        } while(lockinfo.l_type != F_UNLCK);

        sc = 0;
        fsc = 0;
      	while(fgets(buffer, BUFFER_SIZE, fp)) {
        	g_strchomp(buffer);
        	str_val=g_strsplit(buffer, "\t", SBFNUM);
        	if(str_val[0] && str_val[0][0] &&
		   str_val[1] && str_val[1][0] &&
		   str_val[2] && str_val[2][0]) {
                        valid=0;
                   	if(!str_val[3]) { /* < 2.2.0 file format */
                        	memcpy(&rules, &ClassicRules, sizeof(rules));
                                valid=1;
                   	} else {
                        	if(str_val[3][0] &&
                           	   str_val[4] && str_val[4][0] &&
                           	   str_val[5] && str_val[5][0] &&
                           	   str_val[6] && str_val[6][0] &&
                           	   str_val[7] && str_val[7][0]) {
                                	rules.xsize = strtol(str_val[3], NULL, 10);
		                        rules.ysize = strtol(str_val[4], NULL, 10);
                	                rules.colors = strtol(str_val[5], NULL, 10);
                        	        rules.next = strtol(str_val[6], NULL, 10);
                                	rules.destroy = strtol(str_val[7], NULL, 10);
                                	valid=1;
                        	}
                   	}
                        if(valid && g_ascii_strcasecmp(str_val[0],"<none>")) {
                                if(memcmp(&rules, &Rules, sizeof(rules)) == 0) {
                                        tstr=g_locale_to_utf8(str_val[0], -1, &br, &bw, NULL);
                                        if(tstr) {
                                		strncpy(b[sc].name, tstr, sizeof(b[sc].name));
                                                g_free(tstr);
                                        } else {
                                		strncpy(b[sc].name, _("Unknown"), sizeof(b[sc].name));
                                        }
    					b[sc].score=strtol(str_val[1], NULL, 10);
    					if((b[sc].score==LONG_MIN) || (b[sc].score==LONG_MAX)) {
      						b[sc].score=0;
                                	}
                                        tstr=g_locale_to_utf8(str_val[2], -1, &br, &bw, NULL);
                                        if(tstr) {
                                		strncpy(b[sc].date, tstr, sizeof(b[sc].date));
                                                g_free(tstr);
                                        } else {
                                		strncpy(b[sc].date, _("Unknown"), sizeof(b[sc].date));
                                        }
                			sc++;
                                } else {
                                        *bf=g_realloc(*bf, sizeof(struct score_board_full)*(fsc+1));
                                	strncpy((*bf)[fsc].name, str_val[0], sizeof((*bf)[fsc].name));
    					(*bf)[fsc].score=strtol(str_val[1], NULL, 10);
    					if(((*bf)[fsc].score==LONG_MIN) || ((*bf)[fsc].score==LONG_MAX)) {
      						(*bf)[fsc].score=0;
                                	}
                                	strncpy((*bf)[fsc].date, str_val[2], sizeof((*bf)[fsc].date));
                                        memcpy(&((*bf)[fsc].rules), &rules, sizeof(rules));
                                        fsc++;
                                }
                        }
        	}
                g_strfreev(str_val);
        }
        fclose(fp);

        qsort(b, 10, sizeof(struct score_board), score_sort);


        *nbf = fsc;

  	return TRUE;
}

gint insert_entry_in_score_board(struct score_board *board, struct score_board entry) {
  	gint i=0,j;

  	if(entry.score<=0) {
    		return -1;
        }

  	while(i<10 && board[i].score>entry.score) {
    		i++;
        }

  	if(i>9) {
    		return -1;
        }

  	for(j=8;j>=i;j--) {
      		strncpy(board[j+1].name, board[j].name, sizeof(board[j+1].name));
      		strncpy(board[j+1].date, board[j].date, sizeof(board[j+1].date));
      		board[j+1].score=board[j].score;
    	}

  	strncpy(board[i].name, entry.name, sizeof(board[i].name));
  	strncpy(board[i].date, entry.date, sizeof(board[i].date));
  	board[i].score = entry.score;

  	return i;
}
