/*
 * One-pane (file)compare view widget header
 *
 * From a GUI perspective, this widget consists of two components,
 * onepane-widget and overview-widget.
 * This widget is just a GUI container.
 * Almost every logic is handled by GdiffOnePane widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_ONEPVIEW_H__
#define __GDIFF_ONEPVIEW_H__

#include <gtk/gtkhbox.h>
#include "basepane-widget.h"
#include "gdiffoverview.h"

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_ONEPVIEW				(gdiff_onepview_get_type())
#define GDIFF_ONEPVIEW(obj)				GTK_CHECK_CAST(obj, gdiff_onepview_get_type(), GdiffOnepView)
#define GDIFF_ONEPVIEW_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_onepview_get_type(), GdiffOnepViewClass)
#define GDIFF_IS_ONEPVIEW(obj)			GTK_CHECK_TYPE(obj, gdiff_onepview_get_type())
#define GDIFF_IS_ONEPVIEW_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_ONEPVIEW))


typedef struct _GdiffOnepView       GdiffOnepView;
typedef struct _GdiffOnepViewClass  GdiffOnepViewClass;

struct _GdiffOnepView {
	GtkHBox hbox;

	/* Child GUI components */
	GdiffBasePane *onepane;/* accessed via arg "basepane" */
	GdiffOverview *overview;
	GtkWidget *rmenu;

	/* backward pointer for reference */
	GDiffWindow *gdwin;

	/* TRUE if this view is under directory view */
	gboolean is_under_dir;
};

struct _GdiffOnepViewClass {
	GtkHBoxClass parent_class;

	/* Interfaces */
	void (*scrollup)(GdiffOnepView *onepview);/* signal */
	void (*scrolldown)(GdiffOnepView *onepview);/* signal */
};


GtkType gdiff_onepview_get_type(void);
GtkWidget* gdiff_onepview_new(DiffDir *diffdir, DiffFiles *dfiles, gboolean is_under_dir);

/* Macros */
/* I could have these informations in this widget, but I don't.
   Instead, they are implicitly kept in onepane widget.
   I provide interfaces for them by macros. */
#define GDIFF_ONEPVIEW_DIFFDIR(onepview)\
	(GDIFF_BASEPANE(GDIFF_ONEPVIEW(onepview)->onepane)->diffdir)
#define GDIFF_ONEPVIEW_DFILES(onepview)\
	(GDIFF_BASEPANE(GDIFF_ONEPVIEW(onepview)->onepane)->dfiles)
#define GDIFF_ONEPVIEW_FILENAME(onepview, whichfile)\
	(GDIFF_BASEPANE(GDIFF_ONEPVIEW(onepview)->onepane)->filename[whichfile])
#define GDIFF_ONEPVIEW_PREF(onepview)\
	(GDIFF_BASEPANE(GDIFF_ONEPVIEW(onepview)->onepane)->pref)

#define GDIFF_ONEPVIEW_NUM_FILES(onepview)\
	((GDIFF_ONEPVIEW_DFILES(onepview)->is_diff3) ? 3 : 2)

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_ONEPVIEW_H__ */
