/*
 * GUI view misc module
 * This module is for view specific GUI functions.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "diff.h"
#include "gui.h"
#include "dirview.h"
#include "onepaneview.h"
#include "multipaneview.h"
#include "mergeview.h"
#include "viewmisc.h"


/**
 * view_get_pane:
 * Get "basepane" or "auxpane" from @view, and return it.
 **/
GdiffBasePane*
view_get_pane(GtkWidget *view, const char *panename)
{
	GdiffBasePane *pane = NULL;
	GtkArg arg[1];

	g_assert(strcmp(panename, "basepane") == 0 || strcmp(panename, "auxpane") == 0);

	/* view should be file view */
	g_assert(GDIFF_IS_ONEPVIEW(view) || GDIFF_IS_MULTIPVIEW(view) || GDIFF_IS_MERGEVIEW(view));
	
	arg[0].name = (char*)panename;
	gtk_object_getv(GTK_OBJECT(view), 1, arg);
	pane = GDIFF_BASEPANE(GTK_VALUE_OBJECT(arg[0]));

	return pane;
}

/**
 * view_get_fnames:
 * From the specified @view, set an array of file names @fnames.
 **/
void
view_get_fnames(GtkWidget *view, const char **fnames)
{
	if (GDIFF_IS_DIRVIEW(view)) {
		fnames[0] = GDIFF_DIRVIEW_DIRNAME(view, FIRST_FILE);
		fnames[1] = GDIFF_DIRVIEW_DIRNAME(view, SECOND_FILE);
	} else if (GDIFF_IS_ONEPVIEW(view)) {
		fnames[0] = GDIFF_ONEPVIEW_FILENAME(view, FIRST_FILE);
		fnames[1] = GDIFF_ONEPVIEW_FILENAME(view, SECOND_FILE);
		if (GDIFF_ONEPVIEW_NUM_FILES(view) == 3) {
			fnames[2] = GDIFF_ONEPVIEW_FILENAME(view, THIRD_FILE);
		}
	} else if (GDIFF_IS_MULTIPVIEW(view)) {
		fnames[0] = GDIFF_MULTIPVIEW_FILENAME(view, FIRST_FILE);
		fnames[1] = GDIFF_MULTIPVIEW_FILENAME(view, SECOND_FILE);
		if (GDIFF_MULTIPVIEW_NUM_FILES(view) == 3) {
			fnames[2] = GDIFF_MULTIPVIEW_FILENAME(view, THIRD_FILE);
		}
	} else if (GDIFF_IS_MERGEVIEW(view)) {
		fnames[0] = GDIFF_MERGEVIEW_FILENAME(view, FIRST_FILE);
		fnames[1] = GDIFF_MERGEVIEW_FILENAME(view, SECOND_FILE);
		if (GDIFF_MERGEVIEW_NUM_FILES(view) == 3) {
			fnames[2] = GDIFF_MERGEVIEW_FILENAME(view, THIRD_FILE);
		}
	}	
}
