// -*- C++ -*-

/* window_testiconlist.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_testiconlist.h"

#include <iostream>
#include <gtk--/window.h>
#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/main.h>

#include "icons.h" //bitmaps - file copied from Gtk+Extra.

Window_TestIconList::Window_TestIconList()
 : m_VBox(false, 0),
   m_HBox(false, 0),
   m_Table(4, 2, false),
   m_Label_Worksheets("Worksheets"),
   m_Label_Plots("Plots"),
   m_IconList_Worksheets(48, 2),
   m_IconList_Plots(48, 1)
{ 
  set_title("GtkExtra::IconList Demo");
  set_usize(400, 400);
  set_border_width(0);

  add(m_VBox);
  m_VBox.pack_start(m_HBox, true, true, 0);
  
  m_HBox.pack_start(m_Table, false, false, 0);
  m_HBox.pack_start(m_Notebook, true, true, 0);

  m_ScrolledWindow_Worksheets.set_border_width(0);
  m_ScrolledWindow_Worksheets.set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  m_Notebook.append_page(m_ScrolledWindow_Worksheets, m_Label_Worksheets);

  m_ScrolledWindow_Plots.set_border_width(0);
  m_ScrolledWindow_Plots.set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  m_Notebook.append_page(m_ScrolledWindow_Plots, m_Label_Plots);

  //Worsheets:
  {
	  m_IconList_Worksheets.set_selection_mode(0);
	  m_ScrolledWindow_Worksheets.add_with_viewport(m_IconList_Worksheets);

	  for(int i = 0; i<20; i++)
	  {
	    char pchLabel[15];
	    sprintf(pchLabel, "Data %d", i);
	    m_IconList_Worksheets.add_from_data(sheet_icon2, pchLabel, NULL);
	  }
  }

  //Plots:
  {
	  m_IconList_Plots.set_selection_mode(GTK_SELECTION_MULTIPLE);
	  m_ScrolledWindow_Plots.add_with_viewport(m_IconList_Plots);

	  for(int i = 0; i<20; i++)
	  {
	    char pchLabel[15];
	    sprintf(pchLabel, "Plot %d", i);
	    m_IconList_Plots.add_from_data(plot_icon2, pchLabel, NULL);
	  }
  }
  
  show_all();
}

Window_TestIconList::~Window_TestIconList()
{
}

gint Window_TestIconList::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}
