// -*- C++ -*-

/* window_test_contour.h
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef HEADER_WINDOW_TEST_CONTOUR
#define HEADER_WINDOW_TEST_CONTOUR

#include "gtk--.h"
#include "gtk--/window.h"
#include "gtkextra--/gtkextra--.h"

#include <iostream>
#include <string>
#include <string>
#include <vector>

using SigC::bind;
using SigC::slot;
//using namespace Gtk;
//using namespace GtkExtra;

class Window_Test_Contour : public Gtk::Window
{
public:
  Window_Test_Contour();
  virtual ~Window_Test_Contour();
  
protected:

  void activate_plot(gint iPlotNumber);
  
  //Signal handlers:
  virtual gint on_PlotCanvas_select_item(GdkEventButton* event, GtkPlotCanvasChild* item);
  virtual void on_Button_toggled(gint iButtonNumber);
  virtual void on_ButtonRotateX_clicked();
  virtual void on_ButtonRotateY_clicked();
  virtual void on_ButtonRotateZ_clicked();
  
  //'virtual function' signal overrides:
  virtual gint delete_event_impl(GdkEventAny*);
  
protected:
 
  //Member widgets:

  Gtk::VBox m_VBox;
  Gtk::ScrolledWindow m_ScrolledWindow;
  GtkExtra::PlotCanvas m_PlotCanvas;
  GtkExtra::Plot3D m_Plot3D;
  GtkExtra::Plot m_Plot;
  GtkExtra::PlotCSurface m_PlotCSurface1, m_PlotCSurface2; //derived from PlotData.
  Gtk::ToggleButton m_Button1, m_Button2;
  Gtk::Button m_ButtonRotateX, m_ButtonRotateY, m_ButtonRotateZ;

  typedef std::vector<GtkExtra::PlotBox*> type_vecpPlotData;
  type_vecpPlotData m_vecDataSets;
 
};


gdouble function(GtkPlot *plot, 
                 GtkPlotData *data, 
                 gdouble x, gdouble y, gboolean *err);


#endif //HEADER_WINDOW_TEST_CONTOUR
