// -*- C++ -*-

/* window_testsheet.h
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef HEADER_WINDOW_TESTSHEET
#define HEADER_WINDOW_TESTSHEET

#include <iostream>
#include <string>

#include "gtk--.h"
#include "gtk--/window.h"
#include "gtkextra--/gtkextra--.h"

#include "sheet_logsignals.h"
#include "sheet_numeric_withpopup.h"

using SigC::bind;
using SigC::slot;
//using namespace Gtk;
//using namespace GtkExtra;

class Window_TestSheet : public Gtk::Window
{
public:
  Window_TestSheet();
  virtual ~Window_TestSheet();
  
protected:
  virtual GtkExtra::Sheet* Get_CurrentSheet();

  //Signal handlers:

  virtual void on_Button_HideRowTitles();
  virtual void on_Button_HideColumnTitles();
  virtual void on_Button_ShowRowTitles();
  virtual void on_Button_ShowColumnTitles();

  virtual void on_Toolbar_FontCombo_Changed();

  virtual void on_Toolbar_Button_Left();
  virtual void on_Toolbar_Button_Right();
  virtual void on_Toolbar_Button_Center();

  virtual void on_Toolbar_BorderCombo_Changed(gint border);

  virtual void on_Toolbar_ColorCombo_fg(gint i, gchar *color_name);
  virtual void on_Toolbar_ColorCombo_bg(gint i, gchar *color_name);

  virtual void on_Sheet_Entry_Changed();
  virtual gint on_Sheet_Activate(gint row, gint column);

  virtual void on_Entry_Changed();
  virtual void on_Entry_Activate();

  //Sheet 1:
  virtual void on_Button_Show();
  virtual gint on_Sheet_key_press_event_Clipboard(GdkEventKey* key);

  //Sheet 3:
  gboolean on_Sheet3_traverse(gint row, gint col, gint *new_row, gint *new_col);
  
  //'virtual function' signal overrides:
  virtual gint delete_event_impl(GdkEventAny*);
  
protected:
  virtual void build_example1();
  virtual void build_example2();
  virtual void build_example3();
 
  //Member widgets:

  Gtk::VBox m_VBox;
  Gtk::HBox m_HBox_ShowHide;
  Gtk::Button m_Button_HideRowTitles, m_Button_HideColumnTitles, m_Button_ShowRowTitles, m_Button_ShowColumnTitles;
  
  //Toolbar:
  Gtk::Toolbar m_Toolbar;
  Gtk::ToggleButton m_Toolbar_Button_Left, m_Toolbar_Button_Center, m_Toolbar_Button_Right;
  GtkExtra::FontCombo m_Toolbar_FontCombo; //segfaults
  GtkExtra::BorderCombo m_Toolbar_BorderCombo;
  GtkExtra::ColorCombo m_Toolbar_ColorCombo_fg, m_Toolbar_ColorCombo_bg;
  GtkExtra::ToggleCombo m_Toolbar_ToggleCombo;
  Gtk::Pixmap m_pixmap_bg, m_pixmapFont;
  Gtk::Pixmap m_pixmapJustifyLeft, m_pixmapJustifyRight, m_pixmapJustifyCenter;

  Gtk::HBox m_HBox_Status;
  Gtk::Label m_Label_Location;
  Gtk::Entry m_Entry;

  GtkExtra::Sheet* m_ppSheets[3];
  Gtk::ScrolledWindow* m_ppScrolledWindows[3];
  
  Gtk::Notebook m_Notebook;

  //Sheet 1:
  Sheet_LogSignals m_Sheet_LogSignals;
  Gtk::Pixmap* m_ppPixmapBullets[10];
  Gtk::Button* m_pButton_Show;

  //Sheet 2:
  Sheet_Numeric_WithPopup m_Sheet_Numeric_WithPopup;
};

#endif //HEADER_WINDOW_TESTSHEET
