/*
 *   Copyright (C) 2007 Tristan Heaven <tristanheaven@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _LIST_H_
#define _LIST_H_

void list_init(void);
void list_update(void);
void list_append_row(const char *path);
void list_remove_selection(void);
char *list_get_path(const int row);
char *list_get_basename(const int row);
int list_find_row(const char *path);
unsigned int list_count_rows(void);
void list_set_digest(const char *path, const int id, const char *digest);
char *list_get_digest(const int row, const int id);
void list_clear_digests(void);
void list_clear(void);

#endif // _LIST_H_
