/* some functions to do lowlevel access to cdrom drives */

#include "types.h"

typedef enum 
{
   TRACKTYPE_DATA,
   TRACKTYPE_AUDIO,
   TRACKTYPE_UNKNOWN
} cdromlow_tracktype;

/* use this function to get a handle for TOC access */
gtoaster_handle_t cdromlow_gettochandle(const char *device);
/* use this function to free the TOC access handle */
void cdromlow_closetochandle(gtoaster_handle_t handle);

int cdromlow_hasdatatrack(gtoaster_handle_t handle);
int cdromlow_tracks(gtoaster_handle_t handle);
int cdromlow_tracksize_sectors(gtoaster_handle_t handle,int num);
int cdromlow_tracksize(gtoaster_handle_t handle,int num);
int cdromlow_datatracksize(gtoaster_handle_t handle,int num);
int cdromlow_cddbnumber(gtoaster_handle_t handle);
int cdromlow_trackoffset(gtoaster_handle_t handle,int num);

cdromlow_tracktype cdromlow_gettracktype(gtoaster_handle_t handle,int num);

/* retrieve CD Text informations */

char *cdromlow_gettitle(gtoaster_handle_t handle,int num);
char *cdromlow_getperformer(gtoaster_handle_t handle,int num);
char *cdromlow_getdisctitle(gtoaster_handle_t handle);
char *cdromlow_getdiscperformer(gtoaster_handle_t handle);
