#include <gtk/gtk.h>
#include "main.h"

void preferences_cb_do_tray(GtkWidget *chbox, GtkWidget *hwin);
void preferences_cb_show_date(GtkWidget *chbox);
void preferences_cb_do_tooltip(GtkWidget *chbox);
void preferences_cb_auto_purge(GtkWidget *cb, GtkWidget *hbox);

void gui_preferences()
	{
	GtkWidget *dialog, *vbox, *nblabel, *vbox2;
	GtkWidget *cb_do_tray, *cb_save_size, *cb_save_place,  *frame;
	GtkWidget *cb_show_date, *cb_list_tooltip;
	GtkWidget *cb_auto_purge, *sp_purge_days, *label, *hbox;
	
	dialog = gtk_dialog_new_with_buttons(_("Todo List Preferences"), GTK_WINDOW(mw.window), 
		GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_CLOSE, 
		GTK_RESPONSE_CANCEL,
		 NULL);

	vbox2 = gtk_vbox_new(FALSE,0);	


	/* frame 1 */
	vbox = gtk_vbox_new(FALSE, 6);
	
	/* save size option check box */
	cb_save_size = gtk_check_button_new_with_label(_("Restore previous size"));
	 gtk_box_pack_start(GTK_BOX(vbox),cb_save_size, FALSE, TRUE, 0); 
	 /* set it to current value */
	 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_save_size), settings.size);
	
	/* save posisition option check box */
	 cb_save_place = gtk_check_button_new_with_label(_("Restore previous position"));
	 gtk_box_pack_start(GTK_BOX(vbox),cb_save_place, FALSE, TRUE, 0); 
	 /* set it to current value */
	 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_save_place), settings.place);
	
	/** add the page **/
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 12);
	frame = gtk_frame_new(_("Startup"));
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_NONE);
	gtk_label_set_markup(GTK_LABEL(gtk_frame_get_label_widget(GTK_FRAME(frame))), _("<b>Startup</b>"));
	gtk_container_set_border_width(GTK_CONTAINER(frame), 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_box_pack_start(GTK_BOX(vbox2), frame, TRUE, TRUE, 0);


	/** second tab **/
	vbox = gtk_vbox_new(FALSE, 6);
	/* notification tray option check box */
	cb_do_tray = gtk_check_button_new_with_label(_("Enable notification area icon"));
	 gtk_box_pack_start(GTK_BOX(vbox),cb_do_tray, FALSE, TRUE, 0); 
	 /* set it to current value and add signal handler */
	 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_do_tray), settings.do_tray);
	 g_signal_connect(G_OBJECT(cb_do_tray), "toggled", G_CALLBACK(preferences_cb_do_tray), NULL);
	/* show due date column check box */
	 cb_show_date = gtk_check_button_new_with_label(_("Show Due date column"));
	 gtk_box_pack_start(GTK_BOX(vbox),cb_show_date, FALSE, TRUE, 0); 
	 /* set it to current value and add signal handler */
	 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_show_date), settings.show_date_column);
	 g_signal_connect(G_OBJECT(cb_show_date), "toggled", G_CALLBACK(preferences_cb_show_date), NULL);

	 cb_list_tooltip = gtk_check_button_new_with_label(_("Show tooltips in list"));
	 gtk_box_pack_start(GTK_BOX(vbox),cb_list_tooltip, FALSE, TRUE, 0); 
	 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_list_tooltip), settings.list_tooltip);
	 g_signal_connect(G_OBJECT(cb_list_tooltip), "toggled", G_CALLBACK(preferences_cb_do_tooltip), NULL);


	
	/** add the page **/
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 12);
	frame = gtk_frame_new(_("Interface Behaviour"));
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_NONE);	
	gtk_label_set_markup(GTK_LABEL(gtk_frame_get_label_widget(GTK_FRAME(frame))), _("<b>Interface Behaviour</b>"));
	gtk_container_set_border_width(GTK_CONTAINER(frame), 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	

	gtk_box_pack_start(GTK_BOX(vbox2), frame, TRUE, TRUE, 0);

	/** third tab **/
	vbox = gtk_vbox_new(FALSE, 6);
	cb_auto_purge = gtk_check_button_new_with_label(_("Auto purge completed items"));
	gtk_box_pack_start(GTK_BOX(vbox),cb_auto_purge, FALSE, TRUE, 0); 	


	hbox = gtk_hbox_new(FALSE, 6); 
	label = gtk_label_new(_("Purge items after"));
	gtk_box_pack_start(GTK_BOX(hbox),label, FALSE, TRUE, 0); 
	sp_purge_days = gtk_spin_button_new_with_range(1,365, 1);	
	gtk_box_pack_start(GTK_BOX(hbox),sp_purge_days, FALSE, TRUE, 0); 
	label = gtk_label_new(_("days."));
	gtk_box_pack_start(GTK_BOX(hbox),label, FALSE, TRUE, 0); 

	gtk_box_pack_start(GTK_BOX(vbox),hbox, FALSE, TRUE, 0); 
	g_signal_connect(G_OBJECT(cb_auto_purge), "toggled", G_CALLBACK(preferences_cb_auto_purge), hbox);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_auto_purge), settings.auto_purge);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(sp_purge_days), settings.purge_days);
	/* make sure the sensitive is ok */
	preferences_cb_auto_purge(cb_auto_purge, hbox);
	/** add the page **/
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 12);
	frame = gtk_frame_new(_("Auto Purge"));
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_NONE);	
	gtk_label_set_markup(GTK_LABEL(gtk_frame_get_label_widget(GTK_FRAME(frame))), _("<b>Auto Purge</b>"));
	gtk_container_set_border_width(GTK_CONTAINER(frame), 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	gtk_box_pack_start(GTK_BOX(vbox2), frame, TRUE, TRUE, 0);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),vbox2);	
	gtk_container_set_border_width(GTK_CONTAINER(vbox2), 12);

	

	/* show the notebook and add it */	
	gtk_dialog_set_has_separator(GTK_DIALOG(dialog), FALSE);
	

	
	
	gtk_widget_show_all(dialog);
	gtk_dialog_run(GTK_DIALOG(dialog));
	
	/* because there not directly visible I can go save the values now.. (not like do_tray) */
	settings.size = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb_save_size));
	settings.auto_purge = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb_auto_purge));
	settings.purge_days = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sp_purge_days));
	settings.place = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb_save_place));
	gtk_widget_destroy(dialog);
	/* save the settings */
	save_xml();
	}

	/***** preferences notification tray  signal *****************/
void preferences_cb_do_tray(GtkWidget *chbox, GtkWidget *hwin)
	{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chbox)))
			{
			settings.do_tray = TRUE;
			if(tray_icon == NULL)
				{ 
				tray_init();
				}
			}
	else		{
			settings.do_tray = FALSE;
			if(tray_icon != NULL)
				{ 
				gtk_widget_destroy(GTK_WIDGET(tray_icon));
				tray_icon = NULL;
				}
			}		
	}

void preferences_cb_show_date(GtkWidget *chbox)
	{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chbox)))
			{
			settings.show_date_column = TRUE;
			gtk_tree_view_column_set_visible(gtk_tree_view_get_column(GTK_TREE_VIEW(mw.treeview), 2),TRUE);
			}
	else		{
			settings.show_date_column = FALSE;
			gtk_tree_view_column_set_visible(gtk_tree_view_get_column(GTK_TREE_VIEW(mw.treeview), 2),FALSE);
			}		
	}


void preferences_cb_do_tooltip(GtkWidget *chbox)
    {
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chbox)))

			{
			  message_box(_("Showing Tooltips in the todo list is still very alpha.\nBecause of some weird behaviour in gtk it only works with the column headers disabled.\nI hope to get this fixed soon"),"", GTK_MESSAGE_INFO);
			settings.list_tooltip = TRUE;
			gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(mw.treeview), FALSE);			
			}
	else		{

			settings.list_tooltip = FALSE;
			gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(mw.treeview), TRUE);
			}		
    }

void preferences_cb_auto_purge(GtkWidget *cb, GtkWidget *hbox)
    {
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb)))
	gtk_widget_set_sensitive(GTK_WIDGET(hbox), TRUE);
    else 
	gtk_widget_set_sensitive(GTK_WIDGET(hbox), FALSE);
    }
