#include <gtk/gtk.h>
#include <string.h>
#include "main.h"

int categorys = 0;
xmlDocPtr   my_xml_tree;
xmlNodePtr  root;



void read_categorys(){
    xmlNodePtr  cur;
    cur = root->xmlChildrenNode;

    if(mw.mitems != NULL)
    {
	int i;
	for(i=0;mw.mitems[i] != NULL; i++){
	    if(mw.mitems[i]->date != NULL)g_free(mw.mitems[i]->date);
	    
	    gtk_widget_destroy(mw.mitems[i]->item);
	    g_free(mw.mitems[i]);
	}
	categorys = 0;
	mw.mitems = g_realloc(mw.mitems, (categorys+1)*sizeof(int *));
	mw.mitems[0] = NULL;
    }

     while(cur != NULL){
	if(xmlStrEqual(cur->name, (const xmlChar *)"category")){
	    xmlChar *temp;
	    temp = xmlGetProp(cur, (const xmlChar *)"title");
	    mw.mitems = g_realloc(mw.mitems, (categorys+2)*sizeof(int *));
	    mw.mitems[categorys+1] = NULL;
	    mw.mitems[categorys] = g_malloc(sizeof(catitems));
	    mw.mitems[categorys]->item = gtk_menu_item_new_with_label (temp);
	    mw.mitems[categorys]->date = g_strdup(temp);
	    gtk_menu_shell_append (GTK_MENU_SHELL (mw.menu), mw.mitems[categorys]->item);
	    xmlFree(temp);
	    categorys++;    
	    }
	    cur = cur->next;
	}
    

    mw.mitems = g_realloc(mw.mitems, (categorys+3)*sizeof(catitems));
    mw.mitems[categorys+2] = NULL;
    
    
    mw.mitems[categorys] = g_malloc(sizeof(catitems));
    mw.mitems[categorys]->item = gtk_separator_menu_item_new();
    mw.mitems[categorys]->date = g_strdup("");
    gtk_menu_shell_append (GTK_MENU_SHELL (mw.menu), mw.mitems[categorys]->item);
    
    
    mw.mitems[categorys+1] = g_malloc(sizeof(catitems));

    mw.mitems[categorys+1]->item = gtk_menu_item_new_with_label (_("Edit Categories"));	
    mw.mitems[categorys+1]->date = g_strdup(("Edit"));
    gtk_menu_shell_append (GTK_MENU_SHELL (mw.menu), mw.mitems[categorys+1]->item);
    
    gtk_widget_show_all(mw.menu);
 	if(categorys > 0) gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option), 0);
    }
    

    
void load_category(){
    GtkTreeIter iter;
    xmlNodePtr cur = root->xmlChildrenNode;
    gboolean all = FALSE;
    gchar *category;
    gint total = 0;
    if(gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option)) == 0) all = TRUE; 
    if(!all) category  = mw.mitems[gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option))-2]->date;
    else  category  = NULL;
    while (cur != NULL) 
	{
	    xmlChar *temp;
	    temp = xmlGetProp(cur, (const xmlChar *)"title");
	    if(xmlStrEqual(temp, (const xmlChar *)category) || all)
 		{	
		xmlNodePtr cur1;
		cur1= cur->xmlChildrenNode;
	    	while(cur1 != NULL)
		    {
		    if(xmlStrEqual(cur1->name, (const xmlChar *)"item"))
			    {
				guint64 test = 0;
			    xmlNodePtr cur3 = cur1->xmlChildrenNode;
			    gtk_list_store_append((mw.list), &iter);
			    gtk_list_store_set((mw.list), &iter, EDITABLE, TRUE,  COLOR,"RED", -1);
			    gtk_list_store_set((mw.list), &iter, CATEGORY,temp, -1);
				gtk_list_store_set((mw.list), &iter, START_DATE, test, COMPLETED_DATE, test,  -1);
			    total++;
			    while(cur3 != NULL)
			        {
				if(xmlStrEqual(cur3->name, (const xmlChar *)"comment"))
				    {
				    xmlChar *temp;
				    temp = xmlNodeGetContent(cur3);
				    if(temp != NULL) {
					gtk_list_store_set((mw.list), &iter, COMMENT,temp,  -1);
					xmlFree(temp);
					}
				    }
				else if(xmlStrEqual(cur3->name, (const xmlChar *)"summary"))
				    {
				    xmlChar *temp;
				    temp = xmlNodeGetContent(cur3);
				    if(temp != NULL) {
					gtk_list_store_set((mw.list), &iter, SUMMARY,temp,  -1);
					xmlFree(temp);
					}
				    }
				    
				else if(xmlStrEqual(cur3->name, (const xmlChar *)"attribute"))
				    {
				    xmlChar *temp;
    				    temp = xmlGetProp(cur3, (const xmlChar *)"id");
				    if(temp != NULL)
					{
					gtk_list_store_set((mw.list), &iter, ID, atoi(temp),  -1);
					xmlFree(temp);
					}
				    temp = xmlGetProp(cur3, (const xmlChar *)"priority");
				    if(temp != NULL)
					{
					    gint i = atoi(temp);
					    gchar *ttemp;
					    if(i==0) ttemp = g_strdup(_("Low"));
					    else if (i==1) ttemp = g_strdup(_("Medium"));
					    else ttemp = g_strdup(_("High"));
					    gtk_list_store_set((mw.list), &iter, PRIORITY, i, PRIOSTR, ttemp, -1);
					    g_free(ttemp);
					    xmlFree(temp);
					}
				    temp = xmlGetProp(cur3, (const xmlChar *)"done");
				    if(temp != NULL)
					{
					    gtk_list_store_set((mw.list), &iter, DONE,atoi(temp),  -1);
					    xmlFree(temp);
					}
				    temp = xmlGetProp(cur3, (const xmlChar *)"start_date");
				    if(temp != NULL)
					{
					    gtk_list_store_set((mw.list), &iter, START_DATE, g_ascii_strtoull(temp, NULL, 0),  -1);
					    xmlFree(temp);
					}
				    temp = xmlGetProp(cur3, (const xmlChar *)"completed_date");
				    if(temp != NULL)
					{
					    gtk_list_store_set((mw.list), &iter, COMPLETED_DATE, g_ascii_strtoull(temp, NULL, 0),  -1);
					    xmlFree(temp);
					}
				    temp = xmlGetProp(cur3, (const xmlChar *)"enddate");
				    if(temp != NULL)
					{
					GDate *today, *comp;
					guint64 julian;
					gint year, month,day;
					gchar datestr[64];
					today = g_date_new();
					g_date_set_time(today, time(NULL));
					/* so it's compatible with the old xml file are converted. its nasty I know */
					if(!strncasecmp(temp, "No Date",7)) julian = 1;
					else if(sscanf(temp, "%i %i %i",&year, &month, &day) == 3)
					    {
					    comp = g_date_new_dmy((day), (month), year);
					    julian = g_date_get_julian(comp);
					    g_free(comp);
					    } 
					else julian = g_ascii_strtoull(temp, NULL, 0);
					gtk_list_store_set((mw.list), &iter, END_DATE, julian, DUE, FALSE, -1);
//					if(sscanf(temp,"%i %i %i", &year, &month, &day) == 3)
					if(julian > 1){
//					    comp = g_date_new_dmy((day), (month), year);
					    comp = g_date_new_julian(julian);
					    if( g_date_days_between(comp, today) > 0){
					    gtk_list_store_set(mw.list, &iter, DUE,TRUE,-1);
					    g_free(comp);
					//	col.red = 65535; col.blue = col.green = 0;
					    }
					    }
//					else  col = mw.window->style->fg[GTK_STATE_NORMAL];
			
					if(julian > 1)
					    {
						comp = g_date_new_julian(julian);
						g_date_strftime(datestr, 64, "%x", comp);
//						g_print("datestr: %s\n", datestr);
						g_free(comp);
					    }
					else  g_stpcpy(datestr, _("No date"));
					gtk_list_store_set((mw.list), &iter, F_DATE,&datestr,  -1);										
					xmlFree(temp);
					g_date_free(today);
					}
				    }
				cur3 = cur3->next;
				}
			    }
			    cur1 = cur1->next;
			    }
			}
		    xmlFree(temp);
	    	    cur = cur->next;
		    }
    if(total)
	    {
	    GtkTreeIter iter;
	    GtkTreeSelection *selection;
	    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(mw.treeview));
	    if(gtk_tree_model_get_iter_first(GTK_TREE_MODEL(mw.list), &iter))
	    gtk_tree_selection_select_iter(selection, &iter);
	    gtk_widget_set_sensitive(mw.tbdelbut, TRUE);
	    gtk_widget_set_sensitive(mw.tbeditbut, TRUE);	    
	    gtk_widget_set_sensitive(gtk_item_factory_get_widget(GTK_ITEM_FACTORY(mw.item_factory), N_("/Item/Edit")), TRUE);
	    gtk_widget_set_sensitive(gtk_item_factory_get_widget(GTK_ITEM_FACTORY(mw.item_factory), N_("/Item/Remove")), TRUE);	 
	    }
    else    {
	    gtk_widget_set_sensitive(mw.tbdelbut, FALSE);
	    gtk_widget_set_sensitive(mw.tbeditbut, FALSE);	        
	    gtk_widget_set_sensitive(gtk_item_factory_get_widget(GTK_ITEM_FACTORY(mw.item_factory), N_("/Item/Edit")), FALSE);
	    gtk_widget_set_sensitive(gtk_item_factory_get_widget(GTK_ITEM_FACTORY(mw.item_factory), N_("/Item/Remove")), FALSE);	 

	    }    			
    }


xmlNodePtr  get_id_node(gchar *category, gint id)
    {
	xmlNodePtr node = root;
	xmlNodePtr cur = root->xmlChildrenNode;
	while(cur != NULL){
        if(xmlStrEqual(cur->name, "category")){
	    xmlChar *temp = xmlGetProp(cur, (const xmlChar *)"title");
	    if(xmlStrEqual(temp, (const xmlChar *)category))
 		{	
		xmlNodePtr cur1;
		cur1 = cur->xmlChildrenNode;
		while(cur1 != NULL)
		    {
		    if(xmlStrEqual(cur1->name, (const xmlChar *)"item"))
 			{	

			xmlNodePtr cur2;
			cur2 = cur1->xmlChildrenNode;

			while(cur2 != NULL)
			{
			    if(xmlStrEqual(cur2->name, (const xmlChar *)"attribute"))
 			    {	
				xmlChar *temp1 = xmlGetProp(cur2,"id");
				if(temp1 != NULL)
					{
					if(atoi(temp1) == id)node = cur1;
					xmlFree(temp1);
					}     
				}	
			    
			cur2 = cur2->next;
			}
	    	    }	
		cur1 = cur1->next;
		}
	    }
	xmlFree(temp);
	}

	cur = cur->next;
	}
    return node;
}


int  get_all_due_dates()
    {
	xmlNodePtr cur = root->xmlChildrenNode;
	GString * string;
	if(!tray) return;
	string = g_string_new("");
	while(cur != NULL){
        if(xmlStrEqual(cur->name, "category")){
		xmlNodePtr cur1;
		xmlChar *temp;
		int dd = 0;		
		cur1 = cur->xmlChildrenNode;
		temp = xmlGetProp(cur,"title");
		while(cur1 != NULL)
		    {
		    
		    if(xmlStrEqual(cur1->name, (const xmlChar *)"item"))
 			{	
			xmlChar *due=NULL, *done=NULL, *summary=NULL;
			xmlNodePtr cur2;
			cur2 = cur1->xmlChildrenNode;
			while(cur2 != NULL)
			    {
			    
			    if(xmlStrEqual(cur2->name, (const xmlChar *)"summary")){
				if(summary == NULL) summary = xmlNodeGetContent(cur2);
			    }
			else if(xmlStrEqual(cur2->name, (const xmlChar *)"attribute"))
 			    {	
				if(due == NULL ) due = xmlGetProp(cur2,"enddate");
				if(done == NULL )done = xmlGetProp(cur2,"done");
			    }	
			    
			cur2 = cur2->next;
			if(cur2 == NULL){
			    if(summary != NULL && done != NULL && due != NULL)
				    {
					GDate *today, *comp;
					guint64 julian;
					today = g_date_new();
					g_date_set_time(today, time(NULL));
					julian = g_ascii_strtoull(due, NULL, 0);
					if(julian > 1){
					comp = g_date_new_julian(julian);
					    if( g_date_days_between(comp, today) >= 0){
					    if(atoi(done) == 0){
						    if(!dd)  g_string_append_printf(string, "%s:\n", temp);
						    dd = 1;
						    g_string_append_printf(string, "	-%s\n", summary);
						}					    
					    }
					    g_date_free(comp);					    
					    }
					g_date_free(today);
					xmlFree(due);
					xmlFree(summary);
					xmlFree(done);
				    }     
			    else
				{
				if(due != NULL) xmlFree(due);
				if(summary != NULL) xmlFree(summary);
				if(done != NULL) xmlFree(done);
				}
			    }
			}
	    	    }	
		cur1 = cur1->next;
		}
	if(temp != NULL) xmlFree(temp);
	}

	cur = cur->next;
	}
    if(string->len > 0)
    {
    g_string_prepend(string, _("ToDo's that are due today:\n"));
    gtk_tooltips_set_tip (tray_icon_tooltip, GTK_WIDGET (tray_icon), string->str, NULL);
    }
    else{
      gtk_tooltips_set_tip (tray_icon_tooltip, GTK_WIDGET (tray_icon), _("Todo List"), NULL);
    }
    g_string_free(string, TRUE);
    return 1;
}

int  get_all_past_purge()
    {	guint64 now, item;
	xmlNodePtr cur = root->xmlChildrenNode;
	GDate *comp;
    	comp = g_date_new();
	g_date_set_time(comp, time(NULL));
    	if(g_date_valid(comp)) now = g_date_get_julian(comp);
	else{
	     g_date_free(comp);
	     return;
	     }
	g_date_free(comp);

	while(cur != NULL){
        if(xmlStrEqual(cur->name, "category")){
		xmlNodePtr cur1;
		cur1 = cur->xmlChildrenNode;
		while(cur1 != NULL)
		    {
		    
		    if(xmlStrEqual(cur1->name, (const xmlChar *)"item"))
 			{	
			xmlChar  *due=NULL, *done = NULL;
			xmlNodePtr cur2;
			cur2 = cur1->xmlChildrenNode;
			while(cur2 != NULL)
			    {
			    if(xmlStrEqual(cur2->name, (const xmlChar *)"attribute"))
 			    {	
				if(due == NULL )
				    {
				    due = xmlGetProp(cur2,"completed_date");
				    if(due != NULL)
					{
					done = xmlGetProp(cur2,"done");				    
				    if(done != NULL) 
					{
					item = g_ascii_strtoull(due, NULL,0);
					if(atoi(done) &&  item < (now-settings.purge_days))
					    {
					    xmlUnlinkNode(cur1);
					    xmlFreeNode(cur1);
					    cur1= root->xmlChildrenNode;
					    if(cur1 != NULL) cur2= cur1->xmlChildrenNode;
					    else cur2 = NULL;
					    }
					xmlFree(done);
					}
					xmlFree(due);
					}
				    }
				}	
			    if(cur2 != NULL)cur2 = cur2->next;
			    }
			}
		if(cur1 != NULL) cur1 = cur1->next;
	    	    }	
		}
	cur = cur->next;
	}
    save_xml();
    return 1;
}
