#include <gtk/gtk.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <string.h>
#include <libgnomevfs/gnome-vfs.h>
#include "main.h"
#include "tray-icon.h"
#include "debug_printf.h"

/* function declerations */
void set_read_only();
void configuration_restore_size(GConfClient *client);
void configuration_restore_place(GConfClient *client);
char *parse_command (int argc, char **argv);
void backend_changed();

/* the connection to the xml file */
GTodoClient *cl = NULL;

gint xsize=-1, ysize=-1, xpos=-1, ypos=-1;



/* settings struct */
sets settings;
/* gconf client pointer */
GConfClient* client;    






/*GConfEngine* gconf_engine_get_default (void); */

int main(int argc, char **argv)
{
	char *new_path = NULL;
	GError *error = NULL;
	
	bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);
	setlocale(LC_ALL,"");

	debug_printf(DEBUG_INFO, "Parsing commandline options");
	new_path = parse_command (argc, argv);

	debug_printf(DEBUG_INFO, "Initializing gtk, gconf and gnome-vfs");
	gtk_init(&argc, &argv);
	gconf_init(argc, argv, NULL);
	gnome_vfs_init();


	debug_printf(DEBUG_INFO, "Creating gconf client");
	client = gconf_client_get_default();
	
	gconf_client_add_dir(client,
			"/apps/gtodo/prefs",
			GCONF_CLIENT_PRELOAD_NONE,
			NULL);
	gconf_client_add_dir(client,
			"/apps/gtodo/view",
			GCONF_CLIENT_PRELOAD_NONE,
			NULL);

	debug_printf(DEBUG_INFO, "Loading settings from gconf");


	/* TODO REMOVE THE SETTING STRUCT AND DO DIRECT CALLS TO GCONF */
	/* Enable tray by default..  user won't know if he/she doesnt have tray */
	/* this is just for people who don't want it in there tray */
	settings.place = gconf_client_get_bool(client, "/apps/gtodo/prefs/restore-position",NULL);;
	settings.size =  gconf_client_get_bool(client, "/apps/gtodo/prefs/restore-size",NULL);;
	settings.ask_delete_category 	=  gconf_client_get_bool(client, "/apps/gtodo/prefs/ask-delete-category",NULL);
	/* this is kinda (thanks gtk :-/) buggy.. gtk need fix first */
//	settings.list_tooltip		= gconf_client_get_bool(client, "/apps/gtodo/prefs/show-tooltip",NULL);
	/* auto purge is default on.. */
	settings.auto_purge		= gconf_client_get_bool(client, "/apps/gtodo/prefs/auto-purge",NULL);
	/* set default auto purge to a week */	
	settings.purge_days		= gconf_client_get_int(client, "/apps/gtodo/prefs/auto-purge-days",NULL);
	settings.due_color 		= g_strdup(gconf_client_get_string(client, "/apps/gtodo/prefs/due-color",NULL));
	settings.due_today_color 	= g_strdup(gconf_client_get_string(client, "/apps/gtodo/prefs/due-today-color",NULL));
	settings.due_in_days_color 	= g_strdup(gconf_client_get_string(client, "/apps/gtodo/prefs/due-in-days-color",NULL));
	settings.due_days 		= gconf_client_get_int(client, "/apps/gtodo/prefs/due-days",NULL);
	settings.sorttype 		= gconf_client_get_int(client, "/apps/gtodo/prefs/sort-type",NULL);	
	settings.sortorder 		= gconf_client_get_int(client, "/apps/gtodo/prefs/sort-order",NULL);	
	/* treeview hide preferences.. */
	settings.hide_done 		= gconf_client_get_bool(client, "/apps/gtodo/prefs/hide-done",NULL);
	settings.hide_due 		= gconf_client_get_bool(client, "/apps/gtodo/prefs/hide-due",NULL);
	settings.hide_nodate 		=  gconf_client_get_bool(client, "/apps/gtodo/prefs/hide-nodate",NULL);
	settings.hl_indays		= gconf_client_get_bool(client,"/apps/gtodo/prefs/hl-indays",NULL);
	settings.hl_due			= gconf_client_get_bool(client,"/apps/gtodo/prefs/hl-due",NULL);
	settings.hl_today		= gconf_client_get_bool(client,"/apps/gtodo/prefs/hl-today",NULL);


	pref_gconf_set_notifications(client);

	
	/* create the main window */
	debug_printf(DEBUG_INFO, "Creating main interface");
	gui_create_main_window();


	
	if(new_path == NULL)
	{
		char *path = g_strdup_printf("%s/.gtodo/", g_getenv("HOME"));
		debug_printf(DEBUG_INFO, "Trying to open default location.");
		if(!g_file_test(path, G_FILE_TEST_EXISTS))
		{
			gnome_vfs_make_directory(path, 0750);
			if(!g_file_test(path, G_FILE_TEST_EXISTS))
			{
				debug_printf(DEBUG_ERROR, "Failed to create directory: %s", path);
				exit(1);
			}
		}
		g_free(path);
		path = g_strdup_printf("%s/.gtodo/todos", g_getenv("HOME"));
		cl = gtodo_client_new_from_file(path, &error);
		g_free(path);
	}
	else
	{
		GnomeVFSURI *uri = gnome_vfs_uri_new(new_path);
		debug_printf(DEBUG_INFO, "Trying to open given uri.");
		gchar *title = NULL, *tmp = NULL;
		if(uri == NULL)
		{
			debug_printf(DEBUG_ERROR, "Invalid uri %s.", new_path);
			exit(1);
		}
		/* test if its a local uri.. they can be releative.. and we need to resolve that */
		if(gnome_vfs_uri_is_local(uri))
		{
			/* if the uri exists we can open it.. no need for more tests */
			if(gnome_vfs_uri_exists(uri))
			{
				cl = gtodo_client_new_from_file(new_path, &error);

			}
			else
			{
				/* we still need to find out if its a valid path */
				char *dirname =  gnome_vfs_uri_extract_dirname(uri);
				if(!strncmp(dirname, ".", 1) || (strlen(dirname) == 1 && !strncmp(dirname, "/", 1)))
				{
					/* there should be default function to get the full path from a relative one  */
					char *cur_dir_tmp = g_get_current_dir();
					char *path = NULL;
					/* grrrrrrrr stupid gnome_vfs needs a ending / in the base path */
					char *cur_dir = g_strdup_printf("%s/", cur_dir_tmp);
					g_free(cur_dir_tmp);
					path =  gnome_vfs_uri_make_full_from_relative(cur_dir,new_path);
					cl = gtodo_client_new_from_file(path, &error);
					g_free(path);		
					g_free(cur_dir);
				}
				else
				{
					cl = gtodo_client_new_from_file(new_path, &error);
				}
				g_free(dirname);
			}
		}
		else
		{
			cl = gtodo_client_new_from_file(new_path, &error);
		}
		/* start checking the GError */
		if(error != NULL)
		{
			GtkWidget *dialog = NULL;
			dialog = gtk_message_dialog_new_with_markup(GTK_WINDOW(mw.window),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_CLOSE,
					"The following error occured while opening:\n<i>%s</i>",
					error->message);
			gtk_widget_show_all(dialog);
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
			debug_printf(DEBUG_ERROR,"Error while opening: %s\n", error->message);

			exit(1);
		}



		tmp = gnome_vfs_uri_extract_short_name(uri);
		title = g_strdup_printf("Todo List - %s %s", tmp, (gtodo_client_get_read_only(cl) == TRUE)? "(RO)": "" );
		gtk_window_set_title(GTK_WINDOW(mw.window), title);
		g_free(tmp);
		g_free(title);

		gnome_vfs_uri_unref(uri);
	}

	if(cl == NULL)
	{
		debug_printf(DEBUG_ERROR,"Failed to open, or create the default gtodo client.\n");
		exit(1);
	}

	if(settings.auto_purge && !gtodo_client_get_read_only(cl))
	{
		debug_printf(DEBUG_INFO, "Purging items that are past purge date");
		get_all_past_purge();
	}

	if(gconf_client_get_int(client, "/apps/gtodo/prefs/size-x",NULL) != -1 &&  
		gconf_client_get_int(client, "/apps/gtodo/prefs/size-x",NULL) != -1 && 
		settings.size)
	{
		gtk_window_resize(GTK_WINDOW(mw.window),  
				gconf_client_get_int(client, "/apps/gtodo/prefs/size-x",NULL),  
				gconf_client_get_int(client, "/apps/gtodo/prefs/size-y",NULL));
	}
	
	if(gconf_client_get_int(client, "/apps/gtodo/prefs/pos-x",NULL) != -1 && 
		gconf_client_get_int(client, "/apps/gtodo/prefs/pos-y",NULL) != -1 && 
		settings.place)
	{
		gtk_window_move(GTK_WINDOW(mw.window), 
				gconf_client_get_int(client, "/apps/gtodo/prefs/pos-x",NULL), 
				gconf_client_get_int(client, "/apps/gtodo/prefs/pos-y",NULL));
	}

	/* read the categorys */
	{
		int i =  gconf_client_get_int(client, "/apps/gtodo/view/last-category",NULL);
		debug_printf(DEBUG_INFO, "Reading categories");
		read_categorys();
		gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option),i);
	}
	/* nasty thing to fix the tooltip in the list */
	if(gconf_client_get_bool(client, "/apps/gtodo/prefs/show-tooltip",NULL))
	{
		debug_printf(DEBUG_WARNING, "Doing nasty hack to get around tooltip error");
		gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(mw.treeview), FALSE);			
	}

	gtk_widget_show_all(mw.window);
	if(settings.start_hidden)
	{
		gtk_widget_hide(mw.window);
	}
	if(gtodo_client_get_read_only(cl)) 
	{
		debug_printf(DEBUG_WARNING, "Read only file detected, disabling severall options");
		set_read_only();
	}

	gtodo_client_set_changed_callback(cl,(void *)backend_changed ,NULL);
	g_timeout_add(300000, (GSourceFunc)check_for_notification_event, NULL);

	check_for_notification_event();

	tray_init();

	gl_update(cl->xml_path);
	gtk_main();
	return 0;
}


/************************
  save the xml file and quit
  saving xml isnt needed anymore, this is done on the fly
 ************************/
void quit_program()
{
	debug_printf(DEBUG_INFO, "Quiting....");
	/* calling a window moved, so the position is saved */
	if(mw.window)windows_moved(mw.window);
	gtk_main_quit();
}
void startup_new_item()
{
	g_print("add\n");
	gui_add_todo_item(NULL,GINT_TO_POINTER(0), 0);
}
void startup_view_item(guint32 buf)
{
	gui_add_todo_item(NULL, GINT_TO_POINTER(-1), buf);
}

char *parse_command (int argc, char **argv) 
{
	int i;
	char *output = NULL;
	settings.start_hidden = 0;
	if(argc < 2) return NULL;

	for(i=1; i< argc; i++) 
	{
		if(!strncmp(argv[i], "-?", 2) || !strncmp(argv[i], "--help", 6) || !strncmp(argv[i], _("--help"), strlen(_("--help"))))
		{
			printf(_("gtodo v%s\ngtodo has to following commandline options:\n-s	--show	Shows an todo item by there id.\n only usefull for programs calling gtodo\n-?	--help	This Message.\n"), VERSION);
			exit(1);
		}
		else if (!strncmp(argv[i], "-s", 2) || !strncmp(argv[i], "--show", 6) || !strncmp(argv[i], _("--show"), strlen(_("--show"))))
		{
			if(argc < 1 || argv[i+1]  == NULL)
			{
				g_print(_("The --show command an todo item ID as argument\n"));
				exit(1);
			}
			i++;
			gtk_init_add((GtkFunction)startup_view_item,(gpointer)(gint)g_ascii_strtoull(argv[i], NULL, 0));
		}
		else if (!strncmp(argv[i], "-n", 2) || !strncmp(argv[i], "--new", 6) || !strncmp(argv[i], _("--new"), strlen(_("--new"))))
		{
			i++;
			gtk_init_add((GtkFunction)startup_new_item,NULL);
		}
		else if(!strncmp(argv[i], "-h",2) || !strncmp(argv[i],"--hidden", 8) || !strncmp(argv[i],_("--hidden"), strlen(_("--hidden"))))
		{
			settings.start_hidden = 1;		

		}

		else{
			output = argv[i];
		}
	}
	return output;
}

void backend_changed()
{
	debug_printf(DEBUG_INFO, "Backend data changed, updating interface");
	category_changed();    
}

void set_read_only()
{

	gtk_widget_set_sensitive (mw.tbdelbut, FALSE);                                                                                 
	gtk_label_set_text_with_mnemonic(GTK_LABEL(mw.tbeditlb),_("_View"));
	gtk_widget_set_sensitive(mw.tbaddbut, FALSE);
	gtk_widget_set_sensitive (gtk_item_factory_get_widget(GTK_ITEM_FACTORY (mw.item_factory), N_("/Item/Edit")), FALSE);
	gtk_widget_set_sensitive (gtk_item_factory_get_widget(GTK_ITEM_FACTORY (mw.item_factory), N_("/Item/Remove")), FALSE);        
	gtk_widget_set_sensitive (gtk_item_factory_get_widget(GTK_ITEM_FACTORY (mw.item_factory), N_("/Item/Add")), FALSE);         
	gtk_widget_set_sensitive (gtk_item_factory_get_widget(GTK_ITEM_FACTORY (mw.item_factory), N_("/Item/Remove Completed Items")), FALSE);         
	gtk_widget_set_sensitive (gtk_item_factory_get_widget(GTK_ITEM_FACTORY (mw.item_factory), N_("/ToDo/Edit Categories")), FALSE);         
	gtk_widget_show_all(mw.window);
}
