// /home/yoan/soft/gtwitter3/gtwitter/MainWindowTest.cs created with MonoDelop
// User: yoan at 19:27 24.05.2007
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using NUnit.Framework;

namespace gtwitter
{
	[TestFixture()]
	public class MainWindowTest
	{
		
		[Test]
		public void UrlDetectionTest()
		{
			// from -> to (expected)
			string[,] urls = {
				{"aaa bbb ccc", "aaa bbb ccc"},
				// http:// or www. handling
				{"http://example.org", "<a href=\"http://example.org\">http://example.org</a>"},
				{"http://example.org foo", "<a href=\"http://example.org\">http://example.org</a> foo"},
				{"www.example.com foo", "<a href=\"http://www.example.com\">www.example.com</a> foo"},
				{"http://example.org ()", "<a href=\"http://example.org\">http://example.org</a> ()"},
				{"http://www.example.org", "<a href=\"http://www.example.org\">http://www.example.org</a>"},
				{"http://example.org?foo", "<a href=\"http://example.org?foo\">http://example.org?foo</a>"},
				{"http://example.org?foo=bar&foobar=barfoo", "<a href=\"http://example.org?foo=bar&foobar=barfoo\">http://example.org?foo=bar&foobar=barfoo</a>"},
				// multiple urls
				{"http://example.org and http://example.org", "<a href=\"http://example.org\">http://example.org</a> and <a href=\"http://example.org\">http://example.org</a>"},
				// @nickname handling
				{"@foo", "@<a href=\"http://twitter.com/foo\">foo</a>"},
				{"@foo_bAr_999 say hey", "@<a href=\"http://twitter.com/foo_bAr_999\">foo_bAr_999</a> say hey"},
				{"@Méo: say hey", "@<a href=\"http://twitter.com/Méo\">Méo</a>: say hey"},
				{"@foo, @bar", "@<a href=\"http://twitter.com/foo\">foo</a>, @<a href=\"http://twitter.com/bar\">bar</a>"},
			};
			
			for(int i=urls.Length-2; i>0; i-=2) {
				Assert.AreEqual(urls[i/2, 1], MainWindow.UrlDetection(urls[i/2, 0]), urls[i/2, 0] + " fails");
			}
		}
	}
}