#ifndef EXEC_H
#define EXEC_H

/*
 * OO wrapper for execve
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "Exception.h"

// Base class to costruct objects that run child processes
class Exec
{
protected: 
	// TODO: if allocation fails, then probably also allocation in
	// exception throwing is going to fail.  What should I do to report
	// out of memory errors?  I don't know.
	class strlist
	{
	protected:
		char** ptr;
		int cur;
		int size;

		void expand() throw ();

	public:
		strlist(int start_size = 8) throw ();
		~strlist() throw ();

		void add(const char* str) throw ();
		void add(const std::string& str) throw ();

		char *const * get() throw ()
		{
			if (cur >= size)
				expand();
			ptr[cur] = 0;
			return ptr;
		}
	};

	std::string program;
	strlist argv;
	strlist env;

public:
	/// Create a new object that will execute program `program'
	Exec(const std::string& program) throw ()
		: program(program) {}

	/// Add an argument to the argument list of the program
	void addArg(const std::string& arg) throw () { argv.add(arg); }

	/// Add a new item (a string in the form "VAR=value") to the environment of
	/// the program
	void addEnv(const std::string& envstr) throw () { env.add(envstr); }

	/// execve() the program, never returning if all goes well
	void exec() throw (SystemException);
};

// vim:set ts=4 sw=4:
#endif
