#include "PacketMaker.h"

extern "C" {
#include <libnet.h>
}

Buffer PacketMaker::makeARPRequest(const IPAddress& ip) throw ()
{
	unsigned char ether_broadcast_addr[6] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
	unsigned char ether_no_addr[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	unsigned char ip_no_addr[4] = {0x00, 0x00, 0x00, 0x00};
	struct libnet_ether_addr* localmac = sender.getMACAddress();
	libnet_t* ln_context = sender.getLibnetContext();

	// Build the pieces of the packet
	libnet_build_arp (
			ARPHRD_ETHER,
			ETHERTYPE_IP,
			ETHER_ADDR_LEN,
			4,
			ARPOP_REQUEST,
			localmac->ether_addr_octet,
			(u_char *)ip_no_addr,			// FIXME: what's in here?  The broadcast addr maybe?
			ether_broadcast_addr,
			(u_char *)ip.s_addr_p(),
			NULL,
			0,
			ln_context, 0);
	libnet_build_ethernet (
			ether_broadcast_addr,
			localmac->ether_addr_octet,
			ETHERTYPE_ARP,
			NULL, 0,
			ln_context, 0);

	// Construct the packet
	u_char* buf;
	u_int32_t len;
	libnet_adv_cull_packet(ln_context, &buf, &len);
	Buffer pkt(buf, len, false);

	// Waiting for libnet 1.2...
	//libnet_adv_free_packet(ln_context, buf);
	// In the meantime...
	if (ln_context->aligner > 0)
		buf -= ln_context->aligner;
	free(buf);

	libnet_clear_packet(ln_context);

	return pkt;
}
    
// vim:set ts=4 sw=4:
