/*
 * Tester that delegates testing to an external script
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ScriptScanner.h"

using namespace std;


void ScriptScanner::handleTermination(const std::string& signature, int status) throw ()
{
	MutexLock lock(candMutex);

	if (status != 0)
		return;

	map<string, const Scan*>::iterator i = scans.find(signature);
	if (i != scans.end())
		succeeded(i->second);
}


void ScriptScanner::addCandidate(const ScriptScan* scan)
	throw ()
{
	map<string, const Scan*>::iterator i = scans.find(scan->signature());
	if (i == scans.end())
	{
		scans.insert(pair<string, const Scan*>(scan->signature(), scan));
		runner.addProcess(scan->signature(), scan->cmdline(), this);
	}
}

// vim:set ts=4 sw=4:
